/*
  File autogenerated by gengetopt version 2.22.1
  generated with the following command:
  gengetopt -i kinfold.ggo --default-optional --include-getopt

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "cmdline.h"

const char *gengetopt_args_info_purpose = "Kinetic Folding Program for Nucleic Acids";

const char *gengetopt_args_info_usage = "Usage: Kinfold [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_full_help[] = {
  "  -h, --help            Print help and exit",
  "      --full-help       Print help, including hidden options, and exit",
  "  -V, --version         Print version and exit",
  "\nEnergy Model:",
  "  -d, --dangle=INT      <0|1|2> set dangling end model to (none|normal|double)  \n                          (possible values=\"0\", \"1\", \"2\" default=`2')",
  "  -T, --Temp=FLOAT      simulation temperature  (default=`37')",
  "  -P, --Par=filename    read energy-parameter-file",
  "      --logML           use logarithmic multiloop energies instead of linear  \n                          (default=on)",
  "\nMoveSet:",
  "      --noShift         turn off shift-moves  (default=off)",
  "      --noLP            forbid structures with isolated base-pairs  \n                          (default=off)",
  "\nSimulation:",
  "      --seed=STRING     set random number seed specify 3 integers as \n                          int=int=int  (default=`clock')",
  "      --time=FLOAT      set maxtime of simulation  (default=`500')",
  "      --num=INT         set number of trajectories  (default=`1')",
  "      --start           read start structure from stdin (otherwise use open \n                          chain)  (default=off)",
  "      --stop            read stop structure(s) from stdin (optherwise use MFE)  \n                          (default=off)",
  "      --met             use Metropolis rule for rates (not Kawasaki rule)  \n                          (default=off)",
  "      --fpt             compute first passage time (stop when a stop-structure \n                          is reached)  (default=on)",
  "      --grow=FLOAT      grow chain every <float> time steps  (default=`0')",
  "      --glen=INT        initial size of growing chain  (default=`15')",
  "      --phi=DOUBLE      set phi value",
  "      --pbounds=STRING  specify 3 floats for phi_min, phi_inc, phi_max in the \n                          form <d1=d2=d3>",
  "\nOutput:",
  "      --log=filename    set basename of log-file  (default=`kinout')",
  "      --err=filename    set basename of error-log-file",
  "  -q, --silent          no output to stdout  (default=off)",
  "  -v, --verbose         more information to stdout  (default=off)",
  "      --lmin            output only local minima to stdout  (default=off)",
  "      --cut=FLOAT       output structures with E <= <float> to stdout  \n                          (default=`20')",
  "1st line sequence2nd line start structure (if option --start is used)following \nlines stop structures",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_full_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_full_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_full_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_full_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_full_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_full_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_full_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_full_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_full_help[8];
  gengetopt_args_info_help[9] = gengetopt_args_info_full_help[9];
  gengetopt_args_info_help[10] = gengetopt_args_info_full_help[10];
  gengetopt_args_info_help[11] = gengetopt_args_info_full_help[11];
  gengetopt_args_info_help[12] = gengetopt_args_info_full_help[12];
  gengetopt_args_info_help[13] = gengetopt_args_info_full_help[13];
  gengetopt_args_info_help[14] = gengetopt_args_info_full_help[14];
  gengetopt_args_info_help[15] = gengetopt_args_info_full_help[15];
  gengetopt_args_info_help[16] = gengetopt_args_info_full_help[16];
  gengetopt_args_info_help[17] = gengetopt_args_info_full_help[17];
  gengetopt_args_info_help[18] = gengetopt_args_info_full_help[18];
  gengetopt_args_info_help[19] = gengetopt_args_info_full_help[19];
  gengetopt_args_info_help[20] = gengetopt_args_info_full_help[20];
  gengetopt_args_info_help[21] = gengetopt_args_info_full_help[23];
  gengetopt_args_info_help[22] = gengetopt_args_info_full_help[24];
  gengetopt_args_info_help[23] = gengetopt_args_info_full_help[25];
  gengetopt_args_info_help[24] = gengetopt_args_info_full_help[26];
  gengetopt_args_info_help[25] = gengetopt_args_info_full_help[27];
  gengetopt_args_info_help[26] = gengetopt_args_info_full_help[28];
  gengetopt_args_info_help[27] = gengetopt_args_info_full_help[29];
  gengetopt_args_info_help[28] = gengetopt_args_info_full_help[30];
  gengetopt_args_info_help[29] = 0; 
  
}

const char *gengetopt_args_info_help[30];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
  , ARG_DOUBLE
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


char *cmdline_parser_dangle_values[] = {"0", "1", "2", 0} ;	/* Possible values for dangle.  */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->dangle_given = 0 ;
  args_info->Temp_given = 0 ;
  args_info->Par_given = 0 ;
  args_info->logML_given = 0 ;
  args_info->noShift_given = 0 ;
  args_info->noLP_given = 0 ;
  args_info->seed_given = 0 ;
  args_info->time_given = 0 ;
  args_info->num_given = 0 ;
  args_info->start_given = 0 ;
  args_info->stop_given = 0 ;
  args_info->met_given = 0 ;
  args_info->fpt_given = 0 ;
  args_info->grow_given = 0 ;
  args_info->glen_given = 0 ;
  args_info->phi_given = 0 ;
  args_info->pbounds_given = 0 ;
  args_info->log_given = 0 ;
  args_info->err_given = 0 ;
  args_info->silent_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->lmin_given = 0 ;
  args_info->cut_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->dangle_arg = 2;
  args_info->dangle_orig = NULL;
  args_info->Temp_arg = 37;
  args_info->Temp_orig = NULL;
  args_info->Par_arg = NULL;
  args_info->Par_orig = NULL;
  args_info->logML_flag = 1;
  args_info->noShift_flag = 0;
  args_info->noLP_flag = 0;
  args_info->seed_arg = gengetopt_strdup ("clock");
  args_info->seed_orig = NULL;
  args_info->time_arg = 500;
  args_info->time_orig = NULL;
  args_info->num_arg = 1;
  args_info->num_orig = NULL;
  args_info->start_flag = 0;
  args_info->stop_flag = 0;
  args_info->met_flag = 0;
  args_info->fpt_flag = 1;
  args_info->grow_arg = 0;
  args_info->grow_orig = NULL;
  args_info->glen_arg = 15;
  args_info->glen_orig = NULL;
  args_info->phi_orig = NULL;
  args_info->pbounds_arg = NULL;
  args_info->pbounds_orig = NULL;
  args_info->log_arg = gengetopt_strdup ("kinout");
  args_info->log_orig = NULL;
  args_info->err_arg = NULL;
  args_info->err_orig = NULL;
  args_info->silent_flag = 0;
  args_info->verbose_flag = 0;
  args_info->lmin_flag = 0;
  args_info->cut_arg = 20;
  args_info->cut_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_full_help[0] ;
  args_info->full_help_help = gengetopt_args_info_full_help[1] ;
  args_info->version_help = gengetopt_args_info_full_help[2] ;
  args_info->dangle_help = gengetopt_args_info_full_help[4] ;
  args_info->Temp_help = gengetopt_args_info_full_help[5] ;
  args_info->Par_help = gengetopt_args_info_full_help[6] ;
  args_info->logML_help = gengetopt_args_info_full_help[7] ;
  args_info->noShift_help = gengetopt_args_info_full_help[9] ;
  args_info->noLP_help = gengetopt_args_info_full_help[10] ;
  args_info->seed_help = gengetopt_args_info_full_help[12] ;
  args_info->time_help = gengetopt_args_info_full_help[13] ;
  args_info->num_help = gengetopt_args_info_full_help[14] ;
  args_info->start_help = gengetopt_args_info_full_help[15] ;
  args_info->stop_help = gengetopt_args_info_full_help[16] ;
  args_info->met_help = gengetopt_args_info_full_help[17] ;
  args_info->fpt_help = gengetopt_args_info_full_help[18] ;
  args_info->grow_help = gengetopt_args_info_full_help[19] ;
  args_info->glen_help = gengetopt_args_info_full_help[20] ;
  args_info->phi_help = gengetopt_args_info_full_help[21] ;
  args_info->pbounds_help = gengetopt_args_info_full_help[22] ;
  args_info->log_help = gengetopt_args_info_full_help[24] ;
  args_info->err_help = gengetopt_args_info_full_help[25] ;
  args_info->silent_help = gengetopt_args_info_full_help[26] ;
  args_info->verbose_help = gengetopt_args_info_full_help[27] ;
  args_info->lmin_help = gengetopt_args_info_full_help[28] ;
  args_info->cut_help = gengetopt_args_info_full_help[29] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->dangle_orig));
  free_string_field (&(args_info->Temp_orig));
  free_string_field (&(args_info->Par_arg));
  free_string_field (&(args_info->Par_orig));
  free_string_field (&(args_info->seed_arg));
  free_string_field (&(args_info->seed_orig));
  free_string_field (&(args_info->time_orig));
  free_string_field (&(args_info->num_orig));
  free_string_field (&(args_info->grow_orig));
  free_string_field (&(args_info->glen_orig));
  free_string_field (&(args_info->phi_orig));
  free_string_field (&(args_info->pbounds_arg));
  free_string_field (&(args_info->pbounds_orig));
  free_string_field (&(args_info->log_arg));
  free_string_field (&(args_info->log_orig));
  free_string_field (&(args_info->err_arg));
  free_string_field (&(args_info->err_orig));
  free_string_field (&(args_info->cut_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->dangle_given)
    write_into_file(outfile, "dangle", args_info->dangle_orig, cmdline_parser_dangle_values);
  if (args_info->Temp_given)
    write_into_file(outfile, "Temp", args_info->Temp_orig, 0);
  if (args_info->Par_given)
    write_into_file(outfile, "Par", args_info->Par_orig, 0);
  if (args_info->logML_given)
    write_into_file(outfile, "logML", 0, 0 );
  if (args_info->noShift_given)
    write_into_file(outfile, "noShift", 0, 0 );
  if (args_info->noLP_given)
    write_into_file(outfile, "noLP", 0, 0 );
  if (args_info->seed_given)
    write_into_file(outfile, "seed", args_info->seed_orig, 0);
  if (args_info->time_given)
    write_into_file(outfile, "time", args_info->time_orig, 0);
  if (args_info->num_given)
    write_into_file(outfile, "num", args_info->num_orig, 0);
  if (args_info->start_given)
    write_into_file(outfile, "start", 0, 0 );
  if (args_info->stop_given)
    write_into_file(outfile, "stop", 0, 0 );
  if (args_info->met_given)
    write_into_file(outfile, "met", 0, 0 );
  if (args_info->fpt_given)
    write_into_file(outfile, "fpt", 0, 0 );
  if (args_info->grow_given)
    write_into_file(outfile, "grow", args_info->grow_orig, 0);
  if (args_info->glen_given)
    write_into_file(outfile, "glen", args_info->glen_orig, 0);
  if (args_info->phi_given)
    write_into_file(outfile, "phi", args_info->phi_orig, 0);
  if (args_info->pbounds_given)
    write_into_file(outfile, "pbounds", args_info->pbounds_orig, 0);
  if (args_info->log_given)
    write_into_file(outfile, "log", args_info->log_orig, 0);
  if (args_info->err_given)
    write_into_file(outfile, "err", args_info->err_orig, 0);
  if (args_info->silent_given)
    write_into_file(outfile, "silent", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->lmin_given)
    write_into_file(outfile, "lmin", 0, 0 );
  if (args_info->cut_given)
    write_into_file(outfile, "cut", args_info->cut_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* For communication from `getopt' to the caller.
   When `getopt' finds an option that takes an argument,
   the argument value is returned here.
   Also, when `ordering' is RETURN_IN_ORDER,
   each non-option ARGV-element is returned here.  */

static char *optarg;

/* Index in ARGV of the next element to be scanned.
   This is used for communication to and from the caller
   and for communication between successive calls to `getopt'.

   On entry to `getopt', zero means this is the first call; initialize.

   When `getopt' returns -1, this is the index of the first of the
   non-option elements that the caller should itself scan.

   Otherwise, `optind' communicates from one call to the next
   how much of ARGV has been scanned so far.  */

static int optind;

/* Callers store zero here to inhibit the error message `getopt' prints
   for unrecognized options.  */

static int opterr;

/* Set to an option character which was unrecognized.  */

static int optopt;

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "dangle",	1, NULL, 'd' },
        { "Temp",	1, NULL, 'T' },
        { "Par",	1, NULL, 'P' },
        { "logML",	0, NULL, 0 },
        { "noShift",	0, NULL, 0 },
        { "noLP",	0, NULL, 0 },
        { "seed",	1, NULL, 0 },
        { "time",	1, NULL, 0 },
        { "num",	1, NULL, 0 },
        { "start",	0, NULL, 0 },
        { "stop",	0, NULL, 0 },
        { "met",	0, NULL, 0 },
        { "fpt",	0, NULL, 0 },
        { "grow",	1, NULL, 0 },
        { "glen",	1, NULL, 0 },
        { "phi",	1, NULL, 0 },
        { "pbounds",	1, NULL, 0 },
        { "log",	1, NULL, 0 },
        { "err",	1, NULL, 0 },
        { "silent",	0, NULL, 'q' },
        { "verbose",	0, NULL, 'v' },
        { "lmin",	0, NULL, 0 },
        { "cut",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVd:T:P:qv", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'd':	/* <0|1|2> set dangling end model to (none|normal|double).  */
        
        
          if (update_arg( (void *)&(args_info->dangle_arg), 
               &(args_info->dangle_orig), &(args_info->dangle_given),
              &(local_args_info.dangle_given), optarg, cmdline_parser_dangle_values, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dangle", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* simulation temperature.  */
        
        
          if (update_arg( (void *)&(args_info->Temp_arg), 
               &(args_info->Temp_orig), &(args_info->Temp_given),
              &(local_args_info.Temp_given), optarg, 0, "37", ARG_FLOAT,
              check_ambiguity, override, 0, 0,
              "Temp", 'T',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* read energy-parameter-file.  */
        
        
          if (update_arg( (void *)&(args_info->Par_arg), 
               &(args_info->Par_orig), &(args_info->Par_given),
              &(local_args_info.Par_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "Par", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* no output to stdout.  */
        
        
          if (update_arg((void *)&(args_info->silent_flag), 0, &(args_info->silent_given),
              &(local_args_info.silent_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "silent", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* more information to stdout.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* use logarithmic multiloop energies instead of linear.  */
          if (strcmp (long_options[option_index].name, "logML") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->logML_flag), 0, &(args_info->logML_given),
                &(local_args_info.logML_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "logML", '-',
                additional_error))
              goto failure;
          
          }
          /* turn off shift-moves.  */
          else if (strcmp (long_options[option_index].name, "noShift") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noShift_flag), 0, &(args_info->noShift_given),
                &(local_args_info.noShift_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noShift", '-',
                additional_error))
              goto failure;
          
          }
          /* forbid structures with isolated base-pairs.  */
          else if (strcmp (long_options[option_index].name, "noLP") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noLP_flag), 0, &(args_info->noLP_given),
                &(local_args_info.noLP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noLP", '-',
                additional_error))
              goto failure;
          
          }
          /* set random number seed specify 3 integers as int=int=int.  */
          else if (strcmp (long_options[option_index].name, "seed") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->seed_arg), 
                 &(args_info->seed_orig), &(args_info->seed_given),
                &(local_args_info.seed_given), optarg, 0, "clock", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "seed", '-',
                additional_error))
              goto failure;
          
          }
          /* set maxtime of simulation.  */
          else if (strcmp (long_options[option_index].name, "time") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->time_arg), 
                 &(args_info->time_orig), &(args_info->time_given),
                &(local_args_info.time_given), optarg, 0, "500", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "time", '-',
                additional_error))
              goto failure;
          
          }
          /* set number of trajectories.  */
          else if (strcmp (long_options[option_index].name, "num") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->num_arg), 
                 &(args_info->num_orig), &(args_info->num_given),
                &(local_args_info.num_given), optarg, 0, "1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "num", '-',
                additional_error))
              goto failure;
          
          }
          /* read start structure from stdin (otherwise use open chain).  */
          else if (strcmp (long_options[option_index].name, "start") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->start_flag), 0, &(args_info->start_given),
                &(local_args_info.start_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "start", '-',
                additional_error))
              goto failure;
          
          }
          /* read stop structure(s) from stdin (optherwise use MFE).  */
          else if (strcmp (long_options[option_index].name, "stop") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->stop_flag), 0, &(args_info->stop_given),
                &(local_args_info.stop_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "stop", '-',
                additional_error))
              goto failure;
          
          }
          /* use Metropolis rule for rates (not Kawasaki rule).  */
          else if (strcmp (long_options[option_index].name, "met") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->met_flag), 0, &(args_info->met_given),
                &(local_args_info.met_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "met", '-',
                additional_error))
              goto failure;
          
          }
          /* compute first passage time (stop when a stop-structure is reached).  */
          else if (strcmp (long_options[option_index].name, "fpt") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->fpt_flag), 0, &(args_info->fpt_given),
                &(local_args_info.fpt_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "fpt", '-',
                additional_error))
              goto failure;
          
          }
          /* grow chain every <float> time steps.  */
          else if (strcmp (long_options[option_index].name, "grow") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->grow_arg), 
                 &(args_info->grow_orig), &(args_info->grow_given),
                &(local_args_info.grow_given), optarg, 0, "0", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "grow", '-',
                additional_error))
              goto failure;
          
          }
          /* initial size of growing chain.  */
          else if (strcmp (long_options[option_index].name, "glen") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->glen_arg), 
                 &(args_info->glen_orig), &(args_info->glen_given),
                &(local_args_info.glen_given), optarg, 0, "15", ARG_INT,
                check_ambiguity, override, 0, 0,
                "glen", '-',
                additional_error))
              goto failure;
          
          }
          /* set phi value.  */
          else if (strcmp (long_options[option_index].name, "phi") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->phi_arg), 
                 &(args_info->phi_orig), &(args_info->phi_given),
                &(local_args_info.phi_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "phi", '-',
                additional_error))
              goto failure;
          
          }
          /* specify 3 floats for phi_min, phi_inc, phi_max in the form <d1=d2=d3>.  */
          else if (strcmp (long_options[option_index].name, "pbounds") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->pbounds_arg), 
                 &(args_info->pbounds_orig), &(args_info->pbounds_given),
                &(local_args_info.pbounds_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "pbounds", '-',
                additional_error))
              goto failure;
          
          }
          /* set basename of log-file.  */
          else if (strcmp (long_options[option_index].name, "log") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_arg), 
                 &(args_info->log_orig), &(args_info->log_given),
                &(local_args_info.log_given), optarg, 0, "kinout", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "log", '-',
                additional_error))
              goto failure;
          
          }
          /* set basename of error-log-file.  */
          else if (strcmp (long_options[option_index].name, "err") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->err_arg), 
                 &(args_info->err_orig), &(args_info->err_given),
                &(local_args_info.err_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "err", '-',
                additional_error))
              goto failure;
          
          }
          /* output only local minima to stdout.  */
          else if (strcmp (long_options[option_index].name, "lmin") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->lmin_flag), 0, &(args_info->lmin_given),
                &(local_args_info.lmin_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "lmin", '-',
                additional_error))
              goto failure;
          
          }
          /* output structures with E <= <float> to stdout.  */
          else if (strcmp (long_options[option_index].name, "cut") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cut_arg), 
                 &(args_info->cut_orig), &(args_info->cut_given),
                &(local_args_info.cut_given), optarg, 0, "20", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "cut", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
