/** @file RNAxplorer_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef RNAXPLORER_CMDL_H
#define RNAXPLORER_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef RNAXPLORER_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define RNAXPLORER_CMDLINE_PARSER_PACKAGE "RNAxplorer"
#endif

#ifndef RNAXPLORER_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define RNAXPLORER_CMDLINE_PARSER_PACKAGE_NAME "RNAxplorer"
#endif

#ifndef RNAXPLORER_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define RNAXPLORER_CMDLINE_PARSER_VERSION "0.9"
#endif

/** @brief Where the command line options are stored */
struct RNAxplorer_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int verbose_flag;	/**< @brief Be verbose
 (default=off).  */
  const char *verbose_help; /**< @brief Be verbose
 help description.  */
  char * sequence_arg;	/**< @brief Input sequence (default='').  */
  char * sequence_orig;	/**< @brief Input sequence original value given at command line.  */
  const char *sequence_help; /**< @brief Input sequence help description.  */
  int penalize_structures_flag;	/**< @brief Penalize structures instead of base pairs of local minima, that occure too often. (default=off).  */
  const char *penalize_structures_help; /**< @brief Penalize structures instead of base pairs of local minima, that occure too often. help description.  */
  char * struc1_arg;	/**< @brief Input structure 1 (default='').  */
  char * struc1_orig;	/**< @brief Input structure 1 original value given at command line.  */
  const char *struc1_help; /**< @brief Input structure 1 help description.  */
  char * struc2_arg;	/**< @brief Input structure 2 (default='').  */
  char * struc2_orig;	/**< @brief Input structure 2 original value given at command line.  */
  const char *struc2_help; /**< @brief Input structure 2 help description.  */
  int granularity_arg;	/**< @brief Granularity, i.e. number of samples after which distortion checks are performed (default='100').  */
  char * granularity_orig;	/**< @brief Granularity, i.e. number of samples after which distortion checks are performed original value given at command line.  */
  const char *granularity_help; /**< @brief Granularity, i.e. number of samples after which distortion checks are performed help description.  */
  int num_samples_arg;	/**< @brief Number of samples in total. The number of samples per iteration is n/g. (default='100000').  */
  char * num_samples_orig;	/**< @brief Number of samples in total. The number of samples per iteration is n/g. original value given at command line.  */
  const char *num_samples_help; /**< @brief Number of samples in total. The number of samples per iteration is n/g. help description.  */
  float exploration_factor_arg;	/**< @brief Exploration factor (default='1').  */
  char * exploration_factor_orig;	/**< @brief Exploration factor original value given at command line.  */
  const char *exploration_factor_help; /**< @brief Exploration factor help description.  */
  float min_exploration_percent_arg;	/**< @brief Minimum exploration percentage before adding new repelled structures (default='1').  */
  char * min_exploration_percent_orig;	/**< @brief Minimum exploration percentage before adding new repelled structures original value given at command line.  */
  const char *min_exploration_percent_help; /**< @brief Minimum exploration percentage before adding new repelled structures help description.  */
  int cluster_flag;	/**< @brief Cluster resulting local minima to reduce effective size (default=off).  */
  const char *cluster_help; /**< @brief Cluster resulting local minima to reduce effective size help description.  */
  char * lmin_file_arg;	/**< @brief Output filename for local minima (default='').  */
  char * lmin_file_orig;	/**< @brief Output filename for local minima original value given at command line.  */
  const char *lmin_file_help; /**< @brief Output filename for local minima help description.  */
  char * TwoD_file_arg;	/**< @brief Output filename for pseudo-2D file (default='').  */
  char * TwoD_file_orig;	/**< @brief Output filename for pseudo-2D file original value given at command line.  */
  const char *TwoD_file_help; /**< @brief Output filename for pseudo-2D file help description.  */
  int nonred_flag;	/**< @brief Do sampling with non-redundant pbacktrack (default=off).  */
  const char *nonred_help; /**< @brief Do sampling with non-redundant pbacktrack help description.  */
  char * nonred_file_arg;	/**< @brief Input filename for nonredundant samples (default='').  */
  char * nonred_file_orig;	/**< @brief Input filename for nonredundant samples original value given at command line.  */
  const char *nonred_file_help; /**< @brief Input filename for nonredundant samples help description.  */
  int explore_two_neighborhood_flag;	/**< @brief Explore 2-Neighborhood of local minima, i.e. eliminate shallow minima (default=off).  */
  const char *explore_two_neighborhood_help; /**< @brief Explore 2-Neighborhood of local minima, i.e. eliminate shallow minima help description.  */
  int post_filter_two_flag;	/**< @brief Post processing Filter local minima according to 2-Neighborhood, i.e. eliminate shallow minima (default=off).  */
  const char *post_filter_two_help; /**< @brief Post processing Filter local minima according to 2-Neighborhood, i.e. eliminate shallow minima help description.  */
  int ediff_penalty_flag;	/**< @brief Use energy difference instead of kT for penalty (default=off).  */
  const char *ediff_penalty_help; /**< @brief Use energy difference instead of kT for penalty help description.  */
  float mu_arg;	/**< @brief proportion factor used to decide whether sampling round was sufficient (default='0.1').  */
  char * mu_orig;	/**< @brief proportion factor used to decide whether sampling round was sufficient original value given at command line.  */
  const char *mu_help; /**< @brief proportion factor used to decide whether sampling round was sufficient help description.  */
  char * method_arg;	/**< @brief Set the method used to obtain meshpoint structures for the bisection algorithm
 (default='RSH').  */
  char * method_orig;	/**< @brief Set the method used to obtain meshpoint structures for the bisection algorithm
 original value given at command line.  */
  const char *method_help; /**< @brief Set the method used to obtain meshpoint structures for the bisection algorithm
 help description.  */
  double betaScale_arg;	/**< @brief Set the scaling of the Boltzmann factors
 (default='1.').  */
  char * betaScale_orig;	/**< @brief Set the scaling of the Boltzmann factors
 original value given at command line.  */
  const char *betaScale_help; /**< @brief Set the scaling of the Boltzmann factors
 help description.  */
  char * extended_opt_arg;	/**< @brief Some extended options:
  N    normal distortion (no shift)
  B    alter both potentials at once
  R    relax potential instead of increasing it
  S    shift potential to other structure
  F    shift to first structure
  V    verbose
  
 (default='').  */
  char * extended_opt_orig;	/**< @brief Some extended options:
  N    normal distortion (no shift)
  B    alter both potentials at once
  R    relax potential instead of increasing it
  S    shift potential to other structure
  F    shift to first structure
  V    verbose
  
 original value given at command line.  */
  const char *extended_opt_help; /**< @brief Some extended options:
  N    normal distortion (no shift)
  B    alter both potentials at once
  R    relax potential instead of increasing it
  S    shift potential to other structure
  F    shift to first structure
  V    verbose
  
 help description.  */
  int iterations_arg;	/**< @brief Set the number of iterations/simulations
  
 (default='1').  */
  char * iterations_orig;	/**< @brief Set the number of iterations/simulations
  
 original value given at command line.  */
  const char *iterations_help; /**< @brief Set the number of iterations/simulations
  
 help description.  */
  int maxKeep_arg;	/**< @brief maxKeep for direct path search
  
 (default='10').  */
  char * maxKeep_orig;	/**< @brief maxKeep for direct path search
  
 original value given at command line.  */
  const char *maxKeep_help; /**< @brief maxKeep for direct path search
  
 help description.  */
  int maxStore_arg;	/**< @brief amount of best solutions to hold per iteration
  
 (default='10').  */
  char * maxStore_orig;	/**< @brief amount of best solutions to hold per iteration
  
 original value given at command line.  */
  const char *maxStore_help; /**< @brief amount of best solutions to hold per iteration
  
 help description.  */
  int remember_arg;	/**< @brief Set the number of structure states to remember in a TABU list
  
 (default='10').  */
  char * remember_orig;	/**< @brief Set the number of structure states to remember in a TABU list
  
 original value given at command line.  */
  const char *remember_help; /**< @brief Set the number of structure states to remember in a TABU list
  
 help description.  */
  int circ_flag;	/**< @brief Assume a circular (instead of linear) RNA molecule.
 (default=off).  */
  const char *circ_help; /**< @brief Assume a circular (instead of linear) RNA molecule.
 help description.  */
  float cooling_rate_arg;	/**< @brief Cooling factor used for simulated annealing
  
 (default='0.9998').  */
  char * cooling_rate_orig;	/**< @brief Cooling factor used for simulated annealing
  
 original value given at command line.  */
  const char *cooling_rate_help; /**< @brief Cooling factor used for simulated annealing
  
 help description.  */
  float tstart_arg;	/**< @brief start temperature in deg. Celcius
  
 (default='37.0').  */
  char * tstart_orig;	/**< @brief start temperature in deg. Celcius
  
 original value given at command line.  */
  const char *tstart_help; /**< @brief start temperature in deg. Celcius
  
 help description.  */
  float tstop_arg;	/**< @brief stop temperature in deg. Celcius
  
 (default='0.0').  */
  char * tstop_orig;	/**< @brief stop temperature in deg. Celcius
  
 original value given at command line.  */
  const char *tstop_help; /**< @brief stop temperature in deg. Celcius
  
 help description.  */
  int penalizeBackWalks_flag;	/**< @brief Add a penalty for backward moves, i.e. moves along states already visited
  
 (default=off).  */
  const char *penalizeBackWalks_help; /**< @brief Add a penalty for backward moves, i.e. moves along states already visited
  
 help description.  */
  int basinStructure_flag;	/**< @brief just perform a gradient walk starting from a given structure
  
 (default=off).  */
  const char *basinStructure_help; /**< @brief just perform a gradient walk starting from a given structure
  
 help description.  */
  int maxD_arg;	/**< @brief Maximum base pair distance between meshpoints and references
  
 (default='5').  */
  char * maxD_orig;	/**< @brief Maximum base pair distance between meshpoints and references
  
 original value given at command line.  */
  const char *maxD_help; /**< @brief Maximum base pair distance between meshpoints and references
  
 help description.  */
  int maxD1_arg;	/**< @brief Maximum base pair distance between meshpoints and reference structure 1
  
 (default='5').  */
  char * maxD1_orig;	/**< @brief Maximum base pair distance between meshpoints and reference structure 1
  
 original value given at command line.  */
  const char *maxD1_help; /**< @brief Maximum base pair distance between meshpoints and reference structure 1
  
 help description.  */
  int maxD2_arg;	/**< @brief Maximum base pair distance between meshpoints and reference structure 2
  
 (default='5').  */
  char * maxD2_orig;	/**< @brief Maximum base pair distance between meshpoints and reference structure 2
  
 original value given at command line.  */
  const char *maxD2_help; /**< @brief Maximum base pair distance between meshpoints and reference structure 2
  
 help description.  */
  double temp_arg;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
.  */
  char * temp_orig;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 original value given at command line.  */
  const char *temp_help; /**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 help description.  */
  char ** p0_arg;	/**< @brief Set the percentage of the references distortion value <int> to <double>
  Can be given for all reference indices
  (NOTE: the value <double> should be between 0 and 1)
  (example: \"--p0 2=0.5\" - distortion value of sequence 2 will be multiplied with 0.5 before sampling.).  */
  char ** p0_orig;	/**< @brief Set the percentage of the references distortion value <int> to <double>
  Can be given for all reference indices
  (NOTE: the value <double> should be between 0 and 1)
  (example: \"--p0 2=0.5\" - distortion value of sequence 2 will be multiplied with 0.5 before sampling.) original value given at command line.  */
  unsigned int p0_min; /**< @brief Set the percentage of the references distortion value <int> to <double>
  Can be given for all reference indices
  (NOTE: the value <double> should be between 0 and 1)
  (example: \"--p0 2=0.5\" - distortion value of sequence 2 will be multiplied with 0.5 before sampling.)'s minimum occurreces */
  unsigned int p0_max; /**< @brief Set the percentage of the references distortion value <int> to <double>
  Can be given for all reference indices
  (NOTE: the value <double> should be between 0 and 1)
  (example: \"--p0 2=0.5\" - distortion value of sequence 2 will be multiplied with 0.5 before sampling.)'s maximum occurreces */
  const char *p0_help; /**< @brief Set the percentage of the references distortion value <int> to <double>
  Can be given for all reference indices
  (NOTE: the value <double> should be between 0 and 1)
  (example: \"--p0 2=0.5\" - distortion value of sequence 2 will be multiplied with 0.5 before sampling.) help description.  */
  int shift_moves_flag;	/**< @brief Use shift moves for gradient walks.
  
 (default=off).  */
  const char *shift_moves_help; /**< @brief Use shift moves for gradient walks.
  
 help description.  */
  char * parameter_file_arg;	/**< @brief Use the given parameter file for gradient walks.
  
.  */
  char * parameter_file_orig;	/**< @brief Use the given parameter file for gradient walks.
  
 original value given at command line.  */
  const char *parameter_file_help; /**< @brief Use the given parameter file for gradient walks.
  
 help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int sequence_given ;	/**< @brief Whether sequence was given.  */
  unsigned int penalize_structures_given ;	/**< @brief Whether penalize-structures was given.  */
  unsigned int struc1_given ;	/**< @brief Whether struc1 was given.  */
  unsigned int struc2_given ;	/**< @brief Whether struc2 was given.  */
  unsigned int granularity_given ;	/**< @brief Whether granularity was given.  */
  unsigned int num_samples_given ;	/**< @brief Whether num-samples was given.  */
  unsigned int exploration_factor_given ;	/**< @brief Whether exploration-factor was given.  */
  unsigned int min_exploration_percent_given ;	/**< @brief Whether min-exploration-percent was given.  */
  unsigned int cluster_given ;	/**< @brief Whether cluster was given.  */
  unsigned int lmin_file_given ;	/**< @brief Whether lmin-file was given.  */
  unsigned int TwoD_file_given ;	/**< @brief Whether TwoD-file was given.  */
  unsigned int nonred_given ;	/**< @brief Whether nonred was given.  */
  unsigned int nonred_file_given ;	/**< @brief Whether nonred-file was given.  */
  unsigned int explore_two_neighborhood_given ;	/**< @brief Whether explore-two-neighborhood was given.  */
  unsigned int post_filter_two_given ;	/**< @brief Whether post-filter-two was given.  */
  unsigned int ediff_penalty_given ;	/**< @brief Whether ediff-penalty was given.  */
  unsigned int mu_given ;	/**< @brief Whether mu was given.  */
  unsigned int method_given ;	/**< @brief Whether method was given.  */
  unsigned int betaScale_given ;	/**< @brief Whether betaScale was given.  */
  unsigned int extended_opt_given ;	/**< @brief Whether extended_opt was given.  */
  unsigned int iterations_given ;	/**< @brief Whether iterations was given.  */
  unsigned int maxKeep_given ;	/**< @brief Whether maxKeep was given.  */
  unsigned int maxStore_given ;	/**< @brief Whether maxStore was given.  */
  unsigned int remember_given ;	/**< @brief Whether remember was given.  */
  unsigned int circ_given ;	/**< @brief Whether circ was given.  */
  unsigned int cooling_rate_given ;	/**< @brief Whether cooling-rate was given.  */
  unsigned int tstart_given ;	/**< @brief Whether tstart was given.  */
  unsigned int tstop_given ;	/**< @brief Whether tstop was given.  */
  unsigned int penalizeBackWalks_given ;	/**< @brief Whether penalizeBackWalks was given.  */
  unsigned int basinStructure_given ;	/**< @brief Whether basinStructure was given.  */
  unsigned int maxD_given ;	/**< @brief Whether maxD was given.  */
  unsigned int maxD1_given ;	/**< @brief Whether maxD1 was given.  */
  unsigned int maxD2_given ;	/**< @brief Whether maxD2 was given.  */
  unsigned int temp_given ;	/**< @brief Whether temp was given.  */
  unsigned int p0_given ;	/**< @brief Whether p0 was given.  */
  unsigned int shift_moves_given ;	/**< @brief Whether shift_moves was given.  */
  unsigned int parameter_file_given ;	/**< @brief Whether parameter_file was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct RNAxplorer_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure RNAxplorer_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure RNAxplorer_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *RNAxplorer_args_info_purpose;
/** @brief the usage string of the program */
extern const char *RNAxplorer_args_info_usage;
/** @brief the description string of the program */
extern const char *RNAxplorer_args_info_description;
/** @brief all the lines making the help output */
extern const char *RNAxplorer_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *RNAxplorer_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *RNAxplorer_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAxplorer_cmdline_parser (int argc, char **argv,
  struct RNAxplorer_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use RNAxplorer_cmdline_parser_ext() instead
 */
int RNAxplorer_cmdline_parser2 (int argc, char **argv,
  struct RNAxplorer_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAxplorer_cmdline_parser_ext (int argc, char **argv,
  struct RNAxplorer_args_info *args_info,
  struct RNAxplorer_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAxplorer_cmdline_parser_dump(FILE *outfile,
  struct RNAxplorer_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAxplorer_cmdline_parser_file_save(const char *filename,
  struct RNAxplorer_args_info *args_info);

/**
 * Print the help
 */
void RNAxplorer_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void RNAxplorer_cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void RNAxplorer_cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void RNAxplorer_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a RNAxplorer_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void RNAxplorer_cmdline_parser_params_init(struct RNAxplorer_cmdline_parser_params *params);

/**
 * Allocates dynamically a RNAxplorer_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized RNAxplorer_cmdline_parser_params structure
 */
struct RNAxplorer_cmdline_parser_params *RNAxplorer_cmdline_parser_params_create(void);

/**
 * Initializes the passed RNAxplorer_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void RNAxplorer_cmdline_parser_init (struct RNAxplorer_args_info *args_info);
/**
 * Deallocates the string fields of the RNAxplorer_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void RNAxplorer_cmdline_parser_free (struct RNAxplorer_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int RNAxplorer_cmdline_parser_required (struct RNAxplorer_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNAXPLORER_CMDL_H */
