/** @file ct2db_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CT2DB_CMDL_H
#define CT2DB_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CT2DB_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CT2DB_CMDLINE_PARSER_PACKAGE "ct2db"
#endif

#ifndef CT2DB_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CT2DB_CMDLINE_PARSER_PACKAGE_NAME "ct2db"
#endif

#ifndef CT2DB_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CT2DB_CMDLINE_PARSER_VERSION "1.0"
#endif

/** @brief Where the command line options are stored */
struct ct2db_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int no_pk_flag;	/**< @brief Remove pseudoknots from structure
  
 (default=off).  */
  const char *no_pk_help; /**< @brief Remove pseudoknots from structure
  
 help description.  */
  int no_modified_flag;	/**< @brief Do not keep modified bases, i.e. replace all non-canonical nucleotides with N.
  
 (default=off).  */
  const char *no_modified_help; /**< @brief Do not keep modified bases, i.e. replace all non-canonical nucleotides with N.
  
 help description.  */
  int verbose_flag;	/**< @brief Be verbose.
  
 (default=off).  */
  const char *verbose_help; /**< @brief Be verbose.
  
 help description.  */
  char * fasta_header_arg;	/**< @brief Overwrite FASTA header with user-provided string.
.  */
  char * fasta_header_orig;	/**< @brief Overwrite FASTA header with user-provided string.
 original value given at command line.  */
  const char *fasta_header_help; /**< @brief Overwrite FASTA header with user-provided string.
 help description.  */
  char * fh_from_filename_arg;	/**< @brief Use input file name as output FASTA header.
 (default='replace').  */
  char * fh_from_filename_orig;	/**< @brief Use input file name as output FASTA header.
 original value given at command line.  */
  const char *fh_from_filename_help; /**< @brief Use input file name as output FASTA header.
 help description.  */
  char * filename_suffix_arg;	/**< @brief The filename suffix to remove when turning the filename into a FASTA header.
 (default='.ct').  */
  char * filename_suffix_orig;	/**< @brief The filename suffix to remove when turning the filename into a FASTA header.
 original value given at command line.  */
  const char *filename_suffix_help; /**< @brief The filename suffix to remove when turning the filename into a FASTA header.
 help description.  */
  int log_level_arg;	/**< @brief Set log level threshold.
 (default='2').  */
  char * log_level_orig;	/**< @brief Set log level threshold.
 original value given at command line.  */
  const char *log_level_help; /**< @brief Set log level threshold.
 help description.  */
  char * log_file_arg;	/**< @brief Print log messages to a file instead of stderr.
 (default='ct2db.log').  */
  char * log_file_orig;	/**< @brief Print log messages to a file instead of stderr.
 original value given at command line.  */
  const char *log_file_help; /**< @brief Print log messages to a file instead of stderr.
 help description.  */
  int log_time_flag;	/**< @brief Include time stamp in log messages.
  
 (default=off).  */
  const char *log_time_help; /**< @brief Include time stamp in log messages.
  
 help description.  */
  int log_call_flag;	/**< @brief Include file and line of log calling function.
  
 (default=off).  */
  const char *log_call_help; /**< @brief Include file and line of log calling function.
  
 help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int no_pk_given ;	/**< @brief Whether no-pk was given.  */
  unsigned int no_modified_given ;	/**< @brief Whether no-modified was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int fasta_header_given ;	/**< @brief Whether fasta-header was given.  */
  unsigned int fh_from_filename_given ;	/**< @brief Whether fh-from-filename was given.  */
  unsigned int filename_suffix_given ;	/**< @brief Whether filename-suffix was given.  */
  unsigned int log_level_given ;	/**< @brief Whether log-level was given.  */
  unsigned int log_file_given ;	/**< @brief Whether log-file was given.  */
  unsigned int log_time_given ;	/**< @brief Whether log-time was given.  */
  unsigned int log_call_given ;	/**< @brief Whether log-call was given.  */

  char **inputs ; /**< @brief unnamed options (options without names) */
  unsigned inputs_num ; /**< @brief unnamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct ct2db_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure ct2db_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure ct2db_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *ct2db_args_info_purpose;
/** @brief the usage string of the program */
extern const char *ct2db_args_info_usage;
/** @brief the description string of the program */
extern const char *ct2db_args_info_description;
/** @brief all the lines making the help output */
extern const char *ct2db_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *ct2db_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *ct2db_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ct2db_cmdline_parser (int argc, char **argv,
  struct ct2db_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use ct2db_cmdline_parser_ext() instead
 */
int ct2db_cmdline_parser2 (int argc, char **argv,
  struct ct2db_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ct2db_cmdline_parser_ext (int argc, char **argv,
  struct ct2db_args_info *args_info,
  struct ct2db_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ct2db_cmdline_parser_dump(FILE *outfile,
  struct ct2db_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ct2db_cmdline_parser_file_save(const char *filename,
  struct ct2db_args_info *args_info);

/**
 * Print the help
 */
void ct2db_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void ct2db_cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void ct2db_cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void ct2db_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a ct2db_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void ct2db_cmdline_parser_params_init(struct ct2db_cmdline_parser_params *params);

/**
 * Allocates dynamically a ct2db_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized ct2db_cmdline_parser_params structure
 */
struct ct2db_cmdline_parser_params *ct2db_cmdline_parser_params_create(void);

/**
 * Initializes the passed ct2db_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void ct2db_cmdline_parser_init (struct ct2db_args_info *args_info);
/**
 * Deallocates the string fields of the ct2db_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void ct2db_cmdline_parser_free (struct ct2db_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int ct2db_cmdline_parser_required (struct ct2db_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CT2DB_CMDL_H */
