/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt -i RNAsnoop.ggo --file-name=RNAsnoop_cmdl --include-getopt --default-optional --func-name=RNAsnoop_cmdline_parser --arg-struct-name=RNAsnoop_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAsnoop_cmdl.h"

const char *RNAsnoop_args_info_purpose = "Find targets of a query H/ACA snoRNA";

const char *RNAsnoop_args_info_usage = "Usage: RNAsnoop [options]\n";

const char *RNAsnoop_args_info_versiontext = "";

const char *RNAsnoop_args_info_description = "reads a target RNA sequence and a H/ACA snoRNA sequence\nfrom a target and query file, respectively and computes optimal\nand suboptimal secondary structures for their hybridization. The\ncalculation can be done roughly in O(nm), where is n the length\nof the target sequence and m is the length of the snoRNA stem, as it\nis specially tailored to the special case of H/ACA snoRNA. For general\npurpose target predictions, please have a look at RNAduplex, RNAup,\nRNAcofold and RNAplex. Accessibility effects can be estimated by\nRNAsnoop if a RNAplfold accessibility profile is provided. \n\nThe computed optimal and suboptimal structure are written to\nstdout, one structure per line. Each line consist\nof: The structure in dot bracket format with a \"&\" separating the\ntwo strands. The '<>' brackets represent snoRNA intramolecular\ninteractions, while the '()' brackets represent intermolecular\ninteractions between the snoRNA and its target.\n\nThe range of the structure in the two sequences in the format\n\"from,to : from,to\"; the energy of duplex structure in\nkcal/mol. If available the opening energy are also returned.\n";

const char *RNAsnoop_args_info_detailed_help[] = {
  "      --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden\n                                  options, and exit",
  "  -V, --version                 Print version and exit",
  "\nInput Options:",
  "  Below are command line options which alter the general input behavior of\n  RNAsnoop\n",
  "  -L, --alignmentLength=INT     Limit the extent of the interactions to L\n                                  nucleotides\n\n                                    (default=`25')",
  "  -C, --constraint              Calculate the stem structure subject to\n                                  constraints.\n                                    (default=off)",
  "  The program reads first the stem sequence, then a string containing\n  constraints on the structure encoded with the symbols:\n\n  . (no constraint for this base)\n\n  | (the corresponding base has to be paired\n\n  x (the base is unpaired)\n\n  < (base i is paired with a base j>i)\n\n  > (base i is paired with a base j<i)\n\n  and matching brackets ( ) (base i pairs base j)\n\n  With the exception of \"|\", constraints will disallow all pairs conflicting\n  with the constraint. This is usually sufficient to enforce the constraint,\n  but occasionally a base may stay unpaired in spite of constraints. PF folding\n  ignores constraints of type \"|\".\n\n",
  "  -s, --query=STRING            File containing the query sequence.\n",
  "  Input sequences can be given piped to RNAsnoop or given in a query file with\n  the -s option. Note that the -s option implies that the -t option is also\n  used\n\n",
  "  -t, --target=STRING           File containing the target sequence.\n",
  "  Input sequences can be given piped to RNAsnoop or given in a target file with\n  the -t optionNote that the -t option implies that the -s option is also used\n\n",
  "  -S, --suffix=STRING           Specificy the suffix that was added by RNAup to\n                                  the accessibility files\n\n                                    (default=`_u1_to_30.out')",
  "  -P, --from-RNAplfold=STRING   Specify the directory where accessibility\n                                  profile generated by RNAplfold are found\n\n",
  "\nAlgorithms:",
  "  Options which alter the computing behaviour of RNAplex.\n  Please note that the options allowing to filter out snoRNA-RNA\n  duplexes expect the energy to be given in decacal/mol instead of\n  kcal/mol. A threshold of -2.8(kcal/mol) should be given as -280(decacal/mol)\n\n",
  "  -A, --alignment-mode          Specify if RNAsnoop gets alignments or single\n                                  sequences as input\n\n                                    (default=off)",
  "  -f, --fast-folding=INT        Speedup of the target search  (default=`1')",
  "  This option allows one to decide if the backtracking has to be\n  done (-f 1) or not (-f 0). For -f 1 the structure is computed based\n  on the standard energy model. This is the slowest mode of RNAsnoop. -f\n  0 is the fastest mode, as no structure are recomputed and only the\n  interaction energy is returned\n\n",
  "  -c, --extension-cost=INT      Cost to add to each nucleotide in a duplex\n                                  (default=`0')",
  "  Cost of extending a duplex by one nucleotide. Allows one to find\n  compact duplexes, having few/small bulges or interior loops. Only\n  useful when no accessibility profiles are available. This option is\n  disabled if accessibility profiles are used (-P option)\n\n",
  "  -o, --minimal-right-duplex=INT\n                                Minimal Right Duplex Energy\n\n                                    (default=`-270')",
  "  -l, --minimal-loop-energy=INT Minimal Right Duplex Energy\n                                    (default=`-280')",
  "  Minimal Stem Loop Energy of the snoRNA. The energy should be\n  given in decacalories, i.e. a minimal stem-loop energy of -2.8\n  kcal/mol corresponds to -280 decacal/mol\n\n",
  "  -p, --minimal-left-duplex=INT Minimal Left Duplex Energy\n\n                                    (default=`-170')",
  "  -q, --minimal-duplex=INT      Minimal Duplex Energy\n\n                                    (default=`-1090')",
  "  -d, --duplex-distance=INT     Distance between target 3' ends of two\n                                  consecutive duplexes\n                                    (default=`2')",
  "  Distance between the target 3'ends of two consecutive\n  duplexes. Should be set to the maximal length of interaction to get\n  good results. Smaller d leads to larger overlaps between consecutive\n  duplexes\n\n",
  "  -h, --minimal-stem-length=INT Minimal snoRNA stem length\n\n                                    (default=`5')",
  "  -i, --maximal-stem-length=INT Maximal snoRNA stem length\n\n                                    (default=`120')",
  "  -j, --minimal-duplex-box-length=INT\n                                Minimal distance between the duplex end and the\n                                  H/ACA box\n\n                                    (default=`11')",
  "  -k, --maximal-duplex-box-length=INT\n                                Maximal distance between the duplex end and the\n                                  H/ACA box\n\n                                    (default=`16')",
  "  -m, --minimal-snoRNA-stem-loop-length=INT\n                                Minimal number of nucleotides between the\n                                  beginning of stem loop and\n                                  beginning of the snoRNA sequence\n\n                                    (default=`1')",
  "  -n, --maximal-snoRNA-stem-loop-length=INT\n                                Maximal number of nucleotides between the\n                                  beginning of stem loop and\n                                  beginning of the snoRNA sequence\n\n                                    (default=`100000')",
  "  -v, --minimal-snoRNA-duplex-length=INT\n                                Minimal distance between duplex start and\n                                  snoRNA\n\n                                    (default=`0')",
  "  -w, --maximal-snoRNA-duplex-length=INT\n                                Maximal distance between duplex start and\n                                  snoRNA\n\n                                    (default=`0')",
  "  -x, --minimal-duplex-stem-energy=INT\n                                Minimal duplex stem energy\n\n                                    (default=`-1370')",
  "  -y, --minimal-total-energy=INT\n                                Minimal total energy\n\n                                    (default=`100000')",
  "  -a, --maximal-stem-asymmetry=INT\n                                Maximal snoRNA stem asymmetry\n\n                                    (default=`30')",
  "  -b, --minimal-lower-stem-energy=INT\n                                Minimal lower stem energy\n\n                                    (default=`100000')",
  "\nOutput options:",
  "  Options that modifies the output\n\n",
  "  -e, --energy-threshold=DOUBLE Maximal energy difference between the mfe and\n                                  the desired suboptimal\n                                    (default=`-1')",
  "  Energy range for a duplex to be returned. The threshold is set on the total\n  energy of interaction, i.e. the hybridizationenergy corrected for opening\n  energy if -a is set or the energy corrected by -c. If unset, only the mfe\n  will be returned\n\n",
  "  -I, --produce-ps              Draw annotated 2D structures for a list of\n                                  dot-bracket structures\n                                    (default=off)",
  "  This option allows one to produce interaction figures in PS-format with\n  conservation/accessibility annotation, if available\n\n",
  "  -O, --output_directory=STRING Set where the generated figures should be\n                                  stored\n\n                                    (default=`./')",
  "  -N, --direct-redraw           Outputs 2D interactions concurrently with the\n                                  interaction calculation for each suboptimal\n                                  interaction. The -I option should be\n                                  preferred.\n\n                                    (default=off)",
  "  -U, --from-RNAup=STRING       Specify the directory where accessibility\n                                  profiles generated by RNAup are found\n\n",
  "\nIf in doubt our program is right, nature is at fault.\nComments should be sent to rna@tbi.univie.ac.at.\n\n",
    0
};

static void
init_help_array(void)
{
  RNAsnoop_args_info_help[0] = RNAsnoop_args_info_detailed_help[0];
  RNAsnoop_args_info_help[1] = RNAsnoop_args_info_detailed_help[1];
  RNAsnoop_args_info_help[2] = RNAsnoop_args_info_detailed_help[2];
  RNAsnoop_args_info_help[3] = RNAsnoop_args_info_detailed_help[3];
  RNAsnoop_args_info_help[4] = RNAsnoop_args_info_detailed_help[4];
  RNAsnoop_args_info_help[5] = RNAsnoop_args_info_detailed_help[5];
  RNAsnoop_args_info_help[6] = RNAsnoop_args_info_detailed_help[6];
  RNAsnoop_args_info_help[7] = RNAsnoop_args_info_detailed_help[8];
  RNAsnoop_args_info_help[8] = RNAsnoop_args_info_detailed_help[10];
  RNAsnoop_args_info_help[9] = RNAsnoop_args_info_detailed_help[12];
  RNAsnoop_args_info_help[10] = RNAsnoop_args_info_detailed_help[13];
  RNAsnoop_args_info_help[11] = RNAsnoop_args_info_detailed_help[14];
  RNAsnoop_args_info_help[12] = RNAsnoop_args_info_detailed_help[15];
  RNAsnoop_args_info_help[13] = RNAsnoop_args_info_detailed_help[16];
  RNAsnoop_args_info_help[14] = RNAsnoop_args_info_detailed_help[17];
  RNAsnoop_args_info_help[15] = RNAsnoop_args_info_detailed_help[19];
  RNAsnoop_args_info_help[16] = RNAsnoop_args_info_detailed_help[21];
  RNAsnoop_args_info_help[17] = RNAsnoop_args_info_detailed_help[22];
  RNAsnoop_args_info_help[18] = RNAsnoop_args_info_detailed_help[24];
  RNAsnoop_args_info_help[19] = RNAsnoop_args_info_detailed_help[25];
  RNAsnoop_args_info_help[20] = RNAsnoop_args_info_detailed_help[26];
  RNAsnoop_args_info_help[21] = RNAsnoop_args_info_detailed_help[28];
  RNAsnoop_args_info_help[22] = RNAsnoop_args_info_detailed_help[29];
  RNAsnoop_args_info_help[23] = RNAsnoop_args_info_detailed_help[30];
  RNAsnoop_args_info_help[24] = RNAsnoop_args_info_detailed_help[31];
  RNAsnoop_args_info_help[25] = RNAsnoop_args_info_detailed_help[32];
  RNAsnoop_args_info_help[26] = RNAsnoop_args_info_detailed_help[33];
  RNAsnoop_args_info_help[27] = RNAsnoop_args_info_detailed_help[34];
  RNAsnoop_args_info_help[28] = RNAsnoop_args_info_detailed_help[35];
  RNAsnoop_args_info_help[29] = RNAsnoop_args_info_detailed_help[36];
  RNAsnoop_args_info_help[30] = RNAsnoop_args_info_detailed_help[37];
  RNAsnoop_args_info_help[31] = RNAsnoop_args_info_detailed_help[38];
  RNAsnoop_args_info_help[32] = RNAsnoop_args_info_detailed_help[39];
  RNAsnoop_args_info_help[33] = RNAsnoop_args_info_detailed_help[40];
  RNAsnoop_args_info_help[34] = RNAsnoop_args_info_detailed_help[41];
  RNAsnoop_args_info_help[35] = RNAsnoop_args_info_detailed_help[42];
  RNAsnoop_args_info_help[36] = RNAsnoop_args_info_detailed_help[44];
  RNAsnoop_args_info_help[37] = RNAsnoop_args_info_detailed_help[46];
  RNAsnoop_args_info_help[38] = RNAsnoop_args_info_detailed_help[47];
  RNAsnoop_args_info_help[39] = RNAsnoop_args_info_detailed_help[48];
  RNAsnoop_args_info_help[40] = RNAsnoop_args_info_detailed_help[49];
  RNAsnoop_args_info_help[41] = 0; 
  
}

const char *RNAsnoop_args_info_help[42];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_DOUBLE
} RNAsnoop_cmdline_parser_arg_type;

static
void clear_given (struct RNAsnoop_args_info *args_info);
static
void clear_args (struct RNAsnoop_args_info *args_info);

static int
RNAsnoop_cmdline_parser_internal (int argc, char **argv, struct RNAsnoop_args_info *args_info,
                        struct RNAsnoop_cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAsnoop_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->alignmentLength_given = 0 ;
  args_info->constraint_given = 0 ;
  args_info->query_given = 0 ;
  args_info->target_given = 0 ;
  args_info->suffix_given = 0 ;
  args_info->from_RNAplfold_given = 0 ;
  args_info->alignment_mode_given = 0 ;
  args_info->fast_folding_given = 0 ;
  args_info->extension_cost_given = 0 ;
  args_info->minimal_right_duplex_given = 0 ;
  args_info->minimal_loop_energy_given = 0 ;
  args_info->minimal_left_duplex_given = 0 ;
  args_info->minimal_duplex_given = 0 ;
  args_info->duplex_distance_given = 0 ;
  args_info->minimal_stem_length_given = 0 ;
  args_info->maximal_stem_length_given = 0 ;
  args_info->minimal_duplex_box_length_given = 0 ;
  args_info->maximal_duplex_box_length_given = 0 ;
  args_info->minimal_snoRNA_stem_loop_length_given = 0 ;
  args_info->maximal_snoRNA_stem_loop_length_given = 0 ;
  args_info->minimal_snoRNA_duplex_length_given = 0 ;
  args_info->maximal_snoRNA_duplex_length_given = 0 ;
  args_info->minimal_duplex_stem_energy_given = 0 ;
  args_info->minimal_total_energy_given = 0 ;
  args_info->maximal_stem_asymmetry_given = 0 ;
  args_info->minimal_lower_stem_energy_given = 0 ;
  args_info->energy_threshold_given = 0 ;
  args_info->produce_ps_given = 0 ;
  args_info->output_directory_given = 0 ;
  args_info->direct_redraw_given = 0 ;
  args_info->from_RNAup_given = 0 ;
}

static
void clear_args (struct RNAsnoop_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->alignmentLength_arg = 25;
  args_info->alignmentLength_orig = NULL;
  args_info->constraint_flag = 0;
  args_info->query_arg = NULL;
  args_info->query_orig = NULL;
  args_info->target_arg = NULL;
  args_info->target_orig = NULL;
  args_info->suffix_arg = gengetopt_strdup ("_u1_to_30.out");
  args_info->suffix_orig = NULL;
  args_info->from_RNAplfold_arg = NULL;
  args_info->from_RNAplfold_orig = NULL;
  args_info->alignment_mode_flag = 0;
  args_info->fast_folding_arg = 1;
  args_info->fast_folding_orig = NULL;
  args_info->extension_cost_arg = 0;
  args_info->extension_cost_orig = NULL;
  args_info->minimal_right_duplex_arg = -270;
  args_info->minimal_right_duplex_orig = NULL;
  args_info->minimal_loop_energy_arg = -280;
  args_info->minimal_loop_energy_orig = NULL;
  args_info->minimal_left_duplex_arg = -170;
  args_info->minimal_left_duplex_orig = NULL;
  args_info->minimal_duplex_arg = -1090;
  args_info->minimal_duplex_orig = NULL;
  args_info->duplex_distance_arg = 2;
  args_info->duplex_distance_orig = NULL;
  args_info->minimal_stem_length_arg = 5;
  args_info->minimal_stem_length_orig = NULL;
  args_info->maximal_stem_length_arg = 120;
  args_info->maximal_stem_length_orig = NULL;
  args_info->minimal_duplex_box_length_arg = 11;
  args_info->minimal_duplex_box_length_orig = NULL;
  args_info->maximal_duplex_box_length_arg = 16;
  args_info->maximal_duplex_box_length_orig = NULL;
  args_info->minimal_snoRNA_stem_loop_length_arg = 1;
  args_info->minimal_snoRNA_stem_loop_length_orig = NULL;
  args_info->maximal_snoRNA_stem_loop_length_arg = 100000;
  args_info->maximal_snoRNA_stem_loop_length_orig = NULL;
  args_info->minimal_snoRNA_duplex_length_arg = 0;
  args_info->minimal_snoRNA_duplex_length_orig = NULL;
  args_info->maximal_snoRNA_duplex_length_arg = 0;
  args_info->maximal_snoRNA_duplex_length_orig = NULL;
  args_info->minimal_duplex_stem_energy_arg = -1370;
  args_info->minimal_duplex_stem_energy_orig = NULL;
  args_info->minimal_total_energy_arg = 100000;
  args_info->minimal_total_energy_orig = NULL;
  args_info->maximal_stem_asymmetry_arg = 30;
  args_info->maximal_stem_asymmetry_orig = NULL;
  args_info->minimal_lower_stem_energy_arg = 100000;
  args_info->minimal_lower_stem_energy_orig = NULL;
  args_info->energy_threshold_arg = -1;
  args_info->energy_threshold_orig = NULL;
  args_info->produce_ps_flag = 0;
  args_info->output_directory_arg = gengetopt_strdup ("./");
  args_info->output_directory_orig = NULL;
  args_info->direct_redraw_flag = 0;
  args_info->from_RNAup_arg = NULL;
  args_info->from_RNAup_orig = NULL;
  
}

static
void init_args_info(struct RNAsnoop_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = RNAsnoop_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAsnoop_args_info_detailed_help[1] ;
  args_info->version_help = RNAsnoop_args_info_detailed_help[2] ;
  args_info->alignmentLength_help = RNAsnoop_args_info_detailed_help[5] ;
  args_info->constraint_help = RNAsnoop_args_info_detailed_help[6] ;
  args_info->query_help = RNAsnoop_args_info_detailed_help[8] ;
  args_info->target_help = RNAsnoop_args_info_detailed_help[10] ;
  args_info->suffix_help = RNAsnoop_args_info_detailed_help[12] ;
  args_info->from_RNAplfold_help = RNAsnoop_args_info_detailed_help[13] ;
  args_info->alignment_mode_help = RNAsnoop_args_info_detailed_help[16] ;
  args_info->fast_folding_help = RNAsnoop_args_info_detailed_help[17] ;
  args_info->extension_cost_help = RNAsnoop_args_info_detailed_help[19] ;
  args_info->minimal_right_duplex_help = RNAsnoop_args_info_detailed_help[21] ;
  args_info->minimal_loop_energy_help = RNAsnoop_args_info_detailed_help[22] ;
  args_info->minimal_left_duplex_help = RNAsnoop_args_info_detailed_help[24] ;
  args_info->minimal_duplex_help = RNAsnoop_args_info_detailed_help[25] ;
  args_info->duplex_distance_help = RNAsnoop_args_info_detailed_help[26] ;
  args_info->minimal_stem_length_help = RNAsnoop_args_info_detailed_help[28] ;
  args_info->maximal_stem_length_help = RNAsnoop_args_info_detailed_help[29] ;
  args_info->minimal_duplex_box_length_help = RNAsnoop_args_info_detailed_help[30] ;
  args_info->maximal_duplex_box_length_help = RNAsnoop_args_info_detailed_help[31] ;
  args_info->minimal_snoRNA_stem_loop_length_help = RNAsnoop_args_info_detailed_help[32] ;
  args_info->maximal_snoRNA_stem_loop_length_help = RNAsnoop_args_info_detailed_help[33] ;
  args_info->minimal_snoRNA_duplex_length_help = RNAsnoop_args_info_detailed_help[34] ;
  args_info->maximal_snoRNA_duplex_length_help = RNAsnoop_args_info_detailed_help[35] ;
  args_info->minimal_duplex_stem_energy_help = RNAsnoop_args_info_detailed_help[36] ;
  args_info->minimal_total_energy_help = RNAsnoop_args_info_detailed_help[37] ;
  args_info->maximal_stem_asymmetry_help = RNAsnoop_args_info_detailed_help[38] ;
  args_info->minimal_lower_stem_energy_help = RNAsnoop_args_info_detailed_help[39] ;
  args_info->energy_threshold_help = RNAsnoop_args_info_detailed_help[42] ;
  args_info->produce_ps_help = RNAsnoop_args_info_detailed_help[44] ;
  args_info->output_directory_help = RNAsnoop_args_info_detailed_help[46] ;
  args_info->direct_redraw_help = RNAsnoop_args_info_detailed_help[47] ;
  args_info->from_RNAup_help = RNAsnoop_args_info_detailed_help[48] ;
  
}

void
RNAsnoop_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNASNOOP_CMDLINE_PARSER_PACKAGE_NAME) ? RNASNOOP_CMDLINE_PARSER_PACKAGE_NAME : RNASNOOP_CMDLINE_PARSER_PACKAGE),
     RNASNOOP_CMDLINE_PARSER_VERSION);

  if (strlen(RNAsnoop_args_info_versiontext) > 0)
    printf("\n%s\n", RNAsnoop_args_info_versiontext);
}

static void print_help_common(void) {
  RNAsnoop_cmdline_parser_print_version ();

  if (strlen(RNAsnoop_args_info_purpose) > 0)
    printf("\n%s\n", RNAsnoop_args_info_purpose);

  if (strlen(RNAsnoop_args_info_usage) > 0)
    printf("\n%s\n", RNAsnoop_args_info_usage);

  printf("\n");

  if (strlen(RNAsnoop_args_info_description) > 0)
    printf("%s\n\n", RNAsnoop_args_info_description);
}

void
RNAsnoop_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsnoop_args_info_help[i])
    printf("%s\n", RNAsnoop_args_info_help[i++]);
}

void
RNAsnoop_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsnoop_args_info_detailed_help[i])
    printf("%s\n", RNAsnoop_args_info_detailed_help[i++]);
}

void
RNAsnoop_cmdline_parser_init (struct RNAsnoop_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
RNAsnoop_cmdline_parser_params_init(struct RNAsnoop_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAsnoop_cmdline_parser_params *
RNAsnoop_cmdline_parser_params_create(void)
{
  struct RNAsnoop_cmdline_parser_params *params = 
    (struct RNAsnoop_cmdline_parser_params *)malloc(sizeof(struct RNAsnoop_cmdline_parser_params));
  RNAsnoop_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
RNAsnoop_cmdline_parser_release (struct RNAsnoop_args_info *args_info)
{

  free_string_field (&(args_info->alignmentLength_orig));
  free_string_field (&(args_info->query_arg));
  free_string_field (&(args_info->query_orig));
  free_string_field (&(args_info->target_arg));
  free_string_field (&(args_info->target_orig));
  free_string_field (&(args_info->suffix_arg));
  free_string_field (&(args_info->suffix_orig));
  free_string_field (&(args_info->from_RNAplfold_arg));
  free_string_field (&(args_info->from_RNAplfold_orig));
  free_string_field (&(args_info->fast_folding_orig));
  free_string_field (&(args_info->extension_cost_orig));
  free_string_field (&(args_info->minimal_right_duplex_orig));
  free_string_field (&(args_info->minimal_loop_energy_orig));
  free_string_field (&(args_info->minimal_left_duplex_orig));
  free_string_field (&(args_info->minimal_duplex_orig));
  free_string_field (&(args_info->duplex_distance_orig));
  free_string_field (&(args_info->minimal_stem_length_orig));
  free_string_field (&(args_info->maximal_stem_length_orig));
  free_string_field (&(args_info->minimal_duplex_box_length_orig));
  free_string_field (&(args_info->maximal_duplex_box_length_orig));
  free_string_field (&(args_info->minimal_snoRNA_stem_loop_length_orig));
  free_string_field (&(args_info->maximal_snoRNA_stem_loop_length_orig));
  free_string_field (&(args_info->minimal_snoRNA_duplex_length_orig));
  free_string_field (&(args_info->maximal_snoRNA_duplex_length_orig));
  free_string_field (&(args_info->minimal_duplex_stem_energy_orig));
  free_string_field (&(args_info->minimal_total_energy_orig));
  free_string_field (&(args_info->maximal_stem_asymmetry_orig));
  free_string_field (&(args_info->minimal_lower_stem_energy_orig));
  free_string_field (&(args_info->energy_threshold_orig));
  free_string_field (&(args_info->output_directory_arg));
  free_string_field (&(args_info->output_directory_orig));
  free_string_field (&(args_info->from_RNAup_arg));
  free_string_field (&(args_info->from_RNAup_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
RNAsnoop_cmdline_parser_dump(FILE *outfile, struct RNAsnoop_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNASNOOP_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->alignmentLength_given)
    write_into_file(outfile, "alignmentLength", args_info->alignmentLength_orig, 0);
  if (args_info->constraint_given)
    write_into_file(outfile, "constraint", 0, 0 );
  if (args_info->query_given)
    write_into_file(outfile, "query", args_info->query_orig, 0);
  if (args_info->target_given)
    write_into_file(outfile, "target", args_info->target_orig, 0);
  if (args_info->suffix_given)
    write_into_file(outfile, "suffix", args_info->suffix_orig, 0);
  if (args_info->from_RNAplfold_given)
    write_into_file(outfile, "from-RNAplfold", args_info->from_RNAplfold_orig, 0);
  if (args_info->alignment_mode_given)
    write_into_file(outfile, "alignment-mode", 0, 0 );
  if (args_info->fast_folding_given)
    write_into_file(outfile, "fast-folding", args_info->fast_folding_orig, 0);
  if (args_info->extension_cost_given)
    write_into_file(outfile, "extension-cost", args_info->extension_cost_orig, 0);
  if (args_info->minimal_right_duplex_given)
    write_into_file(outfile, "minimal-right-duplex", args_info->minimal_right_duplex_orig, 0);
  if (args_info->minimal_loop_energy_given)
    write_into_file(outfile, "minimal-loop-energy", args_info->minimal_loop_energy_orig, 0);
  if (args_info->minimal_left_duplex_given)
    write_into_file(outfile, "minimal-left-duplex", args_info->minimal_left_duplex_orig, 0);
  if (args_info->minimal_duplex_given)
    write_into_file(outfile, "minimal-duplex", args_info->minimal_duplex_orig, 0);
  if (args_info->duplex_distance_given)
    write_into_file(outfile, "duplex-distance", args_info->duplex_distance_orig, 0);
  if (args_info->minimal_stem_length_given)
    write_into_file(outfile, "minimal-stem-length", args_info->minimal_stem_length_orig, 0);
  if (args_info->maximal_stem_length_given)
    write_into_file(outfile, "maximal-stem-length", args_info->maximal_stem_length_orig, 0);
  if (args_info->minimal_duplex_box_length_given)
    write_into_file(outfile, "minimal-duplex-box-length", args_info->minimal_duplex_box_length_orig, 0);
  if (args_info->maximal_duplex_box_length_given)
    write_into_file(outfile, "maximal-duplex-box-length", args_info->maximal_duplex_box_length_orig, 0);
  if (args_info->minimal_snoRNA_stem_loop_length_given)
    write_into_file(outfile, "minimal-snoRNA-stem-loop-length", args_info->minimal_snoRNA_stem_loop_length_orig, 0);
  if (args_info->maximal_snoRNA_stem_loop_length_given)
    write_into_file(outfile, "maximal-snoRNA-stem-loop-length", args_info->maximal_snoRNA_stem_loop_length_orig, 0);
  if (args_info->minimal_snoRNA_duplex_length_given)
    write_into_file(outfile, "minimal-snoRNA-duplex-length", args_info->minimal_snoRNA_duplex_length_orig, 0);
  if (args_info->maximal_snoRNA_duplex_length_given)
    write_into_file(outfile, "maximal-snoRNA-duplex-length", args_info->maximal_snoRNA_duplex_length_orig, 0);
  if (args_info->minimal_duplex_stem_energy_given)
    write_into_file(outfile, "minimal-duplex-stem-energy", args_info->minimal_duplex_stem_energy_orig, 0);
  if (args_info->minimal_total_energy_given)
    write_into_file(outfile, "minimal-total-energy", args_info->minimal_total_energy_orig, 0);
  if (args_info->maximal_stem_asymmetry_given)
    write_into_file(outfile, "maximal-stem-asymmetry", args_info->maximal_stem_asymmetry_orig, 0);
  if (args_info->minimal_lower_stem_energy_given)
    write_into_file(outfile, "minimal-lower-stem-energy", args_info->minimal_lower_stem_energy_orig, 0);
  if (args_info->energy_threshold_given)
    write_into_file(outfile, "energy-threshold", args_info->energy_threshold_orig, 0);
  if (args_info->produce_ps_given)
    write_into_file(outfile, "produce-ps", 0, 0 );
  if (args_info->output_directory_given)
    write_into_file(outfile, "output_directory", args_info->output_directory_orig, 0);
  if (args_info->direct_redraw_given)
    write_into_file(outfile, "direct-redraw", 0, 0 );
  if (args_info->from_RNAup_given)
    write_into_file(outfile, "from-RNAup", args_info->from_RNAup_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAsnoop_cmdline_parser_file_save(const char *filename, struct RNAsnoop_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNASNOOP_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAsnoop_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAsnoop_cmdline_parser_free (struct RNAsnoop_args_info *args_info)
{
  RNAsnoop_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
RNAsnoop_cmdline_parser (int argc, char **argv, struct RNAsnoop_args_info *args_info)
{
  return RNAsnoop_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAsnoop_cmdline_parser_ext (int argc, char **argv, struct RNAsnoop_args_info *args_info,
                   struct RNAsnoop_cmdline_parser_params *params)
{
  int result;
  result = RNAsnoop_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAsnoop_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsnoop_cmdline_parser2 (int argc, char **argv, struct RNAsnoop_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAsnoop_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAsnoop_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAsnoop_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsnoop_cmdline_parser_required (struct RNAsnoop_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAsnoop_cmdline_parser_params.check_ambiguity
 * @param override @see RNAsnoop_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAsnoop_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
RNAsnoop_cmdline_parser_internal (
  int argc, char **argv, struct RNAsnoop_args_info *args_info,
                        struct RNAsnoop_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct RNAsnoop_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    RNAsnoop_cmdline_parser_init (args_info);

  RNAsnoop_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 0 },
        { "detailed-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "alignmentLength",	1, NULL, 'L' },
        { "constraint",	0, NULL, 'C' },
        { "query",	1, NULL, 's' },
        { "target",	1, NULL, 't' },
        { "suffix",	1, NULL, 'S' },
        { "from-RNAplfold",	1, NULL, 'P' },
        { "alignment-mode",	0, NULL, 'A' },
        { "fast-folding",	1, NULL, 'f' },
        { "extension-cost",	1, NULL, 'c' },
        { "minimal-right-duplex",	1, NULL, 'o' },
        { "minimal-loop-energy",	1, NULL, 'l' },
        { "minimal-left-duplex",	1, NULL, 'p' },
        { "minimal-duplex",	1, NULL, 'q' },
        { "duplex-distance",	1, NULL, 'd' },
        { "minimal-stem-length",	1, NULL, 'h' },
        { "maximal-stem-length",	1, NULL, 'i' },
        { "minimal-duplex-box-length",	1, NULL, 'j' },
        { "maximal-duplex-box-length",	1, NULL, 'k' },
        { "minimal-snoRNA-stem-loop-length",	1, NULL, 'm' },
        { "maximal-snoRNA-stem-loop-length",	1, NULL, 'n' },
        { "minimal-snoRNA-duplex-length",	1, NULL, 'v' },
        { "maximal-snoRNA-duplex-length",	1, NULL, 'w' },
        { "minimal-duplex-stem-energy",	1, NULL, 'x' },
        { "minimal-total-energy",	1, NULL, 'y' },
        { "maximal-stem-asymmetry",	1, NULL, 'a' },
        { "minimal-lower-stem-energy",	1, NULL, 'b' },
        { "energy-threshold",	1, NULL, 'e' },
        { "produce-ps",	0, NULL, 'I' },
        { "output_directory",	1, NULL, 'O' },
        { "direct-redraw",	0, NULL, 'N' },
        { "from-RNAup",	1, NULL, 'U' },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "VL:Cs:t:S:P:Af:c:o:l:p:q:d:h:i:j:k:m:n:v:w:x:y:a:b:e:IO:NU:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'V':	/* Print version and exit.  */
          RNAsnoop_cmdline_parser_print_version ();
          RNAsnoop_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'L':	/* Limit the extent of the interactions to L nucleotides
        
.  */
        
        
          if (update_arg( (void *)&(args_info->alignmentLength_arg), 
               &(args_info->alignmentLength_orig), &(args_info->alignmentLength_given),
              &(local_args_info.alignmentLength_given), optarg, 0, "25", ARG_INT,
              check_ambiguity, override, 0, 0,
              "alignmentLength", 'L',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Calculate the stem structure subject to constraints.
.  */
        
        
          if (update_arg((void *)&(args_info->constraint_flag), 0, &(args_info->constraint_given),
              &(local_args_info.constraint_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "constraint", 'C',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* File containing the query sequence.
.  */
        
        
          if (update_arg( (void *)&(args_info->query_arg), 
               &(args_info->query_orig), &(args_info->query_given),
              &(local_args_info.query_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "query", 's',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* File containing the target sequence.
.  */
        
        
          if (update_arg( (void *)&(args_info->target_arg), 
               &(args_info->target_orig), &(args_info->target_given),
              &(local_args_info.target_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "target", 't',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* Specificy the suffix that was added by RNAup to the accessibility files
        
.  */
        
        
          if (update_arg( (void *)&(args_info->suffix_arg), 
               &(args_info->suffix_orig), &(args_info->suffix_given),
              &(local_args_info.suffix_given), optarg, 0, "_u1_to_30.out", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "suffix", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Specify the directory where accessibility profile generated by RNAplfold are found
        
.  */
        
        
          if (update_arg( (void *)&(args_info->from_RNAplfold_arg), 
               &(args_info->from_RNAplfold_orig), &(args_info->from_RNAplfold_given),
              &(local_args_info.from_RNAplfold_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "from-RNAplfold", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'A':	/* Specify if RNAsnoop gets alignments or single sequences as input
        
.  */
        
        
          if (update_arg((void *)&(args_info->alignment_mode_flag), 0, &(args_info->alignment_mode_given),
              &(local_args_info.alignment_mode_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "alignment-mode", 'A',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Speedup of the target search.  */
        
        
          if (update_arg( (void *)&(args_info->fast_folding_arg), 
               &(args_info->fast_folding_orig), &(args_info->fast_folding_given),
              &(local_args_info.fast_folding_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "fast-folding", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Cost to add to each nucleotide in a duplex.  */
        
        
          if (update_arg( (void *)&(args_info->extension_cost_arg), 
               &(args_info->extension_cost_orig), &(args_info->extension_cost_given),
              &(local_args_info.extension_cost_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "extension-cost", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Minimal Right Duplex Energy
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_right_duplex_arg), 
               &(args_info->minimal_right_duplex_orig), &(args_info->minimal_right_duplex_given),
              &(local_args_info.minimal_right_duplex_given), optarg, 0, "-270", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-right-duplex", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Minimal Right Duplex Energy
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_loop_energy_arg), 
               &(args_info->minimal_loop_energy_orig), &(args_info->minimal_loop_energy_given),
              &(local_args_info.minimal_loop_energy_given), optarg, 0, "-280", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-loop-energy", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Minimal Left Duplex Energy
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_left_duplex_arg), 
               &(args_info->minimal_left_duplex_orig), &(args_info->minimal_left_duplex_given),
              &(local_args_info.minimal_left_duplex_given), optarg, 0, "-170", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-left-duplex", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Minimal Duplex Energy
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_duplex_arg), 
               &(args_info->minimal_duplex_orig), &(args_info->minimal_duplex_given),
              &(local_args_info.minimal_duplex_given), optarg, 0, "-1090", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-duplex", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Distance between target 3' ends of two consecutive duplexes
.  */
        
        
          if (update_arg( (void *)&(args_info->duplex_distance_arg), 
               &(args_info->duplex_distance_orig), &(args_info->duplex_distance_given),
              &(local_args_info.duplex_distance_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "duplex-distance", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'h':	/* Minimal snoRNA stem length
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_stem_length_arg), 
               &(args_info->minimal_stem_length_orig), &(args_info->minimal_stem_length_given),
              &(local_args_info.minimal_stem_length_given), optarg, 0, "5", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-stem-length", 'h',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Maximal snoRNA stem length
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maximal_stem_length_arg), 
               &(args_info->maximal_stem_length_orig), &(args_info->maximal_stem_length_given),
              &(local_args_info.maximal_stem_length_given), optarg, 0, "120", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maximal-stem-length", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'j':	/* Minimal distance between the duplex end and the H/ACA box
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_duplex_box_length_arg), 
               &(args_info->minimal_duplex_box_length_orig), &(args_info->minimal_duplex_box_length_given),
              &(local_args_info.minimal_duplex_box_length_given), optarg, 0, "11", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-duplex-box-length", 'j',
              additional_error))
            goto failure;
        
          break;
        case 'k':	/* Maximal distance between the duplex end and the H/ACA box
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maximal_duplex_box_length_arg), 
               &(args_info->maximal_duplex_box_length_orig), &(args_info->maximal_duplex_box_length_given),
              &(local_args_info.maximal_duplex_box_length_given), optarg, 0, "16", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maximal-duplex-box-length", 'k',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Minimal number of nucleotides between the beginning of stem loop and
        beginning of the snoRNA sequence
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_snoRNA_stem_loop_length_arg), 
               &(args_info->minimal_snoRNA_stem_loop_length_orig), &(args_info->minimal_snoRNA_stem_loop_length_given),
              &(local_args_info.minimal_snoRNA_stem_loop_length_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-snoRNA-stem-loop-length", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Maximal number of nucleotides between the beginning of stem loop and
        beginning of the snoRNA sequence
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maximal_snoRNA_stem_loop_length_arg), 
               &(args_info->maximal_snoRNA_stem_loop_length_orig), &(args_info->maximal_snoRNA_stem_loop_length_given),
              &(local_args_info.maximal_snoRNA_stem_loop_length_given), optarg, 0, "100000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maximal-snoRNA-stem-loop-length", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Minimal distance between duplex start and snoRNA
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_snoRNA_duplex_length_arg), 
               &(args_info->minimal_snoRNA_duplex_length_orig), &(args_info->minimal_snoRNA_duplex_length_given),
              &(local_args_info.minimal_snoRNA_duplex_length_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-snoRNA-duplex-length", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'w':	/* Maximal distance between duplex start and snoRNA
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maximal_snoRNA_duplex_length_arg), 
               &(args_info->maximal_snoRNA_duplex_length_orig), &(args_info->maximal_snoRNA_duplex_length_given),
              &(local_args_info.maximal_snoRNA_duplex_length_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maximal-snoRNA-duplex-length", 'w',
              additional_error))
            goto failure;
        
          break;
        case 'x':	/* Minimal duplex stem energy
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_duplex_stem_energy_arg), 
               &(args_info->minimal_duplex_stem_energy_orig), &(args_info->minimal_duplex_stem_energy_given),
              &(local_args_info.minimal_duplex_stem_energy_given), optarg, 0, "-1370", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-duplex-stem-energy", 'x',
              additional_error))
            goto failure;
        
          break;
        case 'y':	/* Minimal total energy
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_total_energy_arg), 
               &(args_info->minimal_total_energy_orig), &(args_info->minimal_total_energy_given),
              &(local_args_info.minimal_total_energy_given), optarg, 0, "100000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-total-energy", 'y',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* Maximal snoRNA stem asymmetry
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maximal_stem_asymmetry_arg), 
               &(args_info->maximal_stem_asymmetry_orig), &(args_info->maximal_stem_asymmetry_given),
              &(local_args_info.maximal_stem_asymmetry_given), optarg, 0, "30", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maximal-stem-asymmetry", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Minimal lower stem energy
        
.  */
        
        
          if (update_arg( (void *)&(args_info->minimal_lower_stem_energy_arg), 
               &(args_info->minimal_lower_stem_energy_orig), &(args_info->minimal_lower_stem_energy_given),
              &(local_args_info.minimal_lower_stem_energy_given), optarg, 0, "100000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "minimal-lower-stem-energy", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Maximal energy difference between the mfe and the desired suboptimal
.  */
        
        
          if (update_arg( (void *)&(args_info->energy_threshold_arg), 
               &(args_info->energy_threshold_orig), &(args_info->energy_threshold_given),
              &(local_args_info.energy_threshold_given), optarg, 0, "-1", ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "energy-threshold", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'I':	/* Draw annotated 2D structures for a list of dot-bracket structures
.  */
        
        
          if (update_arg((void *)&(args_info->produce_ps_flag), 0, &(args_info->produce_ps_given),
              &(local_args_info.produce_ps_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "produce-ps", 'I',
              additional_error))
            goto failure;
        
          break;
        case 'O':	/* Set where the generated figures should be stored
        
.  */
        
        
          if (update_arg( (void *)&(args_info->output_directory_arg), 
               &(args_info->output_directory_orig), &(args_info->output_directory_given),
              &(local_args_info.output_directory_given), optarg, 0, "./", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output_directory", 'O',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* Outputs 2D interactions concurrently with the interaction calculation for each suboptimal interaction. The -I option should be preferred.
        
.  */
        
        
          if (update_arg((void *)&(args_info->direct_redraw_flag), 0, &(args_info->direct_redraw_given),
              &(local_args_info.direct_redraw_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "direct-redraw", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'U':	/* Specify the directory where accessibility profiles generated by RNAup are found
        
.  */
        
        
          if (update_arg( (void *)&(args_info->from_RNAup_arg), 
               &(args_info->from_RNAup_orig), &(args_info->from_RNAup_given),
              &(local_args_info.from_RNAup_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "from-RNAup", 'U',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "help") == 0) {
            RNAsnoop_cmdline_parser_print_help ();
            RNAsnoop_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAsnoop_cmdline_parser_print_detailed_help ();
            RNAsnoop_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNASNOOP_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  RNAsnoop_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  RNAsnoop_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
