/*
 * Copyright (c) 2012
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mlapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MLAPACK___FLOAT128_H_
#define _MLAPACK___FLOAT128_H_

#include "mpack_config.h"
#include "quadmath.h"

/* MLAPACK prototypes */

/* MLAPACK driver routines */
void Rsyev ( const char *jobz, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * w, __float128 * work, mpackint lwork, mpackint *info );
void Cheev ( const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * w, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *info );
void Rgesv ( mpackint n, mpackint nrhs, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Cgesv ( mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );

/* MLAPACK computational routines */
void Rsteqr ( const char *compz, mpackint n, __float128 * d, __float128 * e, __float128 * Z, mpackint ldz, __float128 * work, mpackint *info );
void Csteqr ( const char *compz, mpackint n, __float128 * d, __float128 * e, std::complex<__float128> * z, mpackint ldz, __float128 * work, mpackint *info );
void Rsterf ( mpackint n, __float128 * d, __float128 * e, mpackint *info );
void Rorgqr ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cungqr ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rorgql ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cungql ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rsytrd ( const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * d, __float128 * e, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Chetrd ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * d, __float128 * e, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rorgtr ( const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cungtr ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rpotrf ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Cpotrf ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rtrtri ( const char *uplo, const char *diag, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Ctrtri ( const char *uplo, const char *diag, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rgetrf ( mpackint m, mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetrf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rgetri ( mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * work, mpackint lwork, mpackint *info );
void Cgetri ( mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgetrs ( const char *trans, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Cgetrs ( const char *trans, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rtrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *info );
void Ctrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint *info );

/* MLAPACK Auxiliary routines */
__float128 Rlamc3 ( __float128 a, __float128 b );
__float128 Rlamch___float128(const char *cmach);
mpackint iMlaenv___float128(mpackint ispec, const char *name, const char *opts, mpackint n1, mpackint n2,  mpackint n3, mpackint n4);
void Rlae2 ( __float128 a, __float128 b, __float128 c, __float128 * rt1, __float128 * rt2 );
void Rlaev2 ( __float128 a, __float128 b, __float128 c, __float128 * rt1, __float128 * rt2, __float128 * cs1, __float128 * sn1 );
void Claev2 ( std::complex<__float128> a, std::complex<__float128> b, std::complex<__float128> c, __float128 * rt1, __float128 * rt2, __float128 * cs1, std::complex<__float128> * sn1 );
void Rlassq ( mpackint n, __float128 * x, mpackint incx, __float128 * scale, __float128 * sumsq );
void Classq ( mpackint n, std::complex<__float128> * x, mpackint incx, __float128 * scale, __float128 * sumsq );
__float128 Rlanst ( const char *norm, mpackint n, __float128 * d, __float128 * e );
__float128 Clanht ( const char *norm, mpackint n, __float128 * d, std::complex<__float128> * e );
__float128 Rlansy ( const char *norm, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * work );
__float128 Clansy ( const char *norm, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * work );
__float128 Clanhe ( const char *norm, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * work );
__float128 Rlapy2 ( __float128 x, __float128 y );
void Rlarfg ( mpackint N, __float128 * alpha, __float128 * x, mpackint incx, __float128 * tau );
__float128 Rlapy3 ( __float128 x, __float128 y, __float128 z );
void Rladiv ( __float128 a, __float128 b, __float128 c, __float128 d, __float128 * p, __float128 * q );
std::complex<__float128> Cladiv ( std::complex<__float128> x, std::complex<__float128> y );
void Clarfg ( mpackint n, std::complex<__float128> * alpha, std::complex<__float128> * x, mpackint incx, std::complex<__float128> * tau );
void Rlartg ( __float128 f, __float128 g, __float128 * cs, __float128 * sn, __float128 * r );
void Clartg ( std::complex<__float128> f, std::complex<__float128> g, __float128 * cs, std::complex<__float128> * sn, std::complex<__float128> * r );
void Rlaset ( const char *uplo, mpackint m, mpackint n, __float128 alpha, __float128 beta, __float128 * A, mpackint lda );
void Claset ( const char *uplo, mpackint m, mpackint n, std::complex<__float128> alpha, std::complex<__float128> beta, std::complex<__float128> * A, mpackint lda );
void Rlasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, __float128 * c, __float128 * s, __float128 * A, mpackint lda );
void Clasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, __float128 * c, __float128 * s, std::complex<__float128> * A, mpackint lda );
void Rpotf2 ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Clacgv ( mpackint n, std::complex<__float128> * x, mpackint incx );
void Cpotf2 ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rlascl ( const char *type, mpackint kl, mpackint ku, __float128 cfrom, __float128 cto, mpackint m, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Clascl ( const char *type, mpackint kl, mpackint ku, __float128 cfrom, __float128 cto, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rlasrt ( const char *id, mpackint n, __float128 * d, mpackint *info );
void Rsytd2 ( const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * d, __float128 * e, __float128 * tau, mpackint *info );
void Chetd2 ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * d, __float128 * e, std::complex<__float128> * tau, mpackint *info );
void Rlarf ( const char *side, mpackint m, mpackint n, __float128 * v, mpackint incv, __float128 tau, __float128 * C, mpackint ldc, __float128 * work );
void Clarf ( const char *side, mpackint m, mpackint n, std::complex<__float128> * v, mpackint incv, std::complex<__float128> tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work );
void Rorg2l ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cung2l ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rorg2r ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cung2r ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rlarft ( const char *direct, const char *storev, mpackint n, mpackint k, __float128 * v, mpackint ldv, __float128 * tau, __float128 * t, mpackint ldt );
void Clarft ( const char *direct, const char *storev, mpackint n, mpackint k, std::complex<__float128> * v, mpackint ldv, std::complex<__float128> * tau, std::complex<__float128> * t, mpackint ldt );
void Rlarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, __float128 * V, mpackint ldv, __float128 * T, mpackint ldt, __float128 * C, mpackint ldc, __float128 * work, mpackint ldwork );
void Clarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, std::complex<__float128> * V, mpackint ldv, std::complex<__float128> * T, mpackint ldt, std::complex<__float128> * C, mpackint ldc, std::complex<__float128> * work, mpackint ldwork );
void Rlatrd ( const char *uplo, mpackint n, mpackint nb, __float128 * A, mpackint lda, __float128 * e, __float128 * tau, __float128 * w, mpackint ldw );
void Clatrd ( const char *uplo, mpackint n, mpackint nb, std::complex<__float128> * A, mpackint lda, __float128 * e, std::complex<__float128> * tau, std::complex<__float128> * w, mpackint ldw );
void Clacrm ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * B, mpackint ldb, std::complex<__float128> * c, mpackint ldc, __float128 * rwork );
void Rtrti2 ( const char *uplo, const char *diag, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Ctrti2 ( const char *uplo, const char *diag, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rgetf2 ( mpackint m, mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetf2 ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rlaswp ( mpackint n, __float128 * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Claswp ( mpackint n, std::complex<__float128> * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Rlasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * w, mpackint ldw, mpackint *info );
void Clasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * w, mpackint ldw, mpackint *info );
void Clahef ( const char *uplo, mpackint n, mpackint nb, mpackint kb, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * w, mpackint ldw, mpackint *info );
void Clacrt ( mpackint n, std::complex<__float128> * cx, mpackint incx, std::complex<__float128> * cy, mpackint incy, std::complex<__float128> c, std::complex<__float128> s );
void Claesy ( std::complex<__float128> a, std::complex<__float128> b, std::complex<__float128> c, std::complex<__float128> * rt1, std::complex<__float128> * rt2, std::complex<__float128> * evscal, std::complex<__float128> * cs1, std::complex<__float128> * sn1 );
void Crot ( mpackint n, std::complex<__float128> * cx, mpackint incx, std::complex<__float128> * cy, mpackint incy, __float128 c, std::complex<__float128> s );
void Cspmv ( const char *uplo, mpackint n, std::complex<__float128> alpha, std::complex<__float128> * AP, std::complex<__float128> * x, mpackint incx, std::complex<__float128> beta, std::complex<__float128> * y, mpackint incy );
void Cspr ( const char *uplo, mpackint n, std::complex<__float128> alpha, std::complex<__float128> * x, mpackint incx, std::complex<__float128> * AP );
void Csymv ( const char *uplo, mpackint n, std::complex<__float128> alpha, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * x, mpackint incx, std::complex<__float128> beta, std::complex<__float128> * y, mpackint incy );
void Csyr ( const char *uplo, mpackint n, std::complex<__float128> alpha, std::complex<__float128> * x, mpackint incx, std::complex<__float128> * A, mpackint lda );
mpackint iCmax1 ( mpackint n, std::complex<__float128> * cx, mpackint incx );
__float128 RCsum1 ( mpackint n, std::complex<__float128> * cx, mpackint incx );
void Rlacn2 ( mpackint n, __float128 * v, __float128 * x, mpackint *isgn, __float128 * est, mpackint *kase, mpackint *isave );
void Clacn2 ( mpackint n, std::complex<__float128> * v, std::complex<__float128> * x, __float128 * est, mpackint *kase, mpackint *isave );
void Rlatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, __float128 * A, mpackint lda, __float128 * x, __float128 * scale, __float128 * cnorm, mpackint *info );
void Clatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * x, __float128 * scale, __float128 * cnorm, mpackint *info );

/* not yet done ... auxiliary routines */
void Rgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, __float128 * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<__float128> * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgebd2 ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * d, __float128 * e, __float128 * tauq, __float128 * taup, __float128 * work, mpackint *info );
void Cgebd2 ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * d, __float128 * e, std::complex<__float128> * tauq, std::complex<__float128> * taup, std::complex<__float128> * work, mpackint *info );
void Rgehd2 ( mpackint n, mpackint ilo, mpackint ihi, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cgehd2 ( mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rgelq2 ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cgelq2 ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rgeql2 ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cgeql2 ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rgeqr2 ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cgeqr2 ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rgerq2 ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cgerq2 ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rgesc2 ( mpackint n, __float128 * A, mpackint lda, __float128 * rhs, mpackint *ipiv, mpackint *jpiv, __float128 * scale );
void Cgesc2 ( mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * rhs, mpackint *ipiv, mpackint *jpiv, __float128 * scale );
void Rgetc2 ( mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Cgetc2 ( mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Rgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, __float128 * dl, __float128 * d, __float128 * du, __float128 * du2, mpackint *ipiv, __float128 * B, mpackint ldb );
void Cgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * du2, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb );
void Rlabrd ( mpackint m, mpackint n, mpackint nb, __float128 * A, mpackint lda, __float128 * d, __float128 * e, __float128 * tauq, __float128 * taup, __float128 * x, mpackint ldx, __float128 * y, mpackint ldy );
void Clabrd ( mpackint m, mpackint n, mpackint nb, std::complex<__float128> * A, mpackint lda, __float128 * d, __float128 * e, std::complex<__float128> * tauq, std::complex<__float128> * taup, std::complex<__float128> * x, mpackint ldx, std::complex<__float128> * y, mpackint ldy );
void Rlacpy ( const char *uplo, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb );
void Clacpy ( const char *uplo, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb );
void Clarcm ( mpackint m, mpackint n, __float128 * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * c, mpackint ldc, __float128 * rwork );
void Rlaebz ( mpackint ijob, mpackint nitmax, mpackint n, mpackint mmax, mpackint minp, mpackint nbmin, __float128 abstol, __float128 reltol, __float128 pivmin, __float128 * d, __float128 * e, __float128 * e2, mpackint *nval, __float128 * AB, __float128 * c, mpackint *mout, mpackint *nab, __float128 * work, mpackint *iwork, mpackint *info );
void Rlaed0 ( mpackint icompq, mpackint qsiz, mpackint n, __float128 * d, __float128 * e, __float128 * q, mpackint ldq, __float128 * qstore, mpackint ldqs, __float128 * work, mpackint *iwork, mpackint *info );
void Claed0 ( mpackint qsiz, mpackint n, __float128 * d, __float128 * e, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * qstore, mpackint ldqs, __float128 * rwork, mpackint *iwork, mpackint *info );
void Rlaed1 ( mpackint n, __float128 * d, __float128 * q, mpackint ldq, mpackint *indxq, __float128 rho, mpackint cutpnt, __float128 * work, mpackint *iwork, mpackint *info );
void Rlaed2 ( mpackint *k, mpackint n, mpackint n1, __float128 * d, __float128 * q, mpackint ldq, mpackint *indxq, __float128 * rho, __float128 * z, __float128 * dlamda, __float128 * w, __float128 * q2, mpackint *indx, mpackint *indxc, mpackint *indxp, mpackint *coltyp, mpackint *info );
void Rlaed3 ( mpackint k, mpackint n, mpackint n1, __float128 * d, __float128 * q, mpackint ldq, __float128 * rho, __float128 * dlamda, __float128 * q2, mpackint *indx, mpackint *ctot, __float128 * w, __float128 * s, mpackint *info );
void Rlaed4 ( mpackint n, mpackint i, __float128 * d, __float128 * z, __float128 * delta, __float128 rho, __float128 * dlam, mpackint *info );
void Rlaed5 ( mpackint i, __float128 * d, __float128 * z, __float128 * delta, __float128 rho, __float128 * dlam );
void Rlaed6 ( mpackint kniter, mpackint orgati, __float128 rho, __float128 * d, __float128 * z, __float128 * finit, __float128 * tau, mpackint *info );
void Rlaed7 ( mpackint icompq, mpackint n, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, __float128 * d, __float128 * q, mpackint ldq, mpackint *indxq, __float128 rho, mpackint cutpnt, __float128 * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, __float128 * givnum, __float128 * work, mpackint *iwork, mpackint *info );
void Claed7 ( mpackint n, mpackint cutpnt, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, __float128 * d, std::complex<__float128> * q, mpackint ldq, __float128 rho, mpackint *indxq, __float128 * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, __float128 * givnum, std::complex<__float128> * work, __float128 * rwork, mpackint *iwork, mpackint *info );
void Rlaed8 ( mpackint icompq, mpackint *k, mpackint n, mpackint qsiz, __float128 * d, __float128 * q, mpackint ldq, mpackint *indxq, __float128 * rho, mpackint cutpnt, __float128 * z, __float128 * dlamda, __float128 * q2, mpackint ldq2, __float128 * w, mpackint *perm, mpackint *givptr, mpackint *givcol, __float128 * givnum, mpackint *indxp, mpackint *indx, mpackint *info );
void Claed8 ( mpackint *k, mpackint n, mpackint qsiz, std::complex<__float128> * q, mpackint ldq, __float128 * d, __float128 * rho, mpackint cutpnt, __float128 * z, __float128 * dlamda, std::complex<__float128> * q2, mpackint ldq2, __float128 * w, mpackint *indxp, mpackint *indx, mpackint *indxq, mpackint *perm, mpackint *givptr, mpackint *givcol, __float128 * givnum, mpackint *info );
void Rlaed9 ( mpackint k, mpackint kstart, mpackint kstop, mpackint n, __float128 * d, __float128 * q, mpackint ldq, __float128 rho, __float128 * dlamda, __float128 * w, __float128 * s, mpackint lds, mpackint *info );
void Rlaeda ( mpackint n, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, __float128 * givnum, __float128 * q, mpackint *qptr, __float128 * z, __float128 * ztemp, mpackint *info );
void Rlaein ( mpackint rightv, mpackint noinit, mpackint n, __float128 * h, mpackint ldh, __float128 wr, __float128 wi, __float128 * vr, __float128 * vi, __float128 * B, mpackint ldb, __float128 * work, __float128 eps3, __float128 smlnum, __float128 bignum, mpackint *info );
void Claein ( mpackint rightv, mpackint noinit, mpackint n, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> w, std::complex<__float128> * v, std::complex<__float128> * B, mpackint ldb, __float128 * rwork, __float128 eps3, __float128 smlnum, mpackint *info );
void Rlaexc ( mpackint wantq, mpackint n, __float128 * t, mpackint ldt, __float128 * q, mpackint ldq, mpackint j1, mpackint n1, mpackint n2, __float128 * work, mpackint *info );
void Rlag2 ( __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 safmin, __float128 * scale1, __float128 * scale2, __float128 * wr1, __float128 * wr2, __float128 * wi );
void Rlags2 ( mpackint upper, __float128 a1, __float128 a2, __float128 a3, __float128 b1, __float128 b2, __float128 b3, __float128 * csu, __float128 * snu, __float128 * csv, __float128 * snv, __float128 * csq, __float128 * snq );
void Clags2 ( mpacklogical * upper, __float128 a1, std::complex<__float128> a2, __float128 a3, __float128 b1, std::complex<__float128> b2, __float128 b3, __float128 * csu, std::complex<__float128> * snu, __float128 * csv, std::complex<__float128> * snv, __float128 * csq, std::complex<__float128> * snq );
void Rlagtf ( mpackint n, __float128 * a, __float128 lambda, __float128 * b, __float128 * c, __float128 * tol, __float128 * d, mpackint *in, mpackint *info );
void Rlagtm ( const char *trans, mpackint n, mpackint nrhs, __float128 alpha, __float128 * dl, __float128 * d, __float128 * du, __float128 * x, mpackint ldx, __float128 * beta, __float128 * B, mpackint ldb );
void Clagtm ( const char *trans, mpackint n, mpackint nrhs, __float128 alpha, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * x, mpackint ldx, __float128 beta, std::complex<__float128> * B, mpackint ldb );
void Rlagts ( mpackint job, mpackint n, __float128 * a, __float128 * b, __float128 * c, __float128 * d, mpackint *in, __float128 * y, __float128 * tol, mpackint *info );
void Rlagv2 ( __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * csl, __float128 * snl, __float128 * csr, __float128 * snr );
void Rlahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, __float128 * h, mpackint ldh, __float128 * wr, __float128 * wi, mpackint iloz, mpackint ihiz, __float128 * z, mpackint ldz, mpackint *info );
void Clahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> * w, mpackint iloz, mpackint ihiz, std::complex<__float128> * z, mpackint ldz, mpackint *info );
void Rlahr2 ( mpackint n, mpackint k, mpackint nb, __float128 * A, mpackint lda, __float128 * tau, __float128 * t, mpackint ldt, __float128 * y, mpackint ldy );
void Clahr2 ( mpackint n, mpackint k, mpackint nb, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * y, mpackint ldy );
void Rlahrd ( mpackint n, mpackint k, mpackint nb, __float128 * A, mpackint lda, __float128 * tau, __float128 * t, mpackint ldt, __float128 * y, mpackint ldy );
void Clahrd ( mpackint n, mpackint k, mpackint nb, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * y, mpackint ldy );
void Rlaic1 ( mpackint job, mpackint j, __float128 * x, __float128 sest, __float128 * w, __float128 gamma, __float128 * sestpr, __float128 * s, __float128 * c );
void Claic1 ( mpackint job, mpackint j, std::complex<__float128> * x, __float128 sest, std::complex<__float128> * w, std::complex<__float128> gamma, __float128 * sestpr, std::complex<__float128> * s, std::complex<__float128> * c );
void Rlaln2 ( mpackint ltrans, mpackint na, mpackint nw, __float128 smin, __float128 ca, __float128 * A, mpackint lda, __float128 d1, __float128 d2, __float128 * B, mpackint ldb, __float128 wr, __float128 wi, __float128 * x, mpackint ldx, __float128 * scale, __float128 * xnorm, mpackint *info );
void Rlals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, __float128 * B, mpackint ldb, __float128 * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, __float128 * givnum, mpackint ldgnum, __float128 * poles, __float128 * difl, __float128 * difr, __float128 * z, mpackint k, __float128 c, __float128 s, __float128 * work, mpackint *info );
void Clals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, __float128 * givnum, mpackint ldgnum, __float128 * poles, __float128 * difl, __float128 * difr, __float128 * z, mpackint k, __float128 c, __float128 s, __float128 * rwork, mpackint *info );
void Rlalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, __float128 * B, mpackint ldb, __float128 * bx, mpackint ldbx, __float128 * u, mpackint ldu, __float128 * vt, mpackint *k, __float128 * difl, __float128 * difr, __float128 * z, __float128 * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, __float128 * givnum, __float128 * c, __float128 * s, __float128 * work, mpackint *iwork, mpackint *info );
void Clalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * bx, mpackint ldbx, __float128 * u, mpackint ldu, __float128 * vt, mpackint *k, __float128 * difl, __float128 * difr, __float128 * z, __float128 * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, __float128 * givnum, __float128 * c, __float128 * s, __float128 * rwork, mpackint *iwork, mpackint *info );
void Rlalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, __float128 * d, __float128 * e, __float128 * B, mpackint ldb, __float128 rcond, mpackint *rank, __float128 * work, mpackint *iwork, mpackint *info );
void Clalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, __float128 * d, __float128 * e, std::complex<__float128> * B, mpackint ldb, __float128 rcond, mpackint *rank, std::complex<__float128> * work, __float128 * rwork, mpackint *iwork, mpackint *info );
void Rlamrg ( mpackint n1, mpackint n2, __float128 * a, mpackint dtrd1, mpackint dtrd2, mpackint *index );
__float128 Rlangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, __float128 * ab, mpackint ldab, __float128 * work );
__float128 Clangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, std::complex<__float128> * AB, mpackint ldab, __float128 * work );
__float128 Rlange ( const char *norm, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * work );
__float128 Clange ( const char *norm, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * work );
__float128 Rlangt ( const char *norm, mpackint n, __float128 * dl, __float128 * d, __float128 * du );
__float128 Clangt ( const char *norm, mpackint n, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du );
__float128 Rlanhs ( const char *norm, mpackint n, __float128 * A, mpackint lda, __float128 * work );
__float128 Clanhs ( const char *norm, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * work );
__float128 Rlansb ( const char *norm, const char *uplo, mpackint n, mpackint k, __float128 * AB, mpackint ldab, __float128 * work );
__float128 Clansb ( const char *norm, const char *uplo, mpackint n, mpackint k, std::complex<__float128> * AB, mpackint ldab, __float128 * work );
__float128 Clanhb ( const char *norm, const char *uplo, mpackint n, mpackint k, std::complex<__float128> * AB, mpackint ldab, __float128 * work );
__float128 Rlansp ( const char *norm, const char *uplo, mpackint n, __float128 * ap, __float128 * work );
__float128 Clansp ( const char *norm, const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * work );
__float128 Clanhp ( const char *norm, const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * work );
__float128 Rlantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, __float128 * AB, mpackint ldab, __float128 * work );
std::complex<__float128> Clantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, std::complex<__float128> * AB, mpackint ldab, __float128 * work );
__float128 Rlantp ( const char *norm, const char *uplo, const char *diag, mpackint n, __float128 * ap, __float128 * work );
std::complex<__float128> Clantp ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<__float128> * ap, __float128 * work );
__float128 Rlantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * work );
__float128 Clantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * work );
void Rlanv2 ( __float128 * a, __float128 * b, __float128 * c, __float128 * d, __float128 * rt1r, __float128 * rt1i, __float128 * rt2r, __float128 * rt2i, __float128 * cs, __float128 * sn );
void Rlapll ( mpackint n, __float128 * x, mpackint incx, __float128 * y, mpackint incy, __float128 * ssmin );
void Clapll ( mpackint n, std::complex<__float128> * x, mpackint incx, std::complex<__float128> * y, mpackint incy, __float128 * ssmin );
void Rlapmt ( mpackint *forwrd, mpackint m, mpackint n, __float128 * X, mpackint ldx, mpackint *k );
void Clapmt ( mpackint *forwrd, mpackint m, mpackint n, std::complex<__float128> * X, mpackint ldx, mpackint *k );
void Rlaqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, __float128 * AB, mpackint ldab, __float128 * r, __float128 * c, __float128 rowcnd, __float128 colcnd, __float128 amax, char *equed );
void Claqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<__float128> * AB, mpackint ldab, __float128 * r, __float128 * c, __float128 rowcnd, __float128 colcnd, __float128 amax, char *equed );
void Rlaqge ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * r, __float128 * c, __float128 rowcnd, __float128 colcnd, __float128 amax, char *equed );
void Claqge ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * r, __float128 * c, __float128 rowcnd, __float128 colcnd, __float128 amax, char *equed );
void Rlaqp2 ( mpackint m, mpackint n, mpackint offset, __float128 * A, mpackint lda, mpackint *jpvt, __float128 * tau, __float128 * vn1, __float128 * vn2, __float128 * work );
void Claqp2 ( mpackint m, mpackint n, mpackint offset, std::complex<__float128> * A, mpackint lda, mpackint *jpvt, std::complex<__float128> * tau, __float128 * vn1, __float128 * vn2, std::complex<__float128> * work );
void Rlaqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, __float128 * A, mpackint lda, mpackint *jpvt, __float128 * tau, __float128 * vn1, __float128 * vn2, __float128 * auxv, __float128 * f, mpackint ldf );
void Claqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, std::complex<__float128> * A, mpackint lda, mpackint *jpvt, std::complex<__float128> * tau, __float128 * vn1, __float128 * vn2, std::complex<__float128> * auxv, std::complex<__float128> * f, mpackint ldf );
void Rlaqsb ( const char *uplo, mpackint n, mpackint kd, __float128 * ab, mpackint ldab, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Claqsb ( const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * ab, mpackint ldab, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Claqhb ( const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Rlaqsp ( const char *uplo, mpackint n, __float128 * ap, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Claqsp ( const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Claqhp ( const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Rlaqsy ( const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Claqsy ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Claqhe ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * s, __float128 scond, __float128 amax, char *equed );
void Rlaqtr ( mpackint ltran, mpackint lreal, mpackint n, __float128 * t, mpackint ldt, __float128 * B, __float128 w, __float128 * scale, __float128 * x, __float128 * work, mpackint *info );
void Rlar1v ( mpackint n, mpackint b1, mpackint bn, __float128 lambda, __float128 * d, __float128 * l, __float128 * ld, __float128 * lld, __float128 pivmin, __float128 gaptol, __float128 * z, mpackint wantnc, mpackint *negcnt, __float128 * ztz, __float128 * mingma, mpackint *r, mpackint *isuppz, __float128 * nrminv, __float128 * resid, __float128 * rqcorr, __float128 * work );
void Clar1v ( mpackint n, mpackint b1, mpackint bn, __float128 lambda, __float128 * d, __float128 * l, __float128 * ld, __float128 * lld, __float128 pivmin, __float128 gaptol, std::complex<__float128> * z, mpackint wantnc, mpackint *negcnt, __float128 * ztz, __float128 * mingma, mpackint *r, mpackint *isuppz, __float128 * nrminv, __float128 * resid, __float128 * rqcorr, __float128 * work );
void Rlar2v ( mpackint n, __float128 * x, __float128 * y, __float128 * z, mpackint incx, __float128 * c, __float128 * s, mpackint incc );
void Clar2v ( mpackint n, std::complex<__float128> * x, std::complex<__float128> * y, std::complex<__float128> * z, mpackint incx, __float128 * c, std::complex<__float128> * s, mpackint incc );
void Rlarfx ( const char *side, mpackint m, mpackint n, __float128 * v, __float128 tau, __float128 * c, mpackint ldc, __float128 * work );
void Clarfx ( const char *side, mpackint m, mpackint n, std::complex<__float128> * v, std::complex<__float128> tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work );
void Rlargv ( mpackint n, __float128 * x, mpackint incx, __float128 * y, mpackint incy, __float128 * c, mpackint incc );
void Clargv ( mpackint n, std::complex<__float128> * x, mpackint incx, std::complex<__float128> * y, mpackint incy, __float128 * c, mpackint incc );
void Rlarnv ( mpackint idist, mpackint *iseed, mpackint n, __float128 * x );
void Clarnv ( mpackint idist, mpackint *iseed, mpackint n, std::complex<__float128> * x );
mpackint Rlaneg ( mpackint n, __float128 * d, __float128 * lld, __float128 sigma, __float128 pivmin, mpackint r );
void Rlarra ( mpackint n, __float128 * d, __float128 * e, __float128 * e2, __float128 spltol, __float128 tnrm, mpackint *nsplit, mpackint *isplit, mpackint *info );
void Rlarrb ( mpackint n, __float128 * d, __float128 * lld, mpackint ifirst, mpackint ilast, __float128 rtol1, __float128 rtol2, mpackint offset, __float128 * w, __float128 * wgap, __float128 * werr, __float128 * work, mpackint *iwork, __float128 pivmin, __float128 spdiam, mpackint twist, mpackint *info );
void Rlarrc ( const char *jobt, mpackint n, __float128 vl, __float128 vu, __float128 * d, __float128 * e, __float128 pivmin, mpackint *eigcnt, mpackint *lcnt, mpackint *rcnt, mpackint *info );
void Rlarrd ( const char *range, const char *order, mpackint n, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 *gers, __float128 reltol, __float128 * d, __float128 * e, __float128 * e2, __float128 pivmin, mpackint nsplit, mpackint *isplit, mpackint *m, __float128 * w, __float128 * werr, __float128 * wl, __float128 * wu, mpackint *iblock, mpackint *indexw, __float128 * work, mpackint *iwork, mpackint *info );
void Rlarre ( const char *range, mpackint n, __float128 * vl, __float128 * vu, mpackint il, mpackint iu, __float128 * d, __float128 * e, __float128 * e2, __float128 rtol1, __float128 rtol2, __float128 spltol, mpackint * nsplit, mpackint *isplit, mpackint * m, __float128 * w, __float128 * werr, __float128 * wgap, mpackint *iblock, mpackint *indexw, __float128 * gers, __float128 * pivmin, __float128 * work, mpackint *iwork, mpackint *info );
void Rlarrf ( mpackint n, __float128 * d, __float128 * l, __float128 * ld, mpackint clstrt, mpackint clend, __float128 * w, __float128 * wgap, __float128 * werr, __float128 spdiam, __float128 clgapl, __float128 clgapr, __float128 pivmin, __float128 * sigma, __float128 * dplus, __float128 * lplus, __float128 * work, mpackint *info );
void Rlarrj ( mpackint n, __float128 * d, __float128 * e2, mpackint ifirst, mpackint ilast, __float128 rtol, mpackint offset, __float128 * w, __float128 * werr, __float128 * work, mpackint *iwork, __float128 pivmin, __float128 spdiam, mpackint *info );
void Rlarrk ( mpackint n, mpackint iw, __float128 gl, __float128 gu, __float128 * d, __float128 * e2, __float128 pivmin, __float128 reltol, __float128 * w, __float128 * werr, mpackint *info );
void Rlarrr ( mpackint n, __float128 * d, __float128 * e, mpackint *info );
void Rlartv ( mpackint n, __float128 * x, mpackint incx, __float128 * y, mpackint incy, __float128 * c, __float128 * s, mpackint incc );
void Clartv ( mpackint n, std::complex<__float128> * x, mpackint incx, std::complex<__float128> * y, mpackint incy, __float128 * c, std::complex<__float128> * s, mpackint incc );
void Rlarrv ( mpackint n, __float128 vl, __float128 vu, __float128 * d, __float128 * l, __float128 pivmin, mpackint * isplit, mpackint m, mpackint dol, mpackint dou, __float128 minrgp, __float128 rtol1, __float128 rtol2, __float128 * w, __float128 * werr, __float128 * wgap, mpackint * iblock, mpackint * indexw, __float128 * gers, __float128 * z, mpackint ldz, mpackint * isuppz, __float128 * work, mpackint * iwork, mpackint * info );
void Clarrv ( mpackint n, __float128 vl, __float128 vu, __float128 * d, __float128 * l, __float128 pivmin, mpackint *isplit, mpackint m, mpackint dol, mpackint dou, __float128 minrgp, __float128 rtol1, __float128 rtol2, __float128 * w, __float128 * werr, __float128 * wgap, mpackint *iblock, mpackint *indexw, __float128 * gers, std::complex<__float128> * z, mpackint ldz, mpackint *isuppz, __float128 * work, mpackint *iwork, mpackint *info );
void Rlaruv ( mpackint *iseed, mpackint n, __float128 * x );
void Rlarz ( const char *side, mpackint m, mpackint n, mpackint l, __float128 * v, mpackint incv, __float128 tau, __float128 * C, mpackint ldc, __float128 * work );
void Clarz ( const char *side, mpackint m, mpackint n, mpackint l, std::complex<__float128> * v, mpackint incv, std::complex<__float128> tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work );
void Rlarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, __float128 * v, mpackint ldv, __float128 * t, mpackint ldt, __float128 * c, mpackint ldc, __float128 * work, mpackint ldwork );
void Clarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<__float128> * v, mpackint ldv, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint ldwork );
void Rlarzt ( const char *direct, const char *storev, mpackint n, mpackint k, __float128 * v, mpackint ldv, __float128 * tau, __float128 * t, mpackint ldt );
void Clarzt ( const char *direct, const char *storev, mpackint n, mpackint k, std::complex<__float128> * v, mpackint ldv, std::complex<__float128> * tau, std::complex<__float128> * t, mpackint ldt );
void Rlas2 ( __float128 f, __float128 g, __float128 h, __float128 * ssmin, __float128 * ssmax );
void Rlasd0 ( mpackint n, mpackint sqre, __float128 * d, __float128 * e, __float128 * u, mpackint ldu, __float128 * vt, mpackint ldvt, mpackint smlsiz, mpackint *iwork, __float128 * work, mpackint *info );
void Rlasd1 ( mpackint nl, mpackint nr, mpackint *sqre, __float128 * d, __float128 * alpha, __float128 * beta, __float128 * u, mpackint ldu, __float128 * vt, mpackint ldvt, mpackint *idxq, mpackint *iwork, __float128 * work, mpackint *info );
void Rlasd2 ( mpackint nl, mpackint nr, mpackint sqre, mpackint *k, __float128 * d, __float128 * z, __float128 alpha, __float128 beta, __float128 * u, mpackint ldu, __float128 * vt, mpackint ldvt, __float128 * dsigma, __float128 * u2, mpackint ldu2, __float128 * vt2, mpackint ldvt2, mpackint *idxp, mpackint *idx, mpackint *idxc, mpackint *idxq, mpackint *coltyp, mpackint *info );
void Rlasd3 ( mpackint nl, mpackint nr, mpackint sqre, mpackint k, __float128 * d, __float128 * q, mpackint ldq, __float128 * dsigma, __float128 * u, mpackint ldu, __float128 * u2, mpackint ldu2, __float128 * vt, mpackint ldvt, __float128 * vt2, mpackint ldvt2, mpackint *idxc, mpackint *ctot, __float128 * z, mpackint *info );
void Rlasd4 ( mpackint n, mpackint i, __float128 * d, __float128 * z, __float128 * delta, __float128 rho, __float128 * sigma, __float128 * work, mpackint *info );
void Rlasd5 ( mpackint i, __float128 * d, __float128 * z, __float128 * delta, __float128 rho, __float128 * dsigma, __float128 * work );
void Rlasd6 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, __float128 * d, __float128 * vf, __float128 * vl, __float128 * alpha, __float128 * beta, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, __float128 * givnum, mpackint ldgnum, __float128 * poles, __float128 * difl, __float128 * difr, __float128 * z, mpackint k, __float128 * c, __float128 * s, __float128 * work, mpackint *iwork, mpackint *info );
void Rlasd7 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint k, __float128 * d, __float128 * z, __float128 * zw, __float128 * vf, __float128 * vfw, __float128 * vl, __float128 * vlw, __float128 alpha, __float128 beta, __float128 * dsigma, mpackint *idx, mpackint *idxp, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, __float128 * givnum, mpackint ldgnum, __float128 * c, __float128 * s, mpackint *info );
void Rlasd8 ( mpackint icompq, mpackint k, __float128 * d, __float128 * z, __float128 * vf, __float128 * vl, __float128 * difl, __float128 * difr, mpackint lddifr, __float128 * dsigma, __float128 * work, mpackint *info );
void Rlasda ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint sqre, __float128 * d, __float128 * e, __float128 * u, mpackint ldu, __float128 * vt, mpackint *k, __float128 * difl, __float128 * difr, __float128 * z, __float128 * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, __float128 * givnum, __float128 * c, __float128 * s, __float128 * work, mpackint *iwork, mpackint *info );
void Rlasdq ( const char *uplo, mpackint sqre, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, __float128 * d, __float128 * e, __float128 * vt, mpackint ldvt, __float128 * u, mpackint ldu, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Rlasdt ( mpackint n, mpackint lvl, mpackint nd, mpackint *inode, mpackint *ndiml, mpackint *ndimr, mpackint msub );
void Rlasq1 ( mpackint n, __float128 * d, __float128 * e, __float128 * work, mpackint *info );
void Rlasq2 ( mpackint n, __float128 * z, mpackint *info );
void Rlasq3 ( mpackint i0, mpackint n0, __float128 * z, mpackint pp, __float128 * dmin, __float128 * sigma, __float128 * desig, __float128 qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint ieee );
void Rlasq4 ( mpackint i0, mpackint n0, __float128 * z, mpackint pp, mpackint n0in, __float128 dmin, __float128 dmin1, __float128 dmin2, __float128 dn, __float128 dn1, __float128 dn2, __float128 * tau, mpackint *ttype );
void Rlasq5 ( mpackint i0, mpackint n0, __float128 * z, mpackint pp, __float128 tau, __float128 * dmin, __float128 * dmin1, __float128 * dmin2, __float128 * dn, __float128 * dnm1, __float128 * dnm2, mpackint ieee );
void Rlasq6 ( mpackint i0, mpackint n0, __float128 * z, mpackint pp, __float128 * dmin, __float128 * dmin1, __float128 * dmin2, __float128 * dn, __float128 * dnm1, __float128 * dnm2 );
void Rlasv2 ( __float128 f, __float128 g, __float128 h, __float128 * ssmin, __float128 * ssmax, __float128 * snr, __float128 * csr, __float128 * snl, __float128 * csl );
void Rlasy2 ( mpackint ltranl, mpackint ltranr, mpackint isgn, mpackint n1, mpackint n2, __float128 * tl, mpackint ldtl, __float128 * tr, mpackint ldtr, __float128 * B, mpackint ldb, __float128 * scale, __float128 * x, mpackint ldx, __float128 * xnorm, mpackint *info );
void Rlatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, __float128 * x, __float128 * scale, __float128 * cnorm, mpackint *info );
void Clatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * x, __float128 * scale, __float128 * cnorm, mpackint *info );
void Rlatdf ( mpackint ijob, mpackint n, __float128 * z, mpackint ldz, __float128 * rhs, __float128 * rdsum, __float128 * rdscal, mpackint *ipiv, mpackint *jpiv );
void Clatdf ( mpackint ijob, mpackint n, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * rhs, __float128 * rdsum, __float128 * rdscal, mpackint *ipiv, mpackint *jpiv );
void Rlatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, __float128 * ap, __float128 * x, __float128 * scale, __float128 * cnorm, mpackint *info );
void Clatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, std::complex<__float128> * ap, std::complex<__float128> * x, __float128 * scale, __float128 * cnorm, mpackint *info );
void Rlauu2 ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Clauu2 ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rlauum ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Clauum ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rlatrz ( mpackint m, mpackint n, mpackint l, __float128 * A, mpackint lda, __float128 * tau, __float128 * work );
void Clatrz ( mpackint m, mpackint n, mpackint l, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work );
void Rorgl2 ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cungl2 ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rorgr2 ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint *info );
void Cungr2 ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rorm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Cunm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint *info );
void Rorm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Cunm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint *info );
void Rorml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Cunml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint *info );
void Rormr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * C, mpackint ldc, __float128 * work, mpackint *info );
void Cunmr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint *info );
void Rormr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Cunmr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint *info );
void Rpbtf2 ( const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, mpackint *info );
void Cpbtf2 ( const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, mpackint *info );
void Rptts2 ( mpackint n, mpackint nrhs, __float128 * d, __float128 * e, __float128 * b, mpackint ldb );
void Cptts2 ( mpackint iuplo, mpackint n, mpackint nrhs, __float128 * d, std::complex<__float128> * e, std::complex<__float128> * B, mpackint ldb );
void Rrscl ( mpackint n, __float128 sa, __float128 * sx, mpackint incx );
void CRrscl ( mpackint n, __float128 sa, std::complex<__float128> * sx, mpackint incx );
void Rsygs2 ( mpackint itype, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *info );
void Chegs2 ( mpackint itype, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rsytf2 ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Csytf2 ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Chetf2 ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rtgex2 ( mpackint wantq, mpackint wantz, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * q, mpackint ldq, __float128 * z, mpackint ldz, mpackint j1, mpackint n1, mpackint n2, __float128 * work, mpackint lwork, mpackint *info );
void Ctgex2 ( mpackint wantq, mpackint wantz, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * z, mpackint ldz, mpackint j1, mpackint *info );
void Rtgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * c, mpackint ldc, __float128 * d, mpackint ldd, __float128 * e, mpackint lde, __float128 * f, mpackint ldf, __float128 * scale, __float128 * rdsum, __float128 * rdscal, mpackint *iwork, mpackint *pq, mpackint *info );
void Ctgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * C, mpackint ldc, std::complex<__float128> * d, mpackint ldd, std::complex<__float128> * e, mpackint lde, std::complex<__float128> * f, mpackint ldf, __float128 * scale, __float128 * rdsum, __float128 * rdscal, mpackint *info );
void Rlazq3 ( mpackint i0, mpackint n0, __float128 * z, mpackint pp, __float128 * dmin, __float128 * sigma, __float128 * desig, __float128 qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint *ieee, mpackint *ttype, __float128 * dmin1, __float128 * dmin2, __float128 * dn, __float128 * dn1, __float128 * dn2, __float128 * tau );
void Rlazq4 ( mpackint i0, mpackint n0, __float128 * z, mpackint pp, mpackint n0in, __float128 dmin, __float128 dmin1, __float128 dmin2, __float128 dn, __float128 dn1, __float128 dn2, __float128 * tau, mpackint *ttype, __float128 * g );
void Rlaqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, __float128 * h, mpackint ldh, __float128 * wr, __float128 * wi, mpackint iloz, mpackint ihiz, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *info );
void Claqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> * w, mpackint *iloz, mpackint *ihiz, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rlaqr1 ( mpackint n, __float128 * h, mpackint ldh, __float128 sr1, __float128 si1, __float128 sr2, __float128 si2, __float128 * v );
void Claqr1 ( mpackint n, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> s1, std::complex<__float128> s2, std::complex<__float128> * v );
void Rlaqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, __float128 * h, mpackint ldh, mpackint iloz, mpackint ihiz, __float128 * z, mpackint ldz, mpackint *ns, mpackint *nd, __float128 * sr, __float128 * si, __float128 * v, mpackint ldv, mpackint nh, __float128 * t, mpackint ldt, mpackint nv, __float128 * wv, mpackint ldwv, __float128 * work, mpackint lwork );
void Claqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, std::complex<__float128> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<__float128> * z, mpackint ldz, mpackint *ns, mpackint *nd, std::complex<__float128> * sh, std::complex<__float128> * v, mpackint ldv, mpackint nh, std::complex<__float128> * t, mpackint ldt, mpackint nv, std::complex<__float128> * wv, mpackint ldwv, std::complex<__float128> * work, mpackint lwork );
void Rlaqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, __float128 * h, mpackint ldh, mpackint iloz, mpackint ihiz, __float128 * z, mpackint ldz, mpackint ns, mpackint nd, __float128 * sr, __float128 * si, __float128 * v, mpackint ldv, mpackint nh, __float128 * t, mpackint ldt, mpackint nv, __float128 * wv, mpackint ldwv, __float128 * work, mpackint lwork );
void Claqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, std::complex<__float128> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<__float128> * z, mpackint ldz, mpackint *ns, mpackint *nd, std::complex<__float128> * sh, std::complex<__float128> * v, mpackint ldv, mpackint nh, std::complex<__float128> * t, mpackint ldt, mpackint nv, std::complex<__float128> * wv, mpackint ldwv, std::complex<__float128> * work, mpackint lwork );
void Rlaqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, __float128 * h, mpackint ldh, __float128 * wr, __float128 * wi, mpackint iloz, mpackint ihiz, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *info );
void Claqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> * w, mpackint iloz, mpackint ihiz, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rlaqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kac22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, __float128 * sr, __float128 * si, __float128 * h, mpackint ldh, mpackint iloz, mpackint ihiz, __float128 * z, mpackint ldz, __float128 * v, mpackint ldv, __float128 * u, mpackint ldu, mpackint nv, __float128 * wv, mpackint ldwv, mpackint nh, __float128 * wh, mpackint ldwh );
void Claqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kacc22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, std::complex<__float128> * s, std::complex<__float128> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * v, mpackint ldv, std::complex<__float128> * u, mpackint ldu, mpackint nv, std::complex<__float128> * wv, mpackint ldwv, mpackint nh, std::complex<__float128> * wh, mpackint ldwh );
void Rlatzm ( const char *side, mpackint m, mpackint n, __float128 * v, mpackint incv, __float128 * tau, __float128 *c1, __float128 * c2, mpackint ldc, __float128 * work );
void Clatzm ( const char *side, mpackint m, mpackint n, std::complex<__float128> * v, mpackint incv, std::complex<__float128> * tau, std::complex<__float128> * c1, std::complex<__float128> * c2, mpackint ldc, std::complex<__float128> * work );
void Clacp2 ( const char *uplo, mpackint m, mpackint n, __float128 * A, mpackint lda, std::complex<__float128> * B, mpackint ldb );
mpackint Risnan ( __float128 din );

/* not yet done ... driver and computational routines */
void Rbdsdc ( const char *uplo, const char *compq, mpackint n, __float128 * d, __float128 * e, __float128 * u, mpackint ldu, __float128 * vt, mpackint ldvt, __float128 * q, mpackint * iq, __float128 * work, mpackint * iwork, mpackint * info );
void Rbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, __float128 * d, __float128 * e, __float128 * vt, mpackint ldvt, __float128 * u, mpackint ldu, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Cbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, __float128 * d, __float128 * e, std::complex<__float128> * vt, mpackint ldvt, std::complex<__float128> * u, mpackint ldu, std::complex<__float128> * c, mpackint ldc, __float128 * rwork, mpackint * info );
void Rdisna ( const char *job, mpackint m, mpackint n, __float128 * d, __float128 * sep, mpackint *info );
void Rgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, __float128 * AB, mpackint ldab, __float128 * d, __float128 * e, __float128 * q, mpackint ldq, __float128 * pt, mpackint ldpt, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Cgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, std::complex<__float128> * AB, mpackint ldab, __float128 * d, __float128 * e, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * pt, mpackint ldpt, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, __float128 * AB, mpackint ldab, mpackint *ipiv, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Cgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, std::complex<__float128> * AB, mpackint ldab, mpackint *ipiv, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, __float128 * AB, mpackint ldab, __float128 * r, __float128 * c, __float128 * rowcnd, __float128 * colcnd, __float128 * amax, mpackint *info );
void Cgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<__float128> * AB, mpackint ldab, __float128 * r, __float128 * c, __float128 * rowcnd, __float128 * colcnd, __float128 * amax, mpackint *info );
void Rgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, __float128 * AB, mpackint ldab, __float128 * afb, mpackint ldafb, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * afb, mpackint ldafb, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, __float128 * AB, mpackint ldab, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Cgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<__float128> * ab, mpackint ldab, mpackint *ipiv, std::complex<__float128> * b, mpackint ldb, mpackint *info );
void Rgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, __float128 * AB, mpackint ldab, __float128 * afb, mpackint ldafb, mpackint * ipiv, char *equed, __float128 * r, __float128 * c, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint * iwork, mpackint * info );
void Cgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * afb, mpackint ldafb, mpackint * ipiv, char *equed, __float128 * r, __float128 * c, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, __float128 * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<__float128> * ab, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, __float128 * AB, mpackint ldab, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Cgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<__float128> * AB, mpackint ldab, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, __float128 * scale, mpackint m, __float128 * v, mpackint ldv, mpackint *info );
void Cgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, __float128 * scale, mpackint m, std::complex<__float128> * v, mpackint ldv, mpackint *info );
void Rgebal ( const char *job, mpackint n, __float128 * A, mpackint lda, mpackint *ilo, mpackint *ihi, __float128 * scale, mpackint *info );
void Cgebal ( const char *job, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ilo, mpackint *ihi, __float128 * scale, mpackint *info );
void Rgebrd ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * d, __float128 * e, __float128 * tauq, __float128 * taup, __float128 * work, mpackint lwork, mpackint *info );
void Cgebrd ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * d, __float128 * e, std::complex<__float128> * tauq, std::complex<__float128> * taup, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgecon ( const char *norm, mpackint n, __float128 * A, mpackint lda, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Cgecon ( const char *norm, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgeequ ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * r, __float128 * c, __float128 * rowcnd, __float128 * colcnd, __float128 * amax, mpackint *info );
void Cgeequ ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * r, __float128 * c, __float128 * rowcnd, __float128 * colcnd, __float128 * amax, mpackint *info );
void Rgees ( const char *jobvs, const char *sort, LFP select, mpackint n, __float128 * A, mpackint lda, mpackint *sdim, __float128 * wr, __float128 * wi, __float128 * vs, mpackint ldvs, __float128 * work, mpackint lwork, mpacklogical * bwork, mpackint *info );
void Cgees ( const char *jobvs, const char *sort, LFP select, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *sdim, std::complex<__float128> * w, std::complex<__float128> * vs, mpackint ldvs, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpacklogical * bwork, mpackint *info );
void Rgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, __float128 * A, mpackint lda, mpackint * sdim, __float128 * wr, __float128 * wi, __float128 * vs, mpackint ldvs, __float128 * rconde, __float128 * rcondv, __float128 * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *sdim, std::complex<__float128> * w, std::complex<__float128> * vs, mpackint ldvs, __float128 * rconde, __float128 * rcondv, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpacklogical * bwork, mpackint *info );
void Rgeev ( const char *jobvl, const char *jobvr, mpackint n, __float128 * A, mpackint lda, __float128 * wr, __float128 * wi, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, __float128 * work, mpackint lwork, mpackint *info );
void Cgeev ( const char *jobvl, const char *jobvr, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * w, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Rgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, __float128 * A, mpackint lda, __float128 * wr, __float128 * wi, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, __float128 * scale, __float128 * abnrm, __float128 * rconde, __float128 * rcondv, __float128 * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * w, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, __float128 * scale, __float128 * abnrm, __float128 * rconde, __float128 * rcondv, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Cgehrd ( mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgehrd ( mpackint n, mpackint ilo, mpackint ihi, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Rgelqf ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cgelqf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * work, mpackint lwork, mpackint *info );
void Cgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgelsx ( mpackint m, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *jpvt, __float128 rcond, mpackint *rank, __float128 * work, mpackint *info );
void Cgelsx ( mpackint m, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint *jpvt, __float128 rcond, mpackint *rank, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgelsd ( mpackint m, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * s, __float128 * rcond, mpackint *rank, __float128 * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Cgelsd ( mpackint m, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 * s, __float128 rcond, mpackint * rank, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * iwork, mpackint * info );
void Rgelss ( mpackint m, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * s, __float128 rcond, mpackint * rank, __float128 * work, mpackint lwork, mpackint * info );
void Cgelss ( mpackint m, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 * s, __float128 rcond, mpackint * rank, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Rgelsy ( mpackint m, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *jpvt, __float128 rcond, mpackint *rank, __float128 * work, mpackint lwork, mpackint *info );
void Cgelsy ( mpackint m, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint * jpvt, __float128 rcond, mpackint * rank, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Rgeqlf ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cgeqlf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgeqpf ( mpackint m, mpackint n, __float128 * A, mpackint lda, mpackint *jpvt, __float128 * tau, __float128 * work, mpackint *info );
void Cgeqpf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *jpvt, std::complex<__float128> * tau, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgeqp3 ( mpackint m, mpackint n, __float128 * A, mpackint lda, mpackint *jpvt, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cgeqp3 ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *jpvt, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *info );
void Rgeqrf ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cgeqrf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgerfs ( const char *trans, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * af, mpackint ldaf, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cgerfs ( const char *trans, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgerqf ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cgerqf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgesdd ( const char *jobz, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * s, __float128 * u, mpackint ldu, __float128 * vt, mpackint ldvt, __float128 * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgesdd ( const char *jobz, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * s, std::complex<__float128> * u, mpackint ldu, std::complex<__float128> * vt, mpackint ldvt, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * iwork, mpackint * info );
void Rgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * s, __float128 * u, mpackint ldu, __float128 * vt, mpackint ldvt, __float128 * work, mpackint lwork, mpackint * info );
void Cgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * s, std::complex<__float128> * u, mpackint ldu, std::complex<__float128> * vt, mpackint ldvt, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Rgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * af, mpackint ldaf, mpackint * ipiv, char *equed, __float128 * r, __float128 * c, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint * iwork, mpackint * info );
void Cgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, mpackint * ipiv, char *equed, __float128 * r, __float128 * c, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, __float128 * lscale, __float128 * rscale, mpackint m, __float128 * v, mpackint ldv, mpackint *info );
void Cggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, __float128 * lscale, __float128 * rscale, mpackint m, std::complex<__float128> * v, mpackint ldv, mpackint *info );
void Rggbal ( const char *job, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *ilo, mpackint *ihi, __float128 * lscale, __float128 * rscale, __float128 * work, mpackint *info );
void Cggbal ( const char *job, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint *ilo, mpackint *ihi, __float128 * lscale, __float128 * rscale, __float128 * work, mpackint *info );
void Rgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint * sdim, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * vsl, mpackint ldvsl, __float128 * vsr, mpackint ldvsr, __float128 * work, mpackint lwork, mpacklogical * bwork, mpackint * info );
void Cgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint * sdim, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * vsl, mpackint ldvsl, std::complex<__float128> * vsr, mpackint ldvsr, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpacklogical * bwork, mpackint * info );
void Rgegs ( const char *jobvsl, const char *jobvsr, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * vsl, mpackint ldvsl, __float128 * vsr, mpackint ldvsr, __float128 * work, mpackint lwork, mpackint *info );
void Cgegs ( const char *jobvsl, const char *jobvsr, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * vsl, mpackint ldvsl, std::complex<__float128> * vsr, mpackint ldvsr, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Rggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint * sdim, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * vsl, mpackint ldvsl, __float128 * vsr, mpackint ldvsr, __float128 * rconde, __float128 * rcondv, __float128 * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint * sdim, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * vsl, mpackint ldvsl, std::complex<__float128> * vsr, mpackint ldvsr, __float128 * rconde, __float128 * rcondv, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Rggev ( const char *jobvl, const char *jobvr, mpackint n, __float128 * A, mpackint lda, __float128 * b, mpackint ldb, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, __float128 * work, mpackint lwork, mpackint * info );
void Cggev ( const char *jobvl, const char *jobvr, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Rgegv ( const char *jobvl, const char *jobvr, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, __float128 * work, mpackint lwork, mpackint * info );
void Cgegv ( const char *jobvl, const char *jobvr, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * info );
void Rggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, __float128 * lscale, __float128 * rscale, __float128 * abnrm, __float128 * bbnrm, __float128 * rconde, __float128 * rcondv, __float128 * work, mpackint lwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Cggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, __float128 * lscale, __float128 * rscale, __float128 * abnrm, __float128 * bbnrm, __float128 * rconde, __float128 * rcondv, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Rggglm ( mpackint n, mpackint m, mpackint p, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * d, __float128 * x, __float128 * y, __float128 * work, mpackint lwork, mpackint *info );
void Cggglm ( mpackint n, mpackint m, mpackint p, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * d, std::complex<__float128> * x, std::complex<__float128> * y, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * q, mpackint ldq, __float128 * z, mpackint ldz, mpackint *info );
void Cgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * z, mpackint ldz, mpackint *info );
void Rgglse ( mpackint m, mpackint n, mpackint p, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * c, __float128 * d, __float128 * x, __float128 * work, mpackint lwork, mpackint *info );
void Cgglse ( mpackint m, mpackint n, mpackint p, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * c, std::complex<__float128> * d, std::complex<__float128> * x, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rggqrf ( mpackint n, mpackint m, mpackint p, __float128 * A, mpackint lda, __float128 * taua, __float128 * B, mpackint ldb, __float128 * taub, __float128 * work, mpackint lwork, mpackint *info );
void Cggqrf ( mpackint n, mpackint m, mpackint p, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * taua, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * taub, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rggrqf ( mpackint m, mpackint p, mpackint n, __float128 * A, mpackint lda, __float128 * taua, __float128 * B, mpackint ldb, __float128 * taub, __float128 * work, mpackint lwork, mpackint *info );
void Cggrqf ( mpackint m, mpackint p, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * taua, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * taub, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * alpha, __float128 * beta, __float128 * u, mpackint ldu, __float128 * v, mpackint ldv, __float128 * q, mpackint ldq, __float128 * work, mpackint *iwork, mpackint *info );
void Cggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 * alpha, __float128 * beta, std::complex<__float128> * u, mpackint ldu, std::complex<__float128> * v, mpackint ldv, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * work, __float128 * rwork, mpackint *iwork, mpackint *info );
void Rggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 tola, __float128 tolb, mpackint *k, mpackint *l, __float128 * u, mpackint ldu, __float128 * v, mpackint ldv, __float128 * q, mpackint ldq, mpackint *iwork, __float128 * tau, __float128 * work, mpackint *info );
void Cggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 tola, __float128 tolb, mpackint *k, mpackint *l, std::complex<__float128> * u, mpackint ldu, std::complex<__float128> * v, mpackint ldv, std::complex<__float128> * q, mpackint ldq, mpackint *iwork, __float128 * rwork, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint *info );
void Rgtcon ( const char *norm, mpackint n, __float128 * dl, __float128 * d, __float128 * du, __float128 * du2, mpackint *ipiv, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Cgtcon ( const char *norm, mpackint n, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * du2, mpackint *ipiv, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, mpackint *info );
void Rgtrfs ( const char *trans, mpackint n, mpackint nrhs, __float128 * dl, __float128 * d, __float128 * du, __float128 * dlf, __float128 * df, __float128 * duf, __float128 * du2, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cgtrfs ( const char *trans, mpackint n, mpackint nrhs, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * dlf, std::complex<__float128> * df, std::complex<__float128> * duf, std::complex<__float128> * du2, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgtsv ( mpackint n, mpackint nrhs, __float128 * dl, __float128 * d, __float128 * du, __float128 * B, mpackint ldb, mpackint *info );
void Cgtsv ( mpackint n, mpackint nrhs, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, __float128 * dl, __float128 * d, __float128 * du, __float128 * dlf, __float128 * df, __float128 * duf, __float128 * du2, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * dlf, std::complex<__float128> * df, std::complex<__float128> * duf, std::complex<__float128> * du2, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rgttrf ( mpackint n, __float128 * dl, __float128 * d, __float128 * du, __float128 * du2, mpackint *ipiv, mpackint *info );
void Cgttrf ( mpackint n, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * du2, mpackint *ipiv, mpackint *info );
void Rgttrs ( const char *trans, mpackint n, mpackint nrhs, __float128 * dl, __float128 * d, __float128 * du, __float128 * du2, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Cgttrs ( const char *trans, mpackint n, mpackint nrhs, std::complex<__float128> * dl, std::complex<__float128> * d, std::complex<__float128> * du, std::complex<__float128> * du2, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rhgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, __float128 * h, mpackint ldh, __float128 * t, mpackint ldt, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * q, mpackint ldq, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *info );
void Chgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *info );
void Rhsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical *select, mpackint n, __float128 * h, mpackint ldh, __float128 * wr, __float128 * wi, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, mpackint mm, mpackint m, __float128 * work, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Chsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical * select, mpackint n, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> * w, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, mpackint mm, mpackint *m, std::complex<__float128> * work, __float128 * rwork, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Rhseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, __float128 * h, mpackint ldh, __float128 * wr, __float128 * wi, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *info );
void Chseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * h, mpackint ldh, std::complex<__float128> * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Ropgtr ( const char *uplo, mpackint n, __float128 * ap, __float128 * tau, __float128 * q, mpackint ldq, __float128 * work, mpackint *info );
void Cupgtr ( const char *uplo, mpackint n, std::complex<__float128> * ap, std::complex<__float128> * tau, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * work, mpackint *info );
void Ropmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, __float128 * ap, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint *info );
void Cupmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, std::complex<__float128> * ap, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint *info );
void Rorgbr ( const char *vect, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cungbr ( const char *vect, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rorghr ( mpackint n, mpackint ilo, mpackint ihi, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cunghr ( mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rorglq ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cunglq ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rorgrq ( mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Cungrq ( mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rormtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * c, mpackint ldc, __float128 * work, mpackint lwork, mpackint *info );
void Cunmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rpbcon ( const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Cpbcon ( const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rpbequ ( const char *uplo, mpackint n, mpackint kd, __float128 * ab, mpackint ldab, __float128 * s, __float128 * scond, __float128 * amax, mpackint *info );
void Cpbequ ( const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, __float128 * s, __float128 * scond, __float128 * amax, mpackint *info );
void Rpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, __float128 * AB, mpackint ldab, __float128 * afb, mpackint ldafb, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * afb, mpackint ldafb, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rpbstf ( const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, mpackint *info );
void Cpbstf ( const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, mpackint *info );
void Rpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, __float128 * AB, mpackint ldab, __float128 * B, mpackint ldb, mpackint *info );
void Cpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<__float128> * ab, mpackint ldab, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, __float128 * AB, mpackint ldab, __float128 * afb, mpackint ldafb, char *equed, __float128 * s, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint * iwork, mpackint * info );
void Cpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * afb, mpackint ldafb, char *equed, __float128 * s, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rpbtrf ( const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, mpackint *info );
void Cpbtrf ( const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, mpackint *info );
void Rpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, __float128 * ab, mpackint ldab, __float128 * B, mpackint ldb, mpackint *info );
void Cpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rpocon ( const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Cpocon ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rpoequ ( mpackint n, __float128 * A, mpackint lda, __float128 * s, __float128 * scond, __float128 * amax, mpackint *info );
void Cpoequ ( mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * s, __float128 * scond, __float128 * amax, mpackint *info );
void Rporfs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * af, mpackint ldaf, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cporfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rposv ( const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *info );
void Cposv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * af, mpackint ldaf, char *equed, __float128 * s, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint * iwork, mpackint * info );
void Cposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, char *equed, __float128 * s, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rpotri ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *info );
void Cpotri ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *info );
void Rpotrs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *info );
void Cpotrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rppcon ( const char *uplo, mpackint n, __float128 * ap, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Cppcon ( const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * anorm, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rppequ ( const char *uplo, mpackint n, __float128 * ap, __float128 * s, __float128 * scond, __float128 * amax, mpackint *info );
void Cppequ ( const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * s, __float128 * scond, __float128 * amax, mpackint *info );
void Rpptrf ( const char *uplo, mpackint n, __float128 * ap, mpackint *info );
void Cpptrf ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *info );
void Rpptri ( const char *uplo, mpackint n, __float128 * ap, mpackint *info );
void Cpptri ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *info );
void Rpptrs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, __float128 * B, mpackint ldb, mpackint *info );
void Cpptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rpprfs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, __float128 * afp, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cpprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * afp, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rppsv ( const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, __float128 * B, mpackint ldb, mpackint *info );
void Cppsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, __float128 * afp, char *equed, __float128 * s, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * afp, char *equed, __float128 * s, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rptcon ( mpackint n, __float128 * d, __float128 * e, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *info );
void Cptcon ( mpackint n, __float128 * d, std::complex<__float128> * e, __float128 anorm, __float128 * rcond, __float128 * rwork, mpackint *info );
void Rpteqr ( const char *compz, mpackint n, __float128 * d, __float128 * e, __float128 * z, mpackint ldz, __float128 * work, mpackint * info );
void Cpteqr ( const char *compz, mpackint n, __float128 * d, __float128 * e, std::complex<__float128> * z, mpackint ldz, __float128 * work, mpackint *info );
void Rptrfs ( mpackint n, mpackint nrhs, __float128 * d, __float128 * e, __float128 * df, __float128 * ef, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *info );
void Cptrfs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * d, std::complex<__float128> * e, __float128 * df, std::complex<__float128> * ef, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rptsv ( mpackint n, mpackint nrhs, __float128 * d, __float128 * e, __float128 * B, mpackint ldb, mpackint *info );
void Cptsv ( mpackint n, mpackint nrhs, __float128 * d, std::complex<__float128> * e, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rptsvx ( const char *fact, mpackint n, mpackint nrhs, __float128 * d, __float128 * e, __float128 * df, __float128 * ef, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *info );
void Cptsvx ( const char *fact, mpackint n, mpackint nrhs, __float128 * d, std::complex<__float128> * e, __float128 * df, std::complex<__float128> * ef, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rpttrf ( mpackint n, __float128 * d, __float128 * e, mpackint *info );
void Cpttrf ( mpackint n, __float128 * d, std::complex<__float128> * e, mpackint *info );
void Rpttrs ( mpackint n, mpackint nrhs, __float128 * d, __float128 * e, __float128 * B, mpackint ldb, mpackint *info );
void Cpttrs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * d, std::complex<__float128> * e, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rsbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *info );
void Chbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rsbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, __float128 * q, mpackint ldq, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * q, mpackint ldq, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint * iwork, mpackint * ifail, mpackint * info );
void Rsbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, __float128 * AB, mpackint ldab, __float128 * bb, mpackint ldbb, __float128 * x, mpackint ldx, __float128 * work, mpackint *info );
void Chbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * bb, mpackint ldbb, std::complex<__float128> * x, mpackint ldx, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rsbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, __float128 * AB, mpackint ldab, __float128 * bb, mpackint ldbb, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *info );
void Chbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * bb, mpackint ldbb, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rsbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, __float128 * AB, mpackint ldab, __float128 * BB, mpackint ldbb, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * BB, mpackint ldbb, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, __float128 * AB, mpackint ldab, __float128 * BB, mpackint ldbb, __float128 * q, mpackint ldq, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<__float128> * ab, mpackint ldab, std::complex<__float128> * bb, mpackint ldbb, std::complex<__float128> * q, mpackint ldq, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, __float128 * d, __float128 * e, __float128 * q, mpackint ldq, __float128 * work, mpackint *info );
void Chbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, __float128 * d, __float128 * e, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * work, mpackint *info );
void Rspcon ( const char *uplo, mpackint n, __float128 * ap, mpackint *ipiv, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Cspcon ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *ipiv, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, mpackint *info );
void Chpcon ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *ipiv, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, mpackint *info );
void Rspev ( const char *jobz, const char *uplo, mpackint n, __float128 * ap, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *info );
void Chpev ( const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rspevd ( const char *jobz, const char *uplo, mpackint n, __float128 * ap, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpevd ( const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspevx ( const char *jobz, const char *range, const char *uplo, mpackint n, __float128 * ap, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpevx ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rspgst ( mpackint itype, const char *uplo, mpackint n, __float128 * ap, __float128 * bp, mpackint *info );
void Chpgst ( mpackint *itype, const char *uplo, mpackint n, std::complex<__float128> * ap, std::complex<__float128> * bp, mpackint *info );
void Rspgv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, __float128 * ap, __float128 * bp, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *info );
void Chpgv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * ap, std::complex<__float128> * bp, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rspgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, __float128 * ap, __float128 * bp, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * ap, std::complex<__float128> * bp, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspgvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, __float128 * ap, __float128 * bp, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint m, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpgvx ( mpackint itype, const char *jobz, char *range, const char *uplo, mpackint n, std::complex<__float128> * ap, std::complex<__float128> * bp, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, __float128 * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsprfs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, __float128 * afp, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Csprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * afp, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Chprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * afp, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rspsv ( const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Cspsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Chpsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, __float128 * afp, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Cspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * afp, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Chpsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * afp, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rsptrd ( const char *uplo, mpackint n, __float128 * ap, __float128 * d, __float128 * e, __float128 * tau, mpackint *info );
void Chptrd ( const char *uplo, mpackint n, std::complex<__float128> * ap, __float128 * d, __float128 * e, std::complex<__float128> * tau, mpackint *info );
void Rsptrf ( const char *uplo, mpackint n, __float128 * ap, mpackint *ipiv, mpackint *info );
void Csptrf ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *ipiv, mpackint *info );
void Chptrf ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *ipiv, mpackint *info );
void Rsptri ( const char *uplo, mpackint n, __float128 * ap, mpackint *ipiv, __float128 * work, mpackint *info );
void Csptri ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *ipiv, std::complex<__float128> * work, mpackint *info );
void Chptri ( const char *uplo, mpackint n, std::complex<__float128> * ap, mpackint *ipiv, std::complex<__float128> * work, mpackint *info );
void Rsptrs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * ap, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Csptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Chptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * ap, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rstebz ( const char *range, const char *order, mpackint n, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, __float128 * d, __float128 * e, mpackint * m, mpackint * nsplit, __float128 * w, mpackint *iblock, mpackint *isplit, __float128 * work, mpackint *iwork, mpackint *info );
void Rstedc ( const char *compz, mpackint n, __float128 * d, __float128 * e, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cstedc ( const char *compz, mpackint n, __float128 * d, __float128 * e, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstegr ( const char *jobz, const char *range, mpackint n, __float128 * d, __float128 * e, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, __float128 * z, mpackint ldz, mpackint * isuppz, __float128 * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstegr ( const char *jobz, const char *range, mpackint n, __float128 *d, __float128 * e, __float128 * vl, __float128 * vu, mpackint *il, mpackint *iu, __float128 * abstol, mpackint m, __float128 * w, std::complex<__float128> * z, mpackint ldz, mpackint *isuppz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstein ( mpackint n, __float128 * d, __float128 * e, mpackint m, __float128 * w, mpackint *iblock, mpackint *isplit, __float128 * z, mpackint ldz, __float128 * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cstein ( mpackint n, __float128 * d, __float128 * e, mpackint m, __float128 * w, mpackint *iblock, mpackint *isplit, std::complex<__float128> * z, mpackint ldz, __float128 * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstev ( const char *jobz, mpackint n, __float128 * d, __float128 * e, __float128 * z, mpackint ldz, __float128 * work, mpackint *info );
void Rstevd ( const char *jobz, mpackint n, __float128 * d, __float128 * e, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstevr ( const char *jobz, const char *range, mpackint n, __float128 * d, __float128 * e, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, __float128 * z, mpackint ldz, mpackint * isuppz, __float128 * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rstevx ( const char *jobz, const char *range, mpackint n, __float128 * d, __float128 * e, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstemr ( const char *jobz, const char *range, mpackint n, __float128 * d, __float128 * e, __float128 vl, __float128 vu, mpackint il, mpackint iu, mpackint * m, __float128 * w, __float128 * z, mpackint ldz, mpackint nzc, mpackint * isuppz, mpacklogical * tryrac, __float128 * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstemr ( const char *jobz, const char *range, mpackint n, __float128 * d, __float128 * e, __float128 vl, __float128 vu, mpackint il, mpackint iu, mpackint * m, __float128 * w, std::complex<__float128> * z, mpackint ldz, mpackint nzc, mpackint *isuppz, mpacklogical * tryrac, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsycon ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, __float128 anorm, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Csycon ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, mpackint *info );
void Checon ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, __float128 anorm, __float128 * rcond, std::complex<__float128> * work, mpackint *info );
void Rsyevd ( const char *jobz, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * w, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cheevd ( const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * w, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsyevr ( const char *jobz, const char *range, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, __float128 * z, mpackint ldz, mpackint * isuppz, __float128 * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cheevr ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, std::complex<__float128> * z, mpackint ldz, mpackint * isuppz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rsyevx ( const char *jobz, const char *range, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cheevx ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsygst ( mpackint itype, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, mpackint *info );
void Chegst ( mpackint itype, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rsygv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * w, __float128 * work, mpackint lwork, mpackint *info );
void Chegv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 * w, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *info );
void Rsygvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * w, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chegvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 * w, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsygvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint *m, __float128 * w, __float128 * z, mpackint ldz, __float128 * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chegvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 vl, __float128 vu, mpackint il, mpackint iu, __float128 abstol, mpackint * m, __float128 * w, std::complex<__float128> * z, mpackint ldz, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsyrfs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * af, mpackint ldaf, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Csyrfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Cherfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rsysv ( const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * work, mpackint lwork, mpackint *info );
void Csysv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Chesv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rsysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * af, mpackint ldaf, mpackint *ipiv, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, __float128 * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Csysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *info );
void Chesvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * af, mpackint ldaf, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * rcond, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, mpackint lwork, __float128 * rwork, mpackint *info );
void Rsytrf ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * work, mpackint lwork, mpackint *info );
void Csytrf ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Chetrf ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rsytri ( const char *uplo, mpackint n, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * work, mpackint *info );
void Csytri ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * work, mpackint *info );
void Chetri ( const char *uplo, mpackint n, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * work, mpackint *info );
void Rsytrs ( const char *uplo, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, mpackint *ipiv, __float128 * B, mpackint ldb, mpackint *info );
void Csytrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Chetrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, mpackint *ipiv, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rtbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, __float128 * AB, mpackint ldab, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Ctbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, std::complex<__float128> * AB, mpackint ldab, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rtbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, __float128 * AB, mpackint ldab, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Ctbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, std::complex<__float128> * AB, mpackint ldab, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rtbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, __float128 * ab, mpackint ldab, __float128 * B, mpackint ldb, mpackint *info );
void Ctbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, std::complex<__float128> * ab, mpackint ldab, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rtgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, __float128 * s, mpackint lds, __float128 *p, mpackint ldp, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, mpackint mm, mpackint *m, __float128 * work, mpackint * info );
void Ctgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, std::complex<__float128> * s, mpackint lds, std::complex<__float128> * p, mpackint ldp, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, mpackint mm, mpackint * m, std::complex<__float128> * work, __float128 * rwork, mpackint * info );
void Rtgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * q, mpackint ldq, __float128 * z, mpackint ldz, mpackint * ifst, mpackint * ilst, __float128 * work, mpackint lwork, mpackint * info );
void Ctgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * z, mpackint ldz, mpackint ifst, mpackint *ilst, mpackint *info );
void Rtgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical *select, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * alphar, __float128 * alphai, __float128 * beta, __float128 * q, mpackint ldq, __float128 * z, mpackint ldz, mpackint * m, __float128 * pl, __float128 * pr, __float128 * dif, __float128 * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Ctgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical * select, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * alpha, std::complex<__float128> * beta, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * z, mpackint ldz, mpackint * m, __float128 * pl, __float128 * pr, __float128 * dif, std::complex<__float128> * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rtgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 tola, __float128 tolb, __float128 * alpha, __float128 * beta, __float128 * u, mpackint ldu, __float128 * v, mpackint ldv, __float128 * q, mpackint ldq, __float128 * work, mpackint ncycle, mpackint *info );
void Ctgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, __float128 tola, __float128 tolb, __float128 * alpha, __float128 * beta, std::complex<__float128> * u, mpackint ldu, std::complex<__float128> * v, mpackint ldv, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * work, mpackint * ncycle, mpackint *info );
void Rtgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, __float128 * s, __float128 * dif, mpackint mm, mpackint * m, __float128 * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, __float128 * s, __float128 * dif, mpackint mm, mpackint * m, std::complex<__float128> * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * c, mpackint ldc, __float128 * d, mpackint ldd, __float128 * e, mpackint lde, __float128 * f, mpackint ldf, __float128 * scale, __float128 * dif, __float128 * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * c, mpackint ldc, std::complex<__float128> * d, mpackint ldd, std::complex<__float128> * e, mpackint lde, std::complex<__float128> * f, mpackint ldf, __float128 * scale, __float128 * dif, std::complex<__float128> * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, __float128 * ap, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Ctpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<__float128> * ap, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rtprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, __float128 * ap, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Ctprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rtptri ( const char *uplo, const char *diag, mpackint n, __float128 * ap, mpackint *info );
void Ctptri ( const char *uplo, const char *diag, mpackint n, std::complex<__float128> * ap, mpackint *info );
void Rtptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, __float128 * ap, __float128 * B, mpackint ldb, mpackint *info );
void Ctptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<__float128> * ap, std::complex<__float128> * B, mpackint ldb, mpackint *info );
void Rtrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, __float128 * A, mpackint lda, __float128 * rcond, __float128 * work, mpackint *iwork, mpackint *info );
void Ctrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<__float128> * A, mpackint lda, __float128 * rcond, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rtrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, __float128 * t, mpackint ldt, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, mpackint mm, mpackint *m, __float128 * work, mpackint *info );
void Ctrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, mpackint mm, mpackint *m, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rtrexc ( const char *compq, mpackint n, __float128 * t, mpackint ldt, __float128 * q, mpackint ldq, mpackint *ifst, mpackint *ilst, __float128 * work, mpackint *info );
void Ctrexc ( const char *compq, mpackint n, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * q, mpackint ldq, mpackint ifst, mpackint ilst, mpackint *info );
void Rtrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * x, mpackint ldx, __float128 * ferr, __float128 * berr, __float128 * work, mpackint *iwork, mpackint *info );
void Ctrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * x, mpackint ldx, __float128 * ferr, __float128 * berr, std::complex<__float128> * work, __float128 * rwork, mpackint *info );
void Rtrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, __float128 * t, mpackint ldt, __float128 * q, mpackint ldq, __float128 * wr, __float128 * wi, mpackint m, __float128 * s, __float128 * sep, __float128 * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Ctrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * q, mpackint ldq, std::complex<__float128> * w, mpackint m, __float128 * s, __float128 * sep, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rtrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, __float128 * t, mpackint ldt, __float128 * vl, mpackint ldvl, __float128 * vr, mpackint ldvr, __float128 * s, __float128 * sep, mpackint mm, mpackint *m, __float128 * work, mpackint ldwork, mpackint *iwork, mpackint *info );
void Ctrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, std::complex<__float128> * t, mpackint ldt, std::complex<__float128> * vl, mpackint ldvl, std::complex<__float128> * vr, mpackint ldvr, __float128 * s, __float128 * sep, mpackint mm, mpackint *m, std::complex<__float128> * work, mpackint ldwork, __float128 * rwork, mpackint *info );
void Rtrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * B, mpackint ldb, __float128 * c, mpackint ldc, __float128 * scale, mpackint *info );
void Ctrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * B, mpackint ldb, std::complex<__float128> * c, mpackint ldc, __float128 * scale, mpackint *info );
void Rtzrzf ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, __float128 * work, mpackint lwork, mpackint *info );
void Ctzrzf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, std::complex<__float128> * work, mpackint lwork, mpackint *info );
void Rtzrqf ( mpackint m, mpackint n, __float128 * A, mpackint lda, __float128 * tau, mpackint *info );
void Ctzrqf ( mpackint m, mpackint n, std::complex<__float128> * A, mpackint lda, std::complex<__float128> * tau, mpackint *info );

#endif
