/*
 * Copyright (c) 2008-2010
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mlapack_dd.h,v 1.31 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MLAPACK_DD_H_
#define _MLAPACK_DD_H_

#include "mpack_config.h"
#include "qd/dd_real.h"
#include "dd_complex.h"

/* MLAPACK prototypes */

/* MLAPACK driver routines */
void Rsyev ( const char *jobz, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * w, dd_real * work, mpackint lwork, mpackint *info );
void Cheev ( const char *jobz, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * w, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *info );
void Rgesv ( mpackint n, mpackint nrhs, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Cgesv ( mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );

/* MLAPACK computational routines */
void Rsteqr ( const char *compz, mpackint n, dd_real * d, dd_real * e, dd_real * Z, mpackint ldz, dd_real * work, mpackint *info );
void Csteqr ( const char *compz, mpackint n, dd_real * d, dd_real * e, dd_complex * z, mpackint ldz, dd_real * work, mpackint *info );
void Rsterf ( mpackint n, dd_real * d, dd_real * e, mpackint *info );
void Rorgqr ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cungqr ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rorgql ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cungql ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rsytrd ( const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * d, dd_real * e, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Chetrd ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * d, dd_real * e, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rorgtr ( const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cungtr ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rpotrf ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Cpotrf ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rtrtri ( const char *uplo, const char *diag, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Ctrtri ( const char *uplo, const char *diag, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rgetrf ( mpackint m, mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetrf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rgetri ( mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * work, mpackint lwork, mpackint *info );
void Cgetri ( mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * work, mpackint lwork, mpackint *info );
void Rgetrs ( const char *trans, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Cgetrs ( const char *trans, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Rtrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *info );
void Ctrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint *info );

/* MLAPACK Auxiliary routines */
dd_real Rlamc3 ( dd_real a, dd_real b );
dd_real Rlamch_dd(const char *cmach);
mpackint iMlaenv_dd(mpackint ispec, const char *name, const char *opts, mpackint n1, mpackint n2,  mpackint n3, mpackint n4);
void Rlae2 ( dd_real a, dd_real b, dd_real c, dd_real * rt1, dd_real * rt2 );
void Rlaev2 ( dd_real a, dd_real b, dd_real c, dd_real * rt1, dd_real * rt2, dd_real * cs1, dd_real * sn1 );
void Claev2 ( dd_complex a, dd_complex b, dd_complex c, dd_real * rt1, dd_real * rt2, dd_real * cs1, dd_complex * sn1 );
void Rlassq ( mpackint n, dd_real * x, mpackint incx, dd_real * scale, dd_real * sumsq );
void Classq ( mpackint n, dd_complex * x, mpackint incx, dd_real * scale, dd_real * sumsq );
dd_real Rlanst ( const char *norm, mpackint n, dd_real * d, dd_real * e );
dd_real Clanht ( const char *norm, mpackint n, dd_real * d, dd_complex * e );
dd_real Rlansy ( const char *norm, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * work );
dd_real Clansy ( const char *norm, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * work );
dd_real Clanhe ( const char *norm, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * work );
dd_real Rlapy2 ( dd_real x, dd_real y );
void Rlarfg ( mpackint N, dd_real * alpha, dd_real * x, mpackint incx, dd_real * tau );
dd_real Rlapy3 ( dd_real x, dd_real y, dd_real z );
void Rladiv ( dd_real a, dd_real b, dd_real c, dd_real d, dd_real * p, dd_real * q );
dd_complex Cladiv ( dd_complex x, dd_complex y );
void Clarfg ( mpackint n, dd_complex * alpha, dd_complex * x, mpackint incx, dd_complex * tau );
void Rlartg ( dd_real f, dd_real g, dd_real * cs, dd_real * sn, dd_real * r );
void Clartg ( dd_complex f, dd_complex g, dd_real * cs, dd_complex * sn, dd_complex * r );
void Rlaset ( const char *uplo, mpackint m, mpackint n, dd_real alpha, dd_real beta, dd_real * A, mpackint lda );
void Claset ( const char *uplo, mpackint m, mpackint n, dd_complex alpha, dd_complex beta, dd_complex * A, mpackint lda );
void Rlasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, dd_real * c, dd_real * s, dd_real * A, mpackint lda );
void Clasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, dd_real * c, dd_real * s, dd_complex * A, mpackint lda );
void Rpotf2 ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Clacgv ( mpackint n, dd_complex * x, mpackint incx );
void Cpotf2 ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rlascl ( const char *type, mpackint kl, mpackint ku, dd_real cfrom, dd_real cto, mpackint m, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Clascl ( const char *type, mpackint kl, mpackint ku, dd_real cfrom, dd_real cto, mpackint m, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rlasrt ( const char *id, mpackint n, dd_real * d, mpackint *info );
void Rsytd2 ( const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * d, dd_real * e, dd_real * tau, mpackint *info );
void Chetd2 ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * d, dd_real * e, dd_complex * tau, mpackint *info );
void Rlarf ( const char *side, mpackint m, mpackint n, dd_real * v, mpackint incv, dd_real tau, dd_real * C, mpackint ldc, dd_real * work );
void Clarf ( const char *side, mpackint m, mpackint n, dd_complex * v, mpackint incv, dd_complex tau, dd_complex * c, mpackint ldc, dd_complex * work );
void Rorg2l ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cung2l ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rorg2r ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cung2r ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rlarft ( const char *direct, const char *storev, mpackint n, mpackint k, dd_real * v, mpackint ldv, dd_real * tau, dd_real * t, mpackint ldt );
void Clarft ( const char *direct, const char *storev, mpackint n, mpackint k, dd_complex * v, mpackint ldv, dd_complex * tau, dd_complex * t, mpackint ldt );
void Rlarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, dd_real * V, mpackint ldv, dd_real * T, mpackint ldt, dd_real * C, mpackint ldc, dd_real * work, mpackint ldwork );
void Clarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, dd_complex * V, mpackint ldv, dd_complex * T, mpackint ldt, dd_complex * C, mpackint ldc, dd_complex * work, mpackint ldwork );
void Rlatrd ( const char *uplo, mpackint n, mpackint nb, dd_real * A, mpackint lda, dd_real * e, dd_real * tau, dd_real * w, mpackint ldw );
void Clatrd ( const char *uplo, mpackint n, mpackint nb, dd_complex * A, mpackint lda, dd_real * e, dd_complex * tau, dd_complex * w, mpackint ldw );
void Clacrm ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * B, mpackint ldb, dd_complex * c, mpackint ldc, dd_real * rwork );
void Rtrti2 ( const char *uplo, const char *diag, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Ctrti2 ( const char *uplo, const char *diag, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rgetf2 ( mpackint m, mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetf2 ( mpackint m, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rlaswp ( mpackint n, dd_real * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Claswp ( mpackint n, dd_complex * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Rlasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * w, mpackint ldw, mpackint *info );
void Clasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * w, mpackint ldw, mpackint *info );
void Clahef ( const char *uplo, mpackint n, mpackint nb, mpackint kb, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * w, mpackint ldw, mpackint *info );
void Clacrt ( mpackint n, dd_complex * cx, mpackint incx, dd_complex * cy, mpackint incy, dd_complex c, dd_complex s );
void Claesy ( dd_complex a, dd_complex b, dd_complex c, dd_complex * rt1, dd_complex * rt2, dd_complex * evscal, dd_complex * cs1, dd_complex * sn1 );
void Crot ( mpackint n, dd_complex * cx, mpackint incx, dd_complex * cy, mpackint incy, dd_real c, dd_complex s );
void Cspmv ( const char *uplo, mpackint n, dd_complex alpha, dd_complex * AP, dd_complex * x, mpackint incx, dd_complex beta, dd_complex * y, mpackint incy );
void Cspr ( const char *uplo, mpackint n, dd_complex alpha, dd_complex * x, mpackint incx, dd_complex * AP );
void Csymv ( const char *uplo, mpackint n, dd_complex alpha, dd_complex * A, mpackint lda, dd_complex * x, mpackint incx, dd_complex beta, dd_complex * y, mpackint incy );
void Csyr ( const char *uplo, mpackint n, dd_complex alpha, dd_complex * x, mpackint incx, dd_complex * A, mpackint lda );
mpackint iCmax1 ( mpackint n, dd_complex * cx, mpackint incx );
dd_real RCsum1 ( mpackint n, dd_complex * cx, mpackint incx );
void Rlacn2 ( mpackint n, dd_real * v, dd_real * x, mpackint *isgn, dd_real * est, mpackint *kase, mpackint *isave );
void Clacn2 ( mpackint n, dd_complex * v, dd_complex * x, dd_real * est, mpackint *kase, mpackint *isave );
void Rlatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, dd_real * A, mpackint lda, dd_real * x, dd_real * scale, dd_real * cnorm, mpackint *info );
void Clatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, dd_complex * A, mpackint lda, dd_complex * x, dd_real * scale, dd_real * cnorm, mpackint *info );

/* not yet done ... auxiliary routines */
void Rgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_real * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_complex * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgebd2 ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * d, dd_real * e, dd_real * tauq, dd_real * taup, dd_real * work, mpackint *info );
void Cgebd2 ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * d, dd_real * e, dd_complex * tauq, dd_complex * taup, dd_complex * work, mpackint *info );
void Rgehd2 ( mpackint n, mpackint ilo, mpackint ihi, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cgehd2 ( mpackint n, mpackint ilo, mpackint ihi, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rgelq2 ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cgelq2 ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rgeql2 ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cgeql2 ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rgeqr2 ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cgeqr2 ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rgerq2 ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cgerq2 ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rgesc2 ( mpackint n, dd_real * A, mpackint lda, dd_real * rhs, mpackint *ipiv, mpackint *jpiv, dd_real * scale );
void Cgesc2 ( mpackint n, dd_complex * A, mpackint lda, dd_complex * rhs, mpackint *ipiv, mpackint *jpiv, dd_real * scale );
void Rgetc2 ( mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Cgetc2 ( mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Rgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, dd_real * dl, dd_real * d, dd_real * du, dd_real * du2, mpackint *ipiv, dd_real * B, mpackint ldb );
void Cgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * du2, mpackint *ipiv, dd_complex * B, mpackint ldb );
void Rlabrd ( mpackint m, mpackint n, mpackint nb, dd_real * A, mpackint lda, dd_real * d, dd_real * e, dd_real * tauq, dd_real * taup, dd_real * x, mpackint ldx, dd_real * y, mpackint ldy );
void Clabrd ( mpackint m, mpackint n, mpackint nb, dd_complex * A, mpackint lda, dd_real * d, dd_real * e, dd_complex * tauq, dd_complex * taup, dd_complex * x, mpackint ldx, dd_complex * y, mpackint ldy );
void Rlacpy ( const char *uplo, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb );
void Clacpy ( const char *uplo, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb );
void Clarcm ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * c, mpackint ldc, dd_real * rwork );
void Rlaebz ( mpackint ijob, mpackint nitmax, mpackint n, mpackint mmax, mpackint minp, mpackint nbmin, dd_real abstol, dd_real reltol, dd_real pivmin, dd_real * d, dd_real * e, dd_real * e2, mpackint *nval, dd_real * AB, dd_real * c, mpackint *mout, mpackint *nab, dd_real * work, mpackint *iwork, mpackint *info );
void Rlaed0 ( mpackint icompq, mpackint qsiz, mpackint n, dd_real * d, dd_real * e, dd_real * q, mpackint ldq, dd_real * qstore, mpackint ldqs, dd_real * work, mpackint *iwork, mpackint *info );
void Claed0 ( mpackint qsiz, mpackint n, dd_real * d, dd_real * e, dd_complex * q, mpackint ldq, dd_complex * qstore, mpackint ldqs, dd_real * rwork, mpackint *iwork, mpackint *info );
void Rlaed1 ( mpackint n, dd_real * d, dd_real * q, mpackint ldq, mpackint *indxq, dd_real rho, mpackint cutpnt, dd_real * work, mpackint *iwork, mpackint *info );
void Rlaed2 ( mpackint *k, mpackint n, mpackint n1, dd_real * d, dd_real * q, mpackint ldq, mpackint *indxq, dd_real * rho, dd_real * z, dd_real * dlamda, dd_real * w, dd_real * q2, mpackint *indx, mpackint *indxc, mpackint *indxp, mpackint *coltyp, mpackint *info );
void Rlaed3 ( mpackint k, mpackint n, mpackint n1, dd_real * d, dd_real * q, mpackint ldq, dd_real * rho, dd_real * dlamda, dd_real * q2, mpackint *indx, mpackint *ctot, dd_real * w, dd_real * s, mpackint *info );
void Rlaed4 ( mpackint n, mpackint i, dd_real * d, dd_real * z, dd_real * delta, dd_real rho, dd_real * dlam, mpackint *info );
void Rlaed5 ( mpackint i, dd_real * d, dd_real * z, dd_real * delta, dd_real rho, dd_real * dlam );
void Rlaed6 ( mpackint kniter, mpackint orgati, dd_real rho, dd_real * d, dd_real * z, dd_real * finit, dd_real * tau, mpackint *info );
void Rlaed7 ( mpackint icompq, mpackint n, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, dd_real * d, dd_real * q, mpackint ldq, mpackint *indxq, dd_real rho, mpackint cutpnt, dd_real * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, dd_real * givnum, dd_real * work, mpackint *iwork, mpackint *info );
void Claed7 ( mpackint n, mpackint cutpnt, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, dd_real * d, dd_complex * q, mpackint ldq, dd_real rho, mpackint *indxq, dd_real * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, dd_real * givnum, dd_complex * work, dd_real * rwork, mpackint *iwork, mpackint *info );
void Rlaed8 ( mpackint icompq, mpackint *k, mpackint n, mpackint qsiz, dd_real * d, dd_real * q, mpackint ldq, mpackint *indxq, dd_real * rho, mpackint cutpnt, dd_real * z, dd_real * dlamda, dd_real * q2, mpackint ldq2, dd_real * w, mpackint *perm, mpackint *givptr, mpackint *givcol, dd_real * givnum, mpackint *indxp, mpackint *indx, mpackint *info );
void Claed8 ( mpackint *k, mpackint n, mpackint qsiz, dd_complex * q, mpackint ldq, dd_real * d, dd_real * rho, mpackint cutpnt, dd_real * z, dd_real * dlamda, dd_complex * q2, mpackint ldq2, dd_real * w, mpackint *indxp, mpackint *indx, mpackint *indxq, mpackint *perm, mpackint *givptr, mpackint *givcol, dd_real * givnum, mpackint *info );
void Rlaed9 ( mpackint k, mpackint kstart, mpackint kstop, mpackint n, dd_real * d, dd_real * q, mpackint ldq, dd_real rho, dd_real * dlamda, dd_real * w, dd_real * s, mpackint lds, mpackint *info );
void Rlaeda ( mpackint n, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, dd_real * givnum, dd_real * q, mpackint *qptr, dd_real * z, dd_real * ztemp, mpackint *info );
void Rlaein ( mpackint rightv, mpackint noinit, mpackint n, dd_real * h, mpackint ldh, dd_real wr, dd_real wi, dd_real * vr, dd_real * vi, dd_real * B, mpackint ldb, dd_real * work, dd_real eps3, dd_real smlnum, dd_real bignum, mpackint *info );
void Claein ( mpackint rightv, mpackint noinit, mpackint n, dd_complex * h, mpackint ldh, dd_complex w, dd_complex * v, dd_complex * B, mpackint ldb, dd_real * rwork, dd_real eps3, dd_real smlnum, mpackint *info );
void Rlaexc ( mpackint wantq, mpackint n, dd_real * t, mpackint ldt, dd_real * q, mpackint ldq, mpackint j1, mpackint n1, mpackint n2, dd_real * work, mpackint *info );
void Rlag2 ( dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real safmin, dd_real * scale1, dd_real * scale2, dd_real * wr1, dd_real * wr2, dd_real * wi );
void Rlags2 ( mpackint upper, dd_real a1, dd_real a2, dd_real a3, dd_real b1, dd_real b2, dd_real b3, dd_real * csu, dd_real * snu, dd_real * csv, dd_real * snv, dd_real * csq, dd_real * snq );
void Clags2 ( mpacklogical * upper, dd_real a1, dd_complex a2, dd_real a3, dd_real b1, dd_complex b2, dd_real b3, dd_real * csu, dd_complex * snu, dd_real * csv, dd_complex * snv, dd_real * csq, dd_complex * snq );
void Rlagtf ( mpackint n, dd_real * a, dd_real lambda, dd_real * b, dd_real * c, dd_real * tol, dd_real * d, mpackint *in, mpackint *info );
void Rlagtm ( const char *trans, mpackint n, mpackint nrhs, dd_real alpha, dd_real * dl, dd_real * d, dd_real * du, dd_real * x, mpackint ldx, dd_real * beta, dd_real * B, mpackint ldb );
void Clagtm ( const char *trans, mpackint n, mpackint nrhs, dd_real alpha, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * x, mpackint ldx, dd_real beta, dd_complex * B, mpackint ldb );
void Rlagts ( mpackint job, mpackint n, dd_real * a, dd_real * b, dd_real * c, dd_real * d, mpackint *in, dd_real * y, dd_real * tol, mpackint *info );
void Rlagv2 ( dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * csl, dd_real * snl, dd_real * csr, dd_real * snr );
void Rlahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, dd_real * h, mpackint ldh, dd_real * wr, dd_real * wi, mpackint iloz, mpackint ihiz, dd_real * z, mpackint ldz, mpackint *info );
void Clahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, dd_complex * h, mpackint ldh, dd_complex * w, mpackint iloz, mpackint ihiz, dd_complex * z, mpackint ldz, mpackint *info );
void Rlahr2 ( mpackint n, mpackint k, mpackint nb, dd_real * A, mpackint lda, dd_real * tau, dd_real * t, mpackint ldt, dd_real * y, mpackint ldy );
void Clahr2 ( mpackint n, mpackint k, mpackint nb, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * t, mpackint ldt, dd_complex * y, mpackint ldy );
void Rlahrd ( mpackint n, mpackint k, mpackint nb, dd_real * A, mpackint lda, dd_real * tau, dd_real * t, mpackint ldt, dd_real * y, mpackint ldy );
void Clahrd ( mpackint n, mpackint k, mpackint nb, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * t, mpackint ldt, dd_complex * y, mpackint ldy );
void Rlaic1 ( mpackint job, mpackint j, dd_real * x, dd_real sest, dd_real * w, dd_real gamma, dd_real * sestpr, dd_real * s, dd_real * c );
void Claic1 ( mpackint job, mpackint j, dd_complex * x, dd_real sest, dd_complex * w, dd_complex gamma, dd_real * sestpr, dd_complex * s, dd_complex * c );
void Rlaln2 ( mpackint ltrans, mpackint na, mpackint nw, dd_real smin, dd_real ca, dd_real * A, mpackint lda, dd_real d1, dd_real d2, dd_real * B, mpackint ldb, dd_real wr, dd_real wi, dd_real * x, mpackint ldx, dd_real * scale, dd_real * xnorm, mpackint *info );
void Rlals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, dd_real * B, mpackint ldb, dd_real * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, dd_real * givnum, mpackint ldgnum, dd_real * poles, dd_real * difl, dd_real * difr, dd_real * z, mpackint k, dd_real c, dd_real s, dd_real * work, mpackint *info );
void Clals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, dd_complex * B, mpackint ldb, dd_complex * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, dd_real * givnum, mpackint ldgnum, dd_real * poles, dd_real * difl, dd_real * difr, dd_real * z, mpackint k, dd_real c, dd_real s, dd_real * rwork, mpackint *info );
void Rlalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, dd_real * B, mpackint ldb, dd_real * bx, mpackint ldbx, dd_real * u, mpackint ldu, dd_real * vt, mpackint *k, dd_real * difl, dd_real * difr, dd_real * z, dd_real * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, dd_real * givnum, dd_real * c, dd_real * s, dd_real * work, mpackint *iwork, mpackint *info );
void Clalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, dd_complex * B, mpackint ldb, dd_complex * bx, mpackint ldbx, dd_real * u, mpackint ldu, dd_real * vt, mpackint *k, dd_real * difl, dd_real * difr, dd_real * z, dd_real * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, dd_real * givnum, dd_real * c, dd_real * s, dd_real * rwork, mpackint *iwork, mpackint *info );
void Rlalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, dd_real * d, dd_real * e, dd_real * B, mpackint ldb, dd_real rcond, mpackint *rank, dd_real * work, mpackint *iwork, mpackint *info );
void Clalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, dd_real * d, dd_real * e, dd_complex * B, mpackint ldb, dd_real rcond, mpackint *rank, dd_complex * work, dd_real * rwork, mpackint *iwork, mpackint *info );
void Rlamrg ( mpackint n1, mpackint n2, dd_real * a, mpackint dtrd1, mpackint dtrd2, mpackint *index );
dd_real Rlangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, dd_real * ab, mpackint ldab, dd_real * work );
dd_real Clangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, dd_complex * AB, mpackint ldab, dd_real * work );
dd_real Rlange ( const char *norm, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * work );
dd_real Clange ( const char *norm, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * work );
dd_real Rlangt ( const char *norm, mpackint n, dd_real * dl, dd_real * d, dd_real * du );
dd_real Clangt ( const char *norm, mpackint n, dd_complex * dl, dd_complex * d, dd_complex * du );
dd_real Rlanhs ( const char *norm, mpackint n, dd_real * A, mpackint lda, dd_real * work );
dd_real Clanhs ( const char *norm, mpackint n, dd_complex * A, mpackint lda, dd_real * work );
dd_real Rlansb ( const char *norm, const char *uplo, mpackint n, mpackint k, dd_real * AB, mpackint ldab, dd_real * work );
dd_real Clansb ( const char *norm, const char *uplo, mpackint n, mpackint k, dd_complex * AB, mpackint ldab, dd_real * work );
dd_real Clanhb ( const char *norm, const char *uplo, mpackint n, mpackint k, dd_complex * AB, mpackint ldab, dd_real * work );
dd_real Rlansp ( const char *norm, const char *uplo, mpackint n, dd_real * ap, dd_real * work );
dd_real Clansp ( const char *norm, const char *uplo, mpackint n, dd_complex * ap, dd_real * work );
dd_real Clanhp ( const char *norm, const char *uplo, mpackint n, dd_complex * ap, dd_real * work );
dd_real Rlantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, dd_real * AB, mpackint ldab, dd_real * work );
dd_complex Clantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, dd_complex * AB, mpackint ldab, dd_real * work );
dd_real Rlantp ( const char *norm, const char *uplo, const char *diag, mpackint n, dd_real * ap, dd_real * work );
dd_complex Clantp ( const char *norm, const char *uplo, const char *diag, mpackint n, dd_complex * ap, dd_real * work );
dd_real Rlantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * work );
dd_real Clantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * work );
void Rlanv2 ( dd_real * a, dd_real * b, dd_real * c, dd_real * d, dd_real * rt1r, dd_real * rt1i, dd_real * rt2r, dd_real * rt2i, dd_real * cs, dd_real * sn );
void Rlapll ( mpackint n, dd_real * x, mpackint incx, dd_real * y, mpackint incy, dd_real * ssmin );
void Clapll ( mpackint n, dd_complex * x, mpackint incx, dd_complex * y, mpackint incy, dd_real * ssmin );
void Rlapmt ( mpackint *forwrd, mpackint m, mpackint n, dd_real * X, mpackint ldx, mpackint *k );
void Clapmt ( mpackint *forwrd, mpackint m, mpackint n, dd_complex * X, mpackint ldx, mpackint *k );
void Rlaqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_real * AB, mpackint ldab, dd_real * r, dd_real * c, dd_real rowcnd, dd_real colcnd, dd_real amax, char *equed );
void Claqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_complex * AB, mpackint ldab, dd_real * r, dd_real * c, dd_real rowcnd, dd_real colcnd, dd_real amax, char *equed );
void Rlaqge ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * r, dd_real * c, dd_real rowcnd, dd_real colcnd, dd_real amax, char *equed );
void Claqge ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * r, dd_real * c, dd_real rowcnd, dd_real colcnd, dd_real amax, char *equed );
void Rlaqp2 ( mpackint m, mpackint n, mpackint offset, dd_real * A, mpackint lda, mpackint *jpvt, dd_real * tau, dd_real * vn1, dd_real * vn2, dd_real * work );
void Claqp2 ( mpackint m, mpackint n, mpackint offset, dd_complex * A, mpackint lda, mpackint *jpvt, dd_complex * tau, dd_real * vn1, dd_real * vn2, dd_complex * work );
void Rlaqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, dd_real * A, mpackint lda, mpackint *jpvt, dd_real * tau, dd_real * vn1, dd_real * vn2, dd_real * auxv, dd_real * f, mpackint ldf );
void Claqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, dd_complex * A, mpackint lda, mpackint *jpvt, dd_complex * tau, dd_real * vn1, dd_real * vn2, dd_complex * auxv, dd_complex * f, mpackint ldf );
void Rlaqsb ( const char *uplo, mpackint n, mpackint kd, dd_real * ab, mpackint ldab, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Claqsb ( const char *uplo, mpackint n, mpackint kd, dd_complex * ab, mpackint ldab, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Claqhb ( const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Rlaqsp ( const char *uplo, mpackint n, dd_real * ap, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Claqsp ( const char *uplo, mpackint n, dd_complex * ap, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Claqhp ( const char *uplo, mpackint n, dd_complex * ap, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Rlaqsy ( const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Claqsy ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Claqhe ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * s, dd_real scond, dd_real amax, char *equed );
void Rlaqtr ( mpackint ltran, mpackint lreal, mpackint n, dd_real * t, mpackint ldt, dd_real * B, dd_real w, dd_real * scale, dd_real * x, dd_real * work, mpackint *info );
void Rlar1v ( mpackint n, mpackint b1, mpackint bn, dd_real lambda, dd_real * d, dd_real * l, dd_real * ld, dd_real * lld, dd_real pivmin, dd_real gaptol, dd_real * z, mpackint wantnc, mpackint *negcnt, dd_real * ztz, dd_real * mingma, mpackint *r, mpackint *isuppz, dd_real * nrminv, dd_real * resid, dd_real * rqcorr, dd_real * work );
void Clar1v ( mpackint n, mpackint b1, mpackint bn, dd_real lambda, dd_real * d, dd_real * l, dd_real * ld, dd_real * lld, dd_real pivmin, dd_real gaptol, dd_complex * z, mpackint wantnc, mpackint *negcnt, dd_real * ztz, dd_real * mingma, mpackint *r, mpackint *isuppz, dd_real * nrminv, dd_real * resid, dd_real * rqcorr, dd_real * work );
void Rlar2v ( mpackint n, dd_real * x, dd_real * y, dd_real * z, mpackint incx, dd_real * c, dd_real * s, mpackint incc );
void Clar2v ( mpackint n, dd_complex * x, dd_complex * y, dd_complex * z, mpackint incx, dd_real * c, dd_complex * s, mpackint incc );
void Rlarfx ( const char *side, mpackint m, mpackint n, dd_real * v, dd_real tau, dd_real * c, mpackint ldc, dd_real * work );
void Clarfx ( const char *side, mpackint m, mpackint n, dd_complex * v, dd_complex tau, dd_complex * c, mpackint ldc, dd_complex * work );
void Rlargv ( mpackint n, dd_real * x, mpackint incx, dd_real * y, mpackint incy, dd_real * c, mpackint incc );
void Clargv ( mpackint n, dd_complex * x, mpackint incx, dd_complex * y, mpackint incy, dd_real * c, mpackint incc );
void Rlarnv ( mpackint idist, mpackint *iseed, mpackint n, dd_real * x );
void Clarnv ( mpackint idist, mpackint *iseed, mpackint n, dd_complex * x );
mpackint Rlaneg ( mpackint n, dd_real * d, dd_real * lld, dd_real sigma, dd_real pivmin, mpackint r );
void Rlarra ( mpackint n, dd_real * d, dd_real * e, dd_real * e2, dd_real spltol, dd_real tnrm, mpackint *nsplit, mpackint *isplit, mpackint *info );
void Rlarrb ( mpackint n, dd_real * d, dd_real * lld, mpackint ifirst, mpackint ilast, dd_real rtol1, dd_real rtol2, mpackint offset, dd_real * w, dd_real * wgap, dd_real * werr, dd_real * work, mpackint *iwork, dd_real pivmin, dd_real spdiam, mpackint twist, mpackint *info );
void Rlarrc ( const char *jobt, mpackint n, dd_real vl, dd_real vu, dd_real * d, dd_real * e, dd_real pivmin, mpackint *eigcnt, mpackint *lcnt, mpackint *rcnt, mpackint *info );
void Rlarrd ( const char *range, const char *order, mpackint n, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real *gers, dd_real reltol, dd_real * d, dd_real * e, dd_real * e2, dd_real pivmin, mpackint nsplit, mpackint *isplit, mpackint *m, dd_real * w, dd_real * werr, dd_real * wl, dd_real * wu, mpackint *iblock, mpackint *indexw, dd_real * work, mpackint *iwork, mpackint *info );
void Rlarre ( const char *range, mpackint n, dd_real * vl, dd_real * vu, mpackint il, mpackint iu, dd_real * d, dd_real * e, dd_real * e2, dd_real rtol1, dd_real rtol2, dd_real spltol, mpackint * nsplit, mpackint *isplit, mpackint * m, dd_real * w, dd_real * werr, dd_real * wgap, mpackint *iblock, mpackint *indexw, dd_real * gers, dd_real * pivmin, dd_real * work, mpackint *iwork, mpackint *info );
void Rlarrf ( mpackint n, dd_real * d, dd_real * l, dd_real * ld, mpackint clstrt, mpackint clend, dd_real * w, dd_real * wgap, dd_real * werr, dd_real spdiam, dd_real clgapl, dd_real clgapr, dd_real pivmin, dd_real * sigma, dd_real * dplus, dd_real * lplus, dd_real * work, mpackint *info );
void Rlarrj ( mpackint n, dd_real * d, dd_real * e2, mpackint ifirst, mpackint ilast, dd_real rtol, mpackint offset, dd_real * w, dd_real * werr, dd_real * work, mpackint *iwork, dd_real pivmin, dd_real spdiam, mpackint *info );
void Rlarrk ( mpackint n, mpackint iw, dd_real gl, dd_real gu, dd_real * d, dd_real * e2, dd_real pivmin, dd_real reltol, dd_real * w, dd_real * werr, mpackint *info );
void Rlarrr ( mpackint n, dd_real * d, dd_real * e, mpackint *info );
void Rlartv ( mpackint n, dd_real * x, mpackint incx, dd_real * y, mpackint incy, dd_real * c, dd_real * s, mpackint incc );
void Clartv ( mpackint n, dd_complex * x, mpackint incx, dd_complex * y, mpackint incy, dd_real * c, dd_complex * s, mpackint incc );
void Rlarrv ( mpackint n, dd_real vl, dd_real vu, dd_real * d, dd_real * l, dd_real pivmin, mpackint * isplit, mpackint m, mpackint dol, mpackint dou, dd_real minrgp, dd_real rtol1, dd_real rtol2, dd_real * w, dd_real * werr, dd_real * wgap, mpackint * iblock, mpackint * indexw, dd_real * gers, dd_real * z, mpackint ldz, mpackint * isuppz, dd_real * work, mpackint * iwork, mpackint * info );
void Clarrv ( mpackint n, dd_real vl, dd_real vu, dd_real * d, dd_real * l, dd_real pivmin, mpackint *isplit, mpackint m, mpackint dol, mpackint dou, dd_real minrgp, dd_real rtol1, dd_real rtol2, dd_real * w, dd_real * werr, dd_real * wgap, mpackint *iblock, mpackint *indexw, dd_real * gers, dd_complex * z, mpackint ldz, mpackint *isuppz, dd_real * work, mpackint *iwork, mpackint *info );
void Rlaruv ( mpackint *iseed, mpackint n, dd_real * x );
void Rlarz ( const char *side, mpackint m, mpackint n, mpackint l, dd_real * v, mpackint incv, dd_real tau, dd_real * C, mpackint ldc, dd_real * work );
void Clarz ( const char *side, mpackint m, mpackint n, mpackint l, dd_complex * v, mpackint incv, dd_complex tau, dd_complex * c, mpackint ldc, dd_complex * work );
void Rlarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, dd_real * v, mpackint ldv, dd_real * t, mpackint ldt, dd_real * c, mpackint ldc, dd_real * work, mpackint ldwork );
void Clarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, dd_complex * v, mpackint ldv, dd_complex * t, mpackint ldt, dd_complex * c, mpackint ldc, dd_complex * work, mpackint ldwork );
void Rlarzt ( const char *direct, const char *storev, mpackint n, mpackint k, dd_real * v, mpackint ldv, dd_real * tau, dd_real * t, mpackint ldt );
void Clarzt ( const char *direct, const char *storev, mpackint n, mpackint k, dd_complex * v, mpackint ldv, dd_complex * tau, dd_complex * t, mpackint ldt );
void Rlas2 ( dd_real f, dd_real g, dd_real h, dd_real * ssmin, dd_real * ssmax );
void Rlasd0 ( mpackint n, mpackint sqre, dd_real * d, dd_real * e, dd_real * u, mpackint ldu, dd_real * vt, mpackint ldvt, mpackint smlsiz, mpackint *iwork, dd_real * work, mpackint *info );
void Rlasd1 ( mpackint nl, mpackint nr, mpackint *sqre, dd_real * d, dd_real * alpha, dd_real * beta, dd_real * u, mpackint ldu, dd_real * vt, mpackint ldvt, mpackint *idxq, mpackint *iwork, dd_real * work, mpackint *info );
void Rlasd2 ( mpackint nl, mpackint nr, mpackint sqre, mpackint *k, dd_real * d, dd_real * z, dd_real alpha, dd_real beta, dd_real * u, mpackint ldu, dd_real * vt, mpackint ldvt, dd_real * dsigma, dd_real * u2, mpackint ldu2, dd_real * vt2, mpackint ldvt2, mpackint *idxp, mpackint *idx, mpackint *idxc, mpackint *idxq, mpackint *coltyp, mpackint *info );
void Rlasd3 ( mpackint nl, mpackint nr, mpackint sqre, mpackint k, dd_real * d, dd_real * q, mpackint ldq, dd_real * dsigma, dd_real * u, mpackint ldu, dd_real * u2, mpackint ldu2, dd_real * vt, mpackint ldvt, dd_real * vt2, mpackint ldvt2, mpackint *idxc, mpackint *ctot, dd_real * z, mpackint *info );
void Rlasd4 ( mpackint n, mpackint i, dd_real * d, dd_real * z, dd_real * delta, dd_real rho, dd_real * sigma, dd_real * work, mpackint *info );
void Rlasd5 ( mpackint i, dd_real * d, dd_real * z, dd_real * delta, dd_real rho, dd_real * dsigma, dd_real * work );
void Rlasd6 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, dd_real * d, dd_real * vf, dd_real * vl, dd_real * alpha, dd_real * beta, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, dd_real * givnum, mpackint ldgnum, dd_real * poles, dd_real * difl, dd_real * difr, dd_real * z, mpackint k, dd_real * c, dd_real * s, dd_real * work, mpackint *iwork, mpackint *info );
void Rlasd7 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint k, dd_real * d, dd_real * z, dd_real * zw, dd_real * vf, dd_real * vfw, dd_real * vl, dd_real * vlw, dd_real alpha, dd_real beta, dd_real * dsigma, mpackint *idx, mpackint *idxp, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, dd_real * givnum, mpackint ldgnum, dd_real * c, dd_real * s, mpackint *info );
void Rlasd8 ( mpackint icompq, mpackint k, dd_real * d, dd_real * z, dd_real * vf, dd_real * vl, dd_real * difl, dd_real * difr, mpackint lddifr, dd_real * dsigma, dd_real * work, mpackint *info );
void Rlasda ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint sqre, dd_real * d, dd_real * e, dd_real * u, mpackint ldu, dd_real * vt, mpackint *k, dd_real * difl, dd_real * difr, dd_real * z, dd_real * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, dd_real * givnum, dd_real * c, dd_real * s, dd_real * work, mpackint *iwork, mpackint *info );
void Rlasdq ( const char *uplo, mpackint sqre, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, dd_real * d, dd_real * e, dd_real * vt, mpackint ldvt, dd_real * u, mpackint ldu, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Rlasdt ( mpackint n, mpackint lvl, mpackint nd, mpackint *inode, mpackint *ndiml, mpackint *ndimr, mpackint msub );
void Rlasq1 ( mpackint n, dd_real * d, dd_real * e, dd_real * work, mpackint *info );
void Rlasq2 ( mpackint n, dd_real * z, mpackint *info );
void Rlasq3 ( mpackint i0, mpackint n0, dd_real * z, mpackint pp, dd_real * dmin, dd_real * sigma, dd_real * desig, dd_real qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint ieee );
void Rlasq4 ( mpackint i0, mpackint n0, dd_real * z, mpackint pp, mpackint n0in, dd_real dmin, dd_real dmin1, dd_real dmin2, dd_real dn, dd_real dn1, dd_real dn2, dd_real * tau, mpackint *ttype );
void Rlasq5 ( mpackint i0, mpackint n0, dd_real * z, mpackint pp, dd_real tau, dd_real * dmin, dd_real * dmin1, dd_real * dmin2, dd_real * dn, dd_real * dnm1, dd_real * dnm2, mpackint ieee );
void Rlasq6 ( mpackint i0, mpackint n0, dd_real * z, mpackint pp, dd_real * dmin, dd_real * dmin1, dd_real * dmin2, dd_real * dn, dd_real * dnm1, dd_real * dnm2 );
void Rlasv2 ( dd_real f, dd_real g, dd_real h, dd_real * ssmin, dd_real * ssmax, dd_real * snr, dd_real * csr, dd_real * snl, dd_real * csl );
void Rlasy2 ( mpackint ltranl, mpackint ltranr, mpackint isgn, mpackint n1, mpackint n2, dd_real * tl, mpackint ldtl, dd_real * tr, mpackint ldtr, dd_real * B, mpackint ldb, dd_real * scale, dd_real * x, mpackint ldx, dd_real * xnorm, mpackint *info );
void Rlatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, dd_real * x, dd_real * scale, dd_real * cnorm, mpackint *info );
void Clatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_complex * x, dd_real * scale, dd_real * cnorm, mpackint *info );
void Rlatdf ( mpackint ijob, mpackint n, dd_real * z, mpackint ldz, dd_real * rhs, dd_real * rdsum, dd_real * rdscal, mpackint *ipiv, mpackint *jpiv );
void Clatdf ( mpackint ijob, mpackint n, dd_complex * z, mpackint ldz, dd_complex * rhs, dd_real * rdsum, dd_real * rdscal, mpackint *ipiv, mpackint *jpiv );
void Rlatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, dd_real * ap, dd_real * x, dd_real * scale, dd_real * cnorm, mpackint *info );
void Clatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, dd_complex * ap, dd_complex * x, dd_real * scale, dd_real * cnorm, mpackint *info );
void Rlauu2 ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Clauu2 ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rlauum ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Clauum ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rlatrz ( mpackint m, mpackint n, mpackint l, dd_real * A, mpackint lda, dd_real * tau, dd_real * work );
void Clatrz ( mpackint m, mpackint n, mpackint l, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work );
void Rorgl2 ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cungl2 ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rorgr2 ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint *info );
void Cungr2 ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint *info );
void Rorm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Cunm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint *info );
void Rorm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Cunm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint *info );
void Rorml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Cunml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint *info );
void Rormr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * C, mpackint ldc, dd_real * work, mpackint *info );
void Cunmr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint *info );
void Rormr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Cunmr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint *info );
void Rpbtf2 ( const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, mpackint *info );
void Cpbtf2 ( const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, mpackint *info );
void Rptts2 ( mpackint n, mpackint nrhs, dd_real * d, dd_real * e, dd_real * b, mpackint ldb );
void Cptts2 ( mpackint iuplo, mpackint n, mpackint nrhs, dd_real * d, dd_complex * e, dd_complex * B, mpackint ldb );
void Rrscl ( mpackint n, dd_real sa, dd_real * sx, mpackint incx );
void CRrscl ( mpackint n, dd_real sa, dd_complex * sx, mpackint incx );
void Rsygs2 ( mpackint itype, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *info );
void Chegs2 ( mpackint itype, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint *info );
void Rsytf2 ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Csytf2 ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Chetf2 ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rtgex2 ( mpackint wantq, mpackint wantz, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * q, mpackint ldq, dd_real * z, mpackint ldz, mpackint j1, mpackint n1, mpackint n2, dd_real * work, mpackint lwork, mpackint *info );
void Ctgex2 ( mpackint wantq, mpackint wantz, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * q, mpackint ldq, dd_complex * z, mpackint ldz, mpackint j1, mpackint *info );
void Rtgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * c, mpackint ldc, dd_real * d, mpackint ldd, dd_real * e, mpackint lde, dd_real * f, mpackint ldf, dd_real * scale, dd_real * rdsum, dd_real * rdscal, mpackint *iwork, mpackint *pq, mpackint *info );
void Ctgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * C, mpackint ldc, dd_complex * d, mpackint ldd, dd_complex * e, mpackint lde, dd_complex * f, mpackint ldf, dd_real * scale, dd_real * rdsum, dd_real * rdscal, mpackint *info );
void Rlazq3 ( mpackint i0, mpackint n0, dd_real * z, mpackint pp, dd_real * dmin, dd_real * sigma, dd_real * desig, dd_real qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint *ieee, mpackint *ttype, dd_real * dmin1, dd_real * dmin2, dd_real * dn, dd_real * dn1, dd_real * dn2, dd_real * tau );
void Rlazq4 ( mpackint i0, mpackint n0, dd_real * z, mpackint pp, mpackint n0in, dd_real dmin, dd_real dmin1, dd_real dmin2, dd_real dn, dd_real dn1, dd_real dn2, dd_real * tau, mpackint *ttype, dd_real * g );
void Rlaqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, dd_real * h, mpackint ldh, dd_real * wr, dd_real * wi, mpackint iloz, mpackint ihiz, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *info );
void Claqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, dd_complex * h, mpackint ldh, dd_complex * w, mpackint *iloz, mpackint *ihiz, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, mpackint *info );
void Rlaqr1 ( mpackint n, dd_real * h, mpackint ldh, dd_real sr1, dd_real si1, dd_real sr2, dd_real si2, dd_real * v );
void Claqr1 ( mpackint n, dd_complex * h, mpackint ldh, dd_complex s1, dd_complex s2, dd_complex * v );
void Rlaqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, dd_real * h, mpackint ldh, mpackint iloz, mpackint ihiz, dd_real * z, mpackint ldz, mpackint *ns, mpackint *nd, dd_real * sr, dd_real * si, dd_real * v, mpackint ldv, mpackint nh, dd_real * t, mpackint ldt, mpackint nv, dd_real * wv, mpackint ldwv, dd_real * work, mpackint lwork );
void Claqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, dd_complex * h, mpackint ldh, mpackint iloz, mpackint ihiz, dd_complex * z, mpackint ldz, mpackint *ns, mpackint *nd, dd_complex * sh, dd_complex * v, mpackint ldv, mpackint nh, dd_complex * t, mpackint ldt, mpackint nv, dd_complex * wv, mpackint ldwv, dd_complex * work, mpackint lwork );
void Rlaqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, dd_real * h, mpackint ldh, mpackint iloz, mpackint ihiz, dd_real * z, mpackint ldz, mpackint ns, mpackint nd, dd_real * sr, dd_real * si, dd_real * v, mpackint ldv, mpackint nh, dd_real * t, mpackint ldt, mpackint nv, dd_real * wv, mpackint ldwv, dd_real * work, mpackint lwork );
void Claqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, dd_complex * h, mpackint ldh, mpackint iloz, mpackint ihiz, dd_complex * z, mpackint ldz, mpackint *ns, mpackint *nd, dd_complex * sh, dd_complex * v, mpackint ldv, mpackint nh, dd_complex * t, mpackint ldt, mpackint nv, dd_complex * wv, mpackint ldwv, dd_complex * work, mpackint lwork );
void Rlaqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, dd_real * h, mpackint ldh, dd_real * wr, dd_real * wi, mpackint iloz, mpackint ihiz, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *info );
void Claqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, dd_complex * h, mpackint ldh, dd_complex * w, mpackint iloz, mpackint ihiz, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, mpackint *info );
void Rlaqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kac22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, dd_real * sr, dd_real * si, dd_real * h, mpackint ldh, mpackint iloz, mpackint ihiz, dd_real * z, mpackint ldz, dd_real * v, mpackint ldv, dd_real * u, mpackint ldu, mpackint nv, dd_real * wv, mpackint ldwv, mpackint nh, dd_real * wh, mpackint ldwh );
void Claqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kacc22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, dd_complex * s, dd_complex * h, mpackint ldh, mpackint iloz, mpackint ihiz, dd_complex * z, mpackint ldz, dd_complex * v, mpackint ldv, dd_complex * u, mpackint ldu, mpackint nv, dd_complex * wv, mpackint ldwv, mpackint nh, dd_complex * wh, mpackint ldwh );
void Rlatzm ( const char *side, mpackint m, mpackint n, dd_real * v, mpackint incv, dd_real * tau, dd_real *c1, dd_real * c2, mpackint ldc, dd_real * work );
void Clatzm ( const char *side, mpackint m, mpackint n, dd_complex * v, mpackint incv, dd_complex * tau, dd_complex * c1, dd_complex * c2, mpackint ldc, dd_complex * work );
void Clacp2 ( const char *uplo, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_complex * B, mpackint ldb );
mpackint Risnan ( dd_real din );

/* not yet done ... driver and computational routines */
void Rbdsdc ( const char *uplo, const char *compq, mpackint n, dd_real * d, dd_real * e, dd_real * u, mpackint ldu, dd_real * vt, mpackint ldvt, dd_real * q, mpackint * iq, dd_real * work, mpackint * iwork, mpackint * info );
void Rbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, dd_real * d, dd_real * e, dd_real * vt, mpackint ldvt, dd_real * u, mpackint ldu, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Cbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, dd_real * d, dd_real * e, dd_complex * vt, mpackint ldvt, dd_complex * u, mpackint ldu, dd_complex * c, mpackint ldc, dd_real * rwork, mpackint * info );
void Rdisna ( const char *job, mpackint m, mpackint n, dd_real * d, dd_real * sep, mpackint *info );
void Rgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, dd_real * AB, mpackint ldab, dd_real * d, dd_real * e, dd_real * q, mpackint ldq, dd_real * pt, mpackint ldpt, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Cgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, dd_complex * AB, mpackint ldab, dd_real * d, dd_real * e, dd_complex * q, mpackint ldq, dd_complex * pt, mpackint ldpt, dd_complex * c, mpackint ldc, dd_complex * work, dd_real * rwork, mpackint * info );
void Rgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, dd_real * AB, mpackint ldab, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Cgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, dd_complex * AB, mpackint ldab, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_real * AB, mpackint ldab, dd_real * r, dd_real * c, dd_real * rowcnd, dd_real * colcnd, dd_real * amax, mpackint *info );
void Cgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_complex * AB, mpackint ldab, dd_real * r, dd_real * c, dd_real * rowcnd, dd_real * colcnd, dd_real * amax, mpackint *info );
void Rgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_real * AB, mpackint ldab, dd_real * afb, mpackint ldafb, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_complex * AB, mpackint ldab, dd_complex * afb, mpackint ldafb, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_real * AB, mpackint ldab, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Cgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_complex * ab, mpackint ldab, mpackint *ipiv, dd_complex * b, mpackint ldb, mpackint *info );
void Rgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_real * AB, mpackint ldab, dd_real * afb, mpackint ldafb, mpackint * ipiv, char *equed, dd_real * r, dd_real * c, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint * iwork, mpackint * info );
void Cgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_complex * AB, mpackint ldab, dd_complex * afb, mpackint ldafb, mpackint * ipiv, char *equed, dd_real * r, dd_real * c, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint * info );
void Rgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_real * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, dd_complex * ab, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_real * AB, mpackint ldab, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Cgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, dd_complex * AB, mpackint ldab, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Rgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, dd_real * scale, mpackint m, dd_real * v, mpackint ldv, mpackint *info );
void Cgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, dd_real * scale, mpackint m, dd_complex * v, mpackint ldv, mpackint *info );
void Rgebal ( const char *job, mpackint n, dd_real * A, mpackint lda, mpackint *ilo, mpackint *ihi, dd_real * scale, mpackint *info );
void Cgebal ( const char *job, mpackint n, dd_complex * A, mpackint lda, mpackint *ilo, mpackint *ihi, dd_real * scale, mpackint *info );
void Rgebrd ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * d, dd_real * e, dd_real * tauq, dd_real * taup, dd_real * work, mpackint lwork, mpackint *info );
void Cgebrd ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * d, dd_real * e, dd_complex * tauq, dd_complex * taup, dd_complex * work, mpackint lwork, mpackint *info );
void Rgecon ( const char *norm, mpackint n, dd_real * A, mpackint lda, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Cgecon ( const char *norm, mpackint n, dd_complex * A, mpackint lda, dd_real anorm, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgeequ ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * r, dd_real * c, dd_real * rowcnd, dd_real * colcnd, dd_real * amax, mpackint *info );
void Cgeequ ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * r, dd_real * c, dd_real * rowcnd, dd_real * colcnd, dd_real * amax, mpackint *info );
void Rgees ( const char *jobvs, const char *sort, LFP select, mpackint n, dd_real * A, mpackint lda, mpackint *sdim, dd_real * wr, dd_real * wi, dd_real * vs, mpackint ldvs, dd_real * work, mpackint lwork, mpacklogical * bwork, mpackint *info );
void Cgees ( const char *jobvs, const char *sort, LFP select, mpackint n, dd_complex * A, mpackint lda, mpackint *sdim, dd_complex * w, dd_complex * vs, mpackint ldvs, dd_complex * work, mpackint lwork, dd_real * rwork, mpacklogical * bwork, mpackint *info );
void Rgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, dd_real * A, mpackint lda, mpackint * sdim, dd_real * wr, dd_real * wi, dd_real * vs, mpackint ldvs, dd_real * rconde, dd_real * rcondv, dd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, dd_complex * A, mpackint lda, mpackint *sdim, dd_complex * w, dd_complex * vs, mpackint ldvs, dd_real * rconde, dd_real * rcondv, dd_complex * work, mpackint lwork, dd_real * rwork, mpacklogical * bwork, mpackint *info );
void Rgeev ( const char *jobvl, const char *jobvr, mpackint n, dd_real * A, mpackint lda, dd_real * wr, dd_real * wi, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, dd_real * work, mpackint lwork, mpackint *info );
void Cgeev ( const char *jobvl, const char *jobvr, mpackint n, dd_complex * A, mpackint lda, dd_complex * w, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Rgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, dd_real * A, mpackint lda, dd_real * wr, dd_real * wi, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, dd_real * scale, dd_real * abnrm, dd_real * rconde, dd_real * rcondv, dd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, dd_complex * A, mpackint lda, dd_complex * w, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, dd_real * scale, dd_real * abnrm, dd_real * rconde, dd_real * rcondv, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Cgehrd ( mpackint n, mpackint ilo, mpackint ihi, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rgehrd ( mpackint n, mpackint ilo, mpackint ihi, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Rgelqf ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cgelqf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * work, mpackint lwork, mpackint *info );
void Cgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * work, mpackint lwork, mpackint *info );
void Rgelsx ( mpackint m, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *jpvt, dd_real rcond, mpackint *rank, dd_real * work, mpackint *info );
void Cgelsx ( mpackint m, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint *jpvt, dd_real rcond, mpackint *rank, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgelsd ( mpackint m, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * s, dd_real * rcond, mpackint *rank, dd_real * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Cgelsd ( mpackint m, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real * s, dd_real rcond, mpackint * rank, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * iwork, mpackint * info );
void Rgelss ( mpackint m, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * s, dd_real rcond, mpackint * rank, dd_real * work, mpackint lwork, mpackint * info );
void Cgelss ( mpackint m, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real * s, dd_real rcond, mpackint * rank, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Rgelsy ( mpackint m, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *jpvt, dd_real rcond, mpackint *rank, dd_real * work, mpackint lwork, mpackint *info );
void Cgelsy ( mpackint m, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint * jpvt, dd_real rcond, mpackint * rank, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Rgeqlf ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cgeqlf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rgeqpf ( mpackint m, mpackint n, dd_real * A, mpackint lda, mpackint *jpvt, dd_real * tau, dd_real * work, mpackint *info );
void Cgeqpf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, mpackint *jpvt, dd_complex * tau, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgeqp3 ( mpackint m, mpackint n, dd_real * A, mpackint lda, mpackint *jpvt, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cgeqp3 ( mpackint m, mpackint n, dd_complex * A, mpackint lda, mpackint *jpvt, dd_complex * tau, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *info );
void Rgeqrf ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cgeqrf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rgerfs ( const char *trans, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * af, mpackint ldaf, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cgerfs ( const char *trans, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgerqf ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cgerqf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rgesdd ( const char *jobz, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * s, dd_real * u, mpackint ldu, dd_real * vt, mpackint ldvt, dd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgesdd ( const char *jobz, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * s, dd_complex * u, mpackint ldu, dd_complex * vt, mpackint ldvt, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * iwork, mpackint * info );
void Rgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * s, dd_real * u, mpackint ldu, dd_real * vt, mpackint ldvt, dd_real * work, mpackint lwork, mpackint * info );
void Cgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_real * s, dd_complex * u, mpackint ldu, dd_complex * vt, mpackint ldvt, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Rgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * af, mpackint ldaf, mpackint * ipiv, char *equed, dd_real * r, dd_real * c, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint * iwork, mpackint * info );
void Cgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, mpackint * ipiv, char *equed, dd_real * r, dd_real * c, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint * info );
void Rggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, dd_real * lscale, dd_real * rscale, mpackint m, dd_real * v, mpackint ldv, mpackint *info );
void Cggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, dd_real * lscale, dd_real * rscale, mpackint m, dd_complex * v, mpackint ldv, mpackint *info );
void Rggbal ( const char *job, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *ilo, mpackint *ihi, dd_real * lscale, dd_real * rscale, dd_real * work, mpackint *info );
void Cggbal ( const char *job, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint *ilo, mpackint *ihi, dd_real * lscale, dd_real * rscale, dd_real * work, mpackint *info );
void Rgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint * sdim, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * vsl, mpackint ldvsl, dd_real * vsr, mpackint ldvsr, dd_real * work, mpackint lwork, mpacklogical * bwork, mpackint * info );
void Cgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint * sdim, dd_complex * alpha, dd_complex * beta, dd_complex * vsl, mpackint ldvsl, dd_complex * vsr, mpackint ldvsr, dd_complex * work, mpackint lwork, dd_real * rwork, mpacklogical * bwork, mpackint * info );
void Rgegs ( const char *jobvsl, const char *jobvsr, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * vsl, mpackint ldvsl, dd_real * vsr, mpackint ldvsr, dd_real * work, mpackint lwork, mpackint *info );
void Cgegs ( const char *jobvsl, const char *jobvsr, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * alpha, dd_complex * beta, dd_complex * vsl, mpackint ldvsl, dd_complex * vsr, mpackint ldvsr, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Rggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint * sdim, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * vsl, mpackint ldvsl, dd_real * vsr, mpackint ldvsr, dd_real * rconde, dd_real * rcondv, dd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint * sdim, dd_complex * alpha, dd_complex * beta, dd_complex * vsl, mpackint ldvsl, dd_complex * vsr, mpackint ldvsr, dd_real * rconde, dd_real * rcondv, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Rggev ( const char *jobvl, const char *jobvr, mpackint n, dd_real * A, mpackint lda, dd_real * b, mpackint ldb, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, dd_real * work, mpackint lwork, mpackint * info );
void Cggev ( const char *jobvl, const char *jobvr, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * alpha, dd_complex * beta, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Rgegv ( const char *jobvl, const char *jobvr, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, dd_real * work, mpackint lwork, mpackint * info );
void Cgegv ( const char *jobvl, const char *jobvr, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * alpha, dd_complex * beta, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * info );
void Rggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, dd_real * lscale, dd_real * rscale, dd_real * abnrm, dd_real * bbnrm, dd_real * rconde, dd_real * rcondv, dd_real * work, mpackint lwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Cggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * alpha, dd_complex * beta, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, dd_real * lscale, dd_real * rscale, dd_real * abnrm, dd_real * bbnrm, dd_real * rconde, dd_real * rcondv, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Rggglm ( mpackint n, mpackint m, mpackint p, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * d, dd_real * x, dd_real * y, dd_real * work, mpackint lwork, mpackint *info );
void Cggglm ( mpackint n, mpackint m, mpackint p, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * d, dd_complex * x, dd_complex * y, dd_complex * work, mpackint lwork, mpackint *info );
void Rgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * q, mpackint ldq, dd_real * z, mpackint ldz, mpackint *info );
void Cgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * q, mpackint ldq, dd_complex * z, mpackint ldz, mpackint *info );
void Rgglse ( mpackint m, mpackint n, mpackint p, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * c, dd_real * d, dd_real * x, dd_real * work, mpackint lwork, mpackint *info );
void Cgglse ( mpackint m, mpackint n, mpackint p, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * c, dd_complex * d, dd_complex * x, dd_complex * work, mpackint lwork, mpackint *info );
void Rggqrf ( mpackint n, mpackint m, mpackint p, dd_real * A, mpackint lda, dd_real * taua, dd_real * B, mpackint ldb, dd_real * taub, dd_real * work, mpackint lwork, mpackint *info );
void Cggqrf ( mpackint n, mpackint m, mpackint p, dd_complex * A, mpackint lda, dd_complex * taua, dd_complex * B, mpackint ldb, dd_complex * taub, dd_complex * work, mpackint lwork, mpackint *info );
void Rggrqf ( mpackint m, mpackint p, mpackint n, dd_real * A, mpackint lda, dd_real * taua, dd_real * B, mpackint ldb, dd_real * taub, dd_real * work, mpackint lwork, mpackint *info );
void Cggrqf ( mpackint m, mpackint p, mpackint n, dd_complex * A, mpackint lda, dd_complex * taua, dd_complex * B, mpackint ldb, dd_complex * taub, dd_complex * work, mpackint lwork, mpackint *info );
void Rggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * alpha, dd_real * beta, dd_real * u, mpackint ldu, dd_real * v, mpackint ldv, dd_real * q, mpackint ldq, dd_real * work, mpackint *iwork, mpackint *info );
void Cggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real * alpha, dd_real * beta, dd_complex * u, mpackint ldu, dd_complex * v, mpackint ldv, dd_complex * q, mpackint ldq, dd_complex * work, dd_real * rwork, mpackint *iwork, mpackint *info );
void Rggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real tola, dd_real tolb, mpackint *k, mpackint *l, dd_real * u, mpackint ldu, dd_real * v, mpackint ldv, dd_real * q, mpackint ldq, mpackint *iwork, dd_real * tau, dd_real * work, mpackint *info );
void Cggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real tola, dd_real tolb, mpackint *k, mpackint *l, dd_complex * u, mpackint ldu, dd_complex * v, mpackint ldv, dd_complex * q, mpackint ldq, mpackint *iwork, dd_real * rwork, dd_complex * tau, dd_complex * work, mpackint *info );
void Rgtcon ( const char *norm, mpackint n, dd_real * dl, dd_real * d, dd_real * du, dd_real * du2, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Cgtcon ( const char *norm, mpackint n, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * du2, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_complex * work, mpackint *info );
void Rgtrfs ( const char *trans, mpackint n, mpackint nrhs, dd_real * dl, dd_real * d, dd_real * du, dd_real * dlf, dd_real * df, dd_real * duf, dd_real * du2, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cgtrfs ( const char *trans, mpackint n, mpackint nrhs, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * dlf, dd_complex * df, dd_complex * duf, dd_complex * du2, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgtsv ( mpackint n, mpackint nrhs, dd_real * dl, dd_real * d, dd_real * du, dd_real * B, mpackint ldb, mpackint *info );
void Cgtsv ( mpackint n, mpackint nrhs, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * B, mpackint ldb, mpackint *info );
void Rgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, dd_real * dl, dd_real * d, dd_real * du, dd_real * dlf, dd_real * df, dd_real * duf, dd_real * du2, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * dlf, dd_complex * df, dd_complex * duf, dd_complex * du2, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rgttrf ( mpackint n, dd_real * dl, dd_real * d, dd_real * du, dd_real * du2, mpackint *ipiv, mpackint *info );
void Cgttrf ( mpackint n, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * du2, mpackint *ipiv, mpackint *info );
void Rgttrs ( const char *trans, mpackint n, mpackint nrhs, dd_real * dl, dd_real * d, dd_real * du, dd_real * du2, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Cgttrs ( const char *trans, mpackint n, mpackint nrhs, dd_complex * dl, dd_complex * d, dd_complex * du, dd_complex * du2, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Rhgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, dd_real * h, mpackint ldh, dd_real * t, mpackint ldt, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * q, mpackint ldq, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *info );
void Chgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, dd_complex * h, mpackint ldh, dd_complex * t, mpackint ldt, dd_complex * alpha, dd_complex * beta, dd_complex * q, mpackint ldq, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *info );
void Rhsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical *select, mpackint n, dd_real * h, mpackint ldh, dd_real * wr, dd_real * wi, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, mpackint mm, mpackint m, dd_real * work, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Chsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical * select, mpackint n, dd_complex * h, mpackint ldh, dd_complex * w, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, mpackint mm, mpackint *m, dd_complex * work, dd_real * rwork, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Rhseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, dd_real * h, mpackint ldh, dd_real * wr, dd_real * wi, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *info );
void Chseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, dd_complex * h, mpackint ldh, dd_complex * w, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, mpackint *info );
void Ropgtr ( const char *uplo, mpackint n, dd_real * ap, dd_real * tau, dd_real * q, mpackint ldq, dd_real * work, mpackint *info );
void Cupgtr ( const char *uplo, mpackint n, dd_complex * ap, dd_complex * tau, dd_complex * q, mpackint ldq, dd_complex * work, mpackint *info );
void Ropmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, dd_real * ap, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint *info );
void Cupmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, dd_complex * ap, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint *info );
void Rorgbr ( const char *vect, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cungbr ( const char *vect, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rorghr ( mpackint n, mpackint ilo, mpackint ihi, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cunghr ( mpackint n, mpackint ilo, mpackint ihi, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rorglq ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cunglq ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rorgrq ( mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Cungrq ( mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rormbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rormhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rormlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rormql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rormqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rormrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rormrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rormtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * c, mpackint ldc, dd_real * work, mpackint lwork, mpackint *info );
void Cunmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * c, mpackint ldc, dd_complex * work, mpackint lwork, mpackint *info );
void Rpbcon ( const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Cpbcon ( const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_real anorm, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rpbequ ( const char *uplo, mpackint n, mpackint kd, dd_real * ab, mpackint ldab, dd_real * s, dd_real * scond, dd_real * amax, mpackint *info );
void Cpbequ ( const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_real * s, dd_real * scond, dd_real * amax, mpackint *info );
void Rpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_real * AB, mpackint ldab, dd_real * afb, mpackint ldafb, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_complex * AB, mpackint ldab, dd_complex * afb, mpackint ldafb, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rpbstf ( const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, mpackint *info );
void Cpbstf ( const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, mpackint *info );
void Rpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_real * AB, mpackint ldab, dd_real * B, mpackint ldb, mpackint *info );
void Cpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_complex * ab, mpackint ldab, dd_complex * B, mpackint ldb, mpackint *info );
void Rpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_real * AB, mpackint ldab, dd_real * afb, mpackint ldafb, char *equed, dd_real * s, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint * iwork, mpackint * info );
void Cpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_complex * AB, mpackint ldab, dd_complex * afb, mpackint ldafb, char *equed, dd_real * s, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint * info );
void Rpbtrf ( const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, mpackint *info );
void Cpbtrf ( const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, mpackint *info );
void Rpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_real * ab, mpackint ldab, dd_real * B, mpackint ldb, mpackint *info );
void Cpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, dd_complex * AB, mpackint ldab, dd_complex * B, mpackint ldb, mpackint *info );
void Rpocon ( const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Cpocon ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real anorm, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rpoequ ( mpackint n, dd_real * A, mpackint lda, dd_real * s, dd_real * scond, dd_real * amax, mpackint *info );
void Cpoequ ( mpackint n, dd_complex * A, mpackint lda, dd_real * s, dd_real * scond, dd_real * amax, mpackint *info );
void Rporfs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * af, mpackint ldaf, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cporfs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rposv ( const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *info );
void Cposv ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint *info );
void Rposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * af, mpackint ldaf, char *equed, dd_real * s, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint * iwork, mpackint * info );
void Cposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, char *equed, dd_real * s, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint * info );
void Rpotri ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *info );
void Cpotri ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *info );
void Rpotrs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *info );
void Cpotrs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint *info );
void Rppcon ( const char *uplo, mpackint n, dd_real * ap, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Cppcon ( const char *uplo, mpackint n, dd_complex * ap, dd_real * anorm, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rppequ ( const char *uplo, mpackint n, dd_real * ap, dd_real * s, dd_real * scond, dd_real * amax, mpackint *info );
void Cppequ ( const char *uplo, mpackint n, dd_complex * ap, dd_real * s, dd_real * scond, dd_real * amax, mpackint *info );
void Rpptrf ( const char *uplo, mpackint n, dd_real * ap, mpackint *info );
void Cpptrf ( const char *uplo, mpackint n, dd_complex * ap, mpackint *info );
void Rpptri ( const char *uplo, mpackint n, dd_real * ap, mpackint *info );
void Cpptri ( const char *uplo, mpackint n, dd_complex * ap, mpackint *info );
void Rpptrs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, dd_real * B, mpackint ldb, mpackint *info );
void Cpptrs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * B, mpackint ldb, mpackint *info );
void Rpprfs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, dd_real * afp, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cpprfs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * afp, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rppsv ( const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, dd_real * B, mpackint ldb, mpackint *info );
void Cppsv ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * B, mpackint ldb, mpackint *info );
void Rppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, dd_real * afp, char *equed, dd_real * s, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * afp, char *equed, dd_real * s, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint * info );
void Rptcon ( mpackint n, dd_real * d, dd_real * e, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *info );
void Cptcon ( mpackint n, dd_real * d, dd_complex * e, dd_real anorm, dd_real * rcond, dd_real * rwork, mpackint *info );
void Rpteqr ( const char *compz, mpackint n, dd_real * d, dd_real * e, dd_real * z, mpackint ldz, dd_real * work, mpackint * info );
void Cpteqr ( const char *compz, mpackint n, dd_real * d, dd_real * e, dd_complex * z, mpackint ldz, dd_real * work, mpackint *info );
void Rptrfs ( mpackint n, mpackint nrhs, dd_real * d, dd_real * e, dd_real * df, dd_real * ef, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *info );
void Cptrfs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * d, dd_complex * e, dd_real * df, dd_complex * ef, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rptsv ( mpackint n, mpackint nrhs, dd_real * d, dd_real * e, dd_real * B, mpackint ldb, mpackint *info );
void Cptsv ( mpackint n, mpackint nrhs, dd_real * d, dd_complex * e, dd_complex * B, mpackint ldb, mpackint *info );
void Rptsvx ( const char *fact, mpackint n, mpackint nrhs, dd_real * d, dd_real * e, dd_real * df, dd_real * ef, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *info );
void Cptsvx ( const char *fact, mpackint n, mpackint nrhs, dd_real * d, dd_complex * e, dd_real * df, dd_complex * ef, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rpttrf ( mpackint n, dd_real * d, dd_real * e, mpackint *info );
void Cpttrf ( mpackint n, dd_real * d, dd_complex * e, mpackint *info );
void Rpttrs ( mpackint n, mpackint nrhs, dd_real * d, dd_real * e, dd_real * B, mpackint ldb, mpackint *info );
void Cpttrs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * d, dd_complex * e, dd_complex * B, mpackint ldb, mpackint *info );
void Rsbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *info );
void Chbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint *info );
void Rsbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, dd_real * q, mpackint ldq, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_complex * q, mpackint ldq, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint * iwork, mpackint * ifail, mpackint * info );
void Rsbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_real * AB, mpackint ldab, dd_real * bb, mpackint ldbb, dd_real * x, mpackint ldx, dd_real * work, mpackint *info );
void Chbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_complex * AB, mpackint ldab, dd_complex * bb, mpackint ldbb, dd_complex * x, mpackint ldx, dd_complex * work, dd_real * rwork, mpackint *info );
void Rsbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_real * AB, mpackint ldab, dd_real * bb, mpackint ldbb, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *info );
void Chbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_complex * AB, mpackint ldab, dd_complex * bb, mpackint ldbb, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint *info );
void Rsbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_real * AB, mpackint ldab, dd_real * BB, mpackint ldbb, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_complex * AB, mpackint ldab, dd_complex * BB, mpackint ldbb, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_real * AB, mpackint ldab, dd_real * BB, mpackint ldbb, dd_real * q, mpackint ldq, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, dd_complex * ab, mpackint ldab, dd_complex * bb, mpackint ldbb, dd_complex * q, mpackint ldq, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, dd_real * d, dd_real * e, dd_real * q, mpackint ldq, dd_real * work, mpackint *info );
void Chbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_real * d, dd_real * e, dd_complex * q, mpackint ldq, dd_complex * work, mpackint *info );
void Rspcon ( const char *uplo, mpackint n, dd_real * ap, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Cspcon ( const char *uplo, mpackint n, dd_complex * ap, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_complex * work, mpackint *info );
void Chpcon ( const char *uplo, mpackint n, dd_complex * ap, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_complex * work, mpackint *info );
void Rspev ( const char *jobz, const char *uplo, mpackint n, dd_real * ap, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *info );
void Chpev ( const char *jobz, const char *uplo, mpackint n, dd_complex * ap, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint *info );
void Rspevd ( const char *jobz, const char *uplo, mpackint n, dd_real * ap, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpevd ( const char *jobz, const char *uplo, mpackint n, dd_complex * ap, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspevx ( const char *jobz, const char *range, const char *uplo, mpackint n, dd_real * ap, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpevx ( const char *jobz, const char *range, const char *uplo, mpackint n, dd_complex * ap, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rspgst ( mpackint itype, const char *uplo, mpackint n, dd_real * ap, dd_real * bp, mpackint *info );
void Chpgst ( mpackint *itype, const char *uplo, mpackint n, dd_complex * ap, dd_complex * bp, mpackint *info );
void Rspgv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, dd_real * ap, dd_real * bp, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *info );
void Chpgv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, dd_complex * ap, dd_complex * bp, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint *info );
void Rspgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, dd_real * ap, dd_real * bp, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, dd_complex * ap, dd_complex * bp, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspgvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, dd_real * ap, dd_real * bp, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint m, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpgvx ( mpackint itype, const char *jobz, char *range, const char *uplo, mpackint n, dd_complex * ap, dd_complex * bp, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, dd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsprfs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, dd_real * afp, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Csprfs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * afp, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Chprfs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * afp, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rspsv ( const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Cspsv ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Chpsv ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Rspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, dd_real * afp, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Cspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * afp, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Chpsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * afp, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rsptrd ( const char *uplo, mpackint n, dd_real * ap, dd_real * d, dd_real * e, dd_real * tau, mpackint *info );
void Chptrd ( const char *uplo, mpackint n, dd_complex * ap, dd_real * d, dd_real * e, dd_complex * tau, mpackint *info );
void Rsptrf ( const char *uplo, mpackint n, dd_real * ap, mpackint *ipiv, mpackint *info );
void Csptrf ( const char *uplo, mpackint n, dd_complex * ap, mpackint *ipiv, mpackint *info );
void Chptrf ( const char *uplo, mpackint n, dd_complex * ap, mpackint *ipiv, mpackint *info );
void Rsptri ( const char *uplo, mpackint n, dd_real * ap, mpackint *ipiv, dd_real * work, mpackint *info );
void Csptri ( const char *uplo, mpackint n, dd_complex * ap, mpackint *ipiv, dd_complex * work, mpackint *info );
void Chptri ( const char *uplo, mpackint n, dd_complex * ap, mpackint *ipiv, dd_complex * work, mpackint *info );
void Rsptrs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * ap, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Csptrs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Chptrs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * ap, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Rstebz ( const char *range, const char *order, mpackint n, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, dd_real * d, dd_real * e, mpackint * m, mpackint * nsplit, dd_real * w, mpackint *iblock, mpackint *isplit, dd_real * work, mpackint *iwork, mpackint *info );
void Rstedc ( const char *compz, mpackint n, dd_real * d, dd_real * e, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cstedc ( const char *compz, mpackint n, dd_real * d, dd_real * e, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstegr ( const char *jobz, const char *range, mpackint n, dd_real * d, dd_real * e, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_real * z, mpackint ldz, mpackint * isuppz, dd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstegr ( const char *jobz, const char *range, mpackint n, dd_real *d, dd_real * e, dd_real * vl, dd_real * vu, mpackint *il, mpackint *iu, dd_real * abstol, mpackint m, dd_real * w, dd_complex * z, mpackint ldz, mpackint *isuppz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstein ( mpackint n, dd_real * d, dd_real * e, mpackint m, dd_real * w, mpackint *iblock, mpackint *isplit, dd_real * z, mpackint ldz, dd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cstein ( mpackint n, dd_real * d, dd_real * e, mpackint m, dd_real * w, mpackint *iblock, mpackint *isplit, dd_complex * z, mpackint ldz, dd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstev ( const char *jobz, mpackint n, dd_real * d, dd_real * e, dd_real * z, mpackint ldz, dd_real * work, mpackint *info );
void Rstevd ( const char *jobz, mpackint n, dd_real * d, dd_real * e, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstevr ( const char *jobz, const char *range, mpackint n, dd_real * d, dd_real * e, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_real * z, mpackint ldz, mpackint * isuppz, dd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rstevx ( const char *jobz, const char *range, mpackint n, dd_real * d, dd_real * e, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstemr ( const char *jobz, const char *range, mpackint n, dd_real * d, dd_real * e, dd_real vl, dd_real vu, mpackint il, mpackint iu, mpackint * m, dd_real * w, dd_real * z, mpackint ldz, mpackint nzc, mpackint * isuppz, mpacklogical * tryrac, dd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstemr ( const char *jobz, const char *range, mpackint n, dd_real * d, dd_real * e, dd_real vl, dd_real vu, mpackint il, mpackint iu, mpackint * m, dd_real * w, dd_complex * z, mpackint ldz, mpackint nzc, mpackint *isuppz, mpacklogical * tryrac, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsycon ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Csycon ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_complex * work, mpackint *info );
void Checon ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, dd_real anorm, dd_real * rcond, dd_complex * work, mpackint *info );
void Rsyevd ( const char *jobz, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * w, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cheevd ( const char *jobz, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real * w, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsyevr ( const char *jobz, const char *range, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_real * z, mpackint ldz, mpackint * isuppz, dd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cheevr ( const char *jobz, const char *range, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_complex * z, mpackint ldz, mpackint * isuppz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rsyevx ( const char *jobz, const char *range, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cheevx ( const char *jobz, const char *range, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsygst ( mpackint itype, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, mpackint *info );
void Chegst ( mpackint itype, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, mpackint *info );
void Rsygv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * w, dd_real * work, mpackint lwork, mpackint *info );
void Chegv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real * w, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *info );
void Rsygvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * w, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chegvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real * w, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsygvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint *m, dd_real * w, dd_real * z, mpackint ldz, dd_real * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chegvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real vl, dd_real vu, mpackint il, mpackint iu, dd_real abstol, mpackint * m, dd_real * w, dd_complex * z, mpackint ldz, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsyrfs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * af, mpackint ldaf, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Csyrfs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Cherfs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rsysv ( const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * work, mpackint lwork, mpackint *info );
void Csysv ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * work, mpackint lwork, mpackint *info );
void Chesv ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * work, mpackint lwork, mpackint *info );
void Rsysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * af, mpackint ldaf, mpackint *ipiv, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_real * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Csysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *info );
void Chesvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * af, mpackint ldaf, mpackint *ipiv, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * rcond, dd_real * ferr, dd_real * berr, dd_complex * work, mpackint lwork, dd_real * rwork, mpackint *info );
void Rsytrf ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * work, mpackint lwork, mpackint *info );
void Csytrf ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * work, mpackint lwork, mpackint *info );
void Chetrf ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * work, mpackint lwork, mpackint *info );
void Rsytri ( const char *uplo, mpackint n, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * work, mpackint *info );
void Csytri ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * work, mpackint *info );
void Chetri ( const char *uplo, mpackint n, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * work, mpackint *info );
void Rsytrs ( const char *uplo, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, mpackint *ipiv, dd_real * B, mpackint ldb, mpackint *info );
void Csytrs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Chetrs ( const char *uplo, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, mpackint *ipiv, dd_complex * B, mpackint ldb, mpackint *info );
void Rtbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, dd_real * AB, mpackint ldab, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Ctbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, dd_complex * AB, mpackint ldab, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rtbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, dd_real * AB, mpackint ldab, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Ctbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, dd_complex * AB, mpackint ldab, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint * info );
void Rtbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, dd_real * ab, mpackint ldab, dd_real * B, mpackint ldb, mpackint *info );
void Ctbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, dd_complex * ab, mpackint ldab, dd_complex * B, mpackint ldb, mpackint *info );
void Rtgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, dd_real * s, mpackint lds, dd_real *p, mpackint ldp, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, mpackint mm, mpackint *m, dd_real * work, mpackint * info );
void Ctgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, dd_complex * s, mpackint lds, dd_complex * p, mpackint ldp, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, mpackint mm, mpackint * m, dd_complex * work, dd_real * rwork, mpackint * info );
void Rtgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * q, mpackint ldq, dd_real * z, mpackint ldz, mpackint * ifst, mpackint * ilst, dd_real * work, mpackint lwork, mpackint * info );
void Ctgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * q, mpackint ldq, dd_complex * z, mpackint ldz, mpackint ifst, mpackint *ilst, mpackint *info );
void Rtgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical *select, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * alphar, dd_real * alphai, dd_real * beta, dd_real * q, mpackint ldq, dd_real * z, mpackint ldz, mpackint * m, dd_real * pl, dd_real * pr, dd_real * dif, dd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Ctgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical * select, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * alpha, dd_complex * beta, dd_complex * q, mpackint ldq, dd_complex * z, mpackint ldz, mpackint * m, dd_real * pl, dd_real * pr, dd_real * dif, dd_complex * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rtgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real tola, dd_real tolb, dd_real * alpha, dd_real * beta, dd_real * u, mpackint ldu, dd_real * v, mpackint ldv, dd_real * q, mpackint ldq, dd_real * work, mpackint ncycle, mpackint *info );
void Ctgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_real tola, dd_real tolb, dd_real * alpha, dd_real * beta, dd_complex * u, mpackint ldu, dd_complex * v, mpackint ldv, dd_complex * q, mpackint ldq, dd_complex * work, mpackint * ncycle, mpackint *info );
void Rtgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, dd_real * s, dd_real * dif, mpackint mm, mpackint * m, dd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, dd_real * s, dd_real * dif, mpackint mm, mpackint * m, dd_complex * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * c, mpackint ldc, dd_real * d, mpackint ldd, dd_real * e, mpackint lde, dd_real * f, mpackint ldf, dd_real * scale, dd_real * dif, dd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * c, mpackint ldc, dd_complex * d, mpackint ldd, dd_complex * e, mpackint lde, dd_complex * f, mpackint ldf, dd_real * scale, dd_real * dif, dd_complex * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, dd_real * ap, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Ctpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, dd_complex * ap, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rtprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_real * ap, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Ctprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rtptri ( const char *uplo, const char *diag, mpackint n, dd_real * ap, mpackint *info );
void Ctptri ( const char *uplo, const char *diag, mpackint n, dd_complex * ap, mpackint *info );
void Rtptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_real * ap, dd_real * B, mpackint ldb, mpackint *info );
void Ctptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_complex * ap, dd_complex * B, mpackint ldb, mpackint *info );
void Rtrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, dd_real * A, mpackint lda, dd_real * rcond, dd_real * work, mpackint *iwork, mpackint *info );
void Ctrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, dd_complex * A, mpackint lda, dd_real * rcond, dd_complex * work, dd_real * rwork, mpackint *info );
void Rtrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, dd_real * t, mpackint ldt, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, mpackint mm, mpackint *m, dd_real * work, mpackint *info );
void Ctrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, dd_complex * t, mpackint ldt, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, mpackint mm, mpackint *m, dd_complex * work, dd_real * rwork, mpackint *info );
void Rtrexc ( const char *compq, mpackint n, dd_real * t, mpackint ldt, dd_real * q, mpackint ldq, mpackint *ifst, mpackint *ilst, dd_real * work, mpackint *info );
void Ctrexc ( const char *compq, mpackint n, dd_complex * t, mpackint ldt, dd_complex * q, mpackint ldq, mpackint ifst, mpackint ilst, mpackint *info );
void Rtrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_real * work, mpackint *iwork, mpackint *info );
void Ctrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * x, mpackint ldx, dd_real * ferr, dd_real * berr, dd_complex * work, dd_real * rwork, mpackint *info );
void Rtrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, dd_real * t, mpackint ldt, dd_real * q, mpackint ldq, dd_real * wr, dd_real * wi, mpackint m, dd_real * s, dd_real * sep, dd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Ctrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, dd_complex * t, mpackint ldt, dd_complex * q, mpackint ldq, dd_complex * w, mpackint m, dd_real * s, dd_real * sep, dd_complex * work, mpackint lwork, mpackint *info );
void Rtrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, dd_real * t, mpackint ldt, dd_real * vl, mpackint ldvl, dd_real * vr, mpackint ldvr, dd_real * s, dd_real * sep, mpackint mm, mpackint *m, dd_real * work, mpackint ldwork, mpackint *iwork, mpackint *info );
void Ctrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, dd_complex * t, mpackint ldt, dd_complex * vl, mpackint ldvl, dd_complex * vr, mpackint ldvr, dd_real * s, dd_real * sep, mpackint mm, mpackint *m, dd_complex * work, mpackint ldwork, dd_real * rwork, mpackint *info );
void Rtrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * B, mpackint ldb, dd_real * c, mpackint ldc, dd_real * scale, mpackint *info );
void Ctrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * B, mpackint ldb, dd_complex * c, mpackint ldc, dd_real * scale, mpackint *info );
void Rtzrzf ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, dd_real * work, mpackint lwork, mpackint *info );
void Ctzrzf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, dd_complex * work, mpackint lwork, mpackint *info );
void Rtzrqf ( mpackint m, mpackint n, dd_real * A, mpackint lda, dd_real * tau, mpackint *info );
void Ctzrqf ( mpackint m, mpackint n, dd_complex * A, mpackint lda, dd_complex * tau, mpackint *info );

#endif
