/*
 * Copyright (c) 2008-2010
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mlapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MLAPACK_DOUBLE_H_
#define _MLAPACK_DOUBLE_H_

#include "mpack_config.h"

/* MLAPACK prototypes */

/* MLAPACK driver routines */
void Rsyev ( const char *jobz, const char *uplo, mpackint n, double * A, mpackint lda, double * w, double * work, mpackint lwork, mpackint *info );
void Cheev ( const char *jobz, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * w, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *info );
void Rgesv ( mpackint n, mpackint nrhs, double * A, mpackint lda, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Cgesv ( mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );

/* MLAPACK computational routines */
void Rsteqr ( const char *compz, mpackint n, double * d, double * e, double * Z, mpackint ldz, double * work, mpackint *info );
void Csteqr ( const char *compz, mpackint n, double * d, double * e, std::complex<double> * z, mpackint ldz, double * work, mpackint *info );
void Rsterf ( mpackint n, double * d, double * e, mpackint *info );
void Rorgqr ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cungqr ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rorgql ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cungql ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rsytrd ( const char *uplo, mpackint n, double * A, mpackint lda, double * d, double * e, double * tau, double * work, mpackint lwork, mpackint *info );
void Chetrd ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * d, double * e, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rorgtr ( const char *uplo, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cungtr ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rpotrf ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *info );
void Cpotrf ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rtrtri ( const char *uplo, const char *diag, mpackint n, double * A, mpackint lda, mpackint *info );
void Ctrtri ( const char *uplo, const char *diag, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rgetrf ( mpackint m, mpackint n, double * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetrf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rgetri ( mpackint n, double * A, mpackint lda, mpackint *ipiv, double * work, mpackint lwork, mpackint *info );
void Cgetri ( mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgetrs ( const char *trans, mpackint n, mpackint nrhs, double * A, mpackint lda, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Cgetrs ( const char *trans, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rtrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, mpackint *info );
void Ctrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint *info );

/* MLAPACK Auxiliary routines */
double Rlamc3 ( double a, double b );
double Rlamch_double(const char *cmach);
mpackint iMlaenv_double(mpackint ispec, const char *name, const char *opts, mpackint n1, mpackint n2,  mpackint n3, mpackint n4);
void Rlae2 ( double a, double b, double c, double * rt1, double * rt2 );
void Rlaev2 ( double a, double b, double c, double * rt1, double * rt2, double * cs1, double * sn1 );
void Claev2 ( std::complex<double> a, std::complex<double> b, std::complex<double> c, double * rt1, double * rt2, double * cs1, std::complex<double> * sn1 );
void Rlassq ( mpackint n, double * x, mpackint incx, double * scale, double * sumsq );
void Classq ( mpackint n, std::complex<double> * x, mpackint incx, double * scale, double * sumsq );
double Rlanst ( const char *norm, mpackint n, double * d, double * e );
double Clanht ( const char *norm, mpackint n, double * d, std::complex<double> * e );
double Rlansy ( const char *norm, const char *uplo, mpackint n, double * A, mpackint lda, double * work );
double Clansy ( const char *norm, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * work );
double Clanhe ( const char *norm, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * work );
double Rlapy2 ( double x, double y );
void Rlarfg ( mpackint N, double * alpha, double * x, mpackint incx, double * tau );
double Rlapy3 ( double x, double y, double z );
void Rladiv ( double a, double b, double c, double d, double * p, double * q );
std::complex<double> Cladiv ( std::complex<double> x, std::complex<double> y );
void Clarfg ( mpackint n, std::complex<double> * alpha, std::complex<double> * x, mpackint incx, std::complex<double> * tau );
void Rlartg ( double f, double g, double * cs, double * sn, double * r );
void Clartg ( std::complex<double> f, std::complex<double> g, double * cs, std::complex<double> * sn, std::complex<double> * r );
void Rlaset ( const char *uplo, mpackint m, mpackint n, double alpha, double beta, double * A, mpackint lda );
void Claset ( const char *uplo, mpackint m, mpackint n, std::complex<double> alpha, std::complex<double> beta, std::complex<double> * A, mpackint lda );
void Rlasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, double * c, double * s, double * A, mpackint lda );
void Clasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, double * c, double * s, std::complex<double> * A, mpackint lda );
void Rpotf2 ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *info );
void Clacgv ( mpackint n, std::complex<double> * x, mpackint incx );
void Cpotf2 ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rlascl ( const char *type, mpackint kl, mpackint ku, double cfrom, double cto, mpackint m, mpackint n, double * A, mpackint lda, mpackint *info );
void Clascl ( const char *type, mpackint kl, mpackint ku, double cfrom, double cto, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rlasrt ( const char *id, mpackint n, double * d, mpackint *info );
void Rsytd2 ( const char *uplo, mpackint n, double * A, mpackint lda, double * d, double * e, double * tau, mpackint *info );
void Chetd2 ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * d, double * e, std::complex<double> * tau, mpackint *info );
void Rlarf ( const char *side, mpackint m, mpackint n, double * v, mpackint incv, double tau, double * C, mpackint ldc, double * work );
void Clarf ( const char *side, mpackint m, mpackint n, std::complex<double> * v, mpackint incv, std::complex<double> tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work );
void Rorg2l ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cung2l ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rorg2r ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cung2r ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rlarft ( const char *direct, const char *storev, mpackint n, mpackint k, double * v, mpackint ldv, double * tau, double * t, mpackint ldt );
void Clarft ( const char *direct, const char *storev, mpackint n, mpackint k, std::complex<double> * v, mpackint ldv, std::complex<double> * tau, std::complex<double> * t, mpackint ldt );
void Rlarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, double * V, mpackint ldv, double * T, mpackint ldt, double * C, mpackint ldc, double * work, mpackint ldwork );
void Clarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, std::complex<double> * V, mpackint ldv, std::complex<double> * T, mpackint ldt, std::complex<double> * C, mpackint ldc, std::complex<double> * work, mpackint ldwork );
void Rlatrd ( const char *uplo, mpackint n, mpackint nb, double * A, mpackint lda, double * e, double * tau, double * w, mpackint ldw );
void Clatrd ( const char *uplo, mpackint n, mpackint nb, std::complex<double> * A, mpackint lda, double * e, std::complex<double> * tau, std::complex<double> * w, mpackint ldw );
void Clacrm ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * B, mpackint ldb, std::complex<double> * c, mpackint ldc, double * rwork );
void Rtrti2 ( const char *uplo, const char *diag, mpackint n, double * A, mpackint lda, mpackint *info );
void Ctrti2 ( const char *uplo, const char *diag, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rgetf2 ( mpackint m, mpackint n, double * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetf2 ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rlaswp ( mpackint n, double * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Claswp ( mpackint n, std::complex<double> * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Rlasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, double * A, mpackint lda, mpackint *ipiv, double * w, mpackint ldw, mpackint *info );
void Clasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * w, mpackint ldw, mpackint *info );
void Clahef ( const char *uplo, mpackint n, mpackint nb, mpackint kb, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * w, mpackint ldw, mpackint *info );
void Clacrt ( mpackint n, std::complex<double> * cx, mpackint incx, std::complex<double> * cy, mpackint incy, std::complex<double> c, std::complex<double> s );
void Claesy ( std::complex<double> a, std::complex<double> b, std::complex<double> c, std::complex<double> * rt1, std::complex<double> * rt2, std::complex<double> * evscal, std::complex<double> * cs1, std::complex<double> * sn1 );
void Crot ( mpackint n, std::complex<double> * cx, mpackint incx, std::complex<double> * cy, mpackint incy, double c, std::complex<double> s );
void Cspmv ( const char *uplo, mpackint n, std::complex<double> alpha, std::complex<double> * AP, std::complex<double> * x, mpackint incx, std::complex<double> beta, std::complex<double> * y, mpackint incy );
void Cspr ( const char *uplo, mpackint n, std::complex<double> alpha, std::complex<double> * x, mpackint incx, std::complex<double> * AP );
void Csymv ( const char *uplo, mpackint n, std::complex<double> alpha, std::complex<double> * A, mpackint lda, std::complex<double> * x, mpackint incx, std::complex<double> beta, std::complex<double> * y, mpackint incy );
void Csyr ( const char *uplo, mpackint n, std::complex<double> alpha, std::complex<double> * x, mpackint incx, std::complex<double> * A, mpackint lda );
mpackint iCmax1 ( mpackint n, std::complex<double> * cx, mpackint incx );
double RCsum1 ( mpackint n, std::complex<double> * cx, mpackint incx );
void Rlacn2 ( mpackint n, double * v, double * x, mpackint *isgn, double * est, mpackint *kase, mpackint *isave );
void Clacn2 ( mpackint n, std::complex<double> * v, std::complex<double> * x, double * est, mpackint *kase, mpackint *isave );
void Rlatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, double * A, mpackint lda, double * x, double * scale, double * cnorm, mpackint *info );
void Clatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * x, double * scale, double * cnorm, mpackint *info );

/* not yet done ... auxiliary routines */
void Rgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, double * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<double> * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgebd2 ( mpackint m, mpackint n, double * A, mpackint lda, double * d, double * e, double * tauq, double * taup, double * work, mpackint *info );
void Cgebd2 ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * d, double * e, std::complex<double> * tauq, std::complex<double> * taup, std::complex<double> * work, mpackint *info );
void Rgehd2 ( mpackint n, mpackint ilo, mpackint ihi, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cgehd2 ( mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rgelq2 ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cgelq2 ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rgeql2 ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cgeql2 ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rgeqr2 ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cgeqr2 ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rgerq2 ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cgerq2 ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rgesc2 ( mpackint n, double * A, mpackint lda, double * rhs, mpackint *ipiv, mpackint *jpiv, double * scale );
void Cgesc2 ( mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * rhs, mpackint *ipiv, mpackint *jpiv, double * scale );
void Rgetc2 ( mpackint n, double * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Cgetc2 ( mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Rgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, double * dl, double * d, double * du, double * du2, mpackint *ipiv, double * B, mpackint ldb );
void Cgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * du2, mpackint *ipiv, std::complex<double> * B, mpackint ldb );
void Rlabrd ( mpackint m, mpackint n, mpackint nb, double * A, mpackint lda, double * d, double * e, double * tauq, double * taup, double * x, mpackint ldx, double * y, mpackint ldy );
void Clabrd ( mpackint m, mpackint n, mpackint nb, std::complex<double> * A, mpackint lda, double * d, double * e, std::complex<double> * tauq, std::complex<double> * taup, std::complex<double> * x, mpackint ldx, std::complex<double> * y, mpackint ldy );
void Rlacpy ( const char *uplo, mpackint m, mpackint n, double * A, mpackint lda, double * B, mpackint ldb );
void Clacpy ( const char *uplo, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb );
void Clarcm ( mpackint m, mpackint n, double * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * c, mpackint ldc, double * rwork );
void Rlaebz ( mpackint ijob, mpackint nitmax, mpackint n, mpackint mmax, mpackint minp, mpackint nbmin, double abstol, double reltol, double pivmin, double * d, double * e, double * e2, mpackint *nval, double * AB, double * c, mpackint *mout, mpackint *nab, double * work, mpackint *iwork, mpackint *info );
void Rlaed0 ( mpackint icompq, mpackint qsiz, mpackint n, double * d, double * e, double * q, mpackint ldq, double * qstore, mpackint ldqs, double * work, mpackint *iwork, mpackint *info );
void Claed0 ( mpackint qsiz, mpackint n, double * d, double * e, std::complex<double> * q, mpackint ldq, std::complex<double> * qstore, mpackint ldqs, double * rwork, mpackint *iwork, mpackint *info );
void Rlaed1 ( mpackint n, double * d, double * q, mpackint ldq, mpackint *indxq, double rho, mpackint cutpnt, double * work, mpackint *iwork, mpackint *info );
void Rlaed2 ( mpackint *k, mpackint n, mpackint n1, double * d, double * q, mpackint ldq, mpackint *indxq, double * rho, double * z, double * dlamda, double * w, double * q2, mpackint *indx, mpackint *indxc, mpackint *indxp, mpackint *coltyp, mpackint *info );
void Rlaed3 ( mpackint k, mpackint n, mpackint n1, double * d, double * q, mpackint ldq, double * rho, double * dlamda, double * q2, mpackint *indx, mpackint *ctot, double * w, double * s, mpackint *info );
void Rlaed4 ( mpackint n, mpackint i, double * d, double * z, double * delta, double rho, double * dlam, mpackint *info );
void Rlaed5 ( mpackint i, double * d, double * z, double * delta, double rho, double * dlam );
void Rlaed6 ( mpackint kniter, mpackint orgati, double rho, double * d, double * z, double * finit, double * tau, mpackint *info );
void Rlaed7 ( mpackint icompq, mpackint n, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, double * d, double * q, mpackint ldq, mpackint *indxq, double rho, mpackint cutpnt, double * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, double * givnum, double * work, mpackint *iwork, mpackint *info );
void Claed7 ( mpackint n, mpackint cutpnt, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, double * d, std::complex<double> * q, mpackint ldq, double rho, mpackint *indxq, double * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, double * givnum, std::complex<double> * work, double * rwork, mpackint *iwork, mpackint *info );
void Rlaed8 ( mpackint icompq, mpackint *k, mpackint n, mpackint qsiz, double * d, double * q, mpackint ldq, mpackint *indxq, double * rho, mpackint cutpnt, double * z, double * dlamda, double * q2, mpackint ldq2, double * w, mpackint *perm, mpackint *givptr, mpackint *givcol, double * givnum, mpackint *indxp, mpackint *indx, mpackint *info );
void Claed8 ( mpackint *k, mpackint n, mpackint qsiz, std::complex<double> * q, mpackint ldq, double * d, double * rho, mpackint cutpnt, double * z, double * dlamda, std::complex<double> * q2, mpackint ldq2, double * w, mpackint *indxp, mpackint *indx, mpackint *indxq, mpackint *perm, mpackint *givptr, mpackint *givcol, double * givnum, mpackint *info );
void Rlaed9 ( mpackint k, mpackint kstart, mpackint kstop, mpackint n, double * d, double * q, mpackint ldq, double rho, double * dlamda, double * w, double * s, mpackint lds, mpackint *info );
void Rlaeda ( mpackint n, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, double * givnum, double * q, mpackint *qptr, double * z, double * ztemp, mpackint *info );
void Rlaein ( mpackint rightv, mpackint noinit, mpackint n, double * h, mpackint ldh, double wr, double wi, double * vr, double * vi, double * B, mpackint ldb, double * work, double eps3, double smlnum, double bignum, mpackint *info );
void Claein ( mpackint rightv, mpackint noinit, mpackint n, std::complex<double> * h, mpackint ldh, std::complex<double> w, std::complex<double> * v, std::complex<double> * B, mpackint ldb, double * rwork, double eps3, double smlnum, mpackint *info );
void Rlaexc ( mpackint wantq, mpackint n, double * t, mpackint ldt, double * q, mpackint ldq, mpackint j1, mpackint n1, mpackint n2, double * work, mpackint *info );
void Rlag2 ( double * A, mpackint lda, double * B, mpackint ldb, double safmin, double * scale1, double * scale2, double * wr1, double * wr2, double * wi );
void Rlags2 ( mpackint upper, double a1, double a2, double a3, double b1, double b2, double b3, double * csu, double * snu, double * csv, double * snv, double * csq, double * snq );
void Clags2 ( mpacklogical * upper, double a1, std::complex<double> a2, double a3, double b1, std::complex<double> b2, double b3, double * csu, std::complex<double> * snu, double * csv, std::complex<double> * snv, double * csq, std::complex<double> * snq );
void Rlagtf ( mpackint n, double * a, double lambda, double * b, double * c, double * tol, double * d, mpackint *in, mpackint *info );
void Rlagtm ( const char *trans, mpackint n, mpackint nrhs, double alpha, double * dl, double * d, double * du, double * x, mpackint ldx, double * beta, double * B, mpackint ldb );
void Clagtm ( const char *trans, mpackint n, mpackint nrhs, double alpha, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * x, mpackint ldx, double beta, std::complex<double> * B, mpackint ldb );
void Rlagts ( mpackint job, mpackint n, double * a, double * b, double * c, double * d, mpackint *in, double * y, double * tol, mpackint *info );
void Rlagv2 ( double * A, mpackint lda, double * B, mpackint ldb, double * alphar, double * alphai, double * beta, double * csl, double * snl, double * csr, double * snr );
void Rlahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, double * h, mpackint ldh, double * wr, double * wi, mpackint iloz, mpackint ihiz, double * z, mpackint ldz, mpackint *info );
void Clahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * h, mpackint ldh, std::complex<double> * w, mpackint iloz, mpackint ihiz, std::complex<double> * z, mpackint ldz, mpackint *info );
void Rlahr2 ( mpackint n, mpackint k, mpackint nb, double * A, mpackint lda, double * tau, double * t, mpackint ldt, double * y, mpackint ldy );
void Clahr2 ( mpackint n, mpackint k, mpackint nb, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * t, mpackint ldt, std::complex<double> * y, mpackint ldy );
void Rlahrd ( mpackint n, mpackint k, mpackint nb, double * A, mpackint lda, double * tau, double * t, mpackint ldt, double * y, mpackint ldy );
void Clahrd ( mpackint n, mpackint k, mpackint nb, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * t, mpackint ldt, std::complex<double> * y, mpackint ldy );
void Rlaic1 ( mpackint job, mpackint j, double * x, double sest, double * w, double gamma, double * sestpr, double * s, double * c );
void Claic1 ( mpackint job, mpackint j, std::complex<double> * x, double sest, std::complex<double> * w, std::complex<double> gamma, double * sestpr, std::complex<double> * s, std::complex<double> * c );
void Rlaln2 ( mpackint ltrans, mpackint na, mpackint nw, double smin, double ca, double * A, mpackint lda, double d1, double d2, double * B, mpackint ldb, double wr, double wi, double * x, mpackint ldx, double * scale, double * xnorm, mpackint *info );
void Rlals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, double * B, mpackint ldb, double * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, double * givnum, mpackint ldgnum, double * poles, double * difl, double * difr, double * z, mpackint k, double c, double s, double * work, mpackint *info );
void Clals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, std::complex<double> * B, mpackint ldb, std::complex<double> * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, double * givnum, mpackint ldgnum, double * poles, double * difl, double * difr, double * z, mpackint k, double c, double s, double * rwork, mpackint *info );
void Rlalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, double * B, mpackint ldb, double * bx, mpackint ldbx, double * u, mpackint ldu, double * vt, mpackint *k, double * difl, double * difr, double * z, double * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, double * givnum, double * c, double * s, double * work, mpackint *iwork, mpackint *info );
void Clalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, std::complex<double> * B, mpackint ldb, std::complex<double> * bx, mpackint ldbx, double * u, mpackint ldu, double * vt, mpackint *k, double * difl, double * difr, double * z, double * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, double * givnum, double * c, double * s, double * rwork, mpackint *iwork, mpackint *info );
void Rlalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, double * d, double * e, double * B, mpackint ldb, double rcond, mpackint *rank, double * work, mpackint *iwork, mpackint *info );
void Clalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, double * d, double * e, std::complex<double> * B, mpackint ldb, double rcond, mpackint *rank, std::complex<double> * work, double * rwork, mpackint *iwork, mpackint *info );
void Rlamrg ( mpackint n1, mpackint n2, double * a, mpackint dtrd1, mpackint dtrd2, mpackint *index );
double Rlangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, double * ab, mpackint ldab, double * work );
double Clangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, std::complex<double> * AB, mpackint ldab, double * work );
double Rlange ( const char *norm, mpackint m, mpackint n, double * A, mpackint lda, double * work );
double Clange ( const char *norm, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * work );
double Rlangt ( const char *norm, mpackint n, double * dl, double * d, double * du );
double Clangt ( const char *norm, mpackint n, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du );
double Rlanhs ( const char *norm, mpackint n, double * A, mpackint lda, double * work );
double Clanhs ( const char *norm, mpackint n, std::complex<double> * A, mpackint lda, double * work );
double Rlansb ( const char *norm, const char *uplo, mpackint n, mpackint k, double * AB, mpackint ldab, double * work );
double Clansb ( const char *norm, const char *uplo, mpackint n, mpackint k, std::complex<double> * AB, mpackint ldab, double * work );
double Clanhb ( const char *norm, const char *uplo, mpackint n, mpackint k, std::complex<double> * AB, mpackint ldab, double * work );
double Rlansp ( const char *norm, const char *uplo, mpackint n, double * ap, double * work );
double Clansp ( const char *norm, const char *uplo, mpackint n, std::complex<double> * ap, double * work );
double Clanhp ( const char *norm, const char *uplo, mpackint n, std::complex<double> * ap, double * work );
double Rlantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, double * AB, mpackint ldab, double * work );
std::complex<double> Clantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, std::complex<double> * AB, mpackint ldab, double * work );
double Rlantp ( const char *norm, const char *uplo, const char *diag, mpackint n, double * ap, double * work );
std::complex<double> Clantp ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<double> * ap, double * work );
double Rlantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, double * A, mpackint lda, double * work );
double Clantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * work );
void Rlanv2 ( double * a, double * b, double * c, double * d, double * rt1r, double * rt1i, double * rt2r, double * rt2i, double * cs, double * sn );
void Rlapll ( mpackint n, double * x, mpackint incx, double * y, mpackint incy, double * ssmin );
void Clapll ( mpackint n, std::complex<double> * x, mpackint incx, std::complex<double> * y, mpackint incy, double * ssmin );
void Rlapmt ( mpackint *forwrd, mpackint m, mpackint n, double * X, mpackint ldx, mpackint *k );
void Clapmt ( mpackint *forwrd, mpackint m, mpackint n, std::complex<double> * X, mpackint ldx, mpackint *k );
void Rlaqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, double * AB, mpackint ldab, double * r, double * c, double rowcnd, double colcnd, double amax, char *equed );
void Claqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<double> * AB, mpackint ldab, double * r, double * c, double rowcnd, double colcnd, double amax, char *equed );
void Rlaqge ( mpackint m, mpackint n, double * A, mpackint lda, double * r, double * c, double rowcnd, double colcnd, double amax, char *equed );
void Claqge ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * r, double * c, double rowcnd, double colcnd, double amax, char *equed );
void Rlaqp2 ( mpackint m, mpackint n, mpackint offset, double * A, mpackint lda, mpackint *jpvt, double * tau, double * vn1, double * vn2, double * work );
void Claqp2 ( mpackint m, mpackint n, mpackint offset, std::complex<double> * A, mpackint lda, mpackint *jpvt, std::complex<double> * tau, double * vn1, double * vn2, std::complex<double> * work );
void Rlaqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, double * A, mpackint lda, mpackint *jpvt, double * tau, double * vn1, double * vn2, double * auxv, double * f, mpackint ldf );
void Claqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, std::complex<double> * A, mpackint lda, mpackint *jpvt, std::complex<double> * tau, double * vn1, double * vn2, std::complex<double> * auxv, std::complex<double> * f, mpackint ldf );
void Rlaqsb ( const char *uplo, mpackint n, mpackint kd, double * ab, mpackint ldab, double * s, double scond, double amax, char *equed );
void Claqsb ( const char *uplo, mpackint n, mpackint kd, std::complex<double> * ab, mpackint ldab, double * s, double scond, double amax, char *equed );
void Claqhb ( const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, double * s, double scond, double amax, char *equed );
void Rlaqsp ( const char *uplo, mpackint n, double * ap, double * s, double scond, double amax, char *equed );
void Claqsp ( const char *uplo, mpackint n, std::complex<double> * ap, double * s, double scond, double amax, char *equed );
void Claqhp ( const char *uplo, mpackint n, std::complex<double> * ap, double * s, double scond, double amax, char *equed );
void Rlaqsy ( const char *uplo, mpackint n, double * A, mpackint lda, double * s, double scond, double amax, char *equed );
void Claqsy ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * s, double scond, double amax, char *equed );
void Claqhe ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * s, double scond, double amax, char *equed );
void Rlaqtr ( mpackint ltran, mpackint lreal, mpackint n, double * t, mpackint ldt, double * B, double w, double * scale, double * x, double * work, mpackint *info );
void Rlar1v ( mpackint n, mpackint b1, mpackint bn, double lambda, double * d, double * l, double * ld, double * lld, double pivmin, double gaptol, double * z, mpackint wantnc, mpackint *negcnt, double * ztz, double * mingma, mpackint *r, mpackint *isuppz, double * nrminv, double * resid, double * rqcorr, double * work );
void Clar1v ( mpackint n, mpackint b1, mpackint bn, double lambda, double * d, double * l, double * ld, double * lld, double pivmin, double gaptol, std::complex<double> * z, mpackint wantnc, mpackint *negcnt, double * ztz, double * mingma, mpackint *r, mpackint *isuppz, double * nrminv, double * resid, double * rqcorr, double * work );
void Rlar2v ( mpackint n, double * x, double * y, double * z, mpackint incx, double * c, double * s, mpackint incc );
void Clar2v ( mpackint n, std::complex<double> * x, std::complex<double> * y, std::complex<double> * z, mpackint incx, double * c, std::complex<double> * s, mpackint incc );
void Rlarfx ( const char *side, mpackint m, mpackint n, double * v, double tau, double * c, mpackint ldc, double * work );
void Clarfx ( const char *side, mpackint m, mpackint n, std::complex<double> * v, std::complex<double> tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work );
void Rlargv ( mpackint n, double * x, mpackint incx, double * y, mpackint incy, double * c, mpackint incc );
void Clargv ( mpackint n, std::complex<double> * x, mpackint incx, std::complex<double> * y, mpackint incy, double * c, mpackint incc );
void Rlarnv ( mpackint idist, mpackint *iseed, mpackint n, double * x );
void Clarnv ( mpackint idist, mpackint *iseed, mpackint n, std::complex<double> * x );
mpackint Rlaneg ( mpackint n, double * d, double * lld, double sigma, double pivmin, mpackint r );
void Rlarra ( mpackint n, double * d, double * e, double * e2, double spltol, double tnrm, mpackint *nsplit, mpackint *isplit, mpackint *info );
void Rlarrb ( mpackint n, double * d, double * lld, mpackint ifirst, mpackint ilast, double rtol1, double rtol2, mpackint offset, double * w, double * wgap, double * werr, double * work, mpackint *iwork, double pivmin, double spdiam, mpackint twist, mpackint *info );
void Rlarrc ( const char *jobt, mpackint n, double vl, double vu, double * d, double * e, double pivmin, mpackint *eigcnt, mpackint *lcnt, mpackint *rcnt, mpackint *info );
void Rlarrd ( const char *range, const char *order, mpackint n, double vl, double vu, mpackint il, mpackint iu, double *gers, double reltol, double * d, double * e, double * e2, double pivmin, mpackint nsplit, mpackint *isplit, mpackint *m, double * w, double * werr, double * wl, double * wu, mpackint *iblock, mpackint *indexw, double * work, mpackint *iwork, mpackint *info );
void Rlarre ( const char *range, mpackint n, double * vl, double * vu, mpackint il, mpackint iu, double * d, double * e, double * e2, double rtol1, double rtol2, double spltol, mpackint * nsplit, mpackint *isplit, mpackint * m, double * w, double * werr, double * wgap, mpackint *iblock, mpackint *indexw, double * gers, double * pivmin, double * work, mpackint *iwork, mpackint *info );
void Rlarrf ( mpackint n, double * d, double * l, double * ld, mpackint clstrt, mpackint clend, double * w, double * wgap, double * werr, double spdiam, double clgapl, double clgapr, double pivmin, double * sigma, double * dplus, double * lplus, double * work, mpackint *info );
void Rlarrj ( mpackint n, double * d, double * e2, mpackint ifirst, mpackint ilast, double rtol, mpackint offset, double * w, double * werr, double * work, mpackint *iwork, double pivmin, double spdiam, mpackint *info );
void Rlarrk ( mpackint n, mpackint iw, double gl, double gu, double * d, double * e2, double pivmin, double reltol, double * w, double * werr, mpackint *info );
void Rlarrr ( mpackint n, double * d, double * e, mpackint *info );
void Rlartv ( mpackint n, double * x, mpackint incx, double * y, mpackint incy, double * c, double * s, mpackint incc );
void Clartv ( mpackint n, std::complex<double> * x, mpackint incx, std::complex<double> * y, mpackint incy, double * c, std::complex<double> * s, mpackint incc );
void Rlarrv ( mpackint n, double vl, double vu, double * d, double * l, double pivmin, mpackint * isplit, mpackint m, mpackint dol, mpackint dou, double minrgp, double rtol1, double rtol2, double * w, double * werr, double * wgap, mpackint * iblock, mpackint * indexw, double * gers, double * z, mpackint ldz, mpackint * isuppz, double * work, mpackint * iwork, mpackint * info );
void Clarrv ( mpackint n, double vl, double vu, double * d, double * l, double pivmin, mpackint *isplit, mpackint m, mpackint dol, mpackint dou, double minrgp, double rtol1, double rtol2, double * w, double * werr, double * wgap, mpackint *iblock, mpackint *indexw, double * gers, std::complex<double> * z, mpackint ldz, mpackint *isuppz, double * work, mpackint *iwork, mpackint *info );
void Rlaruv ( mpackint *iseed, mpackint n, double * x );
void Rlarz ( const char *side, mpackint m, mpackint n, mpackint l, double * v, mpackint incv, double tau, double * C, mpackint ldc, double * work );
void Clarz ( const char *side, mpackint m, mpackint n, mpackint l, std::complex<double> * v, mpackint incv, std::complex<double> tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work );
void Rlarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, double * v, mpackint ldv, double * t, mpackint ldt, double * c, mpackint ldc, double * work, mpackint ldwork );
void Clarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<double> * v, mpackint ldv, std::complex<double> * t, mpackint ldt, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint ldwork );
void Rlarzt ( const char *direct, const char *storev, mpackint n, mpackint k, double * v, mpackint ldv, double * tau, double * t, mpackint ldt );
void Clarzt ( const char *direct, const char *storev, mpackint n, mpackint k, std::complex<double> * v, mpackint ldv, std::complex<double> * tau, std::complex<double> * t, mpackint ldt );
void Rlas2 ( double f, double g, double h, double * ssmin, double * ssmax );
void Rlasd0 ( mpackint n, mpackint sqre, double * d, double * e, double * u, mpackint ldu, double * vt, mpackint ldvt, mpackint smlsiz, mpackint *iwork, double * work, mpackint *info );
void Rlasd1 ( mpackint nl, mpackint nr, mpackint *sqre, double * d, double * alpha, double * beta, double * u, mpackint ldu, double * vt, mpackint ldvt, mpackint *idxq, mpackint *iwork, double * work, mpackint *info );
void Rlasd2 ( mpackint nl, mpackint nr, mpackint sqre, mpackint *k, double * d, double * z, double alpha, double beta, double * u, mpackint ldu, double * vt, mpackint ldvt, double * dsigma, double * u2, mpackint ldu2, double * vt2, mpackint ldvt2, mpackint *idxp, mpackint *idx, mpackint *idxc, mpackint *idxq, mpackint *coltyp, mpackint *info );
void Rlasd3 ( mpackint nl, mpackint nr, mpackint sqre, mpackint k, double * d, double * q, mpackint ldq, double * dsigma, double * u, mpackint ldu, double * u2, mpackint ldu2, double * vt, mpackint ldvt, double * vt2, mpackint ldvt2, mpackint *idxc, mpackint *ctot, double * z, mpackint *info );
void Rlasd4 ( mpackint n, mpackint i, double * d, double * z, double * delta, double rho, double * sigma, double * work, mpackint *info );
void Rlasd5 ( mpackint i, double * d, double * z, double * delta, double rho, double * dsigma, double * work );
void Rlasd6 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, double * d, double * vf, double * vl, double * alpha, double * beta, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, double * givnum, mpackint ldgnum, double * poles, double * difl, double * difr, double * z, mpackint k, double * c, double * s, double * work, mpackint *iwork, mpackint *info );
void Rlasd7 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint k, double * d, double * z, double * zw, double * vf, double * vfw, double * vl, double * vlw, double alpha, double beta, double * dsigma, mpackint *idx, mpackint *idxp, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, double * givnum, mpackint ldgnum, double * c, double * s, mpackint *info );
void Rlasd8 ( mpackint icompq, mpackint k, double * d, double * z, double * vf, double * vl, double * difl, double * difr, mpackint lddifr, double * dsigma, double * work, mpackint *info );
void Rlasda ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint sqre, double * d, double * e, double * u, mpackint ldu, double * vt, mpackint *k, double * difl, double * difr, double * z, double * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, double * givnum, double * c, double * s, double * work, mpackint *iwork, mpackint *info );
void Rlasdq ( const char *uplo, mpackint sqre, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, double * d, double * e, double * vt, mpackint ldvt, double * u, mpackint ldu, double * c, mpackint ldc, double * work, mpackint *info );
void Rlasdt ( mpackint n, mpackint lvl, mpackint nd, mpackint *inode, mpackint *ndiml, mpackint *ndimr, mpackint msub );
void Rlasq1 ( mpackint n, double * d, double * e, double * work, mpackint *info );
void Rlasq2 ( mpackint n, double * z, mpackint *info );
void Rlasq3 ( mpackint i0, mpackint n0, double * z, mpackint pp, double * dmin, double * sigma, double * desig, double qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint ieee );
void Rlasq4 ( mpackint i0, mpackint n0, double * z, mpackint pp, mpackint n0in, double dmin, double dmin1, double dmin2, double dn, double dn1, double dn2, double * tau, mpackint *ttype );
void Rlasq5 ( mpackint i0, mpackint n0, double * z, mpackint pp, double tau, double * dmin, double * dmin1, double * dmin2, double * dn, double * dnm1, double * dnm2, mpackint ieee );
void Rlasq6 ( mpackint i0, mpackint n0, double * z, mpackint pp, double * dmin, double * dmin1, double * dmin2, double * dn, double * dnm1, double * dnm2 );
void Rlasv2 ( double f, double g, double h, double * ssmin, double * ssmax, double * snr, double * csr, double * snl, double * csl );
void Rlasy2 ( mpackint ltranl, mpackint ltranr, mpackint isgn, mpackint n1, mpackint n2, double * tl, mpackint ldtl, double * tr, mpackint ldtr, double * B, mpackint ldb, double * scale, double * x, mpackint ldx, double * xnorm, mpackint *info );
void Rlatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, double * AB, mpackint ldab, double * x, double * scale, double * cnorm, mpackint *info );
void Clatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, std::complex<double> * x, double * scale, double * cnorm, mpackint *info );
void Rlatdf ( mpackint ijob, mpackint n, double * z, mpackint ldz, double * rhs, double * rdsum, double * rdscal, mpackint *ipiv, mpackint *jpiv );
void Clatdf ( mpackint ijob, mpackint n, std::complex<double> * z, mpackint ldz, std::complex<double> * rhs, double * rdsum, double * rdscal, mpackint *ipiv, mpackint *jpiv );
void Rlatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, double * ap, double * x, double * scale, double * cnorm, mpackint *info );
void Clatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, std::complex<double> * ap, std::complex<double> * x, double * scale, double * cnorm, mpackint *info );
void Rlauu2 ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *info );
void Clauu2 ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rlauum ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *info );
void Clauum ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rlatrz ( mpackint m, mpackint n, mpackint l, double * A, mpackint lda, double * tau, double * work );
void Clatrz ( mpackint m, mpackint n, mpackint l, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work );
void Rorgl2 ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cungl2 ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rorgr2 ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint *info );
void Cungr2 ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rorm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint *info );
void Cunm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint *info );
void Rorm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint *info );
void Cunm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint *info );
void Rorml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint *info );
void Cunml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint *info );
void Rormr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * C, mpackint ldc, double * work, mpackint *info );
void Cunmr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint *info );
void Rormr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint *info );
void Cunmr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint *info );
void Rpbtf2 ( const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, mpackint *info );
void Cpbtf2 ( const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, mpackint *info );
void Rptts2 ( mpackint n, mpackint nrhs, double * d, double * e, double * b, mpackint ldb );
void Cptts2 ( mpackint iuplo, mpackint n, mpackint nrhs, double * d, std::complex<double> * e, std::complex<double> * B, mpackint ldb );
void Rrscl ( mpackint n, double sa, double * sx, mpackint incx );
void CRrscl ( mpackint n, double sa, std::complex<double> * sx, mpackint incx );
void Rsygs2 ( mpackint itype, const char *uplo, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, mpackint *info );
void Chegs2 ( mpackint itype, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rsytf2 ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Csytf2 ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Chetf2 ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rtgex2 ( mpackint wantq, mpackint wantz, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * q, mpackint ldq, double * z, mpackint ldz, mpackint j1, mpackint n1, mpackint n2, double * work, mpackint lwork, mpackint *info );
void Ctgex2 ( mpackint wantq, mpackint wantz, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * q, mpackint ldq, std::complex<double> * z, mpackint ldz, mpackint j1, mpackint *info );
void Rtgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * c, mpackint ldc, double * d, mpackint ldd, double * e, mpackint lde, double * f, mpackint ldf, double * scale, double * rdsum, double * rdscal, mpackint *iwork, mpackint *pq, mpackint *info );
void Ctgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * C, mpackint ldc, std::complex<double> * d, mpackint ldd, std::complex<double> * e, mpackint lde, std::complex<double> * f, mpackint ldf, double * scale, double * rdsum, double * rdscal, mpackint *info );
void Rlazq3 ( mpackint i0, mpackint n0, double * z, mpackint pp, double * dmin, double * sigma, double * desig, double qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint *ieee, mpackint *ttype, double * dmin1, double * dmin2, double * dn, double * dn1, double * dn2, double * tau );
void Rlazq4 ( mpackint i0, mpackint n0, double * z, mpackint pp, mpackint n0in, double dmin, double dmin1, double dmin2, double dn, double dn1, double dn2, double * tau, mpackint *ttype, double * g );
void Rlaqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, double * h, mpackint ldh, double * wr, double * wi, mpackint iloz, mpackint ihiz, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *info );
void Claqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * h, mpackint ldh, std::complex<double> * w, mpackint *iloz, mpackint *ihiz, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rlaqr1 ( mpackint n, double * h, mpackint ldh, double sr1, double si1, double sr2, double si2, double * v );
void Claqr1 ( mpackint n, std::complex<double> * h, mpackint ldh, std::complex<double> s1, std::complex<double> s2, std::complex<double> * v );
void Rlaqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, double * h, mpackint ldh, mpackint iloz, mpackint ihiz, double * z, mpackint ldz, mpackint *ns, mpackint *nd, double * sr, double * si, double * v, mpackint ldv, mpackint nh, double * t, mpackint ldt, mpackint nv, double * wv, mpackint ldwv, double * work, mpackint lwork );
void Claqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, std::complex<double> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<double> * z, mpackint ldz, mpackint *ns, mpackint *nd, std::complex<double> * sh, std::complex<double> * v, mpackint ldv, mpackint nh, std::complex<double> * t, mpackint ldt, mpackint nv, std::complex<double> * wv, mpackint ldwv, std::complex<double> * work, mpackint lwork );
void Rlaqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, double * h, mpackint ldh, mpackint iloz, mpackint ihiz, double * z, mpackint ldz, mpackint ns, mpackint nd, double * sr, double * si, double * v, mpackint ldv, mpackint nh, double * t, mpackint ldt, mpackint nv, double * wv, mpackint ldwv, double * work, mpackint lwork );
void Claqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, std::complex<double> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<double> * z, mpackint ldz, mpackint *ns, mpackint *nd, std::complex<double> * sh, std::complex<double> * v, mpackint ldv, mpackint nh, std::complex<double> * t, mpackint ldt, mpackint nv, std::complex<double> * wv, mpackint ldwv, std::complex<double> * work, mpackint lwork );
void Rlaqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, double * h, mpackint ldh, double * wr, double * wi, mpackint iloz, mpackint ihiz, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *info );
void Claqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * h, mpackint ldh, std::complex<double> * w, mpackint iloz, mpackint ihiz, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rlaqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kac22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, double * sr, double * si, double * h, mpackint ldh, mpackint iloz, mpackint ihiz, double * z, mpackint ldz, double * v, mpackint ldv, double * u, mpackint ldu, mpackint nv, double * wv, mpackint ldwv, mpackint nh, double * wh, mpackint ldwh );
void Claqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kacc22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, std::complex<double> * s, std::complex<double> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<double> * z, mpackint ldz, std::complex<double> * v, mpackint ldv, std::complex<double> * u, mpackint ldu, mpackint nv, std::complex<double> * wv, mpackint ldwv, mpackint nh, std::complex<double> * wh, mpackint ldwh );
void Rlatzm ( const char *side, mpackint m, mpackint n, double * v, mpackint incv, double * tau, double *c1, double * c2, mpackint ldc, double * work );
void Clatzm ( const char *side, mpackint m, mpackint n, std::complex<double> * v, mpackint incv, std::complex<double> * tau, std::complex<double> * c1, std::complex<double> * c2, mpackint ldc, std::complex<double> * work );
void Clacp2 ( const char *uplo, mpackint m, mpackint n, double * A, mpackint lda, std::complex<double> * B, mpackint ldb );
mpackint Risnan ( double din );

/* not yet done ... driver and computational routines */
void Rbdsdc ( const char *uplo, const char *compq, mpackint n, double * d, double * e, double * u, mpackint ldu, double * vt, mpackint ldvt, double * q, mpackint * iq, double * work, mpackint * iwork, mpackint * info );
void Rbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, double * d, double * e, double * vt, mpackint ldvt, double * u, mpackint ldu, double * c, mpackint ldc, double * work, mpackint *info );
void Cbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, double * d, double * e, std::complex<double> * vt, mpackint ldvt, std::complex<double> * u, mpackint ldu, std::complex<double> * c, mpackint ldc, double * rwork, mpackint * info );
void Rdisna ( const char *job, mpackint m, mpackint n, double * d, double * sep, mpackint *info );
void Rgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, double * AB, mpackint ldab, double * d, double * e, double * q, mpackint ldq, double * pt, mpackint ldpt, double * c, mpackint ldc, double * work, mpackint *info );
void Cgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, std::complex<double> * AB, mpackint ldab, double * d, double * e, std::complex<double> * q, mpackint ldq, std::complex<double> * pt, mpackint ldpt, std::complex<double> * c, mpackint ldc, std::complex<double> * work, double * rwork, mpackint * info );
void Rgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, double * AB, mpackint ldab, mpackint *ipiv, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Cgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, std::complex<double> * AB, mpackint ldab, mpackint *ipiv, double anorm, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, double * AB, mpackint ldab, double * r, double * c, double * rowcnd, double * colcnd, double * amax, mpackint *info );
void Cgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<double> * AB, mpackint ldab, double * r, double * c, double * rowcnd, double * colcnd, double * amax, mpackint *info );
void Rgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, double * AB, mpackint ldab, double * afb, mpackint ldafb, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<double> * AB, mpackint ldab, std::complex<double> * afb, mpackint ldafb, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, double * AB, mpackint ldab, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Cgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<double> * ab, mpackint ldab, mpackint *ipiv, std::complex<double> * b, mpackint ldb, mpackint *info );
void Rgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, double * AB, mpackint ldab, double * afb, mpackint ldafb, mpackint * ipiv, char *equed, double * r, double * c, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint * iwork, mpackint * info );
void Cgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<double> * AB, mpackint ldab, std::complex<double> * afb, mpackint ldafb, mpackint * ipiv, char *equed, double * r, double * c, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint * info );
void Rgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, double * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<double> * ab, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, double * AB, mpackint ldab, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Cgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<double> * AB, mpackint ldab, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, double * scale, mpackint m, double * v, mpackint ldv, mpackint *info );
void Cgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, double * scale, mpackint m, std::complex<double> * v, mpackint ldv, mpackint *info );
void Rgebal ( const char *job, mpackint n, double * A, mpackint lda, mpackint *ilo, mpackint *ihi, double * scale, mpackint *info );
void Cgebal ( const char *job, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ilo, mpackint *ihi, double * scale, mpackint *info );
void Rgebrd ( mpackint m, mpackint n, double * A, mpackint lda, double * d, double * e, double * tauq, double * taup, double * work, mpackint lwork, mpackint *info );
void Cgebrd ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * d, double * e, std::complex<double> * tauq, std::complex<double> * taup, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgecon ( const char *norm, mpackint n, double * A, mpackint lda, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Cgecon ( const char *norm, mpackint n, std::complex<double> * A, mpackint lda, double anorm, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rgeequ ( mpackint m, mpackint n, double * A, mpackint lda, double * r, double * c, double * rowcnd, double * colcnd, double * amax, mpackint *info );
void Cgeequ ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * r, double * c, double * rowcnd, double * colcnd, double * amax, mpackint *info );
void Rgees ( const char *jobvs, const char *sort, LFP select, mpackint n, double * A, mpackint lda, mpackint *sdim, double * wr, double * wi, double * vs, mpackint ldvs, double * work, mpackint lwork, mpacklogical * bwork, mpackint *info );
void Cgees ( const char *jobvs, const char *sort, LFP select, mpackint n, std::complex<double> * A, mpackint lda, mpackint *sdim, std::complex<double> * w, std::complex<double> * vs, mpackint ldvs, std::complex<double> * work, mpackint lwork, double * rwork, mpacklogical * bwork, mpackint *info );
void Rgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, double * A, mpackint lda, mpackint * sdim, double * wr, double * wi, double * vs, mpackint ldvs, double * rconde, double * rcondv, double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, std::complex<double> * A, mpackint lda, mpackint *sdim, std::complex<double> * w, std::complex<double> * vs, mpackint ldvs, double * rconde, double * rcondv, std::complex<double> * work, mpackint lwork, double * rwork, mpacklogical * bwork, mpackint *info );
void Rgeev ( const char *jobvl, const char *jobvr, mpackint n, double * A, mpackint lda, double * wr, double * wi, double * vl, mpackint ldvl, double * vr, mpackint ldvr, double * work, mpackint lwork, mpackint *info );
void Cgeev ( const char *jobvl, const char *jobvr, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * w, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Rgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, double * A, mpackint lda, double * wr, double * wi, double * vl, mpackint ldvl, double * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, double * scale, double * abnrm, double * rconde, double * rcondv, double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * w, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, double * scale, double * abnrm, double * rconde, double * rcondv, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Cgehrd ( mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgehrd ( mpackint n, mpackint ilo, mpackint ihi, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Rgelqf ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cgelqf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, double * work, mpackint lwork, mpackint *info );
void Cgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgelsx ( mpackint m, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, mpackint *jpvt, double rcond, mpackint *rank, double * work, mpackint *info );
void Cgelsx ( mpackint m, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint *jpvt, double rcond, mpackint *rank, std::complex<double> * work, double * rwork, mpackint *info );
void Rgelsd ( mpackint m, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, double * s, double * rcond, mpackint *rank, double * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Cgelsd ( mpackint m, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double * s, double rcond, mpackint * rank, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * iwork, mpackint * info );
void Rgelss ( mpackint m, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, double * s, double rcond, mpackint * rank, double * work, mpackint lwork, mpackint * info );
void Cgelss ( mpackint m, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double * s, double rcond, mpackint * rank, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Rgelsy ( mpackint m, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, mpackint *jpvt, double rcond, mpackint *rank, double * work, mpackint lwork, mpackint *info );
void Cgelsy ( mpackint m, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint * jpvt, double rcond, mpackint * rank, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Rgeqlf ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cgeqlf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgeqpf ( mpackint m, mpackint n, double * A, mpackint lda, mpackint *jpvt, double * tau, double * work, mpackint *info );
void Cgeqpf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, mpackint *jpvt, std::complex<double> * tau, std::complex<double> * work, double * rwork, mpackint *info );
void Rgeqp3 ( mpackint m, mpackint n, double * A, mpackint lda, mpackint *jpvt, double * tau, double * work, mpackint lwork, mpackint *info );
void Cgeqp3 ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, mpackint *jpvt, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *info );
void Rgeqrf ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cgeqrf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgerfs ( const char *trans, mpackint n, mpackint nrhs, double * A, mpackint lda, double * af, mpackint ldaf, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cgerfs ( const char *trans, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rgerqf ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cgerqf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgesdd ( const char *jobz, mpackint m, mpackint n, double * A, mpackint lda, double * s, double * u, mpackint ldu, double * vt, mpackint ldvt, double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgesdd ( const char *jobz, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * s, std::complex<double> * u, mpackint ldu, std::complex<double> * vt, mpackint ldvt, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * iwork, mpackint * info );
void Rgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, double * A, mpackint lda, double * s, double * u, mpackint ldu, double * vt, mpackint ldvt, double * work, mpackint lwork, mpackint * info );
void Cgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, double * s, std::complex<double> * u, mpackint ldu, std::complex<double> * vt, mpackint ldvt, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Rgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, double * A, mpackint lda, double * af, mpackint ldaf, mpackint * ipiv, char *equed, double * r, double * c, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint * iwork, mpackint * info );
void Cgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, mpackint * ipiv, char *equed, double * r, double * c, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint * info );
void Rggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, double * lscale, double * rscale, mpackint m, double * v, mpackint ldv, mpackint *info );
void Cggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, double * lscale, double * rscale, mpackint m, std::complex<double> * v, mpackint ldv, mpackint *info );
void Rggbal ( const char *job, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, mpackint *ilo, mpackint *ihi, double * lscale, double * rscale, double * work, mpackint *info );
void Cggbal ( const char *job, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint *ilo, mpackint *ihi, double * lscale, double * rscale, double * work, mpackint *info );
void Rgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, mpackint * sdim, double * alphar, double * alphai, double * beta, double * vsl, mpackint ldvsl, double * vsr, mpackint ldvsr, double * work, mpackint lwork, mpacklogical * bwork, mpackint * info );
void Cgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint * sdim, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * vsl, mpackint ldvsl, std::complex<double> * vsr, mpackint ldvsr, std::complex<double> * work, mpackint lwork, double * rwork, mpacklogical * bwork, mpackint * info );
void Rgegs ( const char *jobvsl, const char *jobvsr, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * alphar, double * alphai, double * beta, double * vsl, mpackint ldvsl, double * vsr, mpackint ldvsr, double * work, mpackint lwork, mpackint *info );
void Cgegs ( const char *jobvsl, const char *jobvsr, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * vsl, mpackint ldvsl, std::complex<double> * vsr, mpackint ldvsr, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Rggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, mpackint * sdim, double * alphar, double * alphai, double * beta, double * vsl, mpackint ldvsl, double * vsr, mpackint ldvsr, double * rconde, double * rcondv, double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint * sdim, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * vsl, mpackint ldvsl, std::complex<double> * vsr, mpackint ldvsr, double * rconde, double * rcondv, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Rggev ( const char *jobvl, const char *jobvr, mpackint n, double * A, mpackint lda, double * b, mpackint ldb, double * alphar, double * alphai, double * beta, double * vl, mpackint ldvl, double * vr, mpackint ldvr, double * work, mpackint lwork, mpackint * info );
void Cggev ( const char *jobvl, const char *jobvr, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Rgegv ( const char *jobvl, const char *jobvr, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * alphar, double * alphai, double * beta, double * vl, mpackint ldvl, double * vr, mpackint ldvr, double * work, mpackint lwork, mpackint * info );
void Cgegv ( const char *jobvl, const char *jobvr, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * info );
void Rggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * alphar, double * alphai, double * beta, double * vl, mpackint ldvl, double * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, double * lscale, double * rscale, double * abnrm, double * bbnrm, double * rconde, double * rcondv, double * work, mpackint lwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Cggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, double * lscale, double * rscale, double * abnrm, double * bbnrm, double * rconde, double * rcondv, std::complex<double> * work, mpackint lwork, double * rwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Rggglm ( mpackint n, mpackint m, mpackint p, double * A, mpackint lda, double * B, mpackint ldb, double * d, double * x, double * y, double * work, mpackint lwork, mpackint *info );
void Cggglm ( mpackint n, mpackint m, mpackint p, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * d, std::complex<double> * x, std::complex<double> * y, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, double * A, mpackint lda, double * B, mpackint ldb, double * q, mpackint ldq, double * z, mpackint ldz, mpackint *info );
void Cgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * q, mpackint ldq, std::complex<double> * z, mpackint ldz, mpackint *info );
void Rgglse ( mpackint m, mpackint n, mpackint p, double * A, mpackint lda, double * B, mpackint ldb, double * c, double * d, double * x, double * work, mpackint lwork, mpackint *info );
void Cgglse ( mpackint m, mpackint n, mpackint p, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * c, std::complex<double> * d, std::complex<double> * x, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rggqrf ( mpackint n, mpackint m, mpackint p, double * A, mpackint lda, double * taua, double * B, mpackint ldb, double * taub, double * work, mpackint lwork, mpackint *info );
void Cggqrf ( mpackint n, mpackint m, mpackint p, std::complex<double> * A, mpackint lda, std::complex<double> * taua, std::complex<double> * B, mpackint ldb, std::complex<double> * taub, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rggrqf ( mpackint m, mpackint p, mpackint n, double * A, mpackint lda, double * taua, double * B, mpackint ldb, double * taub, double * work, mpackint lwork, mpackint *info );
void Cggrqf ( mpackint m, mpackint p, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * taua, std::complex<double> * B, mpackint ldb, std::complex<double> * taub, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, double * A, mpackint lda, double * B, mpackint ldb, double * alpha, double * beta, double * u, mpackint ldu, double * v, mpackint ldv, double * q, mpackint ldq, double * work, mpackint *iwork, mpackint *info );
void Cggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double * alpha, double * beta, std::complex<double> * u, mpackint ldu, std::complex<double> * v, mpackint ldv, std::complex<double> * q, mpackint ldq, std::complex<double> * work, double * rwork, mpackint *iwork, mpackint *info );
void Rggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double tola, double tolb, mpackint *k, mpackint *l, double * u, mpackint ldu, double * v, mpackint ldv, double * q, mpackint ldq, mpackint *iwork, double * tau, double * work, mpackint *info );
void Cggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double tola, double tolb, mpackint *k, mpackint *l, std::complex<double> * u, mpackint ldu, std::complex<double> * v, mpackint ldv, std::complex<double> * q, mpackint ldq, mpackint *iwork, double * rwork, std::complex<double> * tau, std::complex<double> * work, mpackint *info );
void Rgtcon ( const char *norm, mpackint n, double * dl, double * d, double * du, double * du2, mpackint *ipiv, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Cgtcon ( const char *norm, mpackint n, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * du2, mpackint *ipiv, double anorm, double * rcond, std::complex<double> * work, mpackint *info );
void Rgtrfs ( const char *trans, mpackint n, mpackint nrhs, double * dl, double * d, double * du, double * dlf, double * df, double * duf, double * du2, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cgtrfs ( const char *trans, mpackint n, mpackint nrhs, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * dlf, std::complex<double> * df, std::complex<double> * duf, std::complex<double> * du2, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rgtsv ( mpackint n, mpackint nrhs, double * dl, double * d, double * du, double * B, mpackint ldb, mpackint *info );
void Cgtsv ( mpackint n, mpackint nrhs, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, double * dl, double * d, double * du, double * dlf, double * df, double * duf, double * du2, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * dlf, std::complex<double> * df, std::complex<double> * duf, std::complex<double> * du2, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rgttrf ( mpackint n, double * dl, double * d, double * du, double * du2, mpackint *ipiv, mpackint *info );
void Cgttrf ( mpackint n, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * du2, mpackint *ipiv, mpackint *info );
void Rgttrs ( const char *trans, mpackint n, mpackint nrhs, double * dl, double * d, double * du, double * du2, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Cgttrs ( const char *trans, mpackint n, mpackint nrhs, std::complex<double> * dl, std::complex<double> * d, std::complex<double> * du, std::complex<double> * du2, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rhgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, double * h, mpackint ldh, double * t, mpackint ldt, double * alphar, double * alphai, double * beta, double * q, mpackint ldq, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *info );
void Chgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * h, mpackint ldh, std::complex<double> * t, mpackint ldt, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * q, mpackint ldq, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *info );
void Rhsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical *select, mpackint n, double * h, mpackint ldh, double * wr, double * wi, double * vl, mpackint ldvl, double * vr, mpackint ldvr, mpackint mm, mpackint m, double * work, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Chsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical * select, mpackint n, std::complex<double> * h, mpackint ldh, std::complex<double> * w, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, mpackint mm, mpackint *m, std::complex<double> * work, double * rwork, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Rhseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, double * h, mpackint ldh, double * wr, double * wi, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *info );
void Chseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * h, mpackint ldh, std::complex<double> * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, mpackint *info );
void Ropgtr ( const char *uplo, mpackint n, double * ap, double * tau, double * q, mpackint ldq, double * work, mpackint *info );
void Cupgtr ( const char *uplo, mpackint n, std::complex<double> * ap, std::complex<double> * tau, std::complex<double> * q, mpackint ldq, std::complex<double> * work, mpackint *info );
void Ropmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, double * ap, double * tau, double * c, mpackint ldc, double * work, mpackint *info );
void Cupmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, std::complex<double> * ap, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint *info );
void Rorgbr ( const char *vect, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cungbr ( const char *vect, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rorghr ( mpackint n, mpackint ilo, mpackint ihi, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cunghr ( mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rorglq ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cunglq ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rorgrq ( mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Cungrq ( mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rormtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * c, mpackint ldc, double * work, mpackint lwork, mpackint *info );
void Cunmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * c, mpackint ldc, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rpbcon ( const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Cpbcon ( const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, double anorm, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rpbequ ( const char *uplo, mpackint n, mpackint kd, double * ab, mpackint ldab, double * s, double * scond, double * amax, mpackint *info );
void Cpbequ ( const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, double * s, double * scond, double * amax, mpackint *info );
void Rpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, double * AB, mpackint ldab, double * afb, mpackint ldafb, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<double> * AB, mpackint ldab, std::complex<double> * afb, mpackint ldafb, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rpbstf ( const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, mpackint *info );
void Cpbstf ( const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, mpackint *info );
void Rpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, double * AB, mpackint ldab, double * B, mpackint ldb, mpackint *info );
void Cpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<double> * ab, mpackint ldab, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, double * AB, mpackint ldab, double * afb, mpackint ldafb, char *equed, double * s, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint * iwork, mpackint * info );
void Cpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<double> * AB, mpackint ldab, std::complex<double> * afb, mpackint ldafb, char *equed, double * s, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint * info );
void Rpbtrf ( const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, mpackint *info );
void Cpbtrf ( const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, mpackint *info );
void Rpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, double * ab, mpackint ldab, double * B, mpackint ldb, mpackint *info );
void Cpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<double> * AB, mpackint ldab, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rpocon ( const char *uplo, mpackint n, double * A, mpackint lda, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Cpocon ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double anorm, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rpoequ ( mpackint n, double * A, mpackint lda, double * s, double * scond, double * amax, mpackint *info );
void Cpoequ ( mpackint n, std::complex<double> * A, mpackint lda, double * s, double * scond, double * amax, mpackint *info );
void Rporfs ( const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, double * af, mpackint ldaf, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cporfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rposv ( const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, mpackint *info );
void Cposv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, double * af, mpackint ldaf, char *equed, double * s, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint * iwork, mpackint * info );
void Cposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, char *equed, double * s, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint * info );
void Rpotri ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *info );
void Cpotri ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *info );
void Rpotrs ( const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, mpackint *info );
void Cpotrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rppcon ( const char *uplo, mpackint n, double * ap, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Cppcon ( const char *uplo, mpackint n, std::complex<double> * ap, double * anorm, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rppequ ( const char *uplo, mpackint n, double * ap, double * s, double * scond, double * amax, mpackint *info );
void Cppequ ( const char *uplo, mpackint n, std::complex<double> * ap, double * s, double * scond, double * amax, mpackint *info );
void Rpptrf ( const char *uplo, mpackint n, double * ap, mpackint *info );
void Cpptrf ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *info );
void Rpptri ( const char *uplo, mpackint n, double * ap, mpackint *info );
void Cpptri ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *info );
void Rpptrs ( const char *uplo, mpackint n, mpackint nrhs, double * ap, double * B, mpackint ldb, mpackint *info );
void Cpptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rpprfs ( const char *uplo, mpackint n, mpackint nrhs, double * ap, double * afp, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cpprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * afp, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rppsv ( const char *uplo, mpackint n, mpackint nrhs, double * ap, double * B, mpackint ldb, mpackint *info );
void Cppsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, double * ap, double * afp, char *equed, double * s, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * afp, char *equed, double * s, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint * info );
void Rptcon ( mpackint n, double * d, double * e, double anorm, double * rcond, double * work, mpackint *info );
void Cptcon ( mpackint n, double * d, std::complex<double> * e, double anorm, double * rcond, double * rwork, mpackint *info );
void Rpteqr ( const char *compz, mpackint n, double * d, double * e, double * z, mpackint ldz, double * work, mpackint * info );
void Cpteqr ( const char *compz, mpackint n, double * d, double * e, std::complex<double> * z, mpackint ldz, double * work, mpackint *info );
void Rptrfs ( mpackint n, mpackint nrhs, double * d, double * e, double * df, double * ef, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *info );
void Cptrfs ( const char *uplo, mpackint n, mpackint nrhs, double * d, std::complex<double> * e, double * df, std::complex<double> * ef, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rptsv ( mpackint n, mpackint nrhs, double * d, double * e, double * B, mpackint ldb, mpackint *info );
void Cptsv ( mpackint n, mpackint nrhs, double * d, std::complex<double> * e, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rptsvx ( const char *fact, mpackint n, mpackint nrhs, double * d, double * e, double * df, double * ef, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint *info );
void Cptsvx ( const char *fact, mpackint n, mpackint nrhs, double * d, std::complex<double> * e, double * df, std::complex<double> * ef, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rpttrf ( mpackint n, double * d, double * e, mpackint *info );
void Cpttrf ( mpackint n, double * d, std::complex<double> * e, mpackint *info );
void Rpttrs ( mpackint n, mpackint nrhs, double * d, double * e, double * B, mpackint ldb, mpackint *info );
void Cpttrs ( const char *uplo, mpackint n, mpackint nrhs, double * d, std::complex<double> * e, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rsbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, double * w, double * z, mpackint ldz, double * work, mpackint *info );
void Chbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint *info );
void Rsbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, double * w, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, double * q, mpackint ldq, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, double * z, mpackint ldz, double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, std::complex<double> * q, mpackint ldq, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint * iwork, mpackint * ifail, mpackint * info );
void Rsbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, double * AB, mpackint ldab, double * bb, mpackint ldbb, double * x, mpackint ldx, double * work, mpackint *info );
void Chbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<double> * AB, mpackint ldab, std::complex<double> * bb, mpackint ldbb, std::complex<double> * x, mpackint ldx, std::complex<double> * work, double * rwork, mpackint *info );
void Rsbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, double * AB, mpackint ldab, double * bb, mpackint ldbb, double * w, double * z, mpackint ldz, double * work, mpackint *info );
void Chbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<double> * AB, mpackint ldab, std::complex<double> * bb, mpackint ldbb, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint *info );
void Rsbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, double * AB, mpackint ldab, double * BB, mpackint ldbb, double * w, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<double> * AB, mpackint ldab, std::complex<double> * BB, mpackint ldbb, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, double * AB, mpackint ldab, double * BB, mpackint ldbb, double * q, mpackint ldq, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, double * z, mpackint ldz, double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<double> * ab, mpackint ldab, std::complex<double> * bb, mpackint ldbb, std::complex<double> * q, mpackint ldq, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, double * AB, mpackint ldab, double * d, double * e, double * q, mpackint ldq, double * work, mpackint *info );
void Chbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, double * d, double * e, std::complex<double> * q, mpackint ldq, std::complex<double> * work, mpackint *info );
void Rspcon ( const char *uplo, mpackint n, double * ap, mpackint *ipiv, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Cspcon ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *ipiv, double anorm, double * rcond, std::complex<double> * work, mpackint *info );
void Chpcon ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *ipiv, double anorm, double * rcond, std::complex<double> * work, mpackint *info );
void Rspev ( const char *jobz, const char *uplo, mpackint n, double * ap, double * w, double * z, mpackint ldz, double * work, mpackint *info );
void Chpev ( const char *jobz, const char *uplo, mpackint n, std::complex<double> * ap, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint *info );
void Rspevd ( const char *jobz, const char *uplo, mpackint n, double * ap, double * w, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpevd ( const char *jobz, const char *uplo, mpackint n, std::complex<double> * ap, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspevx ( const char *jobz, const char *range, const char *uplo, mpackint n, double * ap, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, double * z, mpackint ldz, double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpevx ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<double> * ap, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rspgst ( mpackint itype, const char *uplo, mpackint n, double * ap, double * bp, mpackint *info );
void Chpgst ( mpackint *itype, const char *uplo, mpackint n, std::complex<double> * ap, std::complex<double> * bp, mpackint *info );
void Rspgv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, double * ap, double * bp, double * w, double * z, mpackint ldz, double * work, mpackint *info );
void Chpgv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, std::complex<double> * ap, std::complex<double> * bp, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint *info );
void Rspgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, double * ap, double * bp, double * w, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, std::complex<double> * ap, std::complex<double> * bp, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspgvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, double * ap, double * bp, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint m, double * w, double * z, mpackint ldz, double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpgvx ( mpackint itype, const char *jobz, char *range, const char *uplo, mpackint n, std::complex<double> * ap, std::complex<double> * bp, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsprfs ( const char *uplo, mpackint n, mpackint nrhs, double * ap, double * afp, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Csprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * afp, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Chprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * afp, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rspsv ( const char *uplo, mpackint n, mpackint nrhs, double * ap, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Cspsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Chpsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, double * ap, double * afp, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Cspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * afp, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Chpsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * afp, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rsptrd ( const char *uplo, mpackint n, double * ap, double * d, double * e, double * tau, mpackint *info );
void Chptrd ( const char *uplo, mpackint n, std::complex<double> * ap, double * d, double * e, std::complex<double> * tau, mpackint *info );
void Rsptrf ( const char *uplo, mpackint n, double * ap, mpackint *ipiv, mpackint *info );
void Csptrf ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *ipiv, mpackint *info );
void Chptrf ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *ipiv, mpackint *info );
void Rsptri ( const char *uplo, mpackint n, double * ap, mpackint *ipiv, double * work, mpackint *info );
void Csptri ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *ipiv, std::complex<double> * work, mpackint *info );
void Chptri ( const char *uplo, mpackint n, std::complex<double> * ap, mpackint *ipiv, std::complex<double> * work, mpackint *info );
void Rsptrs ( const char *uplo, mpackint n, mpackint nrhs, double * ap, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Csptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Chptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * ap, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rstebz ( const char *range, const char *order, mpackint n, double vl, double vu, mpackint il, mpackint iu, double abstol, double * d, double * e, mpackint * m, mpackint * nsplit, double * w, mpackint *iblock, mpackint *isplit, double * work, mpackint *iwork, mpackint *info );
void Rstedc ( const char *compz, mpackint n, double * d, double * e, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cstedc ( const char *compz, mpackint n, double * d, double * e, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstegr ( const char *jobz, const char *range, mpackint n, double * d, double * e, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, double * z, mpackint ldz, mpackint * isuppz, double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstegr ( const char *jobz, const char *range, mpackint n, double *d, double * e, double * vl, double * vu, mpackint *il, mpackint *iu, double * abstol, mpackint m, double * w, std::complex<double> * z, mpackint ldz, mpackint *isuppz, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstein ( mpackint n, double * d, double * e, mpackint m, double * w, mpackint *iblock, mpackint *isplit, double * z, mpackint ldz, double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cstein ( mpackint n, double * d, double * e, mpackint m, double * w, mpackint *iblock, mpackint *isplit, std::complex<double> * z, mpackint ldz, double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstev ( const char *jobz, mpackint n, double * d, double * e, double * z, mpackint ldz, double * work, mpackint *info );
void Rstevd ( const char *jobz, mpackint n, double * d, double * e, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstevr ( const char *jobz, const char *range, mpackint n, double * d, double * e, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, double * z, mpackint ldz, mpackint * isuppz, double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rstevx ( const char *jobz, const char *range, mpackint n, double * d, double * e, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, double * z, mpackint ldz, double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstemr ( const char *jobz, const char *range, mpackint n, double * d, double * e, double vl, double vu, mpackint il, mpackint iu, mpackint * m, double * w, double * z, mpackint ldz, mpackint nzc, mpackint * isuppz, mpacklogical * tryrac, double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstemr ( const char *jobz, const char *range, mpackint n, double * d, double * e, double vl, double vu, mpackint il, mpackint iu, mpackint * m, double * w, std::complex<double> * z, mpackint ldz, mpackint nzc, mpackint *isuppz, mpacklogical * tryrac, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsycon ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *ipiv, double anorm, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Csycon ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, double anorm, double * rcond, std::complex<double> * work, mpackint *info );
void Checon ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, double anorm, double * rcond, std::complex<double> * work, mpackint *info );
void Rsyevd ( const char *jobz, const char *uplo, mpackint n, double * A, mpackint lda, double * w, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cheevd ( const char *jobz, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double * w, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsyevr ( const char *jobz, const char *range, const char *uplo, mpackint n, double * A, mpackint lda, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, double * z, mpackint ldz, mpackint * isuppz, double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cheevr ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, std::complex<double> * z, mpackint ldz, mpackint * isuppz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rsyevx ( const char *jobz, const char *range, const char *uplo, mpackint n, double * A, mpackint lda, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cheevx ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsygst ( mpackint itype, const char *uplo, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, mpackint *info );
void Chegst ( mpackint itype, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rsygv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * w, double * work, mpackint lwork, mpackint *info );
void Chegv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double * w, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *info );
void Rsygvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * w, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chegvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double * w, std::complex<double> * work, mpackint lwork, double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsygvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint *m, double * w, double * z, mpackint ldz, double * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chegvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double vl, double vu, mpackint il, mpackint iu, double abstol, mpackint * m, double * w, std::complex<double> * z, mpackint ldz, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsyrfs ( const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, double * af, mpackint ldaf, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Csyrfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Cherfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rsysv ( const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, mpackint *ipiv, double * B, mpackint ldb, double * work, mpackint lwork, mpackint *info );
void Csysv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * work, mpackint lwork, mpackint *info );
void Chesv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rsysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, double * af, mpackint ldaf, mpackint *ipiv, double * B, mpackint ldb, double * x, mpackint ldx, double * rcond, double * ferr, double * berr, double * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Csysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *info );
void Chesvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * af, mpackint ldaf, mpackint *ipiv, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * rcond, double * ferr, double * berr, std::complex<double> * work, mpackint lwork, double * rwork, mpackint *info );
void Rsytrf ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *ipiv, double * work, mpackint lwork, mpackint *info );
void Csytrf ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * work, mpackint lwork, mpackint *info );
void Chetrf ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rsytri ( const char *uplo, mpackint n, double * A, mpackint lda, mpackint *ipiv, double * work, mpackint *info );
void Csytri ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * work, mpackint *info );
void Chetri ( const char *uplo, mpackint n, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * work, mpackint *info );
void Rsytrs ( const char *uplo, mpackint n, mpackint nrhs, double * A, mpackint lda, mpackint *ipiv, double * B, mpackint ldb, mpackint *info );
void Csytrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Chetrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, mpackint *ipiv, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rtbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, double * AB, mpackint ldab, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Ctbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, std::complex<double> * AB, mpackint ldab, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rtbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, double * AB, mpackint ldab, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Ctbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, std::complex<double> * AB, mpackint ldab, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint * info );
void Rtbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, double * ab, mpackint ldab, double * B, mpackint ldb, mpackint *info );
void Ctbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, std::complex<double> * ab, mpackint ldab, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rtgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, double * s, mpackint lds, double *p, mpackint ldp, double * vl, mpackint ldvl, double * vr, mpackint ldvr, mpackint mm, mpackint *m, double * work, mpackint * info );
void Ctgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, std::complex<double> * s, mpackint lds, std::complex<double> * p, mpackint ldp, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, mpackint mm, mpackint * m, std::complex<double> * work, double * rwork, mpackint * info );
void Rtgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * q, mpackint ldq, double * z, mpackint ldz, mpackint * ifst, mpackint * ilst, double * work, mpackint lwork, mpackint * info );
void Ctgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * q, mpackint ldq, std::complex<double> * z, mpackint ldz, mpackint ifst, mpackint *ilst, mpackint *info );
void Rtgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical *select, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * alphar, double * alphai, double * beta, double * q, mpackint ldq, double * z, mpackint ldz, mpackint * m, double * pl, double * pr, double * dif, double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Ctgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical * select, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * alpha, std::complex<double> * beta, std::complex<double> * q, mpackint ldq, std::complex<double> * z, mpackint ldz, mpackint * m, double * pl, double * pr, double * dif, std::complex<double> * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rtgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, double * A, mpackint lda, double * B, mpackint ldb, double tola, double tolb, double * alpha, double * beta, double * u, mpackint ldu, double * v, mpackint ldv, double * q, mpackint ldq, double * work, mpackint ncycle, mpackint *info );
void Ctgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, double tola, double tolb, double * alpha, double * beta, std::complex<double> * u, mpackint ldu, std::complex<double> * v, mpackint ldv, std::complex<double> * q, mpackint ldq, std::complex<double> * work, mpackint * ncycle, mpackint *info );
void Rtgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * vl, mpackint ldvl, double * vr, mpackint ldvr, double * s, double * dif, mpackint mm, mpackint * m, double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, double * s, double * dif, mpackint mm, mpackint * m, std::complex<double> * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * c, mpackint ldc, double * d, mpackint ldd, double * e, mpackint lde, double * f, mpackint ldf, double * scale, double * dif, double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * c, mpackint ldc, std::complex<double> * d, mpackint ldd, std::complex<double> * e, mpackint lde, std::complex<double> * f, mpackint ldf, double * scale, double * dif, std::complex<double> * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, double * ap, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Ctpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<double> * ap, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rtprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, double * ap, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Ctprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rtptri ( const char *uplo, const char *diag, mpackint n, double * ap, mpackint *info );
void Ctptri ( const char *uplo, const char *diag, mpackint n, std::complex<double> * ap, mpackint *info );
void Rtptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, double * ap, double * B, mpackint ldb, mpackint *info );
void Ctptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<double> * ap, std::complex<double> * B, mpackint ldb, mpackint *info );
void Rtrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, double * A, mpackint lda, double * rcond, double * work, mpackint *iwork, mpackint *info );
void Ctrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<double> * A, mpackint lda, double * rcond, std::complex<double> * work, double * rwork, mpackint *info );
void Rtrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, double * t, mpackint ldt, double * vl, mpackint ldvl, double * vr, mpackint ldvr, mpackint mm, mpackint *m, double * work, mpackint *info );
void Ctrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, std::complex<double> * t, mpackint ldt, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, mpackint mm, mpackint *m, std::complex<double> * work, double * rwork, mpackint *info );
void Rtrexc ( const char *compq, mpackint n, double * t, mpackint ldt, double * q, mpackint ldq, mpackint *ifst, mpackint *ilst, double * work, mpackint *info );
void Ctrexc ( const char *compq, mpackint n, std::complex<double> * t, mpackint ldt, std::complex<double> * q, mpackint ldq, mpackint ifst, mpackint ilst, mpackint *info );
void Rtrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, double * A, mpackint lda, double * B, mpackint ldb, double * x, mpackint ldx, double * ferr, double * berr, double * work, mpackint *iwork, mpackint *info );
void Ctrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * x, mpackint ldx, double * ferr, double * berr, std::complex<double> * work, double * rwork, mpackint *info );
void Rtrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, double * t, mpackint ldt, double * q, mpackint ldq, double * wr, double * wi, mpackint m, double * s, double * sep, double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Ctrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, std::complex<double> * t, mpackint ldt, std::complex<double> * q, mpackint ldq, std::complex<double> * w, mpackint m, double * s, double * sep, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rtrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, double * t, mpackint ldt, double * vl, mpackint ldvl, double * vr, mpackint ldvr, double * s, double * sep, mpackint mm, mpackint *m, double * work, mpackint ldwork, mpackint *iwork, mpackint *info );
void Ctrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, std::complex<double> * t, mpackint ldt, std::complex<double> * vl, mpackint ldvl, std::complex<double> * vr, mpackint ldvr, double * s, double * sep, mpackint mm, mpackint *m, std::complex<double> * work, mpackint ldwork, double * rwork, mpackint *info );
void Rtrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, double * A, mpackint lda, double * B, mpackint ldb, double * c, mpackint ldc, double * scale, mpackint *info );
void Ctrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * B, mpackint ldb, std::complex<double> * c, mpackint ldc, double * scale, mpackint *info );
void Rtzrzf ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, double * work, mpackint lwork, mpackint *info );
void Ctzrzf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, std::complex<double> * work, mpackint lwork, mpackint *info );
void Rtzrqf ( mpackint m, mpackint n, double * A, mpackint lda, double * tau, mpackint *info );
void Ctzrqf ( mpackint m, mpackint n, std::complex<double> * A, mpackint lda, std::complex<double> * tau, mpackint *info );

#endif
