/*
 * Copyright (c) 2008-2010
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mlapack_gmp.h,v 1.34 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MLAPACK_GMP_H_
#define _MLAPACK_GMP_H_

#include "mpack_config.h"
#include "gmpxx.h"
#include "mpc_class.h"

/* MLAPACK prototypes */

/* MLAPACK driver routines */
void Rsyev ( const char *jobz, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * w, mpf_class * work, mpackint lwork, mpackint *info );
void Cheev ( const char *jobz, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * w, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *info );
void Rgesv ( mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Cgesv ( mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );

/* MLAPACK computational routines */
void Rsteqr ( const char *compz, mpackint n, mpf_class * d, mpf_class * e, mpf_class * Z, mpackint ldz, mpf_class * work, mpackint *info );
void Csteqr ( const char *compz, mpackint n, mpf_class * d, mpf_class * e, mpc_class * z, mpackint ldz, mpf_class * work, mpackint *info );
void Rsterf ( mpackint n, mpf_class * d, mpf_class * e, mpackint *info );
void Rorgqr ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cungqr ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rorgql ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cungql ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rsytrd ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Chetrd ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rorgtr ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cungtr ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rpotrf ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Cpotrf ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rtrtri ( const char *uplo, const char *diag, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Ctrtri ( const char *uplo, const char *diag, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rgetrf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetrf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rgetri ( mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * work, mpackint lwork, mpackint *info );
void Cgetri ( mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * work, mpackint lwork, mpackint *info );
void Rgetrs ( const char *trans, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Cgetrs ( const char *trans, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Rtrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *info );
void Ctrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint *info );

/* MLAPACK Auxiliary routines */
mpf_class Rlamc3 ( mpf_class a, mpf_class b );
mpf_class Rlamch_gmp(const char *cmach);
mpackint iMlaenv_gmp(mpackint ispec, const char *name, const char *opts, mpackint n1, mpackint n2, mpackint n3, mpackint n4);
void Rlae2 ( mpf_class a, mpf_class b, mpf_class c, mpf_class * rt1, mpf_class * rt2 );
void Rlaev2 ( mpf_class a, mpf_class b, mpf_class c, mpf_class * rt1, mpf_class * rt2, mpf_class * cs1, mpf_class * sn1 );
void Claev2 ( mpc_class a, mpc_class b, mpc_class c, mpf_class * rt1, mpf_class * rt2, mpf_class * cs1, mpc_class * sn1 );
void Rlassq ( mpackint n, mpf_class * x, mpackint incx, mpf_class * scale, mpf_class * sumsq );
void Classq ( mpackint n, mpc_class * x, mpackint incx, mpf_class * scale, mpf_class * sumsq );
mpf_class Rlanst ( const char *norm, mpackint n, mpf_class * d, mpf_class * e );
mpf_class Clanht ( const char *norm, mpackint n, mpf_class * d, mpc_class * e );
mpf_class Rlansy ( const char *norm, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * work );
mpf_class Clansy ( const char *norm, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * work );
mpf_class Clanhe ( const char *norm, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * work );
mpf_class Rlapy2 ( mpf_class x, mpf_class y );
void Rlarfg ( mpackint N, mpf_class * alpha, mpf_class * x, mpackint incx, mpf_class * tau );
mpf_class Rlapy3 ( mpf_class x, mpf_class y, mpf_class z );
void Rladiv ( mpf_class a, mpf_class b, mpf_class c, mpf_class d, mpf_class * p, mpf_class * q );
mpc_class Cladiv ( mpc_class x, mpc_class y );
void Clarfg ( mpackint n, mpc_class * alpha, mpc_class * x, mpackint incx, mpc_class * tau );
void Rlartg ( mpf_class f, mpf_class g, mpf_class * cs, mpf_class * sn, mpf_class * r );
void Clartg ( mpc_class f, mpc_class g, mpf_class * cs, mpc_class * sn, mpc_class * r );
void Rlaset ( const char *uplo, mpackint m, mpackint n, mpf_class alpha, mpf_class beta, mpf_class * A, mpackint lda );
void Claset ( const char *uplo, mpackint m, mpackint n, mpc_class alpha, mpc_class beta, mpc_class * A, mpackint lda );
void Rlasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, mpf_class * c, mpf_class * s, mpf_class * A, mpackint lda );
void Clasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, mpf_class * c, mpf_class * s, mpc_class * A, mpackint lda );
void Rpotf2 ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Clacgv ( mpackint n, mpc_class * x, mpackint incx );
void Cpotf2 ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rlascl ( const char *type, mpackint kl, mpackint ku, mpf_class cfrom, mpf_class cto, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Clascl ( const char *type, mpackint kl, mpackint ku, mpf_class cfrom, mpf_class cto, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rlasrt ( const char *id, mpackint n, mpf_class * d, mpackint *info );
void Rsytd2 ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpf_class * tau, mpackint *info );
void Chetd2 ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpc_class * tau, mpackint *info );
void Rlarf ( const char *side, mpackint m, mpackint n, mpf_class * v, mpackint incv, mpf_class tau, mpf_class * C, mpackint ldc, mpf_class * work );
void Clarf ( const char *side, mpackint m, mpackint n, mpc_class * v, mpackint incv, mpc_class tau, mpc_class * c, mpackint ldc, mpc_class * work );
void Rorg2l ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cung2l ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rorg2r ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cung2r ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rlarft ( const char *direct, const char *storev, mpackint n, mpackint k, mpf_class * v, mpackint ldv, mpf_class * tau, mpf_class * t, mpackint ldt );
void Clarft ( const char *direct, const char *storev, mpackint n, mpackint k, mpc_class * v, mpackint ldv, mpc_class * tau, mpc_class * t, mpackint ldt );
void Rlarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpf_class * V, mpackint ldv, mpf_class * T, mpackint ldt, mpf_class * C, mpackint ldc, mpf_class * work, mpackint ldwork );
void Clarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpc_class * V, mpackint ldv, mpc_class * T, mpackint ldt, mpc_class * C, mpackint ldc, mpc_class * work, mpackint ldwork );
void Rlatrd ( const char *uplo, mpackint n, mpackint nb, mpf_class * A, mpackint lda, mpf_class * e, mpf_class * tau, mpf_class * w, mpackint ldw );
void Clatrd ( const char *uplo, mpackint n, mpackint nb, mpc_class * A, mpackint lda, mpf_class * e, mpc_class * tau, mpc_class * w, mpackint ldw );
void Clacrm ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpc_class * c, mpackint ldc, mpf_class * rwork );
void Rtrti2 ( const char *uplo, const char *diag, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Ctrti2 ( const char *uplo, const char *diag, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rgetf2 ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetf2 ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rlaswp ( mpackint n, mpf_class * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Claswp ( mpackint n, mpc_class * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Rlasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * w, mpackint ldw, mpackint *info );
void Clasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * w, mpackint ldw, mpackint *info );
void Clahef ( const char *uplo, mpackint n, mpackint nb, mpackint kb, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * w, mpackint ldw, mpackint *info );
void Clacrt ( mpackint n, mpc_class * cx, mpackint incx, mpc_class * cy, mpackint incy, mpc_class c, mpc_class s );
void Claesy ( mpc_class a, mpc_class b, mpc_class c, mpc_class * rt1, mpc_class * rt2, mpc_class * evscal, mpc_class * cs1, mpc_class * sn1 );
void Crot ( mpackint n, mpc_class * cx, mpackint incx, mpc_class * cy, mpackint incy, mpf_class c, mpc_class s );
void Cspmv ( const char *uplo, mpackint n, mpc_class alpha, mpc_class * AP, mpc_class * x, mpackint incx, mpc_class beta, mpc_class * y, mpackint incy );
void Cspr ( const char *uplo, mpackint n, mpc_class alpha, mpc_class * x, mpackint incx, mpc_class * AP );
void Csymv ( const char *uplo, mpackint n, mpc_class alpha, mpc_class * A, mpackint lda, mpc_class * x, mpackint incx, mpc_class beta, mpc_class * y, mpackint incy );
void Csyr ( const char *uplo, mpackint n, mpc_class alpha, mpc_class * x, mpackint incx, mpc_class * A, mpackint lda );
mpackint iCmax1 ( mpackint n, mpc_class * cx, mpackint incx );
mpf_class RCsum1 ( mpackint n, mpc_class * cx, mpackint incx );
void Rlacn2 ( mpackint n, mpf_class * v, mpf_class * x, mpackint *isgn, mpf_class * est, mpackint *kase, mpackint *isave );
void Clacn2 ( mpackint n, mpc_class * v, mpc_class * x, mpf_class * est, mpackint *kase, mpackint *isave );
void Rlatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpf_class * A, mpackint lda, mpf_class * x, mpf_class * scale, mpf_class * cnorm, mpackint *info );
void Clatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpc_class * A, mpackint lda, mpc_class * x, mpf_class * scale, mpf_class * cnorm, mpackint *info );

/* not yet done ... auxiliary routines */
void Rgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpf_class * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpc_class * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgebd2 ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpf_class * tauq, mpf_class * taup, mpf_class * work, mpackint *info );
void Cgebd2 ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpc_class * tauq, mpc_class * taup, mpc_class * work, mpackint *info );
void Rgehd2 ( mpackint n, mpackint ilo, mpackint ihi, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cgehd2 ( mpackint n, mpackint ilo, mpackint ihi, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rgelq2 ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cgelq2 ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rgeql2 ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cgeql2 ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rgeqr2 ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cgeqr2 ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rgerq2 ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cgerq2 ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rgesc2 ( mpackint n, mpf_class * A, mpackint lda, mpf_class * rhs, mpackint *ipiv, mpackint *jpiv, mpf_class * scale );
void Cgesc2 ( mpackint n, mpc_class * A, mpackint lda, mpc_class * rhs, mpackint *ipiv, mpackint *jpiv, mpf_class * scale );
void Rgetc2 ( mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Cgetc2 ( mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Rgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * du2, mpackint *ipiv, mpf_class * B, mpackint ldb );
void Cgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * du2, mpackint *ipiv, mpc_class * B, mpackint ldb );
void Rlabrd ( mpackint m, mpackint n, mpackint nb, mpf_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpf_class * tauq, mpf_class * taup, mpf_class * x, mpackint ldx, mpf_class * y, mpackint ldy );
void Clabrd ( mpackint m, mpackint n, mpackint nb, mpc_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpc_class * tauq, mpc_class * taup, mpc_class * x, mpackint ldx, mpc_class * y, mpackint ldy );
void Rlacpy ( const char *uplo, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb );
void Clacpy ( const char *uplo, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb );
void Clarcm ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * c, mpackint ldc, mpf_class * rwork );
void Rlaebz ( mpackint ijob, mpackint nitmax, mpackint n, mpackint mmax, mpackint minp, mpackint nbmin, mpf_class abstol, mpf_class reltol, mpf_class pivmin, mpf_class * d, mpf_class * e, mpf_class * e2, mpackint *nval, mpf_class * AB, mpf_class * c, mpackint *mout, mpackint *nab, mpf_class * work, mpackint *iwork, mpackint *info );
void Rlaed0 ( mpackint icompq, mpackint qsiz, mpackint n, mpf_class * d, mpf_class * e, mpf_class * q, mpackint ldq, mpf_class * qstore, mpackint ldqs, mpf_class * work, mpackint *iwork, mpackint *info );
void Claed0 ( mpackint qsiz, mpackint n, mpf_class * d, mpf_class * e, mpc_class * q, mpackint ldq, mpc_class * qstore, mpackint ldqs, mpf_class * rwork, mpackint *iwork, mpackint *info );
void Rlaed1 ( mpackint n, mpf_class * d, mpf_class * q, mpackint ldq, mpackint *indxq, mpf_class rho, mpackint cutpnt, mpf_class * work, mpackint *iwork, mpackint *info );
void Rlaed2 ( mpackint *k, mpackint n, mpackint n1, mpf_class * d, mpf_class * q, mpackint ldq, mpackint *indxq, mpf_class * rho, mpf_class * z, mpf_class * dlamda, mpf_class * w, mpf_class * q2, mpackint *indx, mpackint *indxc, mpackint *indxp, mpackint *coltyp, mpackint *info );
void Rlaed3 ( mpackint k, mpackint n, mpackint n1, mpf_class * d, mpf_class * q, mpackint ldq, mpf_class * rho, mpf_class * dlamda, mpf_class * q2, mpackint *indx, mpackint *ctot, mpf_class * w, mpf_class * s, mpackint *info );
void Rlaed4 ( mpackint n, mpackint i, mpf_class * d, mpf_class * z, mpf_class * delta, mpf_class rho, mpf_class * dlam, mpackint *info );
void Rlaed5 ( mpackint i, mpf_class * d, mpf_class * z, mpf_class * delta, mpf_class rho, mpf_class * dlam );
void Rlaed6 ( mpackint kniter, mpackint orgati, mpf_class rho, mpf_class * d, mpf_class * z, mpf_class * finit, mpf_class * tau, mpackint *info );
void Rlaed7 ( mpackint icompq, mpackint n, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpf_class * d, mpf_class * q, mpackint ldq, mpackint *indxq, mpf_class rho, mpackint cutpnt, mpf_class * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, mpf_class * givnum, mpf_class * work, mpackint *iwork, mpackint *info );
void Claed7 ( mpackint n, mpackint cutpnt, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpf_class * d, mpc_class * q, mpackint ldq, mpf_class rho, mpackint *indxq, mpf_class * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, mpf_class * givnum, mpc_class * work, mpf_class * rwork, mpackint *iwork, mpackint *info );
void Rlaed8 ( mpackint icompq, mpackint *k, mpackint n, mpackint qsiz, mpf_class * d, mpf_class * q, mpackint ldq, mpackint *indxq, mpf_class * rho, mpackint cutpnt, mpf_class * z, mpf_class * dlamda, mpf_class * q2, mpackint ldq2, mpf_class * w, mpackint *perm, mpackint *givptr, mpackint *givcol, mpf_class * givnum, mpackint *indxp, mpackint *indx, mpackint *info );
void Claed8 ( mpackint *k, mpackint n, mpackint qsiz, mpc_class * q, mpackint ldq, mpf_class * d, mpf_class * rho, mpackint cutpnt, mpf_class * z, mpf_class * dlamda, mpc_class * q2, mpackint ldq2, mpf_class * w, mpackint *indxp, mpackint *indx, mpackint *indxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpf_class * givnum, mpackint *info );
void Rlaed9 ( mpackint k, mpackint kstart, mpackint kstop, mpackint n, mpf_class * d, mpf_class * q, mpackint ldq, mpf_class rho, mpf_class * dlamda, mpf_class * w, mpf_class * s, mpackint lds, mpackint *info );
void Rlaeda ( mpackint n, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, mpf_class * givnum, mpf_class * q, mpackint *qptr, mpf_class * z, mpf_class * ztemp, mpackint *info );
void Rlaein ( mpackint rightv, mpackint noinit, mpackint n, mpf_class * h, mpackint ldh, mpf_class wr, mpf_class wi, mpf_class * vr, mpf_class * vi, mpf_class * B, mpackint ldb, mpf_class * work, mpf_class eps3, mpf_class smlnum, mpf_class bignum, mpackint *info );
void Claein ( mpackint rightv, mpackint noinit, mpackint n, mpc_class * h, mpackint ldh, mpc_class w, mpc_class * v, mpc_class * B, mpackint ldb, mpf_class * rwork, mpf_class eps3, mpf_class smlnum, mpackint *info );
void Rlaexc ( mpackint wantq, mpackint n, mpf_class * t, mpackint ldt, mpf_class * q, mpackint ldq, mpackint j1, mpackint n1, mpackint n2, mpf_class * work, mpackint *info );
void Rlag2 ( mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class safmin, mpf_class * scale1, mpf_class * scale2, mpf_class * wr1, mpf_class * wr2, mpf_class * wi );
void Rlags2 ( mpackint upper, mpf_class a1, mpf_class a2, mpf_class a3, mpf_class b1, mpf_class b2, mpf_class b3, mpf_class * csu, mpf_class * snu, mpf_class * csv, mpf_class * snv, mpf_class * csq, mpf_class * snq );
void Clags2 ( mpacklogical * upper, mpf_class a1, mpc_class a2, mpf_class a3, mpf_class b1, mpc_class b2, mpf_class b3, mpf_class * csu, mpc_class * snu, mpf_class * csv, mpc_class * snv, mpf_class * csq, mpc_class * snq );
void Rlagtf ( mpackint n, mpf_class * a, mpf_class lambda, mpf_class * b, mpf_class * c, mpf_class * tol, mpf_class * d, mpackint *in, mpackint *info );
void Rlagtm ( const char *trans, mpackint n, mpackint nrhs, mpf_class alpha, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * x, mpackint ldx, mpf_class * beta, mpf_class * B, mpackint ldb );
void Clagtm ( const char *trans, mpackint n, mpackint nrhs, mpf_class alpha, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * x, mpackint ldx, mpf_class beta, mpc_class * B, mpackint ldb );
void Rlagts ( mpackint job, mpackint n, mpf_class * a, mpf_class * b, mpf_class * c, mpf_class * d, mpackint *in, mpf_class * y, mpf_class * tol, mpackint *info );
void Rlagv2 ( mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * csl, mpf_class * snl, mpf_class * csr, mpf_class * snr );
void Rlahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, mpf_class * h, mpackint ldh, mpf_class * wr, mpf_class * wi, mpackint iloz, mpackint ihiz, mpf_class * z, mpackint ldz, mpackint *info );
void Clahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, mpc_class * h, mpackint ldh, mpc_class * w, mpackint iloz, mpackint ihiz, mpc_class * z, mpackint ldz, mpackint *info );
void Rlahr2 ( mpackint n, mpackint k, mpackint nb, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * t, mpackint ldt, mpf_class * y, mpackint ldy );
void Clahr2 ( mpackint n, mpackint k, mpackint nb, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * t, mpackint ldt, mpc_class * y, mpackint ldy );
void Rlahrd ( mpackint n, mpackint k, mpackint nb, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * t, mpackint ldt, mpf_class * y, mpackint ldy );
void Clahrd ( mpackint n, mpackint k, mpackint nb, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * t, mpackint ldt, mpc_class * y, mpackint ldy );
void Rlaic1 ( mpackint job, mpackint j, mpf_class * x, mpf_class sest, mpf_class * w, mpf_class gamma, mpf_class * sestpr, mpf_class * s, mpf_class * c );
void Claic1 ( mpackint job, mpackint j, mpc_class * x, mpf_class sest, mpc_class * w, mpc_class gamma, mpf_class * sestpr, mpc_class * s, mpc_class * c );
void Rlaln2 ( mpackint ltrans, mpackint na, mpackint nw, mpf_class smin, mpf_class ca, mpf_class * A, mpackint lda, mpf_class d1, mpf_class d2, mpf_class * B, mpackint ldb, mpf_class wr, mpf_class wi, mpf_class * x, mpackint ldx, mpf_class * scale, mpf_class * xnorm, mpackint *info );
void Rlals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, mpf_class * B, mpackint ldb, mpf_class * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, mpf_class * givnum, mpackint ldgnum, mpf_class * poles, mpf_class * difl, mpf_class * difr, mpf_class * z, mpackint k, mpf_class c, mpf_class s, mpf_class * work, mpackint *info );
void Clals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, mpc_class * B, mpackint ldb, mpc_class * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, mpf_class * givnum, mpackint ldgnum, mpf_class * poles, mpf_class * difl, mpf_class * difr, mpf_class * z, mpackint k, mpf_class c, mpf_class s, mpf_class * rwork, mpackint *info );
void Rlalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, mpf_class * B, mpackint ldb, mpf_class * bx, mpackint ldbx, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint *k, mpf_class * difl, mpf_class * difr, mpf_class * z, mpf_class * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, mpf_class * givnum, mpf_class * c, mpf_class * s, mpf_class * work, mpackint *iwork, mpackint *info );
void Clalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, mpc_class * B, mpackint ldb, mpc_class * bx, mpackint ldbx, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint *k, mpf_class * difl, mpf_class * difr, mpf_class * z, mpf_class * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, mpf_class * givnum, mpf_class * c, mpf_class * s, mpf_class * rwork, mpackint *iwork, mpackint *info );
void Rlalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, mpf_class * d, mpf_class * e, mpf_class * B, mpackint ldb, mpf_class rcond, mpackint *rank, mpf_class * work, mpackint *iwork, mpackint *info );
void Clalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, mpf_class * d, mpf_class * e, mpc_class * B, mpackint ldb, mpf_class rcond, mpackint *rank, mpc_class * work, mpf_class * rwork, mpackint *iwork, mpackint *info );
void Rlamrg ( mpackint n1, mpackint n2, mpf_class * a, mpackint dtrd1, mpackint dtrd2, mpackint *index );
mpf_class Rlangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpf_class * ab, mpackint ldab, mpf_class * work );
mpf_class Clangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpc_class * AB, mpackint ldab, mpf_class * work );
mpf_class Rlange ( const char *norm, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * work );
mpf_class Clange ( const char *norm, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * work );
mpf_class Rlangt ( const char *norm, mpackint n, mpf_class * dl, mpf_class * d, mpf_class * du );
mpf_class Clangt ( const char *norm, mpackint n, mpc_class * dl, mpc_class * d, mpc_class * du );
mpf_class Rlanhs ( const char *norm, mpackint n, mpf_class * A, mpackint lda, mpf_class * work );
mpf_class Clanhs ( const char *norm, mpackint n, mpc_class * A, mpackint lda, mpf_class * work );
mpf_class Rlansb ( const char *norm, const char *uplo, mpackint n, mpackint k, mpf_class * AB, mpackint ldab, mpf_class * work );
mpf_class Clansb ( const char *norm, const char *uplo, mpackint n, mpackint k, mpc_class * AB, mpackint ldab, mpf_class * work );
mpf_class Clanhb ( const char *norm, const char *uplo, mpackint n, mpackint k, mpc_class * AB, mpackint ldab, mpf_class * work );
mpf_class Rlansp ( const char *norm, const char *uplo, mpackint n, mpf_class * ap, mpf_class * work );
mpf_class Clansp ( const char *norm, const char *uplo, mpackint n, mpc_class * ap, mpf_class * work );
mpf_class Clanhp ( const char *norm, const char *uplo, mpackint n, mpc_class * ap, mpf_class * work );
mpf_class Rlantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, mpf_class * AB, mpackint ldab, mpf_class * work );
mpc_class Clantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, mpc_class * AB, mpackint ldab, mpf_class * work );
mpf_class Rlantp ( const char *norm, const char *uplo, const char *diag, mpackint n, mpf_class * ap, mpf_class * work );
mpc_class Clantp ( const char *norm, const char *uplo, const char *diag, mpackint n, mpc_class * ap, mpf_class * work );
mpf_class Rlantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * work );
mpf_class Clantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * work );
void Rlanv2 ( mpf_class * a, mpf_class * b, mpf_class * c, mpf_class * d, mpf_class * rt1r, mpf_class * rt1i, mpf_class * rt2r, mpf_class * rt2i, mpf_class * cs, mpf_class * sn );
void Rlapll ( mpackint n, mpf_class * x, mpackint incx, mpf_class * y, mpackint incy, mpf_class * ssmin );
void Clapll ( mpackint n, mpc_class * x, mpackint incx, mpc_class * y, mpackint incy, mpf_class * ssmin );
void Rlapmt ( mpackint *forwrd, mpackint m, mpackint n, mpf_class * X, mpackint ldx, mpackint *k );
void Clapmt ( mpackint *forwrd, mpackint m, mpackint n, mpc_class * X, mpackint ldx, mpackint *k );
void Rlaqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpf_class * AB, mpackint ldab, mpf_class * r, mpf_class * c, mpf_class rowcnd, mpf_class colcnd, mpf_class amax, char *equed );
void Claqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpc_class * AB, mpackint ldab, mpf_class * r, mpf_class * c, mpf_class rowcnd, mpf_class colcnd, mpf_class amax, char *equed );
void Rlaqge ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * r, mpf_class * c, mpf_class rowcnd, mpf_class colcnd, mpf_class amax, char *equed );
void Claqge ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * r, mpf_class * c, mpf_class rowcnd, mpf_class colcnd, mpf_class amax, char *equed );
void Rlaqp2 ( mpackint m, mpackint n, mpackint offset, mpf_class * A, mpackint lda, mpackint *jpvt, mpf_class * tau, mpf_class * vn1, mpf_class * vn2, mpf_class * work );
void Claqp2 ( mpackint m, mpackint n, mpackint offset, mpc_class * A, mpackint lda, mpackint *jpvt, mpc_class * tau, mpf_class * vn1, mpf_class * vn2, mpc_class * work );
void Rlaqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, mpf_class * A, mpackint lda, mpackint *jpvt, mpf_class * tau, mpf_class * vn1, mpf_class * vn2, mpf_class * auxv, mpf_class * f, mpackint ldf );
void Claqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, mpc_class * A, mpackint lda, mpackint *jpvt, mpc_class * tau, mpf_class * vn1, mpf_class * vn2, mpc_class * auxv, mpc_class * f, mpackint ldf );
void Rlaqsb ( const char *uplo, mpackint n, mpackint kd, mpf_class * ab, mpackint ldab, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Claqsb ( const char *uplo, mpackint n, mpackint kd, mpc_class * ab, mpackint ldab, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Claqhb ( const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Rlaqsp ( const char *uplo, mpackint n, mpf_class * ap, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Claqsp ( const char *uplo, mpackint n, mpc_class * ap, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Claqhp ( const char *uplo, mpackint n, mpc_class * ap, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Rlaqsy ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Claqsy ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Claqhe ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * s, mpf_class scond, mpf_class amax, char *equed );
void Rlaqtr ( mpackint ltran, mpackint lreal, mpackint n, mpf_class * t, mpackint ldt, mpf_class * B, mpf_class w, mpf_class * scale, mpf_class * x, mpf_class * work, mpackint *info );
void Rlar1v ( mpackint n, mpackint b1, mpackint bn, mpf_class lambda, mpf_class * d, mpf_class * l, mpf_class * ld, mpf_class * lld, mpf_class pivmin, mpf_class gaptol, mpf_class * z, mpackint wantnc, mpackint *negcnt, mpf_class * ztz, mpf_class * mingma, mpackint *r, mpackint *isuppz, mpf_class * nrminv, mpf_class * resid, mpf_class * rqcorr, mpf_class * work );
void Clar1v ( mpackint n, mpackint b1, mpackint bn, mpf_class lambda, mpf_class * d, mpf_class * l, mpf_class * ld, mpf_class * lld, mpf_class pivmin, mpf_class gaptol, mpc_class * z, mpackint wantnc, mpackint *negcnt, mpf_class * ztz, mpf_class * mingma, mpackint *r, mpackint *isuppz, mpf_class * nrminv, mpf_class * resid, mpf_class * rqcorr, mpf_class * work );
void Rlar2v ( mpackint n, mpf_class * x, mpf_class * y, mpf_class * z, mpackint incx, mpf_class * c, mpf_class * s, mpackint incc );
void Clar2v ( mpackint n, mpc_class * x, mpc_class * y, mpc_class * z, mpackint incx, mpf_class * c, mpc_class * s, mpackint incc );
void Rlarfx ( const char *side, mpackint m, mpackint n, mpf_class * v, mpf_class tau, mpf_class * c, mpackint ldc, mpf_class * work );
void Clarfx ( const char *side, mpackint m, mpackint n, mpc_class * v, mpc_class tau, mpc_class * c, mpackint ldc, mpc_class * work );
void Rlargv ( mpackint n, mpf_class * x, mpackint incx, mpf_class * y, mpackint incy, mpf_class * c, mpackint incc );
void Clargv ( mpackint n, mpc_class * x, mpackint incx, mpc_class * y, mpackint incy, mpf_class * c, mpackint incc );
void Rlarnv ( mpackint idist, mpackint *iseed, mpackint n, mpf_class * x );
void Clarnv ( mpackint idist, mpackint *iseed, mpackint n, mpc_class * x );
mpackint Rlaneg ( mpackint n, mpf_class * d, mpf_class * lld, mpf_class sigma, mpf_class pivmin, mpackint r );
void Rlarra ( mpackint n, mpf_class * d, mpf_class * e, mpf_class * e2, mpf_class spltol, mpf_class tnrm, mpackint *nsplit, mpackint *isplit, mpackint *info );
void Rlarrb ( mpackint n, mpf_class * d, mpf_class * lld, mpackint ifirst, mpackint ilast, mpf_class rtol1, mpf_class rtol2, mpackint offset, mpf_class * w, mpf_class * wgap, mpf_class * werr, mpf_class * work, mpackint *iwork, mpf_class pivmin, mpf_class spdiam, mpackint twist, mpackint *info );
void Rlarrc ( const char *jobt, mpackint n, mpf_class vl, mpf_class vu, mpf_class * d, mpf_class * e, mpf_class pivmin, mpackint *eigcnt, mpackint *lcnt, mpackint *rcnt, mpackint *info );
void Rlarrd ( const char *range, const char *order, mpackint n, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class *gers, mpf_class reltol, mpf_class * d, mpf_class * e, mpf_class * e2, mpf_class pivmin, mpackint nsplit, mpackint *isplit, mpackint *m, mpf_class * w, mpf_class * werr, mpf_class * wl, mpf_class * wu, mpackint *iblock, mpackint *indexw, mpf_class * work, mpackint *iwork, mpackint *info );
void Rlarre ( const char *range, mpackint n, mpf_class * vl, mpf_class * vu, mpackint il, mpackint iu, mpf_class * d, mpf_class * e, mpf_class * e2, mpf_class rtol1, mpf_class rtol2, mpf_class spltol, mpackint * nsplit, mpackint *isplit, mpackint * m, mpf_class * w, mpf_class * werr, mpf_class * wgap, mpackint *iblock, mpackint *indexw, mpf_class * gers, mpf_class * pivmin, mpf_class * work, mpackint *iwork, mpackint *info );
void Rlarrf ( mpackint n, mpf_class * d, mpf_class * l, mpf_class * ld, mpackint clstrt, mpackint clend, mpf_class * w, mpf_class * wgap, mpf_class * werr, mpf_class spdiam, mpf_class clgapl, mpf_class clgapr, mpf_class pivmin, mpf_class * sigma, mpf_class * dplus, mpf_class * lplus, mpf_class * work, mpackint *info );
void Rlarrj ( mpackint n, mpf_class * d, mpf_class * e2, mpackint ifirst, mpackint ilast, mpf_class rtol, mpackint offset, mpf_class * w, mpf_class * werr, mpf_class * work, mpackint *iwork, mpf_class pivmin, mpf_class spdiam, mpackint *info );
void Rlarrk ( mpackint n, mpackint iw, mpf_class gl, mpf_class gu, mpf_class * d, mpf_class * e2, mpf_class pivmin, mpf_class reltol, mpf_class * w, mpf_class * werr, mpackint *info );
void Rlarrr ( mpackint n, mpf_class * d, mpf_class * e, mpackint *info );
void Rlartv ( mpackint n, mpf_class * x, mpackint incx, mpf_class * y, mpackint incy, mpf_class * c, mpf_class * s, mpackint incc );
void Clartv ( mpackint n, mpc_class * x, mpackint incx, mpc_class * y, mpackint incy, mpf_class * c, mpc_class * s, mpackint incc );
void Rlarrv ( mpackint n, mpf_class vl, mpf_class vu, mpf_class * d, mpf_class * l, mpf_class pivmin, mpackint * isplit, mpackint m, mpackint dol, mpackint dou, mpf_class minrgp, mpf_class rtol1, mpf_class rtol2, mpf_class * w, mpf_class * werr, mpf_class * wgap, mpackint * iblock, mpackint * indexw, mpf_class * gers, mpf_class * z, mpackint ldz, mpackint * isuppz, mpf_class * work, mpackint * iwork, mpackint * info );
void Clarrv ( mpackint n, mpf_class vl, mpf_class vu, mpf_class * d, mpf_class * l, mpf_class pivmin, mpackint *isplit, mpackint m, mpackint dol, mpackint dou, mpf_class minrgp, mpf_class rtol1, mpf_class rtol2, mpf_class * w, mpf_class * werr, mpf_class * wgap, mpackint *iblock, mpackint *indexw, mpf_class * gers, mpc_class * z, mpackint ldz, mpackint *isuppz, mpf_class * work, mpackint *iwork, mpackint *info );
void Rlaruv ( mpackint *iseed, mpackint n, mpf_class * x );
void Rlarz ( const char *side, mpackint m, mpackint n, mpackint l, mpf_class * v, mpackint incv, mpf_class tau, mpf_class * C, mpackint ldc, mpf_class * work );
void Clarz ( const char *side, mpackint m, mpackint n, mpackint l, mpc_class * v, mpackint incv, mpc_class tau, mpc_class * c, mpackint ldc, mpc_class * work );
void Rlarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, mpf_class * v, mpackint ldv, mpf_class * t, mpackint ldt, mpf_class * c, mpackint ldc, mpf_class * work, mpackint ldwork );
void Clarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, mpc_class * v, mpackint ldv, mpc_class * t, mpackint ldt, mpc_class * c, mpackint ldc, mpc_class * work, mpackint ldwork );
void Rlarzt ( const char *direct, const char *storev, mpackint n, mpackint k, mpf_class * v, mpackint ldv, mpf_class * tau, mpf_class * t, mpackint ldt );
void Clarzt ( const char *direct, const char *storev, mpackint n, mpackint k, mpc_class * v, mpackint ldv, mpc_class * tau, mpc_class * t, mpackint ldt );
void Rlas2 ( mpf_class f, mpf_class g, mpf_class h, mpf_class * ssmin, mpf_class * ssmax );
void Rlasd0 ( mpackint n, mpackint sqre, mpf_class * d, mpf_class * e, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint ldvt, mpackint smlsiz, mpackint *iwork, mpf_class * work, mpackint *info );
void Rlasd1 ( mpackint nl, mpackint nr, mpackint *sqre, mpf_class * d, mpf_class * alpha, mpf_class * beta, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint ldvt, mpackint *idxq, mpackint *iwork, mpf_class * work, mpackint *info );
void Rlasd2 ( mpackint nl, mpackint nr, mpackint sqre, mpackint *k, mpf_class * d, mpf_class * z, mpf_class alpha, mpf_class beta, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint ldvt, mpf_class * dsigma, mpf_class * u2, mpackint ldu2, mpf_class * vt2, mpackint ldvt2, mpackint *idxp, mpackint *idx, mpackint *idxc, mpackint *idxq, mpackint *coltyp, mpackint *info );
void Rlasd3 ( mpackint nl, mpackint nr, mpackint sqre, mpackint k, mpf_class * d, mpf_class * q, mpackint ldq, mpf_class * dsigma, mpf_class * u, mpackint ldu, mpf_class * u2, mpackint ldu2, mpf_class * vt, mpackint ldvt, mpf_class * vt2, mpackint ldvt2, mpackint *idxc, mpackint *ctot, mpf_class * z, mpackint *info );
void Rlasd4 ( mpackint n, mpackint i, mpf_class * d, mpf_class * z, mpf_class * delta, mpf_class rho, mpf_class * sigma, mpf_class * work, mpackint *info );
void Rlasd5 ( mpackint i, mpf_class * d, mpf_class * z, mpf_class * delta, mpf_class rho, mpf_class * dsigma, mpf_class * work );
void Rlasd6 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpf_class * d, mpf_class * vf, mpf_class * vl, mpf_class * alpha, mpf_class * beta, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpf_class * givnum, mpackint ldgnum, mpf_class * poles, mpf_class * difl, mpf_class * difr, mpf_class * z, mpackint k, mpf_class * c, mpf_class * s, mpf_class * work, mpackint *iwork, mpackint *info );
void Rlasd7 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint k, mpf_class * d, mpf_class * z, mpf_class * zw, mpf_class * vf, mpf_class * vfw, mpf_class * vl, mpf_class * vlw, mpf_class alpha, mpf_class beta, mpf_class * dsigma, mpackint *idx, mpackint *idxp, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpf_class * givnum, mpackint ldgnum, mpf_class * c, mpf_class * s, mpackint *info );
void Rlasd8 ( mpackint icompq, mpackint k, mpf_class * d, mpf_class * z, mpf_class * vf, mpf_class * vl, mpf_class * difl, mpf_class * difr, mpackint lddifr, mpf_class * dsigma, mpf_class * work, mpackint *info );
void Rlasda ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint sqre, mpf_class * d, mpf_class * e, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint *k, mpf_class * difl, mpf_class * difr, mpf_class * z, mpf_class * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, mpf_class * givnum, mpf_class * c, mpf_class * s, mpf_class * work, mpackint *iwork, mpackint *info );
void Rlasdq ( const char *uplo, mpackint sqre, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, mpf_class * d, mpf_class * e, mpf_class * vt, mpackint ldvt, mpf_class * u, mpackint ldu, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Rlasdt ( mpackint n, mpackint lvl, mpackint nd, mpackint *inode, mpackint *ndiml, mpackint *ndimr, mpackint msub );
void Rlasq1 ( mpackint n, mpf_class * d, mpf_class * e, mpf_class * work, mpackint *info );
void Rlasq2 ( mpackint n, mpf_class * z, mpackint *info );
void Rlasq3 ( mpackint i0, mpackint n0, mpf_class * z, mpackint pp, mpf_class * dmin, mpf_class * sigma, mpf_class * desig, mpf_class qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint ieee );
void Rlasq4 ( mpackint i0, mpackint n0, mpf_class * z, mpackint pp, mpackint n0in, mpf_class dmin, mpf_class dmin1, mpf_class dmin2, mpf_class dn, mpf_class dn1, mpf_class dn2, mpf_class * tau, mpackint *ttype );
void Rlasq5 ( mpackint i0, mpackint n0, mpf_class * z, mpackint pp, mpf_class tau, mpf_class * dmin, mpf_class * dmin1, mpf_class * dmin2, mpf_class * dn, mpf_class * dnm1, mpf_class * dnm2, mpackint ieee );
void Rlasq6 ( mpackint i0, mpackint n0, mpf_class * z, mpackint pp, mpf_class * dmin, mpf_class * dmin1, mpf_class * dmin2, mpf_class * dn, mpf_class * dnm1, mpf_class * dnm2 );
void Rlasv2 ( mpf_class f, mpf_class g, mpf_class h, mpf_class * ssmin, mpf_class * ssmax, mpf_class * snr, mpf_class * csr, mpf_class * snl, mpf_class * csl );
void Rlasy2 ( mpackint ltranl, mpackint ltranr, mpackint isgn, mpackint n1, mpackint n2, mpf_class * tl, mpackint ldtl, mpf_class * tr, mpackint ldtr, mpf_class * B, mpackint ldb, mpf_class * scale, mpf_class * x, mpackint ldx, mpf_class * xnorm, mpackint *info );
void Rlatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpf_class * x, mpf_class * scale, mpf_class * cnorm, mpackint *info );
void Clatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpc_class * x, mpf_class * scale, mpf_class * cnorm, mpackint *info );
void Rlatdf ( mpackint ijob, mpackint n, mpf_class * z, mpackint ldz, mpf_class * rhs, mpf_class * rdsum, mpf_class * rdscal, mpackint *ipiv, mpackint *jpiv );
void Clatdf ( mpackint ijob, mpackint n, mpc_class * z, mpackint ldz, mpc_class * rhs, mpf_class * rdsum, mpf_class * rdscal, mpackint *ipiv, mpackint *jpiv );
void Rlatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpf_class * ap, mpf_class * x, mpf_class * scale, mpf_class * cnorm, mpackint *info );
void Clatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpc_class * ap, mpc_class * x, mpf_class * scale, mpf_class * cnorm, mpackint *info );
void Rlauu2 ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Clauu2 ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rlauum ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Clauum ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rlatrz ( mpackint m, mpackint n, mpackint l, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work );
void Clatrz ( mpackint m, mpackint n, mpackint l, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work );
void Rorgl2 ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cungl2 ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rorgr2 ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint *info );
void Cungr2 ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint *info );
void Rorm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Cunm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint *info );
void Rorm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Cunm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint *info );
void Rorml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Cunml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint *info );
void Rormr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * C, mpackint ldc, mpf_class * work, mpackint *info );
void Cunmr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint *info );
void Rormr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Cunmr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint *info );
void Rpbtf2 ( const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpackint *info );
void Cpbtf2 ( const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpackint *info );
void Rptts2 ( mpackint n, mpackint nrhs, mpf_class * d, mpf_class * e, mpf_class * b, mpackint ldb );
void Cptts2 ( mpackint iuplo, mpackint n, mpackint nrhs, mpf_class * d, mpc_class * e, mpc_class * B, mpackint ldb );
void Rrscl ( mpackint n, mpf_class sa, mpf_class * sx, mpackint incx );
void CRrscl ( mpackint n, mpf_class sa, mpc_class * sx, mpackint incx );
void Rsygs2 ( mpackint itype, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *info );
void Chegs2 ( mpackint itype, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint *info );
void Rsytf2 ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Csytf2 ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Chetf2 ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rtgex2 ( mpackint wantq, mpackint wantz, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * q, mpackint ldq, mpf_class * z, mpackint ldz, mpackint j1, mpackint n1, mpackint n2, mpf_class * work, mpackint lwork, mpackint *info );
void Ctgex2 ( mpackint wantq, mpackint wantz, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * q, mpackint ldq, mpc_class * z, mpackint ldz, mpackint j1, mpackint *info );
void Rtgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * c, mpackint ldc, mpf_class * d, mpackint ldd, mpf_class * e, mpackint lde, mpf_class * f, mpackint ldf, mpf_class * scale, mpf_class * rdsum, mpf_class * rdscal, mpackint *iwork, mpackint *pq, mpackint *info );
void Ctgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * C, mpackint ldc, mpc_class * d, mpackint ldd, mpc_class * e, mpackint lde, mpc_class * f, mpackint ldf, mpf_class * scale, mpf_class * rdsum, mpf_class * rdscal, mpackint *info );
void Rlazq3 ( mpackint i0, mpackint n0, mpf_class * z, mpackint pp, mpf_class * dmin, mpf_class * sigma, mpf_class * desig, mpf_class qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint *ieee, mpackint *ttype, mpf_class * dmin1, mpf_class * dmin2, mpf_class * dn, mpf_class * dn1, mpf_class * dn2, mpf_class * tau );
void Rlazq4 ( mpackint i0, mpackint n0, mpf_class * z, mpackint pp, mpackint n0in, mpf_class dmin, mpf_class dmin1, mpf_class dmin2, mpf_class dn, mpf_class dn1, mpf_class dn2, mpf_class * tau, mpackint *ttype, mpf_class * g );
void Rlaqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpf_class * h, mpackint ldh, mpf_class * wr, mpf_class * wi, mpackint iloz, mpackint ihiz, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *info );
void Claqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpc_class * h, mpackint ldh, mpc_class * w, mpackint *iloz, mpackint *ihiz, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpackint *info );
void Rlaqr1 ( mpackint n, mpf_class * h, mpackint ldh, mpf_class sr1, mpf_class si1, mpf_class sr2, mpf_class si2, mpf_class * v );
void Claqr1 ( mpackint n, mpc_class * h, mpackint ldh, mpc_class s1, mpc_class s2, mpc_class * v );
void Rlaqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpf_class * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpf_class * z, mpackint ldz, mpackint *ns, mpackint *nd, mpf_class * sr, mpf_class * si, mpf_class * v, mpackint ldv, mpackint nh, mpf_class * t, mpackint ldt, mpackint nv, mpf_class * wv, mpackint ldwv, mpf_class * work, mpackint lwork );
void Claqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpc_class * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpc_class * z, mpackint ldz, mpackint *ns, mpackint *nd, mpc_class * sh, mpc_class * v, mpackint ldv, mpackint nh, mpc_class * t, mpackint ldt, mpackint nv, mpc_class * wv, mpackint ldwv, mpc_class * work, mpackint lwork );
void Rlaqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpf_class * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpf_class * z, mpackint ldz, mpackint ns, mpackint nd, mpf_class * sr, mpf_class * si, mpf_class * v, mpackint ldv, mpackint nh, mpf_class * t, mpackint ldt, mpackint nv, mpf_class * wv, mpackint ldwv, mpf_class * work, mpackint lwork );
void Claqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpc_class * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpc_class * z, mpackint ldz, mpackint *ns, mpackint *nd, mpc_class * sh, mpc_class * v, mpackint ldv, mpackint nh, mpc_class * t, mpackint ldt, mpackint nv, mpc_class * wv, mpackint ldwv, mpc_class * work, mpackint lwork );
void Rlaqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpf_class * h, mpackint ldh, mpf_class * wr, mpf_class * wi, mpackint iloz, mpackint ihiz, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *info );
void Claqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpc_class * h, mpackint ldh, mpc_class * w, mpackint iloz, mpackint ihiz, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpackint *info );
void Rlaqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kac22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, mpf_class * sr, mpf_class * si, mpf_class * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpf_class * z, mpackint ldz, mpf_class * v, mpackint ldv, mpf_class * u, mpackint ldu, mpackint nv, mpf_class * wv, mpackint ldwv, mpackint nh, mpf_class * wh, mpackint ldwh );
void Claqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kacc22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, mpc_class * s, mpc_class * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpc_class * z, mpackint ldz, mpc_class * v, mpackint ldv, mpc_class * u, mpackint ldu, mpackint nv, mpc_class * wv, mpackint ldwv, mpackint nh, mpc_class * wh, mpackint ldwh );
void Rlatzm ( const char *side, mpackint m, mpackint n, mpf_class * v, mpackint incv, mpf_class * tau, mpf_class *c1, mpf_class * c2, mpackint ldc, mpf_class * work );
void Clatzm ( const char *side, mpackint m, mpackint n, mpc_class * v, mpackint incv, mpc_class * tau, mpc_class * c1, mpc_class * c2, mpackint ldc, mpc_class * work );
void Clacp2 ( const char *uplo, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpc_class * B, mpackint ldb );
mpackint Risnan ( mpf_class din );

/* not yet done ... driver and computational routines */
void Rbdsdc ( const char *uplo, const char *compq, mpackint n, mpf_class * d, mpf_class * e, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint ldvt, mpf_class * q, mpackint * iq, mpf_class * work, mpackint * iwork, mpackint * info );
void Rbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, mpf_class * d, mpf_class * e, mpf_class * vt, mpackint ldvt, mpf_class * u, mpackint ldu, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Cbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, mpf_class * d, mpf_class * e, mpc_class * vt, mpackint ldvt, mpc_class * u, mpackint ldu, mpc_class * c, mpackint ldc, mpf_class * rwork, mpackint * info );
void Rdisna ( const char *job, mpackint m, mpackint n, mpf_class * d, mpf_class * sep, mpackint *info );
void Rgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, mpf_class * AB, mpackint ldab, mpf_class * d, mpf_class * e, mpf_class * q, mpackint ldq, mpf_class * pt, mpackint ldpt, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Cgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, mpc_class * AB, mpackint ldab, mpf_class * d, mpf_class * e, mpc_class * q, mpackint ldq, mpc_class * pt, mpackint ldpt, mpc_class * c, mpackint ldc, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpf_class * AB, mpackint ldab, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Cgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpc_class * AB, mpackint ldab, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpf_class * AB, mpackint ldab, mpf_class * r, mpf_class * c, mpf_class * rowcnd, mpf_class * colcnd, mpf_class * amax, mpackint *info );
void Cgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpc_class * AB, mpackint ldab, mpf_class * r, mpf_class * c, mpf_class * rowcnd, mpf_class * colcnd, mpf_class * amax, mpackint *info );
void Rgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpf_class * AB, mpackint ldab, mpf_class * afb, mpackint ldafb, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpc_class * AB, mpackint ldab, mpc_class * afb, mpackint ldafb, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpf_class * AB, mpackint ldab, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Cgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpc_class * ab, mpackint ldab, mpackint *ipiv, mpc_class * b, mpackint ldb, mpackint *info );
void Rgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpf_class * AB, mpackint ldab, mpf_class * afb, mpackint ldafb, mpackint * ipiv, char *equed, mpf_class * r, mpf_class * c, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint * iwork, mpackint * info );
void Cgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpc_class * AB, mpackint ldab, mpc_class * afb, mpackint ldafb, mpackint * ipiv, char *equed, mpf_class * r, mpf_class * c, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpf_class * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpc_class * ab, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpf_class * AB, mpackint ldab, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Cgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpc_class * AB, mpackint ldab, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Rgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpf_class * scale, mpackint m, mpf_class * v, mpackint ldv, mpackint *info );
void Cgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpf_class * scale, mpackint m, mpc_class * v, mpackint ldv, mpackint *info );
void Rgebal ( const char *job, mpackint n, mpf_class * A, mpackint lda, mpackint *ilo, mpackint *ihi, mpf_class * scale, mpackint *info );
void Cgebal ( const char *job, mpackint n, mpc_class * A, mpackint lda, mpackint *ilo, mpackint *ihi, mpf_class * scale, mpackint *info );
void Rgebrd ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpf_class * tauq, mpf_class * taup, mpf_class * work, mpackint lwork, mpackint *info );
void Cgebrd ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * d, mpf_class * e, mpc_class * tauq, mpc_class * taup, mpc_class * work, mpackint lwork, mpackint *info );
void Rgecon ( const char *norm, mpackint n, mpf_class * A, mpackint lda, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Cgecon ( const char *norm, mpackint n, mpc_class * A, mpackint lda, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgeequ ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * r, mpf_class * c, mpf_class * rowcnd, mpf_class * colcnd, mpf_class * amax, mpackint *info );
void Cgeequ ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * r, mpf_class * c, mpf_class * rowcnd, mpf_class * colcnd, mpf_class * amax, mpackint *info );
void Rgees ( const char *jobvs, const char *sort, LFP select, mpackint n, mpf_class * A, mpackint lda, mpackint *sdim, mpf_class * wr, mpf_class * wi, mpf_class * vs, mpackint ldvs, mpf_class * work, mpackint lwork, mpacklogical * bwork, mpackint *info );
void Cgees ( const char *jobvs, const char *sort, LFP select, mpackint n, mpc_class * A, mpackint lda, mpackint *sdim, mpc_class * w, mpc_class * vs, mpackint ldvs, mpc_class * work, mpackint lwork, mpf_class * rwork, mpacklogical * bwork, mpackint *info );
void Rgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, mpf_class * A, mpackint lda, mpackint * sdim, mpf_class * wr, mpf_class * wi, mpf_class * vs, mpackint ldvs, mpf_class * rconde, mpf_class * rcondv, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, mpc_class * A, mpackint lda, mpackint *sdim, mpc_class * w, mpc_class * vs, mpackint ldvs, mpf_class * rconde, mpf_class * rcondv, mpc_class * work, mpackint lwork, mpf_class * rwork, mpacklogical * bwork, mpackint *info );
void Rgeev ( const char *jobvl, const char *jobvr, mpackint n, mpf_class * A, mpackint lda, mpf_class * wr, mpf_class * wi, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpf_class * work, mpackint lwork, mpackint *info );
void Cgeev ( const char *jobvl, const char *jobvr, mpackint n, mpc_class * A, mpackint lda, mpc_class * w, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Rgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpf_class * A, mpackint lda, mpf_class * wr, mpf_class * wi, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpf_class * scale, mpf_class * abnrm, mpf_class * rconde, mpf_class * rcondv, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpc_class * A, mpackint lda, mpc_class * w, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpf_class * scale, mpf_class * abnrm, mpf_class * rconde, mpf_class * rcondv, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Cgehrd ( mpackint n, mpackint ilo, mpackint ihi, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rgehrd ( mpackint n, mpackint ilo, mpackint ihi, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Rgelqf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cgelqf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * work, mpackint lwork, mpackint *info );
void Cgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * work, mpackint lwork, mpackint *info );
void Rgelsx ( mpackint m, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *jpvt, mpf_class rcond, mpackint *rank, mpf_class * work, mpackint *info );
void Cgelsx ( mpackint m, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint *jpvt, mpf_class rcond, mpackint *rank, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgelsd ( mpackint m, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * s, mpf_class * rcond, mpackint *rank, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Cgelsd ( mpackint m, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class * s, mpf_class rcond, mpackint * rank, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * iwork, mpackint * info );
void Rgelss ( mpackint m, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * s, mpf_class rcond, mpackint * rank, mpf_class * work, mpackint lwork, mpackint * info );
void Cgelss ( mpackint m, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class * s, mpf_class rcond, mpackint * rank, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Rgelsy ( mpackint m, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *jpvt, mpf_class rcond, mpackint *rank, mpf_class * work, mpackint lwork, mpackint *info );
void Cgelsy ( mpackint m, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint * jpvt, mpf_class rcond, mpackint * rank, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Rgeqlf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cgeqlf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rgeqpf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpackint *jpvt, mpf_class * tau, mpf_class * work, mpackint *info );
void Cgeqpf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpackint *jpvt, mpc_class * tau, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgeqp3 ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpackint *jpvt, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cgeqp3 ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpackint *jpvt, mpc_class * tau, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *info );
void Rgeqrf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cgeqrf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rgerfs ( const char *trans, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * af, mpackint ldaf, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cgerfs ( const char *trans, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgerqf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cgerqf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rgesdd ( const char *jobz, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * s, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint ldvt, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgesdd ( const char *jobz, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * s, mpc_class * u, mpackint ldu, mpc_class * vt, mpackint ldvt, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * iwork, mpackint * info );
void Rgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * s, mpf_class * u, mpackint ldu, mpf_class * vt, mpackint ldvt, mpf_class * work, mpackint lwork, mpackint * info );
void Cgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpf_class * s, mpc_class * u, mpackint ldu, mpc_class * vt, mpackint ldvt, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Rgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * af, mpackint ldaf, mpackint * ipiv, char *equed, mpf_class * r, mpf_class * c, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint * iwork, mpackint * info );
void Cgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, mpackint * ipiv, char *equed, mpf_class * r, mpf_class * c, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpf_class * lscale, mpf_class * rscale, mpackint m, mpf_class * v, mpackint ldv, mpackint *info );
void Cggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpf_class * lscale, mpf_class * rscale, mpackint m, mpc_class * v, mpackint ldv, mpackint *info );
void Rggbal ( const char *job, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *ilo, mpackint *ihi, mpf_class * lscale, mpf_class * rscale, mpf_class * work, mpackint *info );
void Cggbal ( const char *job, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint *ilo, mpackint *ihi, mpf_class * lscale, mpf_class * rscale, mpf_class * work, mpackint *info );
void Rgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint * sdim, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * vsl, mpackint ldvsl, mpf_class * vsr, mpackint ldvsr, mpf_class * work, mpackint lwork, mpacklogical * bwork, mpackint * info );
void Cgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint * sdim, mpc_class * alpha, mpc_class * beta, mpc_class * vsl, mpackint ldvsl, mpc_class * vsr, mpackint ldvsr, mpc_class * work, mpackint lwork, mpf_class * rwork, mpacklogical * bwork, mpackint * info );
void Rgegs ( const char *jobvsl, const char *jobvsr, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * vsl, mpackint ldvsl, mpf_class * vsr, mpackint ldvsr, mpf_class * work, mpackint lwork, mpackint *info );
void Cgegs ( const char *jobvsl, const char *jobvsr, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * alpha, mpc_class * beta, mpc_class * vsl, mpackint ldvsl, mpc_class * vsr, mpackint ldvsr, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Rggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint * sdim, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * vsl, mpackint ldvsl, mpf_class * vsr, mpackint ldvsr, mpf_class * rconde, mpf_class * rcondv, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint * sdim, mpc_class * alpha, mpc_class * beta, mpc_class * vsl, mpackint ldvsl, mpc_class * vsr, mpackint ldvsr, mpf_class * rconde, mpf_class * rcondv, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Rggev ( const char *jobvl, const char *jobvr, mpackint n, mpf_class * A, mpackint lda, mpf_class * b, mpackint ldb, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpf_class * work, mpackint lwork, mpackint * info );
void Cggev ( const char *jobvl, const char *jobvr, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * alpha, mpc_class * beta, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Rgegv ( const char *jobvl, const char *jobvr, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpf_class * work, mpackint lwork, mpackint * info );
void Cgegv ( const char *jobvl, const char *jobvr, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * alpha, mpc_class * beta, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * info );
void Rggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpf_class * lscale, mpf_class * rscale, mpf_class * abnrm, mpf_class * bbnrm, mpf_class * rconde, mpf_class * rcondv, mpf_class * work, mpackint lwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Cggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * alpha, mpc_class * beta, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpf_class * lscale, mpf_class * rscale, mpf_class * abnrm, mpf_class * bbnrm, mpf_class * rconde, mpf_class * rcondv, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Rggglm ( mpackint n, mpackint m, mpackint p, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * d, mpf_class * x, mpf_class * y, mpf_class * work, mpackint lwork, mpackint *info );
void Cggglm ( mpackint n, mpackint m, mpackint p, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * d, mpc_class * x, mpc_class * y, mpc_class * work, mpackint lwork, mpackint *info );
void Rgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * q, mpackint ldq, mpf_class * z, mpackint ldz, mpackint *info );
void Cgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * q, mpackint ldq, mpc_class * z, mpackint ldz, mpackint *info );
void Rgglse ( mpackint m, mpackint n, mpackint p, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * c, mpf_class * d, mpf_class * x, mpf_class * work, mpackint lwork, mpackint *info );
void Cgglse ( mpackint m, mpackint n, mpackint p, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * c, mpc_class * d, mpc_class * x, mpc_class * work, mpackint lwork, mpackint *info );
void Rggqrf ( mpackint n, mpackint m, mpackint p, mpf_class * A, mpackint lda, mpf_class * taua, mpf_class * B, mpackint ldb, mpf_class * taub, mpf_class * work, mpackint lwork, mpackint *info );
void Cggqrf ( mpackint n, mpackint m, mpackint p, mpc_class * A, mpackint lda, mpc_class * taua, mpc_class * B, mpackint ldb, mpc_class * taub, mpc_class * work, mpackint lwork, mpackint *info );
void Rggrqf ( mpackint m, mpackint p, mpackint n, mpf_class * A, mpackint lda, mpf_class * taua, mpf_class * B, mpackint ldb, mpf_class * taub, mpf_class * work, mpackint lwork, mpackint *info );
void Cggrqf ( mpackint m, mpackint p, mpackint n, mpc_class * A, mpackint lda, mpc_class * taua, mpc_class * B, mpackint ldb, mpc_class * taub, mpc_class * work, mpackint lwork, mpackint *info );
void Rggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * alpha, mpf_class * beta, mpf_class * u, mpackint ldu, mpf_class * v, mpackint ldv, mpf_class * q, mpackint ldq, mpf_class * work, mpackint *iwork, mpackint *info );
void Cggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class * alpha, mpf_class * beta, mpc_class * u, mpackint ldu, mpc_class * v, mpackint ldv, mpc_class * q, mpackint ldq, mpc_class * work, mpf_class * rwork, mpackint *iwork, mpackint *info );
void Rggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class tola, mpf_class tolb, mpackint *k, mpackint *l, mpf_class * u, mpackint ldu, mpf_class * v, mpackint ldv, mpf_class * q, mpackint ldq, mpackint *iwork, mpf_class * tau, mpf_class * work, mpackint *info );
void Cggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class tola, mpf_class tolb, mpackint *k, mpackint *l, mpc_class * u, mpackint ldu, mpc_class * v, mpackint ldv, mpc_class * q, mpackint ldq, mpackint *iwork, mpf_class * rwork, mpc_class * tau, mpc_class * work, mpackint *info );
void Rgtcon ( const char *norm, mpackint n, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * du2, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Cgtcon ( const char *norm, mpackint n, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * du2, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpackint *info );
void Rgtrfs ( const char *trans, mpackint n, mpackint nrhs, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * dlf, mpf_class * df, mpf_class * duf, mpf_class * du2, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cgtrfs ( const char *trans, mpackint n, mpackint nrhs, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * dlf, mpc_class * df, mpc_class * duf, mpc_class * du2, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgtsv ( mpackint n, mpackint nrhs, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * B, mpackint ldb, mpackint *info );
void Cgtsv ( mpackint n, mpackint nrhs, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * B, mpackint ldb, mpackint *info );
void Rgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * dlf, mpf_class * df, mpf_class * duf, mpf_class * du2, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * dlf, mpc_class * df, mpc_class * duf, mpc_class * du2, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rgttrf ( mpackint n, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * du2, mpackint *ipiv, mpackint *info );
void Cgttrf ( mpackint n, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * du2, mpackint *ipiv, mpackint *info );
void Rgttrs ( const char *trans, mpackint n, mpackint nrhs, mpf_class * dl, mpf_class * d, mpf_class * du, mpf_class * du2, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Cgttrs ( const char *trans, mpackint n, mpackint nrhs, mpc_class * dl, mpc_class * d, mpc_class * du, mpc_class * du2, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Rhgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpf_class * h, mpackint ldh, mpf_class * t, mpackint ldt, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * q, mpackint ldq, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *info );
void Chgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpc_class * h, mpackint ldh, mpc_class * t, mpackint ldt, mpc_class * alpha, mpc_class * beta, mpc_class * q, mpackint ldq, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *info );
void Rhsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical *select, mpackint n, mpf_class * h, mpackint ldh, mpf_class * wr, mpf_class * wi, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpackint mm, mpackint m, mpf_class * work, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Chsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical * select, mpackint n, mpc_class * h, mpackint ldh, mpc_class * w, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpackint mm, mpackint *m, mpc_class * work, mpf_class * rwork, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Rhseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpf_class * h, mpackint ldh, mpf_class * wr, mpf_class * wi, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *info );
void Chseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpc_class * h, mpackint ldh, mpc_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpackint *info );
void Ropgtr ( const char *uplo, mpackint n, mpf_class * ap, mpf_class * tau, mpf_class * q, mpackint ldq, mpf_class * work, mpackint *info );
void Cupgtr ( const char *uplo, mpackint n, mpc_class * ap, mpc_class * tau, mpc_class * q, mpackint ldq, mpc_class * work, mpackint *info );
void Ropmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpf_class * ap, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint *info );
void Cupmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpc_class * ap, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint *info );
void Rorgbr ( const char *vect, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cungbr ( const char *vect, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rorghr ( mpackint n, mpackint ilo, mpackint ihi, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cunghr ( mpackint n, mpackint ilo, mpackint ihi, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rorglq ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cunglq ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rorgrq ( mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Cungrq ( mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rormbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rormhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rormlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rormql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rormqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rormrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rormrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rormtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * c, mpackint ldc, mpf_class * work, mpackint lwork, mpackint *info );
void Cunmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * c, mpackint ldc, mpc_class * work, mpackint lwork, mpackint *info );
void Rpbcon ( const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Cpbcon ( const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rpbequ ( const char *uplo, mpackint n, mpackint kd, mpf_class * ab, mpackint ldab, mpf_class * s, mpf_class * scond, mpf_class * amax, mpackint *info );
void Cpbequ ( const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpf_class * s, mpf_class * scond, mpf_class * amax, mpackint *info );
void Rpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpf_class * AB, mpackint ldab, mpf_class * afb, mpackint ldafb, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpc_class * AB, mpackint ldab, mpc_class * afb, mpackint ldafb, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rpbstf ( const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpackint *info );
void Cpbstf ( const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpackint *info );
void Rpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpf_class * AB, mpackint ldab, mpf_class * B, mpackint ldb, mpackint *info );
void Cpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpc_class * ab, mpackint ldab, mpc_class * B, mpackint ldb, mpackint *info );
void Rpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpf_class * AB, mpackint ldab, mpf_class * afb, mpackint ldafb, char *equed, mpf_class * s, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint * iwork, mpackint * info );
void Cpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpc_class * AB, mpackint ldab, mpc_class * afb, mpackint ldafb, char *equed, mpf_class * s, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rpbtrf ( const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpackint *info );
void Cpbtrf ( const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpackint *info );
void Rpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpf_class * ab, mpackint ldab, mpf_class * B, mpackint ldb, mpackint *info );
void Cpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpc_class * AB, mpackint ldab, mpc_class * B, mpackint ldb, mpackint *info );
void Rpocon ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Cpocon ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rpoequ ( mpackint n, mpf_class * A, mpackint lda, mpf_class * s, mpf_class * scond, mpf_class * amax, mpackint *info );
void Cpoequ ( mpackint n, mpc_class * A, mpackint lda, mpf_class * s, mpf_class * scond, mpf_class * amax, mpackint *info );
void Rporfs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * af, mpackint ldaf, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cporfs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rposv ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *info );
void Cposv ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint *info );
void Rposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * af, mpackint ldaf, char *equed, mpf_class * s, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint * iwork, mpackint * info );
void Cposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, char *equed, mpf_class * s, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rpotri ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *info );
void Cpotri ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *info );
void Rpotrs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *info );
void Cpotrs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint *info );
void Rppcon ( const char *uplo, mpackint n, mpf_class * ap, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Cppcon ( const char *uplo, mpackint n, mpc_class * ap, mpf_class * anorm, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rppequ ( const char *uplo, mpackint n, mpf_class * ap, mpf_class * s, mpf_class * scond, mpf_class * amax, mpackint *info );
void Cppequ ( const char *uplo, mpackint n, mpc_class * ap, mpf_class * s, mpf_class * scond, mpf_class * amax, mpackint *info );
void Rpptrf ( const char *uplo, mpackint n, mpf_class * ap, mpackint *info );
void Cpptrf ( const char *uplo, mpackint n, mpc_class * ap, mpackint *info );
void Rpptri ( const char *uplo, mpackint n, mpf_class * ap, mpackint *info );
void Cpptri ( const char *uplo, mpackint n, mpc_class * ap, mpackint *info );
void Rpptrs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * B, mpackint ldb, mpackint *info );
void Cpptrs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * B, mpackint ldb, mpackint *info );
void Rpprfs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * afp, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cpprfs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * afp, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rppsv ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * B, mpackint ldb, mpackint *info );
void Cppsv ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * B, mpackint ldb, mpackint *info );
void Rppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * afp, char *equed, mpf_class * s, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * afp, char *equed, mpf_class * s, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rptcon ( mpackint n, mpf_class * d, mpf_class * e, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *info );
void Cptcon ( mpackint n, mpf_class * d, mpc_class * e, mpf_class anorm, mpf_class * rcond, mpf_class * rwork, mpackint *info );
void Rpteqr ( const char *compz, mpackint n, mpf_class * d, mpf_class * e, mpf_class * z, mpackint ldz, mpf_class * work, mpackint * info );
void Cpteqr ( const char *compz, mpackint n, mpf_class * d, mpf_class * e, mpc_class * z, mpackint ldz, mpf_class * work, mpackint *info );
void Rptrfs ( mpackint n, mpackint nrhs, mpf_class * d, mpf_class * e, mpf_class * df, mpf_class * ef, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *info );
void Cptrfs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * d, mpc_class * e, mpf_class * df, mpc_class * ef, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rptsv ( mpackint n, mpackint nrhs, mpf_class * d, mpf_class * e, mpf_class * B, mpackint ldb, mpackint *info );
void Cptsv ( mpackint n, mpackint nrhs, mpf_class * d, mpc_class * e, mpc_class * B, mpackint ldb, mpackint *info );
void Rptsvx ( const char *fact, mpackint n, mpackint nrhs, mpf_class * d, mpf_class * e, mpf_class * df, mpf_class * ef, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *info );
void Cptsvx ( const char *fact, mpackint n, mpackint nrhs, mpf_class * d, mpc_class * e, mpf_class * df, mpc_class * ef, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rpttrf ( mpackint n, mpf_class * d, mpf_class * e, mpackint *info );
void Cpttrf ( mpackint n, mpf_class * d, mpc_class * e, mpackint *info );
void Rpttrs ( mpackint n, mpackint nrhs, mpf_class * d, mpf_class * e, mpf_class * B, mpackint ldb, mpackint *info );
void Cpttrs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * d, mpc_class * e, mpc_class * B, mpackint ldb, mpackint *info );
void Rsbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *info );
void Chbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rsbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpf_class * q, mpackint ldq, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpc_class * q, mpackint ldq, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint * iwork, mpackint * ifail, mpackint * info );
void Rsbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpf_class * AB, mpackint ldab, mpf_class * bb, mpackint ldbb, mpf_class * x, mpackint ldx, mpf_class * work, mpackint *info );
void Chbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpc_class * AB, mpackint ldab, mpc_class * bb, mpackint ldbb, mpc_class * x, mpackint ldx, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rsbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpf_class * AB, mpackint ldab, mpf_class * bb, mpackint ldbb, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *info );
void Chbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpc_class * AB, mpackint ldab, mpc_class * bb, mpackint ldbb, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rsbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpf_class * AB, mpackint ldab, mpf_class * BB, mpackint ldbb, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpc_class * AB, mpackint ldab, mpc_class * BB, mpackint ldbb, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpf_class * AB, mpackint ldab, mpf_class * BB, mpackint ldbb, mpf_class * q, mpackint ldq, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpc_class * ab, mpackint ldab, mpc_class * bb, mpackint ldbb, mpc_class * q, mpackint ldq, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpf_class * d, mpf_class * e, mpf_class * q, mpackint ldq, mpf_class * work, mpackint *info );
void Chbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpf_class * d, mpf_class * e, mpc_class * q, mpackint ldq, mpc_class * work, mpackint *info );
void Rspcon ( const char *uplo, mpackint n, mpf_class * ap, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Cspcon ( const char *uplo, mpackint n, mpc_class * ap, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpackint *info );
void Chpcon ( const char *uplo, mpackint n, mpc_class * ap, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpackint *info );
void Rspev ( const char *jobz, const char *uplo, mpackint n, mpf_class * ap, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *info );
void Chpev ( const char *jobz, const char *uplo, mpackint n, mpc_class * ap, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rspevd ( const char *jobz, const char *uplo, mpackint n, mpf_class * ap, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpevd ( const char *jobz, const char *uplo, mpackint n, mpc_class * ap, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpf_class * ap, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpc_class * ap, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rspgst ( mpackint itype, const char *uplo, mpackint n, mpf_class * ap, mpf_class * bp, mpackint *info );
void Chpgst ( mpackint *itype, const char *uplo, mpackint n, mpc_class * ap, mpc_class * bp, mpackint *info );
void Rspgv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpf_class * ap, mpf_class * bp, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *info );
void Chpgv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, mpc_class * ap, mpc_class * bp, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rspgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpf_class * ap, mpf_class * bp, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpc_class * ap, mpc_class * bp, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspgvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, mpf_class * ap, mpf_class * bp, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint m, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpgvx ( mpackint itype, const char *jobz, char *range, const char *uplo, mpackint n, mpc_class * ap, mpc_class * bp, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpf_class * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsprfs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * afp, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Csprfs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * afp, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Chprfs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * afp, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rspsv ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Cspsv ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Chpsv ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Rspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * afp, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Cspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * afp, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Chpsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * afp, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rsptrd ( const char *uplo, mpackint n, mpf_class * ap, mpf_class * d, mpf_class * e, mpf_class * tau, mpackint *info );
void Chptrd ( const char *uplo, mpackint n, mpc_class * ap, mpf_class * d, mpf_class * e, mpc_class * tau, mpackint *info );
void Rsptrf ( const char *uplo, mpackint n, mpf_class * ap, mpackint *ipiv, mpackint *info );
void Csptrf ( const char *uplo, mpackint n, mpc_class * ap, mpackint *ipiv, mpackint *info );
void Chptrf ( const char *uplo, mpackint n, mpc_class * ap, mpackint *ipiv, mpackint *info );
void Rsptri ( const char *uplo, mpackint n, mpf_class * ap, mpackint *ipiv, mpf_class * work, mpackint *info );
void Csptri ( const char *uplo, mpackint n, mpc_class * ap, mpackint *ipiv, mpc_class * work, mpackint *info );
void Chptri ( const char *uplo, mpackint n, mpc_class * ap, mpackint *ipiv, mpc_class * work, mpackint *info );
void Rsptrs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * ap, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Csptrs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Chptrs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * ap, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Rstebz ( const char *range, const char *order, mpackint n, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpf_class * d, mpf_class * e, mpackint * m, mpackint * nsplit, mpf_class * w, mpackint *iblock, mpackint *isplit, mpf_class * work, mpackint *iwork, mpackint *info );
void Rstedc ( const char *compz, mpackint n, mpf_class * d, mpf_class * e, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cstedc ( const char *compz, mpackint n, mpf_class * d, mpf_class * e, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstegr ( const char *jobz, const char *range, mpackint n, mpf_class * d, mpf_class * e, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpf_class * z, mpackint ldz, mpackint * isuppz, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstegr ( const char *jobz, const char *range, mpackint n, mpf_class *d, mpf_class * e, mpf_class * vl, mpf_class * vu, mpackint *il, mpackint *iu, mpf_class * abstol, mpackint m, mpf_class * w, mpc_class * z, mpackint ldz, mpackint *isuppz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstein ( mpackint n, mpf_class * d, mpf_class * e, mpackint m, mpf_class * w, mpackint *iblock, mpackint *isplit, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cstein ( mpackint n, mpf_class * d, mpf_class * e, mpackint m, mpf_class * w, mpackint *iblock, mpackint *isplit, mpc_class * z, mpackint ldz, mpf_class * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstev ( const char *jobz, mpackint n, mpf_class * d, mpf_class * e, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *info );
void Rstevd ( const char *jobz, mpackint n, mpf_class * d, mpf_class * e, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstevr ( const char *jobz, const char *range, mpackint n, mpf_class * d, mpf_class * e, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpf_class * z, mpackint ldz, mpackint * isuppz, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rstevx ( const char *jobz, const char *range, mpackint n, mpf_class * d, mpf_class * e, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstemr ( const char *jobz, const char *range, mpackint n, mpf_class * d, mpf_class * e, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpackint * m, mpf_class * w, mpf_class * z, mpackint ldz, mpackint nzc, mpackint * isuppz, mpacklogical * tryrac, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstemr ( const char *jobz, const char *range, mpackint n, mpf_class * d, mpf_class * e, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpackint * m, mpf_class * w, mpc_class * z, mpackint ldz, mpackint nzc, mpackint *isuppz, mpacklogical * tryrac, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsycon ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Csycon ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpackint *info );
void Checon ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpf_class anorm, mpf_class * rcond, mpc_class * work, mpackint *info );
void Rsyevd ( const char *jobz, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * w, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cheevd ( const char *jobz, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class * w, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsyevr ( const char *jobz, const char *range, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpf_class * z, mpackint ldz, mpackint * isuppz, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cheevr ( const char *jobz, const char *range, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpc_class * z, mpackint ldz, mpackint * isuppz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rsyevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cheevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsygst ( mpackint itype, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpackint *info );
void Chegst ( mpackint itype, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpackint *info );
void Rsygv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * w, mpf_class * work, mpackint lwork, mpackint *info );
void Chegv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class * w, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *info );
void Rsygvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * w, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chegvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class * w, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsygvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint *m, mpf_class * w, mpf_class * z, mpackint ldz, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chegvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class vl, mpf_class vu, mpackint il, mpackint iu, mpf_class abstol, mpackint * m, mpf_class * w, mpc_class * z, mpackint ldz, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsyrfs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * af, mpackint ldaf, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Csyrfs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Cherfs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rsysv ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * work, mpackint lwork, mpackint *info );
void Csysv ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * work, mpackint lwork, mpackint *info );
void Chesv ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * work, mpackint lwork, mpackint *info );
void Rsysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * af, mpackint ldaf, mpackint *ipiv, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Csysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *info );
void Chesvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * af, mpackint ldaf, mpackint *ipiv, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * rcond, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpackint lwork, mpf_class * rwork, mpackint *info );
void Rsytrf ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * work, mpackint lwork, mpackint *info );
void Csytrf ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * work, mpackint lwork, mpackint *info );
void Chetrf ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * work, mpackint lwork, mpackint *info );
void Rsytri ( const char *uplo, mpackint n, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * work, mpackint *info );
void Csytri ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * work, mpackint *info );
void Chetri ( const char *uplo, mpackint n, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * work, mpackint *info );
void Rsytrs ( const char *uplo, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpackint *ipiv, mpf_class * B, mpackint ldb, mpackint *info );
void Csytrs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Chetrs ( const char *uplo, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpackint *ipiv, mpc_class * B, mpackint ldb, mpackint *info );
void Rtbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, mpf_class * AB, mpackint ldab, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Ctbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, mpc_class * AB, mpackint ldab, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rtbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpf_class * AB, mpackint ldab, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Ctbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpc_class * AB, mpackint ldab, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rtbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpf_class * ab, mpackint ldab, mpf_class * B, mpackint ldb, mpackint *info );
void Ctbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpc_class * ab, mpackint ldab, mpc_class * B, mpackint ldb, mpackint *info );
void Rtgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpf_class * s, mpackint lds, mpf_class *p, mpackint ldp, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpackint mm, mpackint *m, mpf_class * work, mpackint * info );
void Ctgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpc_class * s, mpackint lds, mpc_class * p, mpackint ldp, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpackint mm, mpackint * m, mpc_class * work, mpf_class * rwork, mpackint * info );
void Rtgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * q, mpackint ldq, mpf_class * z, mpackint ldz, mpackint * ifst, mpackint * ilst, mpf_class * work, mpackint lwork, mpackint * info );
void Ctgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * q, mpackint ldq, mpc_class * z, mpackint ldz, mpackint ifst, mpackint *ilst, mpackint *info );
void Rtgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical *select, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * alphar, mpf_class * alphai, mpf_class * beta, mpf_class * q, mpackint ldq, mpf_class * z, mpackint ldz, mpackint * m, mpf_class * pl, mpf_class * pr, mpf_class * dif, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Ctgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical * select, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * alpha, mpc_class * beta, mpc_class * q, mpackint ldq, mpc_class * z, mpackint ldz, mpackint * m, mpf_class * pl, mpf_class * pr, mpf_class * dif, mpc_class * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rtgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class tola, mpf_class tolb, mpf_class * alpha, mpf_class * beta, mpf_class * u, mpackint ldu, mpf_class * v, mpackint ldv, mpf_class * q, mpackint ldq, mpf_class * work, mpackint ncycle, mpackint *info );
void Ctgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpf_class tola, mpf_class tolb, mpf_class * alpha, mpf_class * beta, mpc_class * u, mpackint ldu, mpc_class * v, mpackint ldv, mpc_class * q, mpackint ldq, mpc_class * work, mpackint * ncycle, mpackint *info );
void Rtgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpf_class * s, mpf_class * dif, mpackint mm, mpackint * m, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpf_class * s, mpf_class * dif, mpackint mm, mpackint * m, mpc_class * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * c, mpackint ldc, mpf_class * d, mpackint ldd, mpf_class * e, mpackint lde, mpf_class * f, mpackint ldf, mpf_class * scale, mpf_class * dif, mpf_class * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * c, mpackint ldc, mpc_class * d, mpackint ldd, mpc_class * e, mpackint lde, mpc_class * f, mpackint ldf, mpf_class * scale, mpf_class * dif, mpc_class * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpf_class * ap, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Ctpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpc_class * ap, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rtprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Ctprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rtptri ( const char *uplo, const char *diag, mpackint n, mpf_class * ap, mpackint *info );
void Ctptri ( const char *uplo, const char *diag, mpackint n, mpc_class * ap, mpackint *info );
void Rtptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpf_class * ap, mpf_class * B, mpackint ldb, mpackint *info );
void Ctptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpc_class * ap, mpc_class * B, mpackint ldb, mpackint *info );
void Rtrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpf_class * A, mpackint lda, mpf_class * rcond, mpf_class * work, mpackint *iwork, mpackint *info );
void Ctrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpc_class * A, mpackint lda, mpf_class * rcond, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rtrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpf_class * t, mpackint ldt, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpackint mm, mpackint *m, mpf_class * work, mpackint *info );
void Ctrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpc_class * t, mpackint ldt, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpackint mm, mpackint *m, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rtrexc ( const char *compq, mpackint n, mpf_class * t, mpackint ldt, mpf_class * q, mpackint ldq, mpackint *ifst, mpackint *ilst, mpf_class * work, mpackint *info );
void Ctrexc ( const char *compq, mpackint n, mpc_class * t, mpackint ldt, mpc_class * q, mpackint ldq, mpackint ifst, mpackint ilst, mpackint *info );
void Rtrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpf_class * work, mpackint *iwork, mpackint *info );
void Ctrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * x, mpackint ldx, mpf_class * ferr, mpf_class * berr, mpc_class * work, mpf_class * rwork, mpackint *info );
void Rtrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, mpf_class * t, mpackint ldt, mpf_class * q, mpackint ldq, mpf_class * wr, mpf_class * wi, mpackint m, mpf_class * s, mpf_class * sep, mpf_class * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Ctrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, mpc_class * t, mpackint ldt, mpc_class * q, mpackint ldq, mpc_class * w, mpackint m, mpf_class * s, mpf_class * sep, mpc_class * work, mpackint lwork, mpackint *info );
void Rtrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpf_class * t, mpackint ldt, mpf_class * vl, mpackint ldvl, mpf_class * vr, mpackint ldvr, mpf_class * s, mpf_class * sep, mpackint mm, mpackint *m, mpf_class * work, mpackint ldwork, mpackint *iwork, mpackint *info );
void Ctrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpc_class * t, mpackint ldt, mpc_class * vl, mpackint ldvl, mpc_class * vr, mpackint ldvr, mpf_class * s, mpf_class * sep, mpackint mm, mpackint *m, mpc_class * work, mpackint ldwork, mpf_class * rwork, mpackint *info );
void Rtrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * B, mpackint ldb, mpf_class * c, mpackint ldc, mpf_class * scale, mpackint *info );
void Ctrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * B, mpackint ldb, mpc_class * c, mpackint ldc, mpf_class * scale, mpackint *info );
void Rtzrzf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpf_class * work, mpackint lwork, mpackint *info );
void Ctzrzf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpc_class * work, mpackint lwork, mpackint *info );
void Rtzrqf ( mpackint m, mpackint n, mpf_class * A, mpackint lda, mpf_class * tau, mpackint *info );
void Ctzrqf ( mpackint m, mpackint n, mpc_class * A, mpackint lda, mpc_class * tau, mpackint *info );

#endif
