/*
 * Copyright (c) 2012
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mlapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MLAPACK_LONGDOUBLE_H_
#define _MLAPACK_LONGDOUBLE_H_

#include "mpack_config.h"

/* MLAPACK prototypes */

/* MLAPACK driver routines */
void Rsyev ( const char *jobz, const char *uplo, mpackint n, long double * A, mpackint lda, long double * w, long double * work, mpackint lwork, mpackint *info );
void Cheev ( const char *jobz, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * w, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *info );
void Rgesv ( mpackint n, mpackint nrhs, long double * A, mpackint lda, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Cgesv ( mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );

/* MLAPACK computational routines */
void Rsteqr ( const char *compz, mpackint n, long double * d, long double * e, long double * Z, mpackint ldz, long double * work, mpackint *info );
void Csteqr ( const char *compz, mpackint n, long double * d, long double * e, std::complex<long double> * z, mpackint ldz, long double * work, mpackint *info );
void Rsterf ( mpackint n, long double * d, long double * e, mpackint *info );
void Rorgqr ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cungqr ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rorgql ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cungql ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rsytrd ( const char *uplo, mpackint n, long double * A, mpackint lda, long double * d, long double * e, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Chetrd ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * d, long double * e, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rorgtr ( const char *uplo, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cungtr ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rpotrf ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *info );
void Cpotrf ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rtrtri ( const char *uplo, const char *diag, mpackint n, long double * A, mpackint lda, mpackint *info );
void Ctrtri ( const char *uplo, const char *diag, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rgetrf ( mpackint m, mpackint n, long double * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetrf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rgetri ( mpackint n, long double * A, mpackint lda, mpackint *ipiv, long double * work, mpackint lwork, mpackint *info );
void Cgetri ( mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgetrs ( const char *trans, mpackint n, mpackint nrhs, long double * A, mpackint lda, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Cgetrs ( const char *trans, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rtrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *info );
void Ctrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint *info );

/* MLAPACK Auxiliary routines */
long double Rlamc3 ( long double a, long double b );
long double Rlamch_longdouble(const char *cmach);
mpackint iMlaenv_longdouble(mpackint ispec, const char *name, const char *opts, mpackint n1, mpackint n2,  mpackint n3, mpackint n4);
void Rlae2 ( long double a, long double b, long double c, long double * rt1, long double * rt2 );
void Rlaev2 ( long double a, long double b, long double c, long double * rt1, long double * rt2, long double * cs1, long double * sn1 );
void Claev2 ( std::complex<long double> a, std::complex<long double> b, std::complex<long double> c, long double * rt1, long double * rt2, long double * cs1, std::complex<long double> * sn1 );
void Rlassq ( mpackint n, long double * x, mpackint incx, long double * scale, long double * sumsq );
void Classq ( mpackint n, std::complex<long double> * x, mpackint incx, long double * scale, long double * sumsq );
long double Rlanst ( const char *norm, mpackint n, long double * d, long double * e );
long double Clanht ( const char *norm, mpackint n, long double * d, std::complex<long double> * e );
long double Rlansy ( const char *norm, const char *uplo, mpackint n, long double * A, mpackint lda, long double * work );
long double Clansy ( const char *norm, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * work );
long double Clanhe ( const char *norm, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * work );
long double Rlapy2 ( long double x, long double y );
void Rlarfg ( mpackint N, long double * alpha, long double * x, mpackint incx, long double * tau );
long double Rlapy3 ( long double x, long double y, long double z );
void Rladiv ( long double a, long double b, long double c, long double d, long double * p, long double * q );
std::complex<long double> Cladiv ( std::complex<long double> x, std::complex<long double> y );
void Clarfg ( mpackint n, std::complex<long double> * alpha, std::complex<long double> * x, mpackint incx, std::complex<long double> * tau );
void Rlartg ( long double f, long double g, long double * cs, long double * sn, long double * r );
void Clartg ( std::complex<long double> f, std::complex<long double> g, long double * cs, std::complex<long double> * sn, std::complex<long double> * r );
void Rlaset ( const char *uplo, mpackint m, mpackint n, long double alpha, long double beta, long double * A, mpackint lda );
void Claset ( const char *uplo, mpackint m, mpackint n, std::complex<long double> alpha, std::complex<long double> beta, std::complex<long double> * A, mpackint lda );
void Rlasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, long double * c, long double * s, long double * A, mpackint lda );
void Clasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, long double * c, long double * s, std::complex<long double> * A, mpackint lda );
void Rpotf2 ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *info );
void Clacgv ( mpackint n, std::complex<long double> * x, mpackint incx );
void Cpotf2 ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rlascl ( const char *type, mpackint kl, mpackint ku, long double cfrom, long double cto, mpackint m, mpackint n, long double * A, mpackint lda, mpackint *info );
void Clascl ( const char *type, mpackint kl, mpackint ku, long double cfrom, long double cto, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rlasrt ( const char *id, mpackint n, long double * d, mpackint *info );
void Rsytd2 ( const char *uplo, mpackint n, long double * A, mpackint lda, long double * d, long double * e, long double * tau, mpackint *info );
void Chetd2 ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * d, long double * e, std::complex<long double> * tau, mpackint *info );
void Rlarf ( const char *side, mpackint m, mpackint n, long double * v, mpackint incv, long double tau, long double * C, mpackint ldc, long double * work );
void Clarf ( const char *side, mpackint m, mpackint n, std::complex<long double> * v, mpackint incv, std::complex<long double> tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work );
void Rorg2l ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cung2l ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rorg2r ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cung2r ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rlarft ( const char *direct, const char *storev, mpackint n, mpackint k, long double * v, mpackint ldv, long double * tau, long double * t, mpackint ldt );
void Clarft ( const char *direct, const char *storev, mpackint n, mpackint k, std::complex<long double> * v, mpackint ldv, std::complex<long double> * tau, std::complex<long double> * t, mpackint ldt );
void Rlarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, long double * V, mpackint ldv, long double * T, mpackint ldt, long double * C, mpackint ldc, long double * work, mpackint ldwork );
void Clarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, std::complex<long double> * V, mpackint ldv, std::complex<long double> * T, mpackint ldt, std::complex<long double> * C, mpackint ldc, std::complex<long double> * work, mpackint ldwork );
void Rlatrd ( const char *uplo, mpackint n, mpackint nb, long double * A, mpackint lda, long double * e, long double * tau, long double * w, mpackint ldw );
void Clatrd ( const char *uplo, mpackint n, mpackint nb, std::complex<long double> * A, mpackint lda, long double * e, std::complex<long double> * tau, std::complex<long double> * w, mpackint ldw );
void Clacrm ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * B, mpackint ldb, std::complex<long double> * c, mpackint ldc, long double * rwork );
void Rtrti2 ( const char *uplo, const char *diag, mpackint n, long double * A, mpackint lda, mpackint *info );
void Ctrti2 ( const char *uplo, const char *diag, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rgetf2 ( mpackint m, mpackint n, long double * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetf2 ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rlaswp ( mpackint n, long double * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Claswp ( mpackint n, std::complex<long double> * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Rlasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, long double * A, mpackint lda, mpackint *ipiv, long double * w, mpackint ldw, mpackint *info );
void Clasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * w, mpackint ldw, mpackint *info );
void Clahef ( const char *uplo, mpackint n, mpackint nb, mpackint kb, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * w, mpackint ldw, mpackint *info );
void Clacrt ( mpackint n, std::complex<long double> * cx, mpackint incx, std::complex<long double> * cy, mpackint incy, std::complex<long double> c, std::complex<long double> s );
void Claesy ( std::complex<long double> a, std::complex<long double> b, std::complex<long double> c, std::complex<long double> * rt1, std::complex<long double> * rt2, std::complex<long double> * evscal, std::complex<long double> * cs1, std::complex<long double> * sn1 );
void Crot ( mpackint n, std::complex<long double> * cx, mpackint incx, std::complex<long double> * cy, mpackint incy, long double c, std::complex<long double> s );
void Cspmv ( const char *uplo, mpackint n, std::complex<long double> alpha, std::complex<long double> * AP, std::complex<long double> * x, mpackint incx, std::complex<long double> beta, std::complex<long double> * y, mpackint incy );
void Cspr ( const char *uplo, mpackint n, std::complex<long double> alpha, std::complex<long double> * x, mpackint incx, std::complex<long double> * AP );
void Csymv ( const char *uplo, mpackint n, std::complex<long double> alpha, std::complex<long double> * A, mpackint lda, std::complex<long double> * x, mpackint incx, std::complex<long double> beta, std::complex<long double> * y, mpackint incy );
void Csyr ( const char *uplo, mpackint n, std::complex<long double> alpha, std::complex<long double> * x, mpackint incx, std::complex<long double> * A, mpackint lda );
mpackint iCmax1 ( mpackint n, std::complex<long double> * cx, mpackint incx );
long double RCsum1 ( mpackint n, std::complex<long double> * cx, mpackint incx );
void Rlacn2 ( mpackint n, long double * v, long double * x, mpackint *isgn, long double * est, mpackint *kase, mpackint *isave );
void Clacn2 ( mpackint n, std::complex<long double> * v, std::complex<long double> * x, long double * est, mpackint *kase, mpackint *isave );
void Rlatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, long double * A, mpackint lda, long double * x, long double * scale, long double * cnorm, mpackint *info );
void Clatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * x, long double * scale, long double * cnorm, mpackint *info );

/* not yet done ... auxiliary routines */
void Rgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, long double * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<long double> * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgebd2 ( mpackint m, mpackint n, long double * A, mpackint lda, long double * d, long double * e, long double * tauq, long double * taup, long double * work, mpackint *info );
void Cgebd2 ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * d, long double * e, std::complex<long double> * tauq, std::complex<long double> * taup, std::complex<long double> * work, mpackint *info );
void Rgehd2 ( mpackint n, mpackint ilo, mpackint ihi, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cgehd2 ( mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rgelq2 ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cgelq2 ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rgeql2 ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cgeql2 ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rgeqr2 ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cgeqr2 ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rgerq2 ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cgerq2 ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rgesc2 ( mpackint n, long double * A, mpackint lda, long double * rhs, mpackint *ipiv, mpackint *jpiv, long double * scale );
void Cgesc2 ( mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * rhs, mpackint *ipiv, mpackint *jpiv, long double * scale );
void Rgetc2 ( mpackint n, long double * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Cgetc2 ( mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Rgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, long double * dl, long double * d, long double * du, long double * du2, mpackint *ipiv, long double * B, mpackint ldb );
void Cgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * du2, mpackint *ipiv, std::complex<long double> * B, mpackint ldb );
void Rlabrd ( mpackint m, mpackint n, mpackint nb, long double * A, mpackint lda, long double * d, long double * e, long double * tauq, long double * taup, long double * x, mpackint ldx, long double * y, mpackint ldy );
void Clabrd ( mpackint m, mpackint n, mpackint nb, std::complex<long double> * A, mpackint lda, long double * d, long double * e, std::complex<long double> * tauq, std::complex<long double> * taup, std::complex<long double> * x, mpackint ldx, std::complex<long double> * y, mpackint ldy );
void Rlacpy ( const char *uplo, mpackint m, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb );
void Clacpy ( const char *uplo, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb );
void Clarcm ( mpackint m, mpackint n, long double * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * c, mpackint ldc, long double * rwork );
void Rlaebz ( mpackint ijob, mpackint nitmax, mpackint n, mpackint mmax, mpackint minp, mpackint nbmin, long double abstol, long double reltol, long double pivmin, long double * d, long double * e, long double * e2, mpackint *nval, long double * AB, long double * c, mpackint *mout, mpackint *nab, long double * work, mpackint *iwork, mpackint *info );
void Rlaed0 ( mpackint icompq, mpackint qsiz, mpackint n, long double * d, long double * e, long double * q, mpackint ldq, long double * qstore, mpackint ldqs, long double * work, mpackint *iwork, mpackint *info );
void Claed0 ( mpackint qsiz, mpackint n, long double * d, long double * e, std::complex<long double> * q, mpackint ldq, std::complex<long double> * qstore, mpackint ldqs, long double * rwork, mpackint *iwork, mpackint *info );
void Rlaed1 ( mpackint n, long double * d, long double * q, mpackint ldq, mpackint *indxq, long double rho, mpackint cutpnt, long double * work, mpackint *iwork, mpackint *info );
void Rlaed2 ( mpackint *k, mpackint n, mpackint n1, long double * d, long double * q, mpackint ldq, mpackint *indxq, long double * rho, long double * z, long double * dlamda, long double * w, long double * q2, mpackint *indx, mpackint *indxc, mpackint *indxp, mpackint *coltyp, mpackint *info );
void Rlaed3 ( mpackint k, mpackint n, mpackint n1, long double * d, long double * q, mpackint ldq, long double * rho, long double * dlamda, long double * q2, mpackint *indx, mpackint *ctot, long double * w, long double * s, mpackint *info );
void Rlaed4 ( mpackint n, mpackint i, long double * d, long double * z, long double * delta, long double rho, long double * dlam, mpackint *info );
void Rlaed5 ( mpackint i, long double * d, long double * z, long double * delta, long double rho, long double * dlam );
void Rlaed6 ( mpackint kniter, mpackint orgati, long double rho, long double * d, long double * z, long double * finit, long double * tau, mpackint *info );
void Rlaed7 ( mpackint icompq, mpackint n, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, long double * d, long double * q, mpackint ldq, mpackint *indxq, long double rho, mpackint cutpnt, long double * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, long double * givnum, long double * work, mpackint *iwork, mpackint *info );
void Claed7 ( mpackint n, mpackint cutpnt, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, long double * d, std::complex<long double> * q, mpackint ldq, long double rho, mpackint *indxq, long double * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, long double * givnum, std::complex<long double> * work, long double * rwork, mpackint *iwork, mpackint *info );
void Rlaed8 ( mpackint icompq, mpackint *k, mpackint n, mpackint qsiz, long double * d, long double * q, mpackint ldq, mpackint *indxq, long double * rho, mpackint cutpnt, long double * z, long double * dlamda, long double * q2, mpackint ldq2, long double * w, mpackint *perm, mpackint *givptr, mpackint *givcol, long double * givnum, mpackint *indxp, mpackint *indx, mpackint *info );
void Claed8 ( mpackint *k, mpackint n, mpackint qsiz, std::complex<long double> * q, mpackint ldq, long double * d, long double * rho, mpackint cutpnt, long double * z, long double * dlamda, std::complex<long double> * q2, mpackint ldq2, long double * w, mpackint *indxp, mpackint *indx, mpackint *indxq, mpackint *perm, mpackint *givptr, mpackint *givcol, long double * givnum, mpackint *info );
void Rlaed9 ( mpackint k, mpackint kstart, mpackint kstop, mpackint n, long double * d, long double * q, mpackint ldq, long double rho, long double * dlamda, long double * w, long double * s, mpackint lds, mpackint *info );
void Rlaeda ( mpackint n, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, long double * givnum, long double * q, mpackint *qptr, long double * z, long double * ztemp, mpackint *info );
void Rlaein ( mpackint rightv, mpackint noinit, mpackint n, long double * h, mpackint ldh, long double wr, long double wi, long double * vr, long double * vi, long double * B, mpackint ldb, long double * work, long double eps3, long double smlnum, long double bignum, mpackint *info );
void Claein ( mpackint rightv, mpackint noinit, mpackint n, std::complex<long double> * h, mpackint ldh, std::complex<long double> w, std::complex<long double> * v, std::complex<long double> * B, mpackint ldb, long double * rwork, long double eps3, long double smlnum, mpackint *info );
void Rlaexc ( mpackint wantq, mpackint n, long double * t, mpackint ldt, long double * q, mpackint ldq, mpackint j1, mpackint n1, mpackint n2, long double * work, mpackint *info );
void Rlag2 ( long double * A, mpackint lda, long double * B, mpackint ldb, long double safmin, long double * scale1, long double * scale2, long double * wr1, long double * wr2, long double * wi );
void Rlags2 ( mpackint upper, long double a1, long double a2, long double a3, long double b1, long double b2, long double b3, long double * csu, long double * snu, long double * csv, long double * snv, long double * csq, long double * snq );
void Clags2 ( mpacklogical * upper, long double a1, std::complex<long double> a2, long double a3, long double b1, std::complex<long double> b2, long double b3, long double * csu, std::complex<long double> * snu, long double * csv, std::complex<long double> * snv, long double * csq, std::complex<long double> * snq );
void Rlagtf ( mpackint n, long double * a, long double lambda, long double * b, long double * c, long double * tol, long double * d, mpackint *in, mpackint *info );
void Rlagtm ( const char *trans, mpackint n, mpackint nrhs, long double alpha, long double * dl, long double * d, long double * du, long double * x, mpackint ldx, long double * beta, long double * B, mpackint ldb );
void Clagtm ( const char *trans, mpackint n, mpackint nrhs, long double alpha, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * x, mpackint ldx, long double beta, std::complex<long double> * B, mpackint ldb );
void Rlagts ( mpackint job, mpackint n, long double * a, long double * b, long double * c, long double * d, mpackint *in, long double * y, long double * tol, mpackint *info );
void Rlagv2 ( long double * A, mpackint lda, long double * B, mpackint ldb, long double * alphar, long double * alphai, long double * beta, long double * csl, long double * snl, long double * csr, long double * snr );
void Rlahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, long double * h, mpackint ldh, long double * wr, long double * wi, mpackint iloz, mpackint ihiz, long double * z, mpackint ldz, mpackint *info );
void Clahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * h, mpackint ldh, std::complex<long double> * w, mpackint iloz, mpackint ihiz, std::complex<long double> * z, mpackint ldz, mpackint *info );
void Rlahr2 ( mpackint n, mpackint k, mpackint nb, long double * A, mpackint lda, long double * tau, long double * t, mpackint ldt, long double * y, mpackint ldy );
void Clahr2 ( mpackint n, mpackint k, mpackint nb, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * t, mpackint ldt, std::complex<long double> * y, mpackint ldy );
void Rlahrd ( mpackint n, mpackint k, mpackint nb, long double * A, mpackint lda, long double * tau, long double * t, mpackint ldt, long double * y, mpackint ldy );
void Clahrd ( mpackint n, mpackint k, mpackint nb, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * t, mpackint ldt, std::complex<long double> * y, mpackint ldy );
void Rlaic1 ( mpackint job, mpackint j, long double * x, long double sest, long double * w, long double gamma, long double * sestpr, long double * s, long double * c );
void Claic1 ( mpackint job, mpackint j, std::complex<long double> * x, long double sest, std::complex<long double> * w, std::complex<long double> gamma, long double * sestpr, std::complex<long double> * s, std::complex<long double> * c );
void Rlaln2 ( mpackint ltrans, mpackint na, mpackint nw, long double smin, long double ca, long double * A, mpackint lda, long double d1, long double d2, long double * B, mpackint ldb, long double wr, long double wi, long double * x, mpackint ldx, long double * scale, long double * xnorm, mpackint *info );
void Rlals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, long double * B, mpackint ldb, long double * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, long double * givnum, mpackint ldgnum, long double * poles, long double * difl, long double * difr, long double * z, mpackint k, long double c, long double s, long double * work, mpackint *info );
void Clals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, std::complex<long double> * B, mpackint ldb, std::complex<long double> * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, long double * givnum, mpackint ldgnum, long double * poles, long double * difl, long double * difr, long double * z, mpackint k, long double c, long double s, long double * rwork, mpackint *info );
void Rlalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, long double * B, mpackint ldb, long double * bx, mpackint ldbx, long double * u, mpackint ldu, long double * vt, mpackint *k, long double * difl, long double * difr, long double * z, long double * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, long double * givnum, long double * c, long double * s, long double * work, mpackint *iwork, mpackint *info );
void Clalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, std::complex<long double> * B, mpackint ldb, std::complex<long double> * bx, mpackint ldbx, long double * u, mpackint ldu, long double * vt, mpackint *k, long double * difl, long double * difr, long double * z, long double * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, long double * givnum, long double * c, long double * s, long double * rwork, mpackint *iwork, mpackint *info );
void Rlalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, long double * d, long double * e, long double * B, mpackint ldb, long double rcond, mpackint *rank, long double * work, mpackint *iwork, mpackint *info );
void Clalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, long double * d, long double * e, std::complex<long double> * B, mpackint ldb, long double rcond, mpackint *rank, std::complex<long double> * work, long double * rwork, mpackint *iwork, mpackint *info );
void Rlamrg ( mpackint n1, mpackint n2, long double * a, mpackint dtrd1, mpackint dtrd2, mpackint *index );
long double Rlangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, long double * ab, mpackint ldab, long double * work );
long double Clangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, std::complex<long double> * AB, mpackint ldab, long double * work );
long double Rlange ( const char *norm, mpackint m, mpackint n, long double * A, mpackint lda, long double * work );
long double Clange ( const char *norm, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * work );
long double Rlangt ( const char *norm, mpackint n, long double * dl, long double * d, long double * du );
long double Clangt ( const char *norm, mpackint n, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du );
long double Rlanhs ( const char *norm, mpackint n, long double * A, mpackint lda, long double * work );
long double Clanhs ( const char *norm, mpackint n, std::complex<long double> * A, mpackint lda, long double * work );
long double Rlansb ( const char *norm, const char *uplo, mpackint n, mpackint k, long double * AB, mpackint ldab, long double * work );
long double Clansb ( const char *norm, const char *uplo, mpackint n, mpackint k, std::complex<long double> * AB, mpackint ldab, long double * work );
long double Clanhb ( const char *norm, const char *uplo, mpackint n, mpackint k, std::complex<long double> * AB, mpackint ldab, long double * work );
long double Rlansp ( const char *norm, const char *uplo, mpackint n, long double * ap, long double * work );
long double Clansp ( const char *norm, const char *uplo, mpackint n, std::complex<long double> * ap, long double * work );
long double Clanhp ( const char *norm, const char *uplo, mpackint n, std::complex<long double> * ap, long double * work );
long double Rlantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, long double * AB, mpackint ldab, long double * work );
std::complex<long double> Clantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, std::complex<long double> * AB, mpackint ldab, long double * work );
long double Rlantp ( const char *norm, const char *uplo, const char *diag, mpackint n, long double * ap, long double * work );
std::complex<long double> Clantp ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<long double> * ap, long double * work );
long double Rlantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, long double * A, mpackint lda, long double * work );
long double Clantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * work );
void Rlanv2 ( long double * a, long double * b, long double * c, long double * d, long double * rt1r, long double * rt1i, long double * rt2r, long double * rt2i, long double * cs, long double * sn );
void Rlapll ( mpackint n, long double * x, mpackint incx, long double * y, mpackint incy, long double * ssmin );
void Clapll ( mpackint n, std::complex<long double> * x, mpackint incx, std::complex<long double> * y, mpackint incy, long double * ssmin );
void Rlapmt ( mpackint *forwrd, mpackint m, mpackint n, long double * X, mpackint ldx, mpackint *k );
void Clapmt ( mpackint *forwrd, mpackint m, mpackint n, std::complex<long double> * X, mpackint ldx, mpackint *k );
void Rlaqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, long double * AB, mpackint ldab, long double * r, long double * c, long double rowcnd, long double colcnd, long double amax, char *equed );
void Claqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<long double> * AB, mpackint ldab, long double * r, long double * c, long double rowcnd, long double colcnd, long double amax, char *equed );
void Rlaqge ( mpackint m, mpackint n, long double * A, mpackint lda, long double * r, long double * c, long double rowcnd, long double colcnd, long double amax, char *equed );
void Claqge ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * r, long double * c, long double rowcnd, long double colcnd, long double amax, char *equed );
void Rlaqp2 ( mpackint m, mpackint n, mpackint offset, long double * A, mpackint lda, mpackint *jpvt, long double * tau, long double * vn1, long double * vn2, long double * work );
void Claqp2 ( mpackint m, mpackint n, mpackint offset, std::complex<long double> * A, mpackint lda, mpackint *jpvt, std::complex<long double> * tau, long double * vn1, long double * vn2, std::complex<long double> * work );
void Rlaqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, long double * A, mpackint lda, mpackint *jpvt, long double * tau, long double * vn1, long double * vn2, long double * auxv, long double * f, mpackint ldf );
void Claqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, std::complex<long double> * A, mpackint lda, mpackint *jpvt, std::complex<long double> * tau, long double * vn1, long double * vn2, std::complex<long double> * auxv, std::complex<long double> * f, mpackint ldf );
void Rlaqsb ( const char *uplo, mpackint n, mpackint kd, long double * ab, mpackint ldab, long double * s, long double scond, long double amax, char *equed );
void Claqsb ( const char *uplo, mpackint n, mpackint kd, std::complex<long double> * ab, mpackint ldab, long double * s, long double scond, long double amax, char *equed );
void Claqhb ( const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, long double * s, long double scond, long double amax, char *equed );
void Rlaqsp ( const char *uplo, mpackint n, long double * ap, long double * s, long double scond, long double amax, char *equed );
void Claqsp ( const char *uplo, mpackint n, std::complex<long double> * ap, long double * s, long double scond, long double amax, char *equed );
void Claqhp ( const char *uplo, mpackint n, std::complex<long double> * ap, long double * s, long double scond, long double amax, char *equed );
void Rlaqsy ( const char *uplo, mpackint n, long double * A, mpackint lda, long double * s, long double scond, long double amax, char *equed );
void Claqsy ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * s, long double scond, long double amax, char *equed );
void Claqhe ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * s, long double scond, long double amax, char *equed );
void Rlaqtr ( mpackint ltran, mpackint lreal, mpackint n, long double * t, mpackint ldt, long double * B, long double w, long double * scale, long double * x, long double * work, mpackint *info );
void Rlar1v ( mpackint n, mpackint b1, mpackint bn, long double lambda, long double * d, long double * l, long double * ld, long double * lld, long double pivmin, long double gaptol, long double * z, mpackint wantnc, mpackint *negcnt, long double * ztz, long double * mingma, mpackint *r, mpackint *isuppz, long double * nrminv, long double * resid, long double * rqcorr, long double * work );
void Clar1v ( mpackint n, mpackint b1, mpackint bn, long double lambda, long double * d, long double * l, long double * ld, long double * lld, long double pivmin, long double gaptol, std::complex<long double> * z, mpackint wantnc, mpackint *negcnt, long double * ztz, long double * mingma, mpackint *r, mpackint *isuppz, long double * nrminv, long double * resid, long double * rqcorr, long double * work );
void Rlar2v ( mpackint n, long double * x, long double * y, long double * z, mpackint incx, long double * c, long double * s, mpackint incc );
void Clar2v ( mpackint n, std::complex<long double> * x, std::complex<long double> * y, std::complex<long double> * z, mpackint incx, long double * c, std::complex<long double> * s, mpackint incc );
void Rlarfx ( const char *side, mpackint m, mpackint n, long double * v, long double tau, long double * c, mpackint ldc, long double * work );
void Clarfx ( const char *side, mpackint m, mpackint n, std::complex<long double> * v, std::complex<long double> tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work );
void Rlargv ( mpackint n, long double * x, mpackint incx, long double * y, mpackint incy, long double * c, mpackint incc );
void Clargv ( mpackint n, std::complex<long double> * x, mpackint incx, std::complex<long double> * y, mpackint incy, long double * c, mpackint incc );
void Rlarnv ( mpackint idist, mpackint *iseed, mpackint n, long double * x );
void Clarnv ( mpackint idist, mpackint *iseed, mpackint n, std::complex<long double> * x );
mpackint Rlaneg ( mpackint n, long double * d, long double * lld, long double sigma, long double pivmin, mpackint r );
void Rlarra ( mpackint n, long double * d, long double * e, long double * e2, long double spltol, long double tnrm, mpackint *nsplit, mpackint *isplit, mpackint *info );
void Rlarrb ( mpackint n, long double * d, long double * lld, mpackint ifirst, mpackint ilast, long double rtol1, long double rtol2, mpackint offset, long double * w, long double * wgap, long double * werr, long double * work, mpackint *iwork, long double pivmin, long double spdiam, mpackint twist, mpackint *info );
void Rlarrc ( const char *jobt, mpackint n, long double vl, long double vu, long double * d, long double * e, long double pivmin, mpackint *eigcnt, mpackint *lcnt, mpackint *rcnt, mpackint *info );
void Rlarrd ( const char *range, const char *order, mpackint n, long double vl, long double vu, mpackint il, mpackint iu, long double *gers, long double reltol, long double * d, long double * e, long double * e2, long double pivmin, mpackint nsplit, mpackint *isplit, mpackint *m, long double * w, long double * werr, long double * wl, long double * wu, mpackint *iblock, mpackint *indexw, long double * work, mpackint *iwork, mpackint *info );
void Rlarre ( const char *range, mpackint n, long double * vl, long double * vu, mpackint il, mpackint iu, long double * d, long double * e, long double * e2, long double rtol1, long double rtol2, long double spltol, mpackint * nsplit, mpackint *isplit, mpackint * m, long double * w, long double * werr, long double * wgap, mpackint *iblock, mpackint *indexw, long double * gers, long double * pivmin, long double * work, mpackint *iwork, mpackint *info );
void Rlarrf ( mpackint n, long double * d, long double * l, long double * ld, mpackint clstrt, mpackint clend, long double * w, long double * wgap, long double * werr, long double spdiam, long double clgapl, long double clgapr, long double pivmin, long double * sigma, long double * dplus, long double * lplus, long double * work, mpackint *info );
void Rlarrj ( mpackint n, long double * d, long double * e2, mpackint ifirst, mpackint ilast, long double rtol, mpackint offset, long double * w, long double * werr, long double * work, mpackint *iwork, long double pivmin, long double spdiam, mpackint *info );
void Rlarrk ( mpackint n, mpackint iw, long double gl, long double gu, long double * d, long double * e2, long double pivmin, long double reltol, long double * w, long double * werr, mpackint *info );
void Rlarrr ( mpackint n, long double * d, long double * e, mpackint *info );
void Rlartv ( mpackint n, long double * x, mpackint incx, long double * y, mpackint incy, long double * c, long double * s, mpackint incc );
void Clartv ( mpackint n, std::complex<long double> * x, mpackint incx, std::complex<long double> * y, mpackint incy, long double * c, std::complex<long double> * s, mpackint incc );
void Rlarrv ( mpackint n, long double vl, long double vu, long double * d, long double * l, long double pivmin, mpackint * isplit, mpackint m, mpackint dol, mpackint dou, long double minrgp, long double rtol1, long double rtol2, long double * w, long double * werr, long double * wgap, mpackint * iblock, mpackint * indexw, long double * gers, long double * z, mpackint ldz, mpackint * isuppz, long double * work, mpackint * iwork, mpackint * info );
void Clarrv ( mpackint n, long double vl, long double vu, long double * d, long double * l, long double pivmin, mpackint *isplit, mpackint m, mpackint dol, mpackint dou, long double minrgp, long double rtol1, long double rtol2, long double * w, long double * werr, long double * wgap, mpackint *iblock, mpackint *indexw, long double * gers, std::complex<long double> * z, mpackint ldz, mpackint *isuppz, long double * work, mpackint *iwork, mpackint *info );
void Rlaruv ( mpackint *iseed, mpackint n, long double * x );
void Rlarz ( const char *side, mpackint m, mpackint n, mpackint l, long double * v, mpackint incv, long double tau, long double * C, mpackint ldc, long double * work );
void Clarz ( const char *side, mpackint m, mpackint n, mpackint l, std::complex<long double> * v, mpackint incv, std::complex<long double> tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work );
void Rlarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, long double * v, mpackint ldv, long double * t, mpackint ldt, long double * c, mpackint ldc, long double * work, mpackint ldwork );
void Clarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<long double> * v, mpackint ldv, std::complex<long double> * t, mpackint ldt, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint ldwork );
void Rlarzt ( const char *direct, const char *storev, mpackint n, mpackint k, long double * v, mpackint ldv, long double * tau, long double * t, mpackint ldt );
void Clarzt ( const char *direct, const char *storev, mpackint n, mpackint k, std::complex<long double> * v, mpackint ldv, std::complex<long double> * tau, std::complex<long double> * t, mpackint ldt );
void Rlas2 ( long double f, long double g, long double h, long double * ssmin, long double * ssmax );
void Rlasd0 ( mpackint n, mpackint sqre, long double * d, long double * e, long double * u, mpackint ldu, long double * vt, mpackint ldvt, mpackint smlsiz, mpackint *iwork, long double * work, mpackint *info );
void Rlasd1 ( mpackint nl, mpackint nr, mpackint *sqre, long double * d, long double * alpha, long double * beta, long double * u, mpackint ldu, long double * vt, mpackint ldvt, mpackint *idxq, mpackint *iwork, long double * work, mpackint *info );
void Rlasd2 ( mpackint nl, mpackint nr, mpackint sqre, mpackint *k, long double * d, long double * z, long double alpha, long double beta, long double * u, mpackint ldu, long double * vt, mpackint ldvt, long double * dsigma, long double * u2, mpackint ldu2, long double * vt2, mpackint ldvt2, mpackint *idxp, mpackint *idx, mpackint *idxc, mpackint *idxq, mpackint *coltyp, mpackint *info );
void Rlasd3 ( mpackint nl, mpackint nr, mpackint sqre, mpackint k, long double * d, long double * q, mpackint ldq, long double * dsigma, long double * u, mpackint ldu, long double * u2, mpackint ldu2, long double * vt, mpackint ldvt, long double * vt2, mpackint ldvt2, mpackint *idxc, mpackint *ctot, long double * z, mpackint *info );
void Rlasd4 ( mpackint n, mpackint i, long double * d, long double * z, long double * delta, long double rho, long double * sigma, long double * work, mpackint *info );
void Rlasd5 ( mpackint i, long double * d, long double * z, long double * delta, long double rho, long double * dsigma, long double * work );
void Rlasd6 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, long double * d, long double * vf, long double * vl, long double * alpha, long double * beta, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, long double * givnum, mpackint ldgnum, long double * poles, long double * difl, long double * difr, long double * z, mpackint k, long double * c, long double * s, long double * work, mpackint *iwork, mpackint *info );
void Rlasd7 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint k, long double * d, long double * z, long double * zw, long double * vf, long double * vfw, long double * vl, long double * vlw, long double alpha, long double beta, long double * dsigma, mpackint *idx, mpackint *idxp, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, long double * givnum, mpackint ldgnum, long double * c, long double * s, mpackint *info );
void Rlasd8 ( mpackint icompq, mpackint k, long double * d, long double * z, long double * vf, long double * vl, long double * difl, long double * difr, mpackint lddifr, long double * dsigma, long double * work, mpackint *info );
void Rlasda ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint sqre, long double * d, long double * e, long double * u, mpackint ldu, long double * vt, mpackint *k, long double * difl, long double * difr, long double * z, long double * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, long double * givnum, long double * c, long double * s, long double * work, mpackint *iwork, mpackint *info );
void Rlasdq ( const char *uplo, mpackint sqre, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, long double * d, long double * e, long double * vt, mpackint ldvt, long double * u, mpackint ldu, long double * c, mpackint ldc, long double * work, mpackint *info );
void Rlasdt ( mpackint n, mpackint lvl, mpackint nd, mpackint *inode, mpackint *ndiml, mpackint *ndimr, mpackint msub );
void Rlasq1 ( mpackint n, long double * d, long double * e, long double * work, mpackint *info );
void Rlasq2 ( mpackint n, long double * z, mpackint *info );
void Rlasq3 ( mpackint i0, mpackint n0, long double * z, mpackint pp, long double * dmin, long double * sigma, long double * desig, long double qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint ieee );
void Rlasq4 ( mpackint i0, mpackint n0, long double * z, mpackint pp, mpackint n0in, long double dmin, long double dmin1, long double dmin2, long double dn, long double dn1, long double dn2, long double * tau, mpackint *ttype );
void Rlasq5 ( mpackint i0, mpackint n0, long double * z, mpackint pp, long double tau, long double * dmin, long double * dmin1, long double * dmin2, long double * dn, long double * dnm1, long double * dnm2, mpackint ieee );
void Rlasq6 ( mpackint i0, mpackint n0, long double * z, mpackint pp, long double * dmin, long double * dmin1, long double * dmin2, long double * dn, long double * dnm1, long double * dnm2 );
void Rlasv2 ( long double f, long double g, long double h, long double * ssmin, long double * ssmax, long double * snr, long double * csr, long double * snl, long double * csl );
void Rlasy2 ( mpackint ltranl, mpackint ltranr, mpackint isgn, mpackint n1, mpackint n2, long double * tl, mpackint ldtl, long double * tr, mpackint ldtr, long double * B, mpackint ldb, long double * scale, long double * x, mpackint ldx, long double * xnorm, mpackint *info );
void Rlatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, long double * AB, mpackint ldab, long double * x, long double * scale, long double * cnorm, mpackint *info );
void Clatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * x, long double * scale, long double * cnorm, mpackint *info );
void Rlatdf ( mpackint ijob, mpackint n, long double * z, mpackint ldz, long double * rhs, long double * rdsum, long double * rdscal, mpackint *ipiv, mpackint *jpiv );
void Clatdf ( mpackint ijob, mpackint n, std::complex<long double> * z, mpackint ldz, std::complex<long double> * rhs, long double * rdsum, long double * rdscal, mpackint *ipiv, mpackint *jpiv );
void Rlatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, long double * ap, long double * x, long double * scale, long double * cnorm, mpackint *info );
void Clatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, std::complex<long double> * ap, std::complex<long double> * x, long double * scale, long double * cnorm, mpackint *info );
void Rlauu2 ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *info );
void Clauu2 ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rlauum ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *info );
void Clauum ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rlatrz ( mpackint m, mpackint n, mpackint l, long double * A, mpackint lda, long double * tau, long double * work );
void Clatrz ( mpackint m, mpackint n, mpackint l, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work );
void Rorgl2 ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cungl2 ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rorgr2 ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint *info );
void Cungr2 ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rorm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint *info );
void Cunm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint *info );
void Rorm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint *info );
void Cunm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint *info );
void Rorml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint *info );
void Cunml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint *info );
void Rormr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * C, mpackint ldc, long double * work, mpackint *info );
void Cunmr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint *info );
void Rormr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint *info );
void Cunmr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint *info );
void Rpbtf2 ( const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, mpackint *info );
void Cpbtf2 ( const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, mpackint *info );
void Rptts2 ( mpackint n, mpackint nrhs, long double * d, long double * e, long double * b, mpackint ldb );
void Cptts2 ( mpackint iuplo, mpackint n, mpackint nrhs, long double * d, std::complex<long double> * e, std::complex<long double> * B, mpackint ldb );
void Rrscl ( mpackint n, long double sa, long double * sx, mpackint incx );
void CRrscl ( mpackint n, long double sa, std::complex<long double> * sx, mpackint incx );
void Rsygs2 ( mpackint itype, const char *uplo, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *info );
void Chegs2 ( mpackint itype, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rsytf2 ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Csytf2 ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Chetf2 ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rtgex2 ( mpackint wantq, mpackint wantz, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * q, mpackint ldq, long double * z, mpackint ldz, mpackint j1, mpackint n1, mpackint n2, long double * work, mpackint lwork, mpackint *info );
void Ctgex2 ( mpackint wantq, mpackint wantz, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * q, mpackint ldq, std::complex<long double> * z, mpackint ldz, mpackint j1, mpackint *info );
void Rtgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * c, mpackint ldc, long double * d, mpackint ldd, long double * e, mpackint lde, long double * f, mpackint ldf, long double * scale, long double * rdsum, long double * rdscal, mpackint *iwork, mpackint *pq, mpackint *info );
void Ctgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * C, mpackint ldc, std::complex<long double> * d, mpackint ldd, std::complex<long double> * e, mpackint lde, std::complex<long double> * f, mpackint ldf, long double * scale, long double * rdsum, long double * rdscal, mpackint *info );
void Rlazq3 ( mpackint i0, mpackint n0, long double * z, mpackint pp, long double * dmin, long double * sigma, long double * desig, long double qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint *ieee, mpackint *ttype, long double * dmin1, long double * dmin2, long double * dn, long double * dn1, long double * dn2, long double * tau );
void Rlazq4 ( mpackint i0, mpackint n0, long double * z, mpackint pp, mpackint n0in, long double dmin, long double dmin1, long double dmin2, long double dn, long double dn1, long double dn2, long double * tau, mpackint *ttype, long double * g );
void Rlaqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, long double * h, mpackint ldh, long double * wr, long double * wi, mpackint iloz, mpackint ihiz, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *info );
void Claqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * h, mpackint ldh, std::complex<long double> * w, mpackint *iloz, mpackint *ihiz, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rlaqr1 ( mpackint n, long double * h, mpackint ldh, long double sr1, long double si1, long double sr2, long double si2, long double * v );
void Claqr1 ( mpackint n, std::complex<long double> * h, mpackint ldh, std::complex<long double> s1, std::complex<long double> s2, std::complex<long double> * v );
void Rlaqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, long double * h, mpackint ldh, mpackint iloz, mpackint ihiz, long double * z, mpackint ldz, mpackint *ns, mpackint *nd, long double * sr, long double * si, long double * v, mpackint ldv, mpackint nh, long double * t, mpackint ldt, mpackint nv, long double * wv, mpackint ldwv, long double * work, mpackint lwork );
void Claqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, std::complex<long double> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<long double> * z, mpackint ldz, mpackint *ns, mpackint *nd, std::complex<long double> * sh, std::complex<long double> * v, mpackint ldv, mpackint nh, std::complex<long double> * t, mpackint ldt, mpackint nv, std::complex<long double> * wv, mpackint ldwv, std::complex<long double> * work, mpackint lwork );
void Rlaqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, long double * h, mpackint ldh, mpackint iloz, mpackint ihiz, long double * z, mpackint ldz, mpackint ns, mpackint nd, long double * sr, long double * si, long double * v, mpackint ldv, mpackint nh, long double * t, mpackint ldt, mpackint nv, long double * wv, mpackint ldwv, long double * work, mpackint lwork );
void Claqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, std::complex<long double> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<long double> * z, mpackint ldz, mpackint *ns, mpackint *nd, std::complex<long double> * sh, std::complex<long double> * v, mpackint ldv, mpackint nh, std::complex<long double> * t, mpackint ldt, mpackint nv, std::complex<long double> * wv, mpackint ldwv, std::complex<long double> * work, mpackint lwork );
void Rlaqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, long double * h, mpackint ldh, long double * wr, long double * wi, mpackint iloz, mpackint ihiz, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *info );
void Claqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * h, mpackint ldh, std::complex<long double> * w, mpackint iloz, mpackint ihiz, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rlaqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kac22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, long double * sr, long double * si, long double * h, mpackint ldh, mpackint iloz, mpackint ihiz, long double * z, mpackint ldz, long double * v, mpackint ldv, long double * u, mpackint ldu, mpackint nv, long double * wv, mpackint ldwv, mpackint nh, long double * wh, mpackint ldwh );
void Claqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kacc22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, std::complex<long double> * s, std::complex<long double> * h, mpackint ldh, mpackint iloz, mpackint ihiz, std::complex<long double> * z, mpackint ldz, std::complex<long double> * v, mpackint ldv, std::complex<long double> * u, mpackint ldu, mpackint nv, std::complex<long double> * wv, mpackint ldwv, mpackint nh, std::complex<long double> * wh, mpackint ldwh );
void Rlatzm ( const char *side, mpackint m, mpackint n, long double * v, mpackint incv, long double * tau, long double *c1, long double * c2, mpackint ldc, long double * work );
void Clatzm ( const char *side, mpackint m, mpackint n, std::complex<long double> * v, mpackint incv, std::complex<long double> * tau, std::complex<long double> * c1, std::complex<long double> * c2, mpackint ldc, std::complex<long double> * work );
void Clacp2 ( const char *uplo, mpackint m, mpackint n, long double * A, mpackint lda, std::complex<long double> * B, mpackint ldb );
mpackint Risnan ( long double din );

/* not yet done ... driver and computational routines */
void Rbdsdc ( const char *uplo, const char *compq, mpackint n, long double * d, long double * e, long double * u, mpackint ldu, long double * vt, mpackint ldvt, long double * q, mpackint * iq, long double * work, mpackint * iwork, mpackint * info );
void Rbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, long double * d, long double * e, long double * vt, mpackint ldvt, long double * u, mpackint ldu, long double * c, mpackint ldc, long double * work, mpackint *info );
void Cbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, long double * d, long double * e, std::complex<long double> * vt, mpackint ldvt, std::complex<long double> * u, mpackint ldu, std::complex<long double> * c, mpackint ldc, long double * rwork, mpackint * info );
void Rdisna ( const char *job, mpackint m, mpackint n, long double * d, long double * sep, mpackint *info );
void Rgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, long double * AB, mpackint ldab, long double * d, long double * e, long double * q, mpackint ldq, long double * pt, mpackint ldpt, long double * c, mpackint ldc, long double * work, mpackint *info );
void Cgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, std::complex<long double> * AB, mpackint ldab, long double * d, long double * e, std::complex<long double> * q, mpackint ldq, std::complex<long double> * pt, mpackint ldpt, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, long double * AB, mpackint ldab, mpackint *ipiv, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Cgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, std::complex<long double> * AB, mpackint ldab, mpackint *ipiv, long double anorm, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, long double * AB, mpackint ldab, long double * r, long double * c, long double * rowcnd, long double * colcnd, long double * amax, mpackint *info );
void Cgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<long double> * AB, mpackint ldab, long double * r, long double * c, long double * rowcnd, long double * colcnd, long double * amax, mpackint *info );
void Rgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, long double * AB, mpackint ldab, long double * afb, mpackint ldafb, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * afb, mpackint ldafb, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, long double * AB, mpackint ldab, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Cgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<long double> * ab, mpackint ldab, mpackint *ipiv, std::complex<long double> * b, mpackint ldb, mpackint *info );
void Rgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, long double * AB, mpackint ldab, long double * afb, mpackint ldafb, mpackint * ipiv, char *equed, long double * r, long double * c, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint * iwork, mpackint * info );
void Cgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * afb, mpackint ldafb, mpackint * ipiv, char *equed, long double * r, long double * c, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, long double * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, std::complex<long double> * ab, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, long double * AB, mpackint ldab, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Cgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, std::complex<long double> * AB, mpackint ldab, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, long double * scale, mpackint m, long double * v, mpackint ldv, mpackint *info );
void Cgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, long double * scale, mpackint m, std::complex<long double> * v, mpackint ldv, mpackint *info );
void Rgebal ( const char *job, mpackint n, long double * A, mpackint lda, mpackint *ilo, mpackint *ihi, long double * scale, mpackint *info );
void Cgebal ( const char *job, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ilo, mpackint *ihi, long double * scale, mpackint *info );
void Rgebrd ( mpackint m, mpackint n, long double * A, mpackint lda, long double * d, long double * e, long double * tauq, long double * taup, long double * work, mpackint lwork, mpackint *info );
void Cgebrd ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * d, long double * e, std::complex<long double> * tauq, std::complex<long double> * taup, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgecon ( const char *norm, mpackint n, long double * A, mpackint lda, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Cgecon ( const char *norm, mpackint n, std::complex<long double> * A, mpackint lda, long double anorm, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgeequ ( mpackint m, mpackint n, long double * A, mpackint lda, long double * r, long double * c, long double * rowcnd, long double * colcnd, long double * amax, mpackint *info );
void Cgeequ ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * r, long double * c, long double * rowcnd, long double * colcnd, long double * amax, mpackint *info );
void Rgees ( const char *jobvs, const char *sort, LFP select, mpackint n, long double * A, mpackint lda, mpackint *sdim, long double * wr, long double * wi, long double * vs, mpackint ldvs, long double * work, mpackint lwork, mpacklogical * bwork, mpackint *info );
void Cgees ( const char *jobvs, const char *sort, LFP select, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *sdim, std::complex<long double> * w, std::complex<long double> * vs, mpackint ldvs, std::complex<long double> * work, mpackint lwork, long double * rwork, mpacklogical * bwork, mpackint *info );
void Rgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, long double * A, mpackint lda, mpackint * sdim, long double * wr, long double * wi, long double * vs, mpackint ldvs, long double * rconde, long double * rcondv, long double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *sdim, std::complex<long double> * w, std::complex<long double> * vs, mpackint ldvs, long double * rconde, long double * rcondv, std::complex<long double> * work, mpackint lwork, long double * rwork, mpacklogical * bwork, mpackint *info );
void Rgeev ( const char *jobvl, const char *jobvr, mpackint n, long double * A, mpackint lda, long double * wr, long double * wi, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, long double * work, mpackint lwork, mpackint *info );
void Cgeev ( const char *jobvl, const char *jobvr, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * w, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Rgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, long double * A, mpackint lda, long double * wr, long double * wi, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, long double * scale, long double * abnrm, long double * rconde, long double * rcondv, long double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * w, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, long double * scale, long double * abnrm, long double * rconde, long double * rcondv, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Cgehrd ( mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgehrd ( mpackint n, mpackint ilo, mpackint ihi, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Rgelqf ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cgelqf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, long double * work, mpackint lwork, mpackint *info );
void Cgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgelsx ( mpackint m, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *jpvt, long double rcond, mpackint *rank, long double * work, mpackint *info );
void Cgelsx ( mpackint m, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint *jpvt, long double rcond, mpackint *rank, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgelsd ( mpackint m, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, long double * s, long double * rcond, mpackint *rank, long double * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Cgelsd ( mpackint m, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double * s, long double rcond, mpackint * rank, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * iwork, mpackint * info );
void Rgelss ( mpackint m, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, long double * s, long double rcond, mpackint * rank, long double * work, mpackint lwork, mpackint * info );
void Cgelss ( mpackint m, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double * s, long double rcond, mpackint * rank, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Rgelsy ( mpackint m, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *jpvt, long double rcond, mpackint *rank, long double * work, mpackint lwork, mpackint *info );
void Cgelsy ( mpackint m, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint * jpvt, long double rcond, mpackint * rank, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Rgeqlf ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cgeqlf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgeqpf ( mpackint m, mpackint n, long double * A, mpackint lda, mpackint *jpvt, long double * tau, long double * work, mpackint *info );
void Cgeqpf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *jpvt, std::complex<long double> * tau, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgeqp3 ( mpackint m, mpackint n, long double * A, mpackint lda, mpackint *jpvt, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cgeqp3 ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *jpvt, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *info );
void Rgeqrf ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cgeqrf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgerfs ( const char *trans, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * af, mpackint ldaf, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cgerfs ( const char *trans, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgerqf ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cgerqf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgesdd ( const char *jobz, mpackint m, mpackint n, long double * A, mpackint lda, long double * s, long double * u, mpackint ldu, long double * vt, mpackint ldvt, long double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgesdd ( const char *jobz, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * s, std::complex<long double> * u, mpackint ldu, std::complex<long double> * vt, mpackint ldvt, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * iwork, mpackint * info );
void Rgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, long double * A, mpackint lda, long double * s, long double * u, mpackint ldu, long double * vt, mpackint ldvt, long double * work, mpackint lwork, mpackint * info );
void Cgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, long double * s, std::complex<long double> * u, mpackint ldu, std::complex<long double> * vt, mpackint ldvt, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Rgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * af, mpackint ldaf, mpackint * ipiv, char *equed, long double * r, long double * c, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint * iwork, mpackint * info );
void Cgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, mpackint * ipiv, char *equed, long double * r, long double * c, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, long double * lscale, long double * rscale, mpackint m, long double * v, mpackint ldv, mpackint *info );
void Cggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, long double * lscale, long double * rscale, mpackint m, std::complex<long double> * v, mpackint ldv, mpackint *info );
void Rggbal ( const char *job, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *ilo, mpackint *ihi, long double * lscale, long double * rscale, long double * work, mpackint *info );
void Cggbal ( const char *job, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint *ilo, mpackint *ihi, long double * lscale, long double * rscale, long double * work, mpackint *info );
void Rgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint * sdim, long double * alphar, long double * alphai, long double * beta, long double * vsl, mpackint ldvsl, long double * vsr, mpackint ldvsr, long double * work, mpackint lwork, mpacklogical * bwork, mpackint * info );
void Cgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint * sdim, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * vsl, mpackint ldvsl, std::complex<long double> * vsr, mpackint ldvsr, std::complex<long double> * work, mpackint lwork, long double * rwork, mpacklogical * bwork, mpackint * info );
void Rgegs ( const char *jobvsl, const char *jobvsr, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * alphar, long double * alphai, long double * beta, long double * vsl, mpackint ldvsl, long double * vsr, mpackint ldvsr, long double * work, mpackint lwork, mpackint *info );
void Cgegs ( const char *jobvsl, const char *jobvsr, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * vsl, mpackint ldvsl, std::complex<long double> * vsr, mpackint ldvsr, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Rggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint * sdim, long double * alphar, long double * alphai, long double * beta, long double * vsl, mpackint ldvsl, long double * vsr, mpackint ldvsr, long double * rconde, long double * rcondv, long double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint * sdim, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * vsl, mpackint ldvsl, std::complex<long double> * vsr, mpackint ldvsr, long double * rconde, long double * rcondv, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Rggev ( const char *jobvl, const char *jobvr, mpackint n, long double * A, mpackint lda, long double * b, mpackint ldb, long double * alphar, long double * alphai, long double * beta, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, long double * work, mpackint lwork, mpackint * info );
void Cggev ( const char *jobvl, const char *jobvr, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Rgegv ( const char *jobvl, const char *jobvr, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * alphar, long double * alphai, long double * beta, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, long double * work, mpackint lwork, mpackint * info );
void Cgegv ( const char *jobvl, const char *jobvr, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * info );
void Rggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * alphar, long double * alphai, long double * beta, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, long double * lscale, long double * rscale, long double * abnrm, long double * bbnrm, long double * rconde, long double * rcondv, long double * work, mpackint lwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Cggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, long double * lscale, long double * rscale, long double * abnrm, long double * bbnrm, long double * rconde, long double * rcondv, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Rggglm ( mpackint n, mpackint m, mpackint p, long double * A, mpackint lda, long double * B, mpackint ldb, long double * d, long double * x, long double * y, long double * work, mpackint lwork, mpackint *info );
void Cggglm ( mpackint n, mpackint m, mpackint p, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * d, std::complex<long double> * x, std::complex<long double> * y, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, long double * A, mpackint lda, long double * B, mpackint ldb, long double * q, mpackint ldq, long double * z, mpackint ldz, mpackint *info );
void Cgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * q, mpackint ldq, std::complex<long double> * z, mpackint ldz, mpackint *info );
void Rgglse ( mpackint m, mpackint n, mpackint p, long double * A, mpackint lda, long double * B, mpackint ldb, long double * c, long double * d, long double * x, long double * work, mpackint lwork, mpackint *info );
void Cgglse ( mpackint m, mpackint n, mpackint p, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * c, std::complex<long double> * d, std::complex<long double> * x, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rggqrf ( mpackint n, mpackint m, mpackint p, long double * A, mpackint lda, long double * taua, long double * B, mpackint ldb, long double * taub, long double * work, mpackint lwork, mpackint *info );
void Cggqrf ( mpackint n, mpackint m, mpackint p, std::complex<long double> * A, mpackint lda, std::complex<long double> * taua, std::complex<long double> * B, mpackint ldb, std::complex<long double> * taub, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rggrqf ( mpackint m, mpackint p, mpackint n, long double * A, mpackint lda, long double * taua, long double * B, mpackint ldb, long double * taub, long double * work, mpackint lwork, mpackint *info );
void Cggrqf ( mpackint m, mpackint p, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * taua, std::complex<long double> * B, mpackint ldb, std::complex<long double> * taub, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, long double * A, mpackint lda, long double * B, mpackint ldb, long double * alpha, long double * beta, long double * u, mpackint ldu, long double * v, mpackint ldv, long double * q, mpackint ldq, long double * work, mpackint *iwork, mpackint *info );
void Cggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double * alpha, long double * beta, std::complex<long double> * u, mpackint ldu, std::complex<long double> * v, mpackint ldv, std::complex<long double> * q, mpackint ldq, std::complex<long double> * work, long double * rwork, mpackint *iwork, mpackint *info );
void Rggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double tola, long double tolb, mpackint *k, mpackint *l, long double * u, mpackint ldu, long double * v, mpackint ldv, long double * q, mpackint ldq, mpackint *iwork, long double * tau, long double * work, mpackint *info );
void Cggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double tola, long double tolb, mpackint *k, mpackint *l, std::complex<long double> * u, mpackint ldu, std::complex<long double> * v, mpackint ldv, std::complex<long double> * q, mpackint ldq, mpackint *iwork, long double * rwork, std::complex<long double> * tau, std::complex<long double> * work, mpackint *info );
void Rgtcon ( const char *norm, mpackint n, long double * dl, long double * d, long double * du, long double * du2, mpackint *ipiv, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Cgtcon ( const char *norm, mpackint n, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * du2, mpackint *ipiv, long double anorm, long double * rcond, std::complex<long double> * work, mpackint *info );
void Rgtrfs ( const char *trans, mpackint n, mpackint nrhs, long double * dl, long double * d, long double * du, long double * dlf, long double * df, long double * duf, long double * du2, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cgtrfs ( const char *trans, mpackint n, mpackint nrhs, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * dlf, std::complex<long double> * df, std::complex<long double> * duf, std::complex<long double> * du2, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgtsv ( mpackint n, mpackint nrhs, long double * dl, long double * d, long double * du, long double * B, mpackint ldb, mpackint *info );
void Cgtsv ( mpackint n, mpackint nrhs, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, long double * dl, long double * d, long double * du, long double * dlf, long double * df, long double * duf, long double * du2, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * dlf, std::complex<long double> * df, std::complex<long double> * duf, std::complex<long double> * du2, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rgttrf ( mpackint n, long double * dl, long double * d, long double * du, long double * du2, mpackint *ipiv, mpackint *info );
void Cgttrf ( mpackint n, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * du2, mpackint *ipiv, mpackint *info );
void Rgttrs ( const char *trans, mpackint n, mpackint nrhs, long double * dl, long double * d, long double * du, long double * du2, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Cgttrs ( const char *trans, mpackint n, mpackint nrhs, std::complex<long double> * dl, std::complex<long double> * d, std::complex<long double> * du, std::complex<long double> * du2, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rhgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, long double * h, mpackint ldh, long double * t, mpackint ldt, long double * alphar, long double * alphai, long double * beta, long double * q, mpackint ldq, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *info );
void Chgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * h, mpackint ldh, std::complex<long double> * t, mpackint ldt, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * q, mpackint ldq, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *info );
void Rhsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical *select, mpackint n, long double * h, mpackint ldh, long double * wr, long double * wi, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, mpackint mm, mpackint m, long double * work, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Chsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical * select, mpackint n, std::complex<long double> * h, mpackint ldh, std::complex<long double> * w, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, mpackint mm, mpackint *m, std::complex<long double> * work, long double * rwork, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Rhseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, long double * h, mpackint ldh, long double * wr, long double * wi, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *info );
void Chseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * h, mpackint ldh, std::complex<long double> * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Ropgtr ( const char *uplo, mpackint n, long double * ap, long double * tau, long double * q, mpackint ldq, long double * work, mpackint *info );
void Cupgtr ( const char *uplo, mpackint n, std::complex<long double> * ap, std::complex<long double> * tau, std::complex<long double> * q, mpackint ldq, std::complex<long double> * work, mpackint *info );
void Ropmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, long double * ap, long double * tau, long double * c, mpackint ldc, long double * work, mpackint *info );
void Cupmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, std::complex<long double> * ap, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint *info );
void Rorgbr ( const char *vect, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cungbr ( const char *vect, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rorghr ( mpackint n, mpackint ilo, mpackint ihi, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cunghr ( mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rorglq ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cunglq ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rorgrq ( mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Cungrq ( mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rormtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * c, mpackint ldc, long double * work, mpackint lwork, mpackint *info );
void Cunmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * c, mpackint ldc, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rpbcon ( const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Cpbcon ( const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, long double anorm, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rpbequ ( const char *uplo, mpackint n, mpackint kd, long double * ab, mpackint ldab, long double * s, long double * scond, long double * amax, mpackint *info );
void Cpbequ ( const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, long double * s, long double * scond, long double * amax, mpackint *info );
void Rpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, long double * AB, mpackint ldab, long double * afb, mpackint ldafb, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * afb, mpackint ldafb, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rpbstf ( const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, mpackint *info );
void Cpbstf ( const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, mpackint *info );
void Rpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, long double * AB, mpackint ldab, long double * B, mpackint ldb, mpackint *info );
void Cpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<long double> * ab, mpackint ldab, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, long double * AB, mpackint ldab, long double * afb, mpackint ldafb, char *equed, long double * s, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint * iwork, mpackint * info );
void Cpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * afb, mpackint ldafb, char *equed, long double * s, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rpbtrf ( const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, mpackint *info );
void Cpbtrf ( const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, mpackint *info );
void Rpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, long double * ab, mpackint ldab, long double * B, mpackint ldb, mpackint *info );
void Cpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rpocon ( const char *uplo, mpackint n, long double * A, mpackint lda, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Cpocon ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double anorm, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rpoequ ( mpackint n, long double * A, mpackint lda, long double * s, long double * scond, long double * amax, mpackint *info );
void Cpoequ ( mpackint n, std::complex<long double> * A, mpackint lda, long double * s, long double * scond, long double * amax, mpackint *info );
void Rporfs ( const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * af, mpackint ldaf, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cporfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rposv ( const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *info );
void Cposv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * af, mpackint ldaf, char *equed, long double * s, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint * iwork, mpackint * info );
void Cposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, char *equed, long double * s, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rpotri ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *info );
void Cpotri ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *info );
void Rpotrs ( const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *info );
void Cpotrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rppcon ( const char *uplo, mpackint n, long double * ap, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Cppcon ( const char *uplo, mpackint n, std::complex<long double> * ap, long double * anorm, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rppequ ( const char *uplo, mpackint n, long double * ap, long double * s, long double * scond, long double * amax, mpackint *info );
void Cppequ ( const char *uplo, mpackint n, std::complex<long double> * ap, long double * s, long double * scond, long double * amax, mpackint *info );
void Rpptrf ( const char *uplo, mpackint n, long double * ap, mpackint *info );
void Cpptrf ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *info );
void Rpptri ( const char *uplo, mpackint n, long double * ap, mpackint *info );
void Cpptri ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *info );
void Rpptrs ( const char *uplo, mpackint n, mpackint nrhs, long double * ap, long double * B, mpackint ldb, mpackint *info );
void Cpptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rpprfs ( const char *uplo, mpackint n, mpackint nrhs, long double * ap, long double * afp, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cpprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * afp, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rppsv ( const char *uplo, mpackint n, mpackint nrhs, long double * ap, long double * B, mpackint ldb, mpackint *info );
void Cppsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, long double * ap, long double * afp, char *equed, long double * s, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * afp, char *equed, long double * s, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rptcon ( mpackint n, long double * d, long double * e, long double anorm, long double * rcond, long double * work, mpackint *info );
void Cptcon ( mpackint n, long double * d, std::complex<long double> * e, long double anorm, long double * rcond, long double * rwork, mpackint *info );
void Rpteqr ( const char *compz, mpackint n, long double * d, long double * e, long double * z, mpackint ldz, long double * work, mpackint * info );
void Cpteqr ( const char *compz, mpackint n, long double * d, long double * e, std::complex<long double> * z, mpackint ldz, long double * work, mpackint *info );
void Rptrfs ( mpackint n, mpackint nrhs, long double * d, long double * e, long double * df, long double * ef, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *info );
void Cptrfs ( const char *uplo, mpackint n, mpackint nrhs, long double * d, std::complex<long double> * e, long double * df, std::complex<long double> * ef, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rptsv ( mpackint n, mpackint nrhs, long double * d, long double * e, long double * B, mpackint ldb, mpackint *info );
void Cptsv ( mpackint n, mpackint nrhs, long double * d, std::complex<long double> * e, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rptsvx ( const char *fact, mpackint n, mpackint nrhs, long double * d, long double * e, long double * df, long double * ef, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint *info );
void Cptsvx ( const char *fact, mpackint n, mpackint nrhs, long double * d, std::complex<long double> * e, long double * df, std::complex<long double> * ef, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rpttrf ( mpackint n, long double * d, long double * e, mpackint *info );
void Cpttrf ( mpackint n, long double * d, std::complex<long double> * e, mpackint *info );
void Rpttrs ( mpackint n, mpackint nrhs, long double * d, long double * e, long double * B, mpackint ldb, mpackint *info );
void Cpttrs ( const char *uplo, mpackint n, mpackint nrhs, long double * d, std::complex<long double> * e, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rsbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, long double * w, long double * z, mpackint ldz, long double * work, mpackint *info );
void Chbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rsbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, long double * w, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, long double * q, mpackint ldq, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, long double * z, mpackint ldz, long double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * q, mpackint ldq, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint * iwork, mpackint * ifail, mpackint * info );
void Rsbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, long double * AB, mpackint ldab, long double * bb, mpackint ldbb, long double * x, mpackint ldx, long double * work, mpackint *info );
void Chbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * bb, mpackint ldbb, std::complex<long double> * x, mpackint ldx, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rsbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, long double * AB, mpackint ldab, long double * bb, mpackint ldbb, long double * w, long double * z, mpackint ldz, long double * work, mpackint *info );
void Chbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * bb, mpackint ldbb, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rsbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, long double * AB, mpackint ldab, long double * BB, mpackint ldbb, long double * w, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * BB, mpackint ldbb, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, long double * AB, mpackint ldab, long double * BB, mpackint ldbb, long double * q, mpackint ldq, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, long double * z, mpackint ldz, long double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, std::complex<long double> * ab, mpackint ldab, std::complex<long double> * bb, mpackint ldbb, std::complex<long double> * q, mpackint ldq, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, long double * AB, mpackint ldab, long double * d, long double * e, long double * q, mpackint ldq, long double * work, mpackint *info );
void Chbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, long double * d, long double * e, std::complex<long double> * q, mpackint ldq, std::complex<long double> * work, mpackint *info );
void Rspcon ( const char *uplo, mpackint n, long double * ap, mpackint *ipiv, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Cspcon ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *ipiv, long double anorm, long double * rcond, std::complex<long double> * work, mpackint *info );
void Chpcon ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *ipiv, long double anorm, long double * rcond, std::complex<long double> * work, mpackint *info );
void Rspev ( const char *jobz, const char *uplo, mpackint n, long double * ap, long double * w, long double * z, mpackint ldz, long double * work, mpackint *info );
void Chpev ( const char *jobz, const char *uplo, mpackint n, std::complex<long double> * ap, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rspevd ( const char *jobz, const char *uplo, mpackint n, long double * ap, long double * w, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpevd ( const char *jobz, const char *uplo, mpackint n, std::complex<long double> * ap, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspevx ( const char *jobz, const char *range, const char *uplo, mpackint n, long double * ap, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, long double * z, mpackint ldz, long double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpevx ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<long double> * ap, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rspgst ( mpackint itype, const char *uplo, mpackint n, long double * ap, long double * bp, mpackint *info );
void Chpgst ( mpackint *itype, const char *uplo, mpackint n, std::complex<long double> * ap, std::complex<long double> * bp, mpackint *info );
void Rspgv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, long double * ap, long double * bp, long double * w, long double * z, mpackint ldz, long double * work, mpackint *info );
void Chpgv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, std::complex<long double> * ap, std::complex<long double> * bp, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rspgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, long double * ap, long double * bp, long double * w, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, std::complex<long double> * ap, std::complex<long double> * bp, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspgvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, long double * ap, long double * bp, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint m, long double * w, long double * z, mpackint ldz, long double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpgvx ( mpackint itype, const char *jobz, char *range, const char *uplo, mpackint n, std::complex<long double> * ap, std::complex<long double> * bp, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, long double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsprfs ( const char *uplo, mpackint n, mpackint nrhs, long double * ap, long double * afp, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Csprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * afp, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Chprfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * afp, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rspsv ( const char *uplo, mpackint n, mpackint nrhs, long double * ap, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Cspsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Chpsv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, long double * ap, long double * afp, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Cspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * afp, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Chpsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * afp, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rsptrd ( const char *uplo, mpackint n, long double * ap, long double * d, long double * e, long double * tau, mpackint *info );
void Chptrd ( const char *uplo, mpackint n, std::complex<long double> * ap, long double * d, long double * e, std::complex<long double> * tau, mpackint *info );
void Rsptrf ( const char *uplo, mpackint n, long double * ap, mpackint *ipiv, mpackint *info );
void Csptrf ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *ipiv, mpackint *info );
void Chptrf ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *ipiv, mpackint *info );
void Rsptri ( const char *uplo, mpackint n, long double * ap, mpackint *ipiv, long double * work, mpackint *info );
void Csptri ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *ipiv, std::complex<long double> * work, mpackint *info );
void Chptri ( const char *uplo, mpackint n, std::complex<long double> * ap, mpackint *ipiv, std::complex<long double> * work, mpackint *info );
void Rsptrs ( const char *uplo, mpackint n, mpackint nrhs, long double * ap, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Csptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Chptrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * ap, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rstebz ( const char *range, const char *order, mpackint n, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, long double * d, long double * e, mpackint * m, mpackint * nsplit, long double * w, mpackint *iblock, mpackint *isplit, long double * work, mpackint *iwork, mpackint *info );
void Rstedc ( const char *compz, mpackint n, long double * d, long double * e, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cstedc ( const char *compz, mpackint n, long double * d, long double * e, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstegr ( const char *jobz, const char *range, mpackint n, long double * d, long double * e, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, long double * z, mpackint ldz, mpackint * isuppz, long double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstegr ( const char *jobz, const char *range, mpackint n, long double *d, long double * e, long double * vl, long double * vu, mpackint *il, mpackint *iu, long double * abstol, mpackint m, long double * w, std::complex<long double> * z, mpackint ldz, mpackint *isuppz, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstein ( mpackint n, long double * d, long double * e, mpackint m, long double * w, mpackint *iblock, mpackint *isplit, long double * z, mpackint ldz, long double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cstein ( mpackint n, long double * d, long double * e, mpackint m, long double * w, mpackint *iblock, mpackint *isplit, std::complex<long double> * z, mpackint ldz, long double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstev ( const char *jobz, mpackint n, long double * d, long double * e, long double * z, mpackint ldz, long double * work, mpackint *info );
void Rstevd ( const char *jobz, mpackint n, long double * d, long double * e, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstevr ( const char *jobz, const char *range, mpackint n, long double * d, long double * e, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, long double * z, mpackint ldz, mpackint * isuppz, long double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rstevx ( const char *jobz, const char *range, mpackint n, long double * d, long double * e, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, long double * z, mpackint ldz, long double * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstemr ( const char *jobz, const char *range, mpackint n, long double * d, long double * e, long double vl, long double vu, mpackint il, mpackint iu, mpackint * m, long double * w, long double * z, mpackint ldz, mpackint nzc, mpackint * isuppz, mpacklogical * tryrac, long double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstemr ( const char *jobz, const char *range, mpackint n, long double * d, long double * e, long double vl, long double vu, mpackint il, mpackint iu, mpackint * m, long double * w, std::complex<long double> * z, mpackint ldz, mpackint nzc, mpackint *isuppz, mpacklogical * tryrac, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsycon ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *ipiv, long double anorm, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Csycon ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, long double anorm, long double * rcond, std::complex<long double> * work, mpackint *info );
void Checon ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, long double anorm, long double * rcond, std::complex<long double> * work, mpackint *info );
void Rsyevd ( const char *jobz, const char *uplo, mpackint n, long double * A, mpackint lda, long double * w, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cheevd ( const char *jobz, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double * w, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsyevr ( const char *jobz, const char *range, const char *uplo, mpackint n, long double * A, mpackint lda, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, long double * z, mpackint ldz, mpackint * isuppz, long double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cheevr ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, std::complex<long double> * z, mpackint ldz, mpackint * isuppz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rsyevx ( const char *jobz, const char *range, const char *uplo, mpackint n, long double * A, mpackint lda, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cheevx ( const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsygst ( mpackint itype, const char *uplo, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, mpackint *info );
void Chegst ( mpackint itype, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rsygv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * w, long double * work, mpackint lwork, mpackint *info );
void Chegv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double * w, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *info );
void Rsygvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * w, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chegvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double * w, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsygvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint *m, long double * w, long double * z, mpackint ldz, long double * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chegvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double vl, long double vu, mpackint il, mpackint iu, long double abstol, mpackint * m, long double * w, std::complex<long double> * z, mpackint ldz, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsyrfs ( const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * af, mpackint ldaf, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Csyrfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Cherfs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rsysv ( const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, mpackint *ipiv, long double * B, mpackint ldb, long double * work, mpackint lwork, mpackint *info );
void Csysv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Chesv ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rsysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * af, mpackint ldaf, mpackint *ipiv, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, long double * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Csysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *info );
void Chesvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * af, mpackint ldaf, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * rcond, long double * ferr, long double * berr, std::complex<long double> * work, mpackint lwork, long double * rwork, mpackint *info );
void Rsytrf ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *ipiv, long double * work, mpackint lwork, mpackint *info );
void Csytrf ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Chetrf ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rsytri ( const char *uplo, mpackint n, long double * A, mpackint lda, mpackint *ipiv, long double * work, mpackint *info );
void Csytri ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * work, mpackint *info );
void Chetri ( const char *uplo, mpackint n, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * work, mpackint *info );
void Rsytrs ( const char *uplo, mpackint n, mpackint nrhs, long double * A, mpackint lda, mpackint *ipiv, long double * B, mpackint ldb, mpackint *info );
void Csytrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Chetrs ( const char *uplo, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, mpackint *ipiv, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rtbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, long double * AB, mpackint ldab, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Ctbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, std::complex<long double> * AB, mpackint ldab, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rtbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, long double * AB, mpackint ldab, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Ctbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, std::complex<long double> * AB, mpackint ldab, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rtbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, long double * ab, mpackint ldab, long double * B, mpackint ldb, mpackint *info );
void Ctbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, std::complex<long double> * ab, mpackint ldab, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rtgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, long double * s, mpackint lds, long double *p, mpackint ldp, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, mpackint mm, mpackint *m, long double * work, mpackint * info );
void Ctgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, std::complex<long double> * s, mpackint lds, std::complex<long double> * p, mpackint ldp, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, mpackint mm, mpackint * m, std::complex<long double> * work, long double * rwork, mpackint * info );
void Rtgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * q, mpackint ldq, long double * z, mpackint ldz, mpackint * ifst, mpackint * ilst, long double * work, mpackint lwork, mpackint * info );
void Ctgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * q, mpackint ldq, std::complex<long double> * z, mpackint ldz, mpackint ifst, mpackint *ilst, mpackint *info );
void Rtgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical *select, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * alphar, long double * alphai, long double * beta, long double * q, mpackint ldq, long double * z, mpackint ldz, mpackint * m, long double * pl, long double * pr, long double * dif, long double * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Ctgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical * select, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * alpha, std::complex<long double> * beta, std::complex<long double> * q, mpackint ldq, std::complex<long double> * z, mpackint ldz, mpackint * m, long double * pl, long double * pr, long double * dif, std::complex<long double> * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rtgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, long double * A, mpackint lda, long double * B, mpackint ldb, long double tola, long double tolb, long double * alpha, long double * beta, long double * u, mpackint ldu, long double * v, mpackint ldv, long double * q, mpackint ldq, long double * work, mpackint ncycle, mpackint *info );
void Ctgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, long double tola, long double tolb, long double * alpha, long double * beta, std::complex<long double> * u, mpackint ldu, std::complex<long double> * v, mpackint ldv, std::complex<long double> * q, mpackint ldq, std::complex<long double> * work, mpackint * ncycle, mpackint *info );
void Rtgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, long double * s, long double * dif, mpackint mm, mpackint * m, long double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, long double * s, long double * dif, mpackint mm, mpackint * m, std::complex<long double> * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * c, mpackint ldc, long double * d, mpackint ldd, long double * e, mpackint lde, long double * f, mpackint ldf, long double * scale, long double * dif, long double * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * c, mpackint ldc, std::complex<long double> * d, mpackint ldd, std::complex<long double> * e, mpackint lde, std::complex<long double> * f, mpackint ldf, long double * scale, long double * dif, std::complex<long double> * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, long double * ap, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Ctpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<long double> * ap, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rtprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, long double * ap, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Ctprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rtptri ( const char *uplo, const char *diag, mpackint n, long double * ap, mpackint *info );
void Ctptri ( const char *uplo, const char *diag, mpackint n, std::complex<long double> * ap, mpackint *info );
void Rtptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, long double * ap, long double * B, mpackint ldb, mpackint *info );
void Ctptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<long double> * ap, std::complex<long double> * B, mpackint ldb, mpackint *info );
void Rtrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, long double * A, mpackint lda, long double * rcond, long double * work, mpackint *iwork, mpackint *info );
void Ctrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, std::complex<long double> * A, mpackint lda, long double * rcond, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rtrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, long double * t, mpackint ldt, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, mpackint mm, mpackint *m, long double * work, mpackint *info );
void Ctrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, std::complex<long double> * t, mpackint ldt, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, mpackint mm, mpackint *m, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rtrexc ( const char *compq, mpackint n, long double * t, mpackint ldt, long double * q, mpackint ldq, mpackint *ifst, mpackint *ilst, long double * work, mpackint *info );
void Ctrexc ( const char *compq, mpackint n, std::complex<long double> * t, mpackint ldt, std::complex<long double> * q, mpackint ldq, mpackint ifst, mpackint ilst, mpackint *info );
void Rtrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, long double * A, mpackint lda, long double * B, mpackint ldb, long double * x, mpackint ldx, long double * ferr, long double * berr, long double * work, mpackint *iwork, mpackint *info );
void Ctrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * x, mpackint ldx, long double * ferr, long double * berr, std::complex<long double> * work, long double * rwork, mpackint *info );
void Rtrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, long double * t, mpackint ldt, long double * q, mpackint ldq, long double * wr, long double * wi, mpackint m, long double * s, long double * sep, long double * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Ctrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, std::complex<long double> * t, mpackint ldt, std::complex<long double> * q, mpackint ldq, std::complex<long double> * w, mpackint m, long double * s, long double * sep, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rtrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, long double * t, mpackint ldt, long double * vl, mpackint ldvl, long double * vr, mpackint ldvr, long double * s, long double * sep, mpackint mm, mpackint *m, long double * work, mpackint ldwork, mpackint *iwork, mpackint *info );
void Ctrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, std::complex<long double> * t, mpackint ldt, std::complex<long double> * vl, mpackint ldvl, std::complex<long double> * vr, mpackint ldvr, long double * s, long double * sep, mpackint mm, mpackint *m, std::complex<long double> * work, mpackint ldwork, long double * rwork, mpackint *info );
void Rtrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, long double * A, mpackint lda, long double * B, mpackint ldb, long double * c, mpackint ldc, long double * scale, mpackint *info );
void Ctrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * B, mpackint ldb, std::complex<long double> * c, mpackint ldc, long double * scale, mpackint *info );
void Rtzrzf ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, long double * work, mpackint lwork, mpackint *info );
void Ctzrzf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, std::complex<long double> * work, mpackint lwork, mpackint *info );
void Rtzrqf ( mpackint m, mpackint n, long double * A, mpackint lda, long double * tau, mpackint *info );
void Ctzrqf ( mpackint m, mpackint n, std::complex<long double> * A, mpackint lda, std::complex<long double> * tau, mpackint *info );

#endif
