/*
 * Copyright (c) 2008-2010
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mlapack_mpfr.h,v 1.5 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MLAPACK_MPFR_H_
#define _MLAPACK_MPFR_H_

#include "mpack_config.h"
#include "mpc_class.h"
#include "gmpxx.h"
#include "mpreal.h"
#include "mpcomplex.h"

using namespace mpfr;

/* MLAPACK prototypes */

/* MLAPACK driver routines */
void Rsyev ( const char *jobz, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * w, mpreal * work, mpackint lwork, mpackint *info );
void Cheev ( const char *jobz, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * w, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *info );
void Rgesv ( mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Cgesv ( mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );

/* MLAPACK computational routines */
void Rsteqr ( const char *compz, mpackint n, mpreal * d, mpreal * e, mpreal * Z, mpackint ldz, mpreal * work, mpackint *info );
void Csteqr ( const char *compz, mpackint n, mpreal * d, mpreal * e, mpcomplex * z, mpackint ldz, mpreal * work, mpackint *info );
void Rsterf ( mpackint n, mpreal * d, mpreal * e, mpackint *info );
void Rorgqr ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cungqr ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rorgql ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cungql ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rsytrd ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * d, mpreal * e, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Chetrd ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * d, mpreal * e, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rorgtr ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cungtr ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rpotrf ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Cpotrf ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rtrtri ( const char *uplo, const char *diag, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Ctrtri ( const char *uplo, const char *diag, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rgetrf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetrf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rgetri ( mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * work, mpackint lwork, mpackint *info );
void Cgetri ( mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgetrs ( const char *trans, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Cgetrs ( const char *trans, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Rtrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *info );
void Ctrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint *info );

/* MLAPACK Auxiliary routines */
mpreal Rlamc3 ( mpreal a, mpreal b );
mpreal Rlamch_mpfr(const char *cmach);
mpackint iMlaenv_mpfr(mpackint ispec, const char *name, const char *opts, mpackint n1, mpackint n2, mpackint n3, mpackint n4);
void Rlae2 ( mpreal a, mpreal b, mpreal c, mpreal * rt1, mpreal * rt2 );
void Rlaev2 ( mpreal a, mpreal b, mpreal c, mpreal * rt1, mpreal * rt2, mpreal * cs1, mpreal * sn1 );
void Claev2 ( mpcomplex a, mpcomplex b, mpcomplex c, mpreal * rt1, mpreal * rt2, mpreal * cs1, mpcomplex * sn1 );
void Rlassq ( mpackint n, mpreal * x, mpackint incx, mpreal * scale, mpreal * sumsq );
void Classq ( mpackint n, mpcomplex * x, mpackint incx, mpreal * scale, mpreal * sumsq );
mpreal Rlanst ( const char *norm, mpackint n, mpreal * d, mpreal * e );
mpreal Clanht ( const char *norm, mpackint n, mpreal * d, mpcomplex * e );
mpreal Rlansy ( const char *norm, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * work );
mpreal Clansy ( const char *norm, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * work );
mpreal Clanhe ( const char *norm, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * work );
mpreal Rlapy2 ( mpreal x, mpreal y );
void Rlarfg ( mpackint N, mpreal * alpha, mpreal * x, mpackint incx, mpreal * tau );
mpreal Rlapy3 ( mpreal x, mpreal y, mpreal z );
void Rladiv ( mpreal a, mpreal b, mpreal c, mpreal d, mpreal * p, mpreal * q );
mpcomplex Cladiv ( mpcomplex x, mpcomplex y );
void Clarfg ( mpackint n, mpcomplex * alpha, mpcomplex * x, mpackint incx, mpcomplex * tau );
void Rlartg ( mpreal f, mpreal g, mpreal * cs, mpreal * sn, mpreal * r );
void Clartg ( mpcomplex f, mpcomplex g, mpreal * cs, mpcomplex * sn, mpcomplex * r );
void Rlaset ( const char *uplo, mpackint m, mpackint n, mpreal alpha, mpreal beta, mpreal * A, mpackint lda );
void Claset ( const char *uplo, mpackint m, mpackint n, mpcomplex alpha, mpcomplex beta, mpcomplex * A, mpackint lda );
void Rlasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, mpreal * c, mpreal * s, mpreal * A, mpackint lda );
void Clasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, mpreal * c, mpreal * s, mpcomplex * A, mpackint lda );
void Rpotf2 ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Clacgv ( mpackint n, mpcomplex * x, mpackint incx );
void Cpotf2 ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rlascl ( const char *type, mpackint kl, mpackint ku, mpreal cfrom, mpreal cto, mpackint m, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Clascl ( const char *type, mpackint kl, mpackint ku, mpreal cfrom, mpreal cto, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rlasrt ( const char *id, mpackint n, mpreal * d, mpackint *info );
void Rsytd2 ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * d, mpreal * e, mpreal * tau, mpackint *info );
void Chetd2 ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * d, mpreal * e, mpcomplex * tau, mpackint *info );
void Rlarf ( const char *side, mpackint m, mpackint n, mpreal * v, mpackint incv, mpreal tau, mpreal * C, mpackint ldc, mpreal * work );
void Clarf ( const char *side, mpackint m, mpackint n, mpcomplex * v, mpackint incv, mpcomplex tau, mpcomplex * c, mpackint ldc, mpcomplex * work );
void Rorg2l ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cung2l ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rorg2r ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cung2r ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rlarft ( const char *direct, const char *storev, mpackint n, mpackint k, mpreal * v, mpackint ldv, mpreal * tau, mpreal * t, mpackint ldt );
void Clarft ( const char *direct, const char *storev, mpackint n, mpackint k, mpcomplex * v, mpackint ldv, mpcomplex * tau, mpcomplex * t, mpackint ldt );
void Rlarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpreal * V, mpackint ldv, mpreal * T, mpackint ldt, mpreal * C, mpackint ldc, mpreal * work, mpackint ldwork );
void Clarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpcomplex * V, mpackint ldv, mpcomplex * T, mpackint ldt, mpcomplex * C, mpackint ldc, mpcomplex * work, mpackint ldwork );
void Rlatrd ( const char *uplo, mpackint n, mpackint nb, mpreal * A, mpackint lda, mpreal * e, mpreal * tau, mpreal * w, mpackint ldw );
void Clatrd ( const char *uplo, mpackint n, mpackint nb, mpcomplex * A, mpackint lda, mpreal * e, mpcomplex * tau, mpcomplex * w, mpackint ldw );
void Clacrm ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * B, mpackint ldb, mpcomplex * c, mpackint ldc, mpreal * rwork );
void Rtrti2 ( const char *uplo, const char *diag, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Ctrti2 ( const char *uplo, const char *diag, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rgetf2 ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetf2 ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rlaswp ( mpackint n, mpreal * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Claswp ( mpackint n, mpcomplex * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Rlasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * w, mpackint ldw, mpackint *info );
void Clasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * w, mpackint ldw, mpackint *info );
void Clahef ( const char *uplo, mpackint n, mpackint nb, mpackint kb, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * w, mpackint ldw, mpackint *info );
void Clacrt ( mpackint n, mpcomplex * cx, mpackint incx, mpcomplex * cy, mpackint incy, mpcomplex c, mpcomplex s );
void Claesy ( mpcomplex a, mpcomplex b, mpcomplex c, mpcomplex * rt1, mpcomplex * rt2, mpcomplex * evscal, mpcomplex * cs1, mpcomplex * sn1 );
void Crot ( mpackint n, mpcomplex * cx, mpackint incx, mpcomplex * cy, mpackint incy, mpreal c, mpcomplex s );
void Cspmv ( const char *uplo, mpackint n, mpcomplex alpha, mpcomplex * AP, mpcomplex * x, mpackint incx, mpcomplex beta, mpcomplex * y, mpackint incy );
void Cspr ( const char *uplo, mpackint n, mpcomplex alpha, mpcomplex * x, mpackint incx, mpcomplex * AP );
void Csymv ( const char *uplo, mpackint n, mpcomplex alpha, mpcomplex * A, mpackint lda, mpcomplex * x, mpackint incx, mpcomplex beta, mpcomplex * y, mpackint incy );
void Csyr ( const char *uplo, mpackint n, mpcomplex alpha, mpcomplex * x, mpackint incx, mpcomplex * A, mpackint lda );
mpackint iCmax1 ( mpackint n, mpcomplex * cx, mpackint incx );
mpreal RCsum1 ( mpackint n, mpcomplex * cx, mpackint incx );
void Rlacn2 ( mpackint n, mpreal * v, mpreal * x, mpackint *isgn, mpreal * est, mpackint *kase, mpackint *isave );
void Clacn2 ( mpackint n, mpcomplex * v, mpcomplex * x, mpreal * est, mpackint *kase, mpackint *isave );
void Rlatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpreal * A, mpackint lda, mpreal * x, mpreal * scale, mpreal * cnorm, mpackint *info );
void Clatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * x, mpreal * scale, mpreal * cnorm, mpackint *info );

/* not yet done ... auxiliary routines */
void Rgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpreal * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpcomplex * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgebd2 ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * d, mpreal * e, mpreal * tauq, mpreal * taup, mpreal * work, mpackint *info );
void Cgebd2 ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * d, mpreal * e, mpcomplex * tauq, mpcomplex * taup, mpcomplex * work, mpackint *info );
void Rgehd2 ( mpackint n, mpackint ilo, mpackint ihi, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cgehd2 ( mpackint n, mpackint ilo, mpackint ihi, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rgelq2 ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cgelq2 ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rgeql2 ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cgeql2 ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rgeqr2 ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cgeqr2 ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rgerq2 ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cgerq2 ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rgesc2 ( mpackint n, mpreal * A, mpackint lda, mpreal * rhs, mpackint *ipiv, mpackint *jpiv, mpreal * scale );
void Cgesc2 ( mpackint n, mpcomplex * A, mpackint lda, mpcomplex * rhs, mpackint *ipiv, mpackint *jpiv, mpreal * scale );
void Rgetc2 ( mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Cgetc2 ( mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Rgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, mpreal * dl, mpreal * d, mpreal * du, mpreal * du2, mpackint *ipiv, mpreal * B, mpackint ldb );
void Cgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * du2, mpackint *ipiv, mpcomplex * B, mpackint ldb );
void Rlabrd ( mpackint m, mpackint n, mpackint nb, mpreal * A, mpackint lda, mpreal * d, mpreal * e, mpreal * tauq, mpreal * taup, mpreal * x, mpackint ldx, mpreal * y, mpackint ldy );
void Clabrd ( mpackint m, mpackint n, mpackint nb, mpcomplex * A, mpackint lda, mpreal * d, mpreal * e, mpcomplex * tauq, mpcomplex * taup, mpcomplex * x, mpackint ldx, mpcomplex * y, mpackint ldy );
void Rlacpy ( const char *uplo, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb );
void Clacpy ( const char *uplo, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb );
void Clarcm ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * c, mpackint ldc, mpreal * rwork );
void Rlaebz ( mpackint ijob, mpackint nitmax, mpackint n, mpackint mmax, mpackint minp, mpackint nbmin, mpreal abstol, mpreal reltol, mpreal pivmin, mpreal * d, mpreal * e, mpreal * e2, mpackint *nval, mpreal * AB, mpreal * c, mpackint *mout, mpackint *nab, mpreal * work, mpackint *iwork, mpackint *info );
void Rlaed0 ( mpackint icompq, mpackint qsiz, mpackint n, mpreal * d, mpreal * e, mpreal * q, mpackint ldq, mpreal * qstore, mpackint ldqs, mpreal * work, mpackint *iwork, mpackint *info );
void Claed0 ( mpackint qsiz, mpackint n, mpreal * d, mpreal * e, mpcomplex * q, mpackint ldq, mpcomplex * qstore, mpackint ldqs, mpreal * rwork, mpackint *iwork, mpackint *info );
void Rlaed1 ( mpackint n, mpreal * d, mpreal * q, mpackint ldq, mpackint *indxq, mpreal rho, mpackint cutpnt, mpreal * work, mpackint *iwork, mpackint *info );
void Rlaed2 ( mpackint *k, mpackint n, mpackint n1, mpreal * d, mpreal * q, mpackint ldq, mpackint *indxq, mpreal * rho, mpreal * z, mpreal * dlamda, mpreal * w, mpreal * q2, mpackint *indx, mpackint *indxc, mpackint *indxp, mpackint *coltyp, mpackint *info );
void Rlaed3 ( mpackint k, mpackint n, mpackint n1, mpreal * d, mpreal * q, mpackint ldq, mpreal * rho, mpreal * dlamda, mpreal * q2, mpackint *indx, mpackint *ctot, mpreal * w, mpreal * s, mpackint *info );
void Rlaed4 ( mpackint n, mpackint i, mpreal * d, mpreal * z, mpreal * delta, mpreal rho, mpreal * dlam, mpackint *info );
void Rlaed5 ( mpackint i, mpreal * d, mpreal * z, mpreal * delta, mpreal rho, mpreal * dlam );
void Rlaed6 ( mpackint kniter, mpackint orgati, mpreal rho, mpreal * d, mpreal * z, mpreal * finit, mpreal * tau, mpackint *info );
void Rlaed7 ( mpackint icompq, mpackint n, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpreal * d, mpreal * q, mpackint ldq, mpackint *indxq, mpreal rho, mpackint cutpnt, mpreal * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, mpreal * givnum, mpreal * work, mpackint *iwork, mpackint *info );
void Claed7 ( mpackint n, mpackint cutpnt, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpreal * d, mpcomplex * q, mpackint ldq, mpreal rho, mpackint *indxq, mpreal * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, mpreal * givnum, mpcomplex * work, mpreal * rwork, mpackint *iwork, mpackint *info );
void Rlaed8 ( mpackint icompq, mpackint *k, mpackint n, mpackint qsiz, mpreal * d, mpreal * q, mpackint ldq, mpackint *indxq, mpreal * rho, mpackint cutpnt, mpreal * z, mpreal * dlamda, mpreal * q2, mpackint ldq2, mpreal * w, mpackint *perm, mpackint *givptr, mpackint *givcol, mpreal * givnum, mpackint *indxp, mpackint *indx, mpackint *info );
void Claed8 ( mpackint *k, mpackint n, mpackint qsiz, mpcomplex * q, mpackint ldq, mpreal * d, mpreal * rho, mpackint cutpnt, mpreal * z, mpreal * dlamda, mpcomplex * q2, mpackint ldq2, mpreal * w, mpackint *indxp, mpackint *indx, mpackint *indxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpreal * givnum, mpackint *info );
void Rlaed9 ( mpackint k, mpackint kstart, mpackint kstop, mpackint n, mpreal * d, mpreal * q, mpackint ldq, mpreal rho, mpreal * dlamda, mpreal * w, mpreal * s, mpackint lds, mpackint *info );
void Rlaeda ( mpackint n, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, mpreal * givnum, mpreal * q, mpackint *qptr, mpreal * z, mpreal * ztemp, mpackint *info );
void Rlaein ( mpackint rightv, mpackint noinit, mpackint n, mpreal * h, mpackint ldh, mpreal wr, mpreal wi, mpreal * vr, mpreal * vi, mpreal * B, mpackint ldb, mpreal * work, mpreal eps3, mpreal smlnum, mpreal bignum, mpackint *info );
void Claein ( mpackint rightv, mpackint noinit, mpackint n, mpcomplex * h, mpackint ldh, mpcomplex w, mpcomplex * v, mpcomplex * B, mpackint ldb, mpreal * rwork, mpreal eps3, mpreal smlnum, mpackint *info );
void Rlaexc ( mpackint wantq, mpackint n, mpreal * t, mpackint ldt, mpreal * q, mpackint ldq, mpackint j1, mpackint n1, mpackint n2, mpreal * work, mpackint *info );
void Rlag2 ( mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal safmin, mpreal * scale1, mpreal * scale2, mpreal * wr1, mpreal * wr2, mpreal * wi );
void Rlags2 ( mpackint upper, mpreal a1, mpreal a2, mpreal a3, mpreal b1, mpreal b2, mpreal b3, mpreal * csu, mpreal * snu, mpreal * csv, mpreal * snv, mpreal * csq, mpreal * snq );
void Clags2 ( mpacklogical * upper, mpreal a1, mpcomplex a2, mpreal a3, mpreal b1, mpcomplex b2, mpreal b3, mpreal * csu, mpcomplex * snu, mpreal * csv, mpcomplex * snv, mpreal * csq, mpcomplex * snq );
void Rlagtf ( mpackint n, mpreal * a, mpreal lambda, mpreal * b, mpreal * c, mpreal * tol, mpreal * d, mpackint *in, mpackint *info );
void Rlagtm ( const char *trans, mpackint n, mpackint nrhs, mpreal alpha, mpreal * dl, mpreal * d, mpreal * du, mpreal * x, mpackint ldx, mpreal * beta, mpreal * B, mpackint ldb );
void Clagtm ( const char *trans, mpackint n, mpackint nrhs, mpreal alpha, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * x, mpackint ldx, mpreal beta, mpcomplex * B, mpackint ldb );
void Rlagts ( mpackint job, mpackint n, mpreal * a, mpreal * b, mpreal * c, mpreal * d, mpackint *in, mpreal * y, mpreal * tol, mpackint *info );
void Rlagv2 ( mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * csl, mpreal * snl, mpreal * csr, mpreal * snr );
void Rlahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, mpreal * h, mpackint ldh, mpreal * wr, mpreal * wi, mpackint iloz, mpackint ihiz, mpreal * z, mpackint ldz, mpackint *info );
void Clahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, mpcomplex * h, mpackint ldh, mpcomplex * w, mpackint iloz, mpackint ihiz, mpcomplex * z, mpackint ldz, mpackint *info );
void Rlahr2 ( mpackint n, mpackint k, mpackint nb, mpreal * A, mpackint lda, mpreal * tau, mpreal * t, mpackint ldt, mpreal * y, mpackint ldy );
void Clahr2 ( mpackint n, mpackint k, mpackint nb, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * t, mpackint ldt, mpcomplex * y, mpackint ldy );
void Rlahrd ( mpackint n, mpackint k, mpackint nb, mpreal * A, mpackint lda, mpreal * tau, mpreal * t, mpackint ldt, mpreal * y, mpackint ldy );
void Clahrd ( mpackint n, mpackint k, mpackint nb, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * t, mpackint ldt, mpcomplex * y, mpackint ldy );
void Rlaic1 ( mpackint job, mpackint j, mpreal * x, mpreal sest, mpreal * w, mpreal gamma, mpreal * sestpr, mpreal * s, mpreal * c );
void Claic1 ( mpackint job, mpackint j, mpcomplex * x, mpreal sest, mpcomplex * w, mpcomplex gamma, mpreal * sestpr, mpcomplex * s, mpcomplex * c );
void Rlaln2 ( mpackint ltrans, mpackint na, mpackint nw, mpreal smin, mpreal ca, mpreal * A, mpackint lda, mpreal d1, mpreal d2, mpreal * B, mpackint ldb, mpreal wr, mpreal wi, mpreal * x, mpackint ldx, mpreal * scale, mpreal * xnorm, mpackint *info );
void Rlals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, mpreal * B, mpackint ldb, mpreal * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, mpreal * givnum, mpackint ldgnum, mpreal * poles, mpreal * difl, mpreal * difr, mpreal * z, mpackint k, mpreal c, mpreal s, mpreal * work, mpackint *info );
void Clals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, mpcomplex * B, mpackint ldb, mpcomplex * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, mpreal * givnum, mpackint ldgnum, mpreal * poles, mpreal * difl, mpreal * difr, mpreal * z, mpackint k, mpreal c, mpreal s, mpreal * rwork, mpackint *info );
void Rlalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, mpreal * B, mpackint ldb, mpreal * bx, mpackint ldbx, mpreal * u, mpackint ldu, mpreal * vt, mpackint *k, mpreal * difl, mpreal * difr, mpreal * z, mpreal * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, mpreal * givnum, mpreal * c, mpreal * s, mpreal * work, mpackint *iwork, mpackint *info );
void Clalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, mpcomplex * B, mpackint ldb, mpcomplex * bx, mpackint ldbx, mpreal * u, mpackint ldu, mpreal * vt, mpackint *k, mpreal * difl, mpreal * difr, mpreal * z, mpreal * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, mpreal * givnum, mpreal * c, mpreal * s, mpreal * rwork, mpackint *iwork, mpackint *info );
void Rlalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, mpreal * d, mpreal * e, mpreal * B, mpackint ldb, mpreal rcond, mpackint *rank, mpreal * work, mpackint *iwork, mpackint *info );
void Clalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, mpreal * d, mpreal * e, mpcomplex * B, mpackint ldb, mpreal rcond, mpackint *rank, mpcomplex * work, mpreal * rwork, mpackint *iwork, mpackint *info );
void Rlamrg ( mpackint n1, mpackint n2, mpreal * a, mpackint dtrd1, mpackint dtrd2, mpackint *index );
mpreal Rlangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpreal * ab, mpackint ldab, mpreal * work );
mpreal Clangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpcomplex * AB, mpackint ldab, mpreal * work );
mpreal Rlange ( const char *norm, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * work );
mpreal Clange ( const char *norm, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * work );
mpreal Rlangt ( const char *norm, mpackint n, mpreal * dl, mpreal * d, mpreal * du );
mpreal Clangt ( const char *norm, mpackint n, mpcomplex * dl, mpcomplex * d, mpcomplex * du );
mpreal Rlanhs ( const char *norm, mpackint n, mpreal * A, mpackint lda, mpreal * work );
mpreal Clanhs ( const char *norm, mpackint n, mpcomplex * A, mpackint lda, mpreal * work );
mpreal Rlansb ( const char *norm, const char *uplo, mpackint n, mpackint k, mpreal * AB, mpackint ldab, mpreal * work );
mpreal Clansb ( const char *norm, const char *uplo, mpackint n, mpackint k, mpcomplex * AB, mpackint ldab, mpreal * work );
mpreal Clanhb ( const char *norm, const char *uplo, mpackint n, mpackint k, mpcomplex * AB, mpackint ldab, mpreal * work );
mpreal Rlansp ( const char *norm, const char *uplo, mpackint n, mpreal * ap, mpreal * work );
mpreal Clansp ( const char *norm, const char *uplo, mpackint n, mpcomplex * ap, mpreal * work );
mpreal Clanhp ( const char *norm, const char *uplo, mpackint n, mpcomplex * ap, mpreal * work );
mpreal Rlantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, mpreal * AB, mpackint ldab, mpreal * work );
mpcomplex Clantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, mpcomplex * AB, mpackint ldab, mpreal * work );
mpreal Rlantp ( const char *norm, const char *uplo, const char *diag, mpackint n, mpreal * ap, mpreal * work );
mpcomplex Clantp ( const char *norm, const char *uplo, const char *diag, mpackint n, mpcomplex * ap, mpreal * work );
mpreal Rlantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * work );
mpreal Clantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * work );
void Rlanv2 ( mpreal * a, mpreal * b, mpreal * c, mpreal * d, mpreal * rt1r, mpreal * rt1i, mpreal * rt2r, mpreal * rt2i, mpreal * cs, mpreal * sn );
void Rlapll ( mpackint n, mpreal * x, mpackint incx, mpreal * y, mpackint incy, mpreal * ssmin );
void Clapll ( mpackint n, mpcomplex * x, mpackint incx, mpcomplex * y, mpackint incy, mpreal * ssmin );
void Rlapmt ( mpackint *forwrd, mpackint m, mpackint n, mpreal * X, mpackint ldx, mpackint *k );
void Clapmt ( mpackint *forwrd, mpackint m, mpackint n, mpcomplex * X, mpackint ldx, mpackint *k );
void Rlaqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpreal * AB, mpackint ldab, mpreal * r, mpreal * c, mpreal rowcnd, mpreal colcnd, mpreal amax, char *equed );
void Claqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpcomplex * AB, mpackint ldab, mpreal * r, mpreal * c, mpreal rowcnd, mpreal colcnd, mpreal amax, char *equed );
void Rlaqge ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * r, mpreal * c, mpreal rowcnd, mpreal colcnd, mpreal amax, char *equed );
void Claqge ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * r, mpreal * c, mpreal rowcnd, mpreal colcnd, mpreal amax, char *equed );
void Rlaqp2 ( mpackint m, mpackint n, mpackint offset, mpreal * A, mpackint lda, mpackint *jpvt, mpreal * tau, mpreal * vn1, mpreal * vn2, mpreal * work );
void Claqp2 ( mpackint m, mpackint n, mpackint offset, mpcomplex * A, mpackint lda, mpackint *jpvt, mpcomplex * tau, mpreal * vn1, mpreal * vn2, mpcomplex * work );
void Rlaqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, mpreal * A, mpackint lda, mpackint *jpvt, mpreal * tau, mpreal * vn1, mpreal * vn2, mpreal * auxv, mpreal * f, mpackint ldf );
void Claqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, mpcomplex * A, mpackint lda, mpackint *jpvt, mpcomplex * tau, mpreal * vn1, mpreal * vn2, mpcomplex * auxv, mpcomplex * f, mpackint ldf );
void Rlaqsb ( const char *uplo, mpackint n, mpackint kd, mpreal * ab, mpackint ldab, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Claqsb ( const char *uplo, mpackint n, mpackint kd, mpcomplex * ab, mpackint ldab, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Claqhb ( const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Rlaqsp ( const char *uplo, mpackint n, mpreal * ap, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Claqsp ( const char *uplo, mpackint n, mpcomplex * ap, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Claqhp ( const char *uplo, mpackint n, mpcomplex * ap, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Rlaqsy ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Claqsy ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Claqhe ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * s, mpreal scond, mpreal amax, char *equed );
void Rlaqtr ( mpackint ltran, mpackint lreal, mpackint n, mpreal * t, mpackint ldt, mpreal * B, mpreal w, mpreal * scale, mpreal * x, mpreal * work, mpackint *info );
void Rlar1v ( mpackint n, mpackint b1, mpackint bn, mpreal lambda, mpreal * d, mpreal * l, mpreal * ld, mpreal * lld, mpreal pivmin, mpreal gaptol, mpreal * z, mpackint wantnc, mpackint *negcnt, mpreal * ztz, mpreal * mingma, mpackint *r, mpackint *isuppz, mpreal * nrminv, mpreal * resid, mpreal * rqcorr, mpreal * work );
void Clar1v ( mpackint n, mpackint b1, mpackint bn, mpreal lambda, mpreal * d, mpreal * l, mpreal * ld, mpreal * lld, mpreal pivmin, mpreal gaptol, mpcomplex * z, mpackint wantnc, mpackint *negcnt, mpreal * ztz, mpreal * mingma, mpackint *r, mpackint *isuppz, mpreal * nrminv, mpreal * resid, mpreal * rqcorr, mpreal * work );
void Rlar2v ( mpackint n, mpreal * x, mpreal * y, mpreal * z, mpackint incx, mpreal * c, mpreal * s, mpackint incc );
void Clar2v ( mpackint n, mpcomplex * x, mpcomplex * y, mpcomplex * z, mpackint incx, mpreal * c, mpcomplex * s, mpackint incc );
void Rlarfx ( const char *side, mpackint m, mpackint n, mpreal * v, mpreal tau, mpreal * c, mpackint ldc, mpreal * work );
void Clarfx ( const char *side, mpackint m, mpackint n, mpcomplex * v, mpcomplex tau, mpcomplex * c, mpackint ldc, mpcomplex * work );
void Rlargv ( mpackint n, mpreal * x, mpackint incx, mpreal * y, mpackint incy, mpreal * c, mpackint incc );
void Clargv ( mpackint n, mpcomplex * x, mpackint incx, mpcomplex * y, mpackint incy, mpreal * c, mpackint incc );
void Rlarnv ( mpackint idist, mpackint *iseed, mpackint n, mpreal * x );
void Clarnv ( mpackint idist, mpackint *iseed, mpackint n, mpcomplex * x );
mpackint Rlaneg ( mpackint n, mpreal * d, mpreal * lld, mpreal sigma, mpreal pivmin, mpackint r );
void Rlarra ( mpackint n, mpreal * d, mpreal * e, mpreal * e2, mpreal spltol, mpreal tnrm, mpackint *nsplit, mpackint *isplit, mpackint *info );
void Rlarrb ( mpackint n, mpreal * d, mpreal * lld, mpackint ifirst, mpackint ilast, mpreal rtol1, mpreal rtol2, mpackint offset, mpreal * w, mpreal * wgap, mpreal * werr, mpreal * work, mpackint *iwork, mpreal pivmin, mpreal spdiam, mpackint twist, mpackint *info );
void Rlarrc ( const char *jobt, mpackint n, mpreal vl, mpreal vu, mpreal * d, mpreal * e, mpreal pivmin, mpackint *eigcnt, mpackint *lcnt, mpackint *rcnt, mpackint *info );
void Rlarrd ( const char *range, const char *order, mpackint n, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal *gers, mpreal reltol, mpreal * d, mpreal * e, mpreal * e2, mpreal pivmin, mpackint nsplit, mpackint *isplit, mpackint *m, mpreal * w, mpreal * werr, mpreal * wl, mpreal * wu, mpackint *iblock, mpackint *indexw, mpreal * work, mpackint *iwork, mpackint *info );
void Rlarre ( const char *range, mpackint n, mpreal * vl, mpreal * vu, mpackint il, mpackint iu, mpreal * d, mpreal * e, mpreal * e2, mpreal rtol1, mpreal rtol2, mpreal spltol, mpackint * nsplit, mpackint *isplit, mpackint * m, mpreal * w, mpreal * werr, mpreal * wgap, mpackint *iblock, mpackint *indexw, mpreal * gers, mpreal * pivmin, mpreal * work, mpackint *iwork, mpackint *info );
void Rlarrf ( mpackint n, mpreal * d, mpreal * l, mpreal * ld, mpackint clstrt, mpackint clend, mpreal * w, mpreal * wgap, mpreal * werr, mpreal spdiam, mpreal clgapl, mpreal clgapr, mpreal pivmin, mpreal * sigma, mpreal * dplus, mpreal * lplus, mpreal * work, mpackint *info );
void Rlarrj ( mpackint n, mpreal * d, mpreal * e2, mpackint ifirst, mpackint ilast, mpreal rtol, mpackint offset, mpreal * w, mpreal * werr, mpreal * work, mpackint *iwork, mpreal pivmin, mpreal spdiam, mpackint *info );
void Rlarrk ( mpackint n, mpackint iw, mpreal gl, mpreal gu, mpreal * d, mpreal * e2, mpreal pivmin, mpreal reltol, mpreal * w, mpreal * werr, mpackint *info );
void Rlarrr ( mpackint n, mpreal * d, mpreal * e, mpackint *info );
void Rlartv ( mpackint n, mpreal * x, mpackint incx, mpreal * y, mpackint incy, mpreal * c, mpreal * s, mpackint incc );
void Clartv ( mpackint n, mpcomplex * x, mpackint incx, mpcomplex * y, mpackint incy, mpreal * c, mpcomplex * s, mpackint incc );
void Rlarrv ( mpackint n, mpreal vl, mpreal vu, mpreal * d, mpreal * l, mpreal pivmin, mpackint * isplit, mpackint m, mpackint dol, mpackint dou, mpreal minrgp, mpreal rtol1, mpreal rtol2, mpreal * w, mpreal * werr, mpreal * wgap, mpackint * iblock, mpackint * indexw, mpreal * gers, mpreal * z, mpackint ldz, mpackint * isuppz, mpreal * work, mpackint * iwork, mpackint * info );
void Clarrv ( mpackint n, mpreal vl, mpreal vu, mpreal * d, mpreal * l, mpreal pivmin, mpackint *isplit, mpackint m, mpackint dol, mpackint dou, mpreal minrgp, mpreal rtol1, mpreal rtol2, mpreal * w, mpreal * werr, mpreal * wgap, mpackint *iblock, mpackint *indexw, mpreal * gers, mpcomplex * z, mpackint ldz, mpackint *isuppz, mpreal * work, mpackint *iwork, mpackint *info );
void Rlaruv ( mpackint *iseed, mpackint n, mpreal * x );
void Rlarz ( const char *side, mpackint m, mpackint n, mpackint l, mpreal * v, mpackint incv, mpreal tau, mpreal * C, mpackint ldc, mpreal * work );
void Clarz ( const char *side, mpackint m, mpackint n, mpackint l, mpcomplex * v, mpackint incv, mpcomplex tau, mpcomplex * c, mpackint ldc, mpcomplex * work );
void Rlarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, mpreal * v, mpackint ldv, mpreal * t, mpackint ldt, mpreal * c, mpackint ldc, mpreal * work, mpackint ldwork );
void Clarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, mpcomplex * v, mpackint ldv, mpcomplex * t, mpackint ldt, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint ldwork );
void Rlarzt ( const char *direct, const char *storev, mpackint n, mpackint k, mpreal * v, mpackint ldv, mpreal * tau, mpreal * t, mpackint ldt );
void Clarzt ( const char *direct, const char *storev, mpackint n, mpackint k, mpcomplex * v, mpackint ldv, mpcomplex * tau, mpcomplex * t, mpackint ldt );
void Rlas2 ( mpreal f, mpreal g, mpreal h, mpreal * ssmin, mpreal * ssmax );
void Rlasd0 ( mpackint n, mpackint sqre, mpreal * d, mpreal * e, mpreal * u, mpackint ldu, mpreal * vt, mpackint ldvt, mpackint smlsiz, mpackint *iwork, mpreal * work, mpackint *info );
void Rlasd1 ( mpackint nl, mpackint nr, mpackint *sqre, mpreal * d, mpreal * alpha, mpreal * beta, mpreal * u, mpackint ldu, mpreal * vt, mpackint ldvt, mpackint *idxq, mpackint *iwork, mpreal * work, mpackint *info );
void Rlasd2 ( mpackint nl, mpackint nr, mpackint sqre, mpackint *k, mpreal * d, mpreal * z, mpreal alpha, mpreal beta, mpreal * u, mpackint ldu, mpreal * vt, mpackint ldvt, mpreal * dsigma, mpreal * u2, mpackint ldu2, mpreal * vt2, mpackint ldvt2, mpackint *idxp, mpackint *idx, mpackint *idxc, mpackint *idxq, mpackint *coltyp, mpackint *info );
void Rlasd3 ( mpackint nl, mpackint nr, mpackint sqre, mpackint k, mpreal * d, mpreal * q, mpackint ldq, mpreal * dsigma, mpreal * u, mpackint ldu, mpreal * u2, mpackint ldu2, mpreal * vt, mpackint ldvt, mpreal * vt2, mpackint ldvt2, mpackint *idxc, mpackint *ctot, mpreal * z, mpackint *info );
void Rlasd4 ( mpackint n, mpackint i, mpreal * d, mpreal * z, mpreal * delta, mpreal rho, mpreal * sigma, mpreal * work, mpackint *info );
void Rlasd5 ( mpackint i, mpreal * d, mpreal * z, mpreal * delta, mpreal rho, mpreal * dsigma, mpreal * work );
void Rlasd6 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpreal * d, mpreal * vf, mpreal * vl, mpreal * alpha, mpreal * beta, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpreal * givnum, mpackint ldgnum, mpreal * poles, mpreal * difl, mpreal * difr, mpreal * z, mpackint k, mpreal * c, mpreal * s, mpreal * work, mpackint *iwork, mpackint *info );
void Rlasd7 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint k, mpreal * d, mpreal * z, mpreal * zw, mpreal * vf, mpreal * vfw, mpreal * vl, mpreal * vlw, mpreal alpha, mpreal beta, mpreal * dsigma, mpackint *idx, mpackint *idxp, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpreal * givnum, mpackint ldgnum, mpreal * c, mpreal * s, mpackint *info );
void Rlasd8 ( mpackint icompq, mpackint k, mpreal * d, mpreal * z, mpreal * vf, mpreal * vl, mpreal * difl, mpreal * difr, mpackint lddifr, mpreal * dsigma, mpreal * work, mpackint *info );
void Rlasda ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint sqre, mpreal * d, mpreal * e, mpreal * u, mpackint ldu, mpreal * vt, mpackint *k, mpreal * difl, mpreal * difr, mpreal * z, mpreal * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, mpreal * givnum, mpreal * c, mpreal * s, mpreal * work, mpackint *iwork, mpackint *info );
void Rlasdq ( const char *uplo, mpackint sqre, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, mpreal * d, mpreal * e, mpreal * vt, mpackint ldvt, mpreal * u, mpackint ldu, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Rlasdt ( mpackint n, mpackint lvl, mpackint nd, mpackint *inode, mpackint *ndiml, mpackint *ndimr, mpackint msub );
void Rlasq1 ( mpackint n, mpreal * d, mpreal * e, mpreal * work, mpackint *info );
void Rlasq2 ( mpackint n, mpreal * z, mpackint *info );
void Rlasq3 ( mpackint i0, mpackint n0, mpreal * z, mpackint pp, mpreal * dmin, mpreal * sigma, mpreal * desig, mpreal qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint ieee );
void Rlasq4 ( mpackint i0, mpackint n0, mpreal * z, mpackint pp, mpackint n0in, mpreal dmin, mpreal dmin1, mpreal dmin2, mpreal dn, mpreal dn1, mpreal dn2, mpreal * tau, mpackint *ttype );
void Rlasq5 ( mpackint i0, mpackint n0, mpreal * z, mpackint pp, mpreal tau, mpreal * dmin, mpreal * dmin1, mpreal * dmin2, mpreal * dn, mpreal * dnm1, mpreal * dnm2, mpackint ieee );
void Rlasq6 ( mpackint i0, mpackint n0, mpreal * z, mpackint pp, mpreal * dmin, mpreal * dmin1, mpreal * dmin2, mpreal * dn, mpreal * dnm1, mpreal * dnm2 );
void Rlasv2 ( mpreal f, mpreal g, mpreal h, mpreal * ssmin, mpreal * ssmax, mpreal * snr, mpreal * csr, mpreal * snl, mpreal * csl );
void Rlasy2 ( mpackint ltranl, mpackint ltranr, mpackint isgn, mpackint n1, mpackint n2, mpreal * tl, mpackint ldtl, mpreal * tr, mpackint ldtr, mpreal * B, mpackint ldb, mpreal * scale, mpreal * x, mpackint ldx, mpreal * xnorm, mpackint *info );
void Rlatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpreal * x, mpreal * scale, mpreal * cnorm, mpackint *info );
void Clatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpcomplex * x, mpreal * scale, mpreal * cnorm, mpackint *info );
void Rlatdf ( mpackint ijob, mpackint n, mpreal * z, mpackint ldz, mpreal * rhs, mpreal * rdsum, mpreal * rdscal, mpackint *ipiv, mpackint *jpiv );
void Clatdf ( mpackint ijob, mpackint n, mpcomplex * z, mpackint ldz, mpcomplex * rhs, mpreal * rdsum, mpreal * rdscal, mpackint *ipiv, mpackint *jpiv );
void Rlatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpreal * ap, mpreal * x, mpreal * scale, mpreal * cnorm, mpackint *info );
void Clatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpcomplex * ap, mpcomplex * x, mpreal * scale, mpreal * cnorm, mpackint *info );
void Rlauu2 ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Clauu2 ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rlauum ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Clauum ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rlatrz ( mpackint m, mpackint n, mpackint l, mpreal * A, mpackint lda, mpreal * tau, mpreal * work );
void Clatrz ( mpackint m, mpackint n, mpackint l, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work );
void Rorgl2 ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cungl2 ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rorgr2 ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint *info );
void Cungr2 ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rorm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Cunm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint *info );
void Rorm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Cunm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint *info );
void Rorml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Cunml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint *info );
void Rormr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * C, mpackint ldc, mpreal * work, mpackint *info );
void Cunmr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint *info );
void Rormr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Cunmr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint *info );
void Rpbtf2 ( const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpackint *info );
void Cpbtf2 ( const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpackint *info );
void Rptts2 ( mpackint n, mpackint nrhs, mpreal * d, mpreal * e, mpreal * b, mpackint ldb );
void Cptts2 ( mpackint iuplo, mpackint n, mpackint nrhs, mpreal * d, mpcomplex * e, mpcomplex * B, mpackint ldb );
void Rrscl ( mpackint n, mpreal sa, mpreal * sx, mpackint incx );
void CRrscl ( mpackint n, mpreal sa, mpcomplex * sx, mpackint incx );
void Rsygs2 ( mpackint itype, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *info );
void Chegs2 ( mpackint itype, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint *info );
void Rsytf2 ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Csytf2 ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Chetf2 ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rtgex2 ( mpackint wantq, mpackint wantz, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * q, mpackint ldq, mpreal * z, mpackint ldz, mpackint j1, mpackint n1, mpackint n2, mpreal * work, mpackint lwork, mpackint *info );
void Ctgex2 ( mpackint wantq, mpackint wantz, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * q, mpackint ldq, mpcomplex * z, mpackint ldz, mpackint j1, mpackint *info );
void Rtgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * c, mpackint ldc, mpreal * d, mpackint ldd, mpreal * e, mpackint lde, mpreal * f, mpackint ldf, mpreal * scale, mpreal * rdsum, mpreal * rdscal, mpackint *iwork, mpackint *pq, mpackint *info );
void Ctgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * C, mpackint ldc, mpcomplex * d, mpackint ldd, mpcomplex * e, mpackint lde, mpcomplex * f, mpackint ldf, mpreal * scale, mpreal * rdsum, mpreal * rdscal, mpackint *info );
void Rlazq3 ( mpackint i0, mpackint n0, mpreal * z, mpackint pp, mpreal * dmin, mpreal * sigma, mpreal * desig, mpreal qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint *ieee, mpackint *ttype, mpreal * dmin1, mpreal * dmin2, mpreal * dn, mpreal * dn1, mpreal * dn2, mpreal * tau );
void Rlazq4 ( mpackint i0, mpackint n0, mpreal * z, mpackint pp, mpackint n0in, mpreal dmin, mpreal dmin1, mpreal dmin2, mpreal dn, mpreal dn1, mpreal dn2, mpreal * tau, mpackint *ttype, mpreal * g );
void Rlaqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpreal * h, mpackint ldh, mpreal * wr, mpreal * wi, mpackint iloz, mpackint ihiz, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *info );
void Claqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpcomplex * h, mpackint ldh, mpcomplex * w, mpackint *iloz, mpackint *ihiz, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpackint *info );
void Rlaqr1 ( mpackint n, mpreal * h, mpackint ldh, mpreal sr1, mpreal si1, mpreal sr2, mpreal si2, mpreal * v );
void Claqr1 ( mpackint n, mpcomplex * h, mpackint ldh, mpcomplex s1, mpcomplex s2, mpcomplex * v );
void Rlaqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpreal * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpreal * z, mpackint ldz, mpackint *ns, mpackint *nd, mpreal * sr, mpreal * si, mpreal * v, mpackint ldv, mpackint nh, mpreal * t, mpackint ldt, mpackint nv, mpreal * wv, mpackint ldwv, mpreal * work, mpackint lwork );
void Claqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpcomplex * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpcomplex * z, mpackint ldz, mpackint *ns, mpackint *nd, mpcomplex * sh, mpcomplex * v, mpackint ldv, mpackint nh, mpcomplex * t, mpackint ldt, mpackint nv, mpcomplex * wv, mpackint ldwv, mpcomplex * work, mpackint lwork );
void Rlaqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpreal * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpreal * z, mpackint ldz, mpackint ns, mpackint nd, mpreal * sr, mpreal * si, mpreal * v, mpackint ldv, mpackint nh, mpreal * t, mpackint ldt, mpackint nv, mpreal * wv, mpackint ldwv, mpreal * work, mpackint lwork );
void Claqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, mpcomplex * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpcomplex * z, mpackint ldz, mpackint *ns, mpackint *nd, mpcomplex * sh, mpcomplex * v, mpackint ldv, mpackint nh, mpcomplex * t, mpackint ldt, mpackint nv, mpcomplex * wv, mpackint ldwv, mpcomplex * work, mpackint lwork );
void Rlaqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpreal * h, mpackint ldh, mpreal * wr, mpreal * wi, mpackint iloz, mpackint ihiz, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *info );
void Claqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, mpcomplex * h, mpackint ldh, mpcomplex * w, mpackint iloz, mpackint ihiz, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpackint *info );
void Rlaqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kac22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, mpreal * sr, mpreal * si, mpreal * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpreal * z, mpackint ldz, mpreal * v, mpackint ldv, mpreal * u, mpackint ldu, mpackint nv, mpreal * wv, mpackint ldwv, mpackint nh, mpreal * wh, mpackint ldwh );
void Claqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kacc22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, mpcomplex * s, mpcomplex * h, mpackint ldh, mpackint iloz, mpackint ihiz, mpcomplex * z, mpackint ldz, mpcomplex * v, mpackint ldv, mpcomplex * u, mpackint ldu, mpackint nv, mpcomplex * wv, mpackint ldwv, mpackint nh, mpcomplex * wh, mpackint ldwh );
void Rlatzm ( const char *side, mpackint m, mpackint n, mpreal * v, mpackint incv, mpreal * tau, mpreal *c1, mpreal * c2, mpackint ldc, mpreal * work );
void Clatzm ( const char *side, mpackint m, mpackint n, mpcomplex * v, mpackint incv, mpcomplex * tau, mpcomplex * c1, mpcomplex * c2, mpackint ldc, mpcomplex * work );
void Clacp2 ( const char *uplo, mpackint m, mpackint n, mpreal * A, mpackint lda, mpcomplex * B, mpackint ldb );
mpackint Risnan ( mpreal din );

/* not yet done ... driver and computational routines */
void Rbdsdc ( const char *uplo, const char *compq, mpackint n, mpreal * d, mpreal * e, mpreal * u, mpackint ldu, mpreal * vt, mpackint ldvt, mpreal * q, mpackint * iq, mpreal * work, mpackint * iwork, mpackint * info );
void Rbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, mpreal * d, mpreal * e, mpreal * vt, mpackint ldvt, mpreal * u, mpackint ldu, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Cbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, mpreal * d, mpreal * e, mpcomplex * vt, mpackint ldvt, mpcomplex * u, mpackint ldu, mpcomplex * c, mpackint ldc, mpreal * rwork, mpackint * info );
void Rdisna ( const char *job, mpackint m, mpackint n, mpreal * d, mpreal * sep, mpackint *info );
void Rgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, mpreal * AB, mpackint ldab, mpreal * d, mpreal * e, mpreal * q, mpackint ldq, mpreal * pt, mpackint ldpt, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Cgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, mpcomplex * AB, mpackint ldab, mpreal * d, mpreal * e, mpcomplex * q, mpackint ldq, mpcomplex * pt, mpackint ldpt, mpcomplex * c, mpackint ldc, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpreal * AB, mpackint ldab, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Cgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, mpcomplex * AB, mpackint ldab, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpreal * AB, mpackint ldab, mpreal * r, mpreal * c, mpreal * rowcnd, mpreal * colcnd, mpreal * amax, mpackint *info );
void Cgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpcomplex * AB, mpackint ldab, mpreal * r, mpreal * c, mpreal * rowcnd, mpreal * colcnd, mpreal * amax, mpackint *info );
void Rgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpreal * AB, mpackint ldab, mpreal * afb, mpackint ldafb, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpcomplex * AB, mpackint ldab, mpcomplex * afb, mpackint ldafb, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpreal * AB, mpackint ldab, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Cgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpcomplex * ab, mpackint ldab, mpackint *ipiv, mpcomplex * b, mpackint ldb, mpackint *info );
void Rgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpreal * AB, mpackint ldab, mpreal * afb, mpackint ldafb, mpackint * ipiv, char *equed, mpreal * r, mpreal * c, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint * iwork, mpackint * info );
void Cgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpcomplex * AB, mpackint ldab, mpcomplex * afb, mpackint ldafb, mpackint * ipiv, char *equed, mpreal * r, mpreal * c, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpreal * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, mpcomplex * ab, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpreal * AB, mpackint ldab, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Cgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, mpcomplex * AB, mpackint ldab, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Rgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpreal * scale, mpackint m, mpreal * v, mpackint ldv, mpackint *info );
void Cgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpreal * scale, mpackint m, mpcomplex * v, mpackint ldv, mpackint *info );
void Rgebal ( const char *job, mpackint n, mpreal * A, mpackint lda, mpackint *ilo, mpackint *ihi, mpreal * scale, mpackint *info );
void Cgebal ( const char *job, mpackint n, mpcomplex * A, mpackint lda, mpackint *ilo, mpackint *ihi, mpreal * scale, mpackint *info );
void Rgebrd ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * d, mpreal * e, mpreal * tauq, mpreal * taup, mpreal * work, mpackint lwork, mpackint *info );
void Cgebrd ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * d, mpreal * e, mpcomplex * tauq, mpcomplex * taup, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgecon ( const char *norm, mpackint n, mpreal * A, mpackint lda, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Cgecon ( const char *norm, mpackint n, mpcomplex * A, mpackint lda, mpreal anorm, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgeequ ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * r, mpreal * c, mpreal * rowcnd, mpreal * colcnd, mpreal * amax, mpackint *info );
void Cgeequ ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * r, mpreal * c, mpreal * rowcnd, mpreal * colcnd, mpreal * amax, mpackint *info );
void Rgees ( const char *jobvs, const char *sort, LFP select, mpackint n, mpreal * A, mpackint lda, mpackint *sdim, mpreal * wr, mpreal * wi, mpreal * vs, mpackint ldvs, mpreal * work, mpackint lwork, mpacklogical * bwork, mpackint *info );
void Cgees ( const char *jobvs, const char *sort, LFP select, mpackint n, mpcomplex * A, mpackint lda, mpackint *sdim, mpcomplex * w, mpcomplex * vs, mpackint ldvs, mpcomplex * work, mpackint lwork, mpreal * rwork, mpacklogical * bwork, mpackint *info );
void Rgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, mpreal * A, mpackint lda, mpackint * sdim, mpreal * wr, mpreal * wi, mpreal * vs, mpackint ldvs, mpreal * rconde, mpreal * rcondv, mpreal * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, mpcomplex * A, mpackint lda, mpackint *sdim, mpcomplex * w, mpcomplex * vs, mpackint ldvs, mpreal * rconde, mpreal * rcondv, mpcomplex * work, mpackint lwork, mpreal * rwork, mpacklogical * bwork, mpackint *info );
void Rgeev ( const char *jobvl, const char *jobvr, mpackint n, mpreal * A, mpackint lda, mpreal * wr, mpreal * wi, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpreal * work, mpackint lwork, mpackint *info );
void Cgeev ( const char *jobvl, const char *jobvr, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * w, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Rgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpreal * A, mpackint lda, mpreal * wr, mpreal * wi, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpreal * scale, mpreal * abnrm, mpreal * rconde, mpreal * rcondv, mpreal * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * w, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpreal * scale, mpreal * abnrm, mpreal * rconde, mpreal * rcondv, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Cgehrd ( mpackint n, mpackint ilo, mpackint ihi, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgehrd ( mpackint n, mpackint ilo, mpackint ihi, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Rgelqf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cgelqf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * work, mpackint lwork, mpackint *info );
void Cgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgelsx ( mpackint m, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *jpvt, mpreal rcond, mpackint *rank, mpreal * work, mpackint *info );
void Cgelsx ( mpackint m, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint *jpvt, mpreal rcond, mpackint *rank, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgelsd ( mpackint m, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * s, mpreal * rcond, mpackint *rank, mpreal * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Cgelsd ( mpackint m, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal * s, mpreal rcond, mpackint * rank, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * iwork, mpackint * info );
void Rgelss ( mpackint m, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * s, mpreal rcond, mpackint * rank, mpreal * work, mpackint lwork, mpackint * info );
void Cgelss ( mpackint m, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal * s, mpreal rcond, mpackint * rank, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Rgelsy ( mpackint m, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *jpvt, mpreal rcond, mpackint *rank, mpreal * work, mpackint lwork, mpackint *info );
void Cgelsy ( mpackint m, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint * jpvt, mpreal rcond, mpackint * rank, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Rgeqlf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cgeqlf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgeqpf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpackint *jpvt, mpreal * tau, mpreal * work, mpackint *info );
void Cgeqpf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpackint *jpvt, mpcomplex * tau, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgeqp3 ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpackint *jpvt, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cgeqp3 ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpackint *jpvt, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *info );
void Rgeqrf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cgeqrf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgerfs ( const char *trans, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * af, mpackint ldaf, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cgerfs ( const char *trans, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgerqf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cgerqf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgesdd ( const char *jobz, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * s, mpreal * u, mpackint ldu, mpreal * vt, mpackint ldvt, mpreal * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgesdd ( const char *jobz, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * s, mpcomplex * u, mpackint ldu, mpcomplex * vt, mpackint ldvt, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * iwork, mpackint * info );
void Rgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * s, mpreal * u, mpackint ldu, mpreal * vt, mpackint ldvt, mpreal * work, mpackint lwork, mpackint * info );
void Cgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpreal * s, mpcomplex * u, mpackint ldu, mpcomplex * vt, mpackint ldvt, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Rgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * af, mpackint ldaf, mpackint * ipiv, char *equed, mpreal * r, mpreal * c, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint * iwork, mpackint * info );
void Cgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, mpackint * ipiv, char *equed, mpreal * r, mpreal * c, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpreal * lscale, mpreal * rscale, mpackint m, mpreal * v, mpackint ldv, mpackint *info );
void Cggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, mpreal * lscale, mpreal * rscale, mpackint m, mpcomplex * v, mpackint ldv, mpackint *info );
void Rggbal ( const char *job, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *ilo, mpackint *ihi, mpreal * lscale, mpreal * rscale, mpreal * work, mpackint *info );
void Cggbal ( const char *job, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint *ilo, mpackint *ihi, mpreal * lscale, mpreal * rscale, mpreal * work, mpackint *info );
void Rgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint * sdim, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * vsl, mpackint ldvsl, mpreal * vsr, mpackint ldvsr, mpreal * work, mpackint lwork, mpacklogical * bwork, mpackint * info );
void Cgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint * sdim, mpcomplex * alpha, mpcomplex * beta, mpcomplex * vsl, mpackint ldvsl, mpcomplex * vsr, mpackint ldvsr, mpcomplex * work, mpackint lwork, mpreal * rwork, mpacklogical * bwork, mpackint * info );
void Rgegs ( const char *jobvsl, const char *jobvsr, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * vsl, mpackint ldvsl, mpreal * vsr, mpackint ldvsr, mpreal * work, mpackint lwork, mpackint *info );
void Cgegs ( const char *jobvsl, const char *jobvsr, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * alpha, mpcomplex * beta, mpcomplex * vsl, mpackint ldvsl, mpcomplex * vsr, mpackint ldvsr, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Rggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint * sdim, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * vsl, mpackint ldvsl, mpreal * vsr, mpackint ldvsr, mpreal * rconde, mpreal * rcondv, mpreal * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint * sdim, mpcomplex * alpha, mpcomplex * beta, mpcomplex * vsl, mpackint ldvsl, mpcomplex * vsr, mpackint ldvsr, mpreal * rconde, mpreal * rcondv, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Rggev ( const char *jobvl, const char *jobvr, mpackint n, mpreal * A, mpackint lda, mpreal * b, mpackint ldb, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpreal * work, mpackint lwork, mpackint * info );
void Cggev ( const char *jobvl, const char *jobvr, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * alpha, mpcomplex * beta, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Rgegv ( const char *jobvl, const char *jobvr, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpreal * work, mpackint lwork, mpackint * info );
void Cgegv ( const char *jobvl, const char *jobvr, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * alpha, mpcomplex * beta, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * info );
void Rggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpreal * lscale, mpreal * rscale, mpreal * abnrm, mpreal * bbnrm, mpreal * rconde, mpreal * rcondv, mpreal * work, mpackint lwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Cggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * alpha, mpcomplex * beta, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, mpreal * lscale, mpreal * rscale, mpreal * abnrm, mpreal * bbnrm, mpreal * rconde, mpreal * rcondv, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Rggglm ( mpackint n, mpackint m, mpackint p, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * d, mpreal * x, mpreal * y, mpreal * work, mpackint lwork, mpackint *info );
void Cggglm ( mpackint n, mpackint m, mpackint p, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * d, mpcomplex * x, mpcomplex * y, mpcomplex * work, mpackint lwork, mpackint *info );
void Rgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * q, mpackint ldq, mpreal * z, mpackint ldz, mpackint *info );
void Cgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * q, mpackint ldq, mpcomplex * z, mpackint ldz, mpackint *info );
void Rgglse ( mpackint m, mpackint n, mpackint p, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * c, mpreal * d, mpreal * x, mpreal * work, mpackint lwork, mpackint *info );
void Cgglse ( mpackint m, mpackint n, mpackint p, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * c, mpcomplex * d, mpcomplex * x, mpcomplex * work, mpackint lwork, mpackint *info );
void Rggqrf ( mpackint n, mpackint m, mpackint p, mpreal * A, mpackint lda, mpreal * taua, mpreal * B, mpackint ldb, mpreal * taub, mpreal * work, mpackint lwork, mpackint *info );
void Cggqrf ( mpackint n, mpackint m, mpackint p, mpcomplex * A, mpackint lda, mpcomplex * taua, mpcomplex * B, mpackint ldb, mpcomplex * taub, mpcomplex * work, mpackint lwork, mpackint *info );
void Rggrqf ( mpackint m, mpackint p, mpackint n, mpreal * A, mpackint lda, mpreal * taua, mpreal * B, mpackint ldb, mpreal * taub, mpreal * work, mpackint lwork, mpackint *info );
void Cggrqf ( mpackint m, mpackint p, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * taua, mpcomplex * B, mpackint ldb, mpcomplex * taub, mpcomplex * work, mpackint lwork, mpackint *info );
void Rggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * alpha, mpreal * beta, mpreal * u, mpackint ldu, mpreal * v, mpackint ldv, mpreal * q, mpackint ldq, mpreal * work, mpackint *iwork, mpackint *info );
void Cggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal * alpha, mpreal * beta, mpcomplex * u, mpackint ldu, mpcomplex * v, mpackint ldv, mpcomplex * q, mpackint ldq, mpcomplex * work, mpreal * rwork, mpackint *iwork, mpackint *info );
void Rggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal tola, mpreal tolb, mpackint *k, mpackint *l, mpreal * u, mpackint ldu, mpreal * v, mpackint ldv, mpreal * q, mpackint ldq, mpackint *iwork, mpreal * tau, mpreal * work, mpackint *info );
void Cggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal tola, mpreal tolb, mpackint *k, mpackint *l, mpcomplex * u, mpackint ldu, mpcomplex * v, mpackint ldv, mpcomplex * q, mpackint ldq, mpackint *iwork, mpreal * rwork, mpcomplex * tau, mpcomplex * work, mpackint *info );
void Rgtcon ( const char *norm, mpackint n, mpreal * dl, mpreal * d, mpreal * du, mpreal * du2, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Cgtcon ( const char *norm, mpackint n, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * du2, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpcomplex * work, mpackint *info );
void Rgtrfs ( const char *trans, mpackint n, mpackint nrhs, mpreal * dl, mpreal * d, mpreal * du, mpreal * dlf, mpreal * df, mpreal * duf, mpreal * du2, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cgtrfs ( const char *trans, mpackint n, mpackint nrhs, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * dlf, mpcomplex * df, mpcomplex * duf, mpcomplex * du2, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgtsv ( mpackint n, mpackint nrhs, mpreal * dl, mpreal * d, mpreal * du, mpreal * B, mpackint ldb, mpackint *info );
void Cgtsv ( mpackint n, mpackint nrhs, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * B, mpackint ldb, mpackint *info );
void Rgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpreal * dl, mpreal * d, mpreal * du, mpreal * dlf, mpreal * df, mpreal * duf, mpreal * du2, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * dlf, mpcomplex * df, mpcomplex * duf, mpcomplex * du2, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rgttrf ( mpackint n, mpreal * dl, mpreal * d, mpreal * du, mpreal * du2, mpackint *ipiv, mpackint *info );
void Cgttrf ( mpackint n, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * du2, mpackint *ipiv, mpackint *info );
void Rgttrs ( const char *trans, mpackint n, mpackint nrhs, mpreal * dl, mpreal * d, mpreal * du, mpreal * du2, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Cgttrs ( const char *trans, mpackint n, mpackint nrhs, mpcomplex * dl, mpcomplex * d, mpcomplex * du, mpcomplex * du2, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Rhgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpreal * h, mpackint ldh, mpreal * t, mpackint ldt, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * q, mpackint ldq, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *info );
void Chgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpcomplex * h, mpackint ldh, mpcomplex * t, mpackint ldt, mpcomplex * alpha, mpcomplex * beta, mpcomplex * q, mpackint ldq, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *info );
void Rhsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical *select, mpackint n, mpreal * h, mpackint ldh, mpreal * wr, mpreal * wi, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpackint mm, mpackint m, mpreal * work, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Chsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical * select, mpackint n, mpcomplex * h, mpackint ldh, mpcomplex * w, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpackint mm, mpackint *m, mpcomplex * work, mpreal * rwork, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Rhseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpreal * h, mpackint ldh, mpreal * wr, mpreal * wi, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *info );
void Chseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, mpcomplex * h, mpackint ldh, mpcomplex * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpackint *info );
void Ropgtr ( const char *uplo, mpackint n, mpreal * ap, mpreal * tau, mpreal * q, mpackint ldq, mpreal * work, mpackint *info );
void Cupgtr ( const char *uplo, mpackint n, mpcomplex * ap, mpcomplex * tau, mpcomplex * q, mpackint ldq, mpcomplex * work, mpackint *info );
void Ropmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpreal * ap, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint *info );
void Cupmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpcomplex * ap, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint *info );
void Rorgbr ( const char *vect, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cungbr ( const char *vect, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rorghr ( mpackint n, mpackint ilo, mpackint ihi, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cunghr ( mpackint n, mpackint ilo, mpackint ihi, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rorglq ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cunglq ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rorgrq ( mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Cungrq ( mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rormtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * c, mpackint ldc, mpreal * work, mpackint lwork, mpackint *info );
void Cunmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * c, mpackint ldc, mpcomplex * work, mpackint lwork, mpackint *info );
void Rpbcon ( const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Cpbcon ( const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpreal anorm, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rpbequ ( const char *uplo, mpackint n, mpackint kd, mpreal * ab, mpackint ldab, mpreal * s, mpreal * scond, mpreal * amax, mpackint *info );
void Cpbequ ( const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpreal * s, mpreal * scond, mpreal * amax, mpackint *info );
void Rpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpreal * AB, mpackint ldab, mpreal * afb, mpackint ldafb, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpcomplex * AB, mpackint ldab, mpcomplex * afb, mpackint ldafb, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rpbstf ( const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpackint *info );
void Cpbstf ( const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpackint *info );
void Rpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpreal * AB, mpackint ldab, mpreal * B, mpackint ldb, mpackint *info );
void Cpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpcomplex * ab, mpackint ldab, mpcomplex * B, mpackint ldb, mpackint *info );
void Rpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpreal * AB, mpackint ldab, mpreal * afb, mpackint ldafb, char *equed, mpreal * s, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint * iwork, mpackint * info );
void Cpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpcomplex * AB, mpackint ldab, mpcomplex * afb, mpackint ldafb, char *equed, mpreal * s, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rpbtrf ( const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpackint *info );
void Cpbtrf ( const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpackint *info );
void Rpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpreal * ab, mpackint ldab, mpreal * B, mpackint ldb, mpackint *info );
void Cpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, mpcomplex * AB, mpackint ldab, mpcomplex * B, mpackint ldb, mpackint *info );
void Rpocon ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Cpocon ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal anorm, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rpoequ ( mpackint n, mpreal * A, mpackint lda, mpreal * s, mpreal * scond, mpreal * amax, mpackint *info );
void Cpoequ ( mpackint n, mpcomplex * A, mpackint lda, mpreal * s, mpreal * scond, mpreal * amax, mpackint *info );
void Rporfs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * af, mpackint ldaf, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cporfs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rposv ( const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *info );
void Cposv ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint *info );
void Rposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * af, mpackint ldaf, char *equed, mpreal * s, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint * iwork, mpackint * info );
void Cposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, char *equed, mpreal * s, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rpotri ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *info );
void Cpotri ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *info );
void Rpotrs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *info );
void Cpotrs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint *info );
void Rppcon ( const char *uplo, mpackint n, mpreal * ap, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Cppcon ( const char *uplo, mpackint n, mpcomplex * ap, mpreal * anorm, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rppequ ( const char *uplo, mpackint n, mpreal * ap, mpreal * s, mpreal * scond, mpreal * amax, mpackint *info );
void Cppequ ( const char *uplo, mpackint n, mpcomplex * ap, mpreal * s, mpreal * scond, mpreal * amax, mpackint *info );
void Rpptrf ( const char *uplo, mpackint n, mpreal * ap, mpackint *info );
void Cpptrf ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *info );
void Rpptri ( const char *uplo, mpackint n, mpreal * ap, mpackint *info );
void Cpptri ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *info );
void Rpptrs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpreal * B, mpackint ldb, mpackint *info );
void Cpptrs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * B, mpackint ldb, mpackint *info );
void Rpprfs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpreal * afp, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cpprfs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * afp, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rppsv ( const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpreal * B, mpackint ldb, mpackint *info );
void Cppsv ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * B, mpackint ldb, mpackint *info );
void Rppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpreal * afp, char *equed, mpreal * s, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * afp, char *equed, mpreal * s, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rptcon ( mpackint n, mpreal * d, mpreal * e, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *info );
void Cptcon ( mpackint n, mpreal * d, mpcomplex * e, mpreal anorm, mpreal * rcond, mpreal * rwork, mpackint *info );
void Rpteqr ( const char *compz, mpackint n, mpreal * d, mpreal * e, mpreal * z, mpackint ldz, mpreal * work, mpackint * info );
void Cpteqr ( const char *compz, mpackint n, mpreal * d, mpreal * e, mpcomplex * z, mpackint ldz, mpreal * work, mpackint *info );
void Rptrfs ( mpackint n, mpackint nrhs, mpreal * d, mpreal * e, mpreal * df, mpreal * ef, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *info );
void Cptrfs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * d, mpcomplex * e, mpreal * df, mpcomplex * ef, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rptsv ( mpackint n, mpackint nrhs, mpreal * d, mpreal * e, mpreal * B, mpackint ldb, mpackint *info );
void Cptsv ( mpackint n, mpackint nrhs, mpreal * d, mpcomplex * e, mpcomplex * B, mpackint ldb, mpackint *info );
void Rptsvx ( const char *fact, mpackint n, mpackint nrhs, mpreal * d, mpreal * e, mpreal * df, mpreal * ef, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *info );
void Cptsvx ( const char *fact, mpackint n, mpackint nrhs, mpreal * d, mpcomplex * e, mpreal * df, mpcomplex * ef, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rpttrf ( mpackint n, mpreal * d, mpreal * e, mpackint *info );
void Cpttrf ( mpackint n, mpreal * d, mpcomplex * e, mpackint *info );
void Rpttrs ( mpackint n, mpackint nrhs, mpreal * d, mpreal * e, mpreal * B, mpackint ldb, mpackint *info );
void Cpttrs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * d, mpcomplex * e, mpcomplex * B, mpackint ldb, mpackint *info );
void Rsbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *info );
void Chbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rsbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpreal * q, mpackint ldq, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpcomplex * q, mpackint ldq, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint * iwork, mpackint * ifail, mpackint * info );
void Rsbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpreal * AB, mpackint ldab, mpreal * bb, mpackint ldbb, mpreal * x, mpackint ldx, mpreal * work, mpackint *info );
void Chbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpcomplex * AB, mpackint ldab, mpcomplex * bb, mpackint ldbb, mpcomplex * x, mpackint ldx, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rsbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpreal * AB, mpackint ldab, mpreal * bb, mpackint ldbb, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *info );
void Chbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpcomplex * AB, mpackint ldab, mpcomplex * bb, mpackint ldbb, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rsbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpreal * AB, mpackint ldab, mpreal * BB, mpackint ldbb, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpcomplex * AB, mpackint ldab, mpcomplex * BB, mpackint ldbb, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpreal * AB, mpackint ldab, mpreal * BB, mpackint ldbb, mpreal * q, mpackint ldq, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, mpcomplex * ab, mpackint ldab, mpcomplex * bb, mpackint ldbb, mpcomplex * q, mpackint ldq, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpreal * d, mpreal * e, mpreal * q, mpackint ldq, mpreal * work, mpackint *info );
void Chbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpreal * d, mpreal * e, mpcomplex * q, mpackint ldq, mpcomplex * work, mpackint *info );
void Rspcon ( const char *uplo, mpackint n, mpreal * ap, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Cspcon ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpcomplex * work, mpackint *info );
void Chpcon ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpcomplex * work, mpackint *info );
void Rspev ( const char *jobz, const char *uplo, mpackint n, mpreal * ap, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *info );
void Chpev ( const char *jobz, const char *uplo, mpackint n, mpcomplex * ap, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rspevd ( const char *jobz, const char *uplo, mpackint n, mpreal * ap, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpevd ( const char *jobz, const char *uplo, mpackint n, mpcomplex * ap, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpreal * ap, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpcomplex * ap, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rspgst ( mpackint itype, const char *uplo, mpackint n, mpreal * ap, mpreal * bp, mpackint *info );
void Chpgst ( mpackint *itype, const char *uplo, mpackint n, mpcomplex * ap, mpcomplex * bp, mpackint *info );
void Rspgv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpreal * ap, mpreal * bp, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *info );
void Chpgv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, mpcomplex * ap, mpcomplex * bp, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rspgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpreal * ap, mpreal * bp, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpcomplex * ap, mpcomplex * bp, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspgvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, mpreal * ap, mpreal * bp, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint m, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpgvx ( mpackint itype, const char *jobz, char *range, const char *uplo, mpackint n, mpcomplex * ap, mpcomplex * bp, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpreal * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsprfs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpreal * afp, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Csprfs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * afp, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Chprfs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * afp, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rspsv ( const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Cspsv ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Chpsv ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Rspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpreal * afp, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Cspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * afp, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Chpsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * afp, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rsptrd ( const char *uplo, mpackint n, mpreal * ap, mpreal * d, mpreal * e, mpreal * tau, mpackint *info );
void Chptrd ( const char *uplo, mpackint n, mpcomplex * ap, mpreal * d, mpreal * e, mpcomplex * tau, mpackint *info );
void Rsptrf ( const char *uplo, mpackint n, mpreal * ap, mpackint *ipiv, mpackint *info );
void Csptrf ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *ipiv, mpackint *info );
void Chptrf ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *ipiv, mpackint *info );
void Rsptri ( const char *uplo, mpackint n, mpreal * ap, mpackint *ipiv, mpreal * work, mpackint *info );
void Csptri ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *ipiv, mpcomplex * work, mpackint *info );
void Chptri ( const char *uplo, mpackint n, mpcomplex * ap, mpackint *ipiv, mpcomplex * work, mpackint *info );
void Rsptrs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * ap, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Csptrs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Chptrs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * ap, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Rstebz ( const char *range, const char *order, mpackint n, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpreal * d, mpreal * e, mpackint * m, mpackint * nsplit, mpreal * w, mpackint *iblock, mpackint *isplit, mpreal * work, mpackint *iwork, mpackint *info );
void Rstedc ( const char *compz, mpackint n, mpreal * d, mpreal * e, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cstedc ( const char *compz, mpackint n, mpreal * d, mpreal * e, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstegr ( const char *jobz, const char *range, mpackint n, mpreal * d, mpreal * e, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpreal * z, mpackint ldz, mpackint * isuppz, mpreal * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstegr ( const char *jobz, const char *range, mpackint n, mpreal *d, mpreal * e, mpreal * vl, mpreal * vu, mpackint *il, mpackint *iu, mpreal * abstol, mpackint m, mpreal * w, mpcomplex * z, mpackint ldz, mpackint *isuppz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstein ( mpackint n, mpreal * d, mpreal * e, mpackint m, mpreal * w, mpackint *iblock, mpackint *isplit, mpreal * z, mpackint ldz, mpreal * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cstein ( mpackint n, mpreal * d, mpreal * e, mpackint m, mpreal * w, mpackint *iblock, mpackint *isplit, mpcomplex * z, mpackint ldz, mpreal * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstev ( const char *jobz, mpackint n, mpreal * d, mpreal * e, mpreal * z, mpackint ldz, mpreal * work, mpackint *info );
void Rstevd ( const char *jobz, mpackint n, mpreal * d, mpreal * e, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstevr ( const char *jobz, const char *range, mpackint n, mpreal * d, mpreal * e, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpreal * z, mpackint ldz, mpackint * isuppz, mpreal * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rstevx ( const char *jobz, const char *range, mpackint n, mpreal * d, mpreal * e, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstemr ( const char *jobz, const char *range, mpackint n, mpreal * d, mpreal * e, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpackint * m, mpreal * w, mpreal * z, mpackint ldz, mpackint nzc, mpackint * isuppz, mpacklogical * tryrac, mpreal * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstemr ( const char *jobz, const char *range, mpackint n, mpreal * d, mpreal * e, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpackint * m, mpreal * w, mpcomplex * z, mpackint ldz, mpackint nzc, mpackint *isuppz, mpacklogical * tryrac, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsycon ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Csycon ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpcomplex * work, mpackint *info );
void Checon ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpreal anorm, mpreal * rcond, mpcomplex * work, mpackint *info );
void Rsyevd ( const char *jobz, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * w, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cheevd ( const char *jobz, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal * w, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsyevr ( const char *jobz, const char *range, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpreal * z, mpackint ldz, mpackint * isuppz, mpreal * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cheevr ( const char *jobz, const char *range, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpcomplex * z, mpackint ldz, mpackint * isuppz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rsyevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cheevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsygst ( mpackint itype, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpackint *info );
void Chegst ( mpackint itype, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpackint *info );
void Rsygv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * w, mpreal * work, mpackint lwork, mpackint *info );
void Chegv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal * w, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *info );
void Rsygvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * w, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chegvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal * w, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsygvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint *m, mpreal * w, mpreal * z, mpackint ldz, mpreal * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chegvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal vl, mpreal vu, mpackint il, mpackint iu, mpreal abstol, mpackint * m, mpreal * w, mpcomplex * z, mpackint ldz, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsyrfs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * af, mpackint ldaf, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Csyrfs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Cherfs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rsysv ( const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * work, mpackint lwork, mpackint *info );
void Csysv ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * work, mpackint lwork, mpackint *info );
void Chesv ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * work, mpackint lwork, mpackint *info );
void Rsysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * af, mpackint ldaf, mpackint *ipiv, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpreal * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Csysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *info );
void Chesvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * af, mpackint ldaf, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * rcond, mpreal * ferr, mpreal * berr, mpcomplex * work, mpackint lwork, mpreal * rwork, mpackint *info );
void Rsytrf ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * work, mpackint lwork, mpackint *info );
void Csytrf ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * work, mpackint lwork, mpackint *info );
void Chetrf ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * work, mpackint lwork, mpackint *info );
void Rsytri ( const char *uplo, mpackint n, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * work, mpackint *info );
void Csytri ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * work, mpackint *info );
void Chetri ( const char *uplo, mpackint n, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * work, mpackint *info );
void Rsytrs ( const char *uplo, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpackint *ipiv, mpreal * B, mpackint ldb, mpackint *info );
void Csytrs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Chetrs ( const char *uplo, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpackint *ipiv, mpcomplex * B, mpackint ldb, mpackint *info );
void Rtbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, mpreal * AB, mpackint ldab, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Ctbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, mpcomplex * AB, mpackint ldab, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rtbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpreal * AB, mpackint ldab, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Ctbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpcomplex * AB, mpackint ldab, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rtbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpreal * ab, mpackint ldab, mpreal * B, mpackint ldb, mpackint *info );
void Ctbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, mpcomplex * ab, mpackint ldab, mpcomplex * B, mpackint ldb, mpackint *info );
void Rtgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpreal * s, mpackint lds, mpreal *p, mpackint ldp, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpackint mm, mpackint *m, mpreal * work, mpackint * info );
void Ctgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpcomplex * s, mpackint lds, mpcomplex * p, mpackint ldp, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpackint mm, mpackint * m, mpcomplex * work, mpreal * rwork, mpackint * info );
void Rtgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * q, mpackint ldq, mpreal * z, mpackint ldz, mpackint * ifst, mpackint * ilst, mpreal * work, mpackint lwork, mpackint * info );
void Ctgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * q, mpackint ldq, mpcomplex * z, mpackint ldz, mpackint ifst, mpackint *ilst, mpackint *info );
void Rtgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical *select, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * alphar, mpreal * alphai, mpreal * beta, mpreal * q, mpackint ldq, mpreal * z, mpackint ldz, mpackint * m, mpreal * pl, mpreal * pr, mpreal * dif, mpreal * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Ctgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical * select, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * alpha, mpcomplex * beta, mpcomplex * q, mpackint ldq, mpcomplex * z, mpackint ldz, mpackint * m, mpreal * pl, mpreal * pr, mpreal * dif, mpcomplex * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rtgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal tola, mpreal tolb, mpreal * alpha, mpreal * beta, mpreal * u, mpackint ldu, mpreal * v, mpackint ldv, mpreal * q, mpackint ldq, mpreal * work, mpackint ncycle, mpackint *info );
void Ctgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpreal tola, mpreal tolb, mpreal * alpha, mpreal * beta, mpcomplex * u, mpackint ldu, mpcomplex * v, mpackint ldv, mpcomplex * q, mpackint ldq, mpcomplex * work, mpackint * ncycle, mpackint *info );
void Rtgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpreal * s, mpreal * dif, mpackint mm, mpackint * m, mpreal * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpreal * s, mpreal * dif, mpackint mm, mpackint * m, mpcomplex * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * c, mpackint ldc, mpreal * d, mpackint ldd, mpreal * e, mpackint lde, mpreal * f, mpackint ldf, mpreal * scale, mpreal * dif, mpreal * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * c, mpackint ldc, mpcomplex * d, mpackint ldd, mpcomplex * e, mpackint lde, mpcomplex * f, mpackint ldf, mpreal * scale, mpreal * dif, mpcomplex * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpreal * ap, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Ctpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpcomplex * ap, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rtprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpreal * ap, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Ctprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rtptri ( const char *uplo, const char *diag, mpackint n, mpreal * ap, mpackint *info );
void Ctptri ( const char *uplo, const char *diag, mpackint n, mpcomplex * ap, mpackint *info );
void Rtptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpreal * ap, mpreal * B, mpackint ldb, mpackint *info );
void Ctptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpcomplex * ap, mpcomplex * B, mpackint ldb, mpackint *info );
void Rtrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpreal * A, mpackint lda, mpreal * rcond, mpreal * work, mpackint *iwork, mpackint *info );
void Ctrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpcomplex * A, mpackint lda, mpreal * rcond, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rtrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpreal * t, mpackint ldt, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpackint mm, mpackint *m, mpreal * work, mpackint *info );
void Ctrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, mpcomplex * t, mpackint ldt, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpackint mm, mpackint *m, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rtrexc ( const char *compq, mpackint n, mpreal * t, mpackint ldt, mpreal * q, mpackint ldq, mpackint *ifst, mpackint *ilst, mpreal * work, mpackint *info );
void Ctrexc ( const char *compq, mpackint n, mpcomplex * t, mpackint ldt, mpcomplex * q, mpackint ldq, mpackint ifst, mpackint ilst, mpackint *info );
void Rtrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpreal * work, mpackint *iwork, mpackint *info );
void Ctrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * x, mpackint ldx, mpreal * ferr, mpreal * berr, mpcomplex * work, mpreal * rwork, mpackint *info );
void Rtrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, mpreal * t, mpackint ldt, mpreal * q, mpackint ldq, mpreal * wr, mpreal * wi, mpackint m, mpreal * s, mpreal * sep, mpreal * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Ctrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, mpcomplex * t, mpackint ldt, mpcomplex * q, mpackint ldq, mpcomplex * w, mpackint m, mpreal * s, mpreal * sep, mpcomplex * work, mpackint lwork, mpackint *info );
void Rtrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpreal * t, mpackint ldt, mpreal * vl, mpackint ldvl, mpreal * vr, mpackint ldvr, mpreal * s, mpreal * sep, mpackint mm, mpackint *m, mpreal * work, mpackint ldwork, mpackint *iwork, mpackint *info );
void Ctrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, mpcomplex * t, mpackint ldt, mpcomplex * vl, mpackint ldvl, mpcomplex * vr, mpackint ldvr, mpreal * s, mpreal * sep, mpackint mm, mpackint *m, mpcomplex * work, mpackint ldwork, mpreal * rwork, mpackint *info );
void Rtrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * B, mpackint ldb, mpreal * c, mpackint ldc, mpreal * scale, mpackint *info );
void Ctrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * B, mpackint ldb, mpcomplex * c, mpackint ldc, mpreal * scale, mpackint *info );
void Rtzrzf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpreal * work, mpackint lwork, mpackint *info );
void Ctzrzf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpcomplex * work, mpackint lwork, mpackint *info );
void Rtzrqf ( mpackint m, mpackint n, mpreal * A, mpackint lda, mpreal * tau, mpackint *info );
void Ctzrqf ( mpackint m, mpackint n, mpcomplex * A, mpackint lda, mpcomplex * tau, mpackint *info );

#endif
