/*
 * Copyright (c) 2008-2010
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mlapack_qd.h,v 1.31 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MLAPACK_QD_H_
#define _MLAPACK_QD_H_

#include "mpack_config.h"
#include <qd/qd_real.h>
#include "qd_complex.h"

/* MLAPACK prototypes */

/* MLAPACK driver routines */
void Rsyev ( const char *jobz, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * w, qd_real * work, mpackint lwork, mpackint *info );
void Cheev ( const char *jobz, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * w, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *info );
void Rgesv ( mpackint n, mpackint nrhs, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Cgesv ( mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );

/* MLAPACK computational routines */
void Rsteqr ( const char *compz, mpackint n, qd_real * d, qd_real * e, qd_real * Z, mpackint ldz, qd_real * work, mpackint *info );
void Csteqr ( const char *compz, mpackint n, qd_real * d, qd_real * e, qd_complex * z, mpackint ldz, qd_real * work, mpackint *info );
void Rsterf ( mpackint n, qd_real * d, qd_real * e, mpackint *info );
void Rorgqr ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cungqr ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rorgql ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cungql ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rsytrd ( const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * d, qd_real * e, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Chetrd ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * d, qd_real * e, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rorgtr ( const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cungtr ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rpotrf ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Cpotrf ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rtrtri ( const char *uplo, const char *diag, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Ctrtri ( const char *uplo, const char *diag, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rgetrf ( mpackint m, mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetrf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rgetri ( mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * work, mpackint lwork, mpackint *info );
void Cgetri ( mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * work, mpackint lwork, mpackint *info );
void Rgetrs ( const char *trans, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Cgetrs ( const char *trans, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Rtrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *info );
void Ctrtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint *info );

/* MLAPACK Auxiliary routines */
qd_real Rlamc3 ( qd_real a, qd_real b );
qd_real Rlamch_qd(const char *cmach);
mpackint iMlaenv_qd(mpackint ispec, const char *name, const char *opts, mpackint n1, mpackint n2,  mpackint n3, mpackint n4);
void Rlae2 ( qd_real a, qd_real b, qd_real c, qd_real * rt1, qd_real * rt2 );
void Rlaev2 ( qd_real a, qd_real b, qd_real c, qd_real * rt1, qd_real * rt2, qd_real * cs1, qd_real * sn1 );
void Claev2 ( qd_complex a, qd_complex b, qd_complex c, qd_real * rt1, qd_real * rt2, qd_real * cs1, qd_complex * sn1 );
void Rlassq ( mpackint n, qd_real * x, mpackint incx, qd_real * scale, qd_real * sumsq );
void Classq ( mpackint n, qd_complex * x, mpackint incx, qd_real * scale, qd_real * sumsq );
qd_real Rlanst ( const char *norm, mpackint n, qd_real * d, qd_real * e );
qd_real Clanht ( const char *norm, mpackint n, qd_real * d, qd_complex * e );
qd_real Rlansy ( const char *norm, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * work );
qd_real Clansy ( const char *norm, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * work );
qd_real Clanhe ( const char *norm, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * work );
qd_real Rlapy2 ( qd_real x, qd_real y );
void Rlarfg ( mpackint N, qd_real * alpha, qd_real * x, mpackint incx, qd_real * tau );
qd_real Rlapy3 ( qd_real x, qd_real y, qd_real z );
void Rladiv ( qd_real a, qd_real b, qd_real c, qd_real d, qd_real * p, qd_real * q );
qd_complex Cladiv ( qd_complex x, qd_complex y );
void Clarfg ( mpackint n, qd_complex * alpha, qd_complex * x, mpackint incx, qd_complex * tau );
void Rlartg ( qd_real f, qd_real g, qd_real * cs, qd_real * sn, qd_real * r );
void Clartg ( qd_complex f, qd_complex g, qd_real * cs, qd_complex * sn, qd_complex * r );
void Rlaset ( const char *uplo, mpackint m, mpackint n, qd_real alpha, qd_real beta, qd_real * A, mpackint lda );
void Claset ( const char *uplo, mpackint m, mpackint n, qd_complex alpha, qd_complex beta, qd_complex * A, mpackint lda );
void Rlasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, qd_real * c, qd_real * s, qd_real * A, mpackint lda );
void Clasr ( const char *side, const char *pivot, const char *direct, mpackint m, mpackint n, qd_real * c, qd_real * s, qd_complex * A, mpackint lda );
void Rpotf2 ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Clacgv ( mpackint n, qd_complex * x, mpackint incx );
void Cpotf2 ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rlascl ( const char *type, mpackint kl, mpackint ku, qd_real cfrom, qd_real cto, mpackint m, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Clascl ( const char *type, mpackint kl, mpackint ku, qd_real cfrom, qd_real cto, mpackint m, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rlasrt ( const char *id, mpackint n, qd_real * d, mpackint *info );
void Rsytd2 ( const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * d, qd_real * e, qd_real * tau, mpackint *info );
void Chetd2 ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * d, qd_real * e, qd_complex * tau, mpackint *info );
void Rlarf ( const char *side, mpackint m, mpackint n, qd_real * v, mpackint incv, qd_real tau, qd_real * C, mpackint ldc, qd_real * work );
void Clarf ( const char *side, mpackint m, mpackint n, qd_complex * v, mpackint incv, qd_complex tau, qd_complex * c, mpackint ldc, qd_complex * work );
void Rorg2l ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cung2l ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rorg2r ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cung2r ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rlarft ( const char *direct, const char *storev, mpackint n, mpackint k, qd_real * v, mpackint ldv, qd_real * tau, qd_real * t, mpackint ldt );
void Clarft ( const char *direct, const char *storev, mpackint n, mpackint k, qd_complex * v, mpackint ldv, qd_complex * tau, qd_complex * t, mpackint ldt );
void Rlarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, qd_real * V, mpackint ldv, qd_real * T, mpackint ldt, qd_real * C, mpackint ldc, qd_real * work, mpackint ldwork );
void Clarfb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, qd_complex * V, mpackint ldv, qd_complex * T, mpackint ldt, qd_complex * C, mpackint ldc, qd_complex * work, mpackint ldwork );
void Rlatrd ( const char *uplo, mpackint n, mpackint nb, qd_real * A, mpackint lda, qd_real * e, qd_real * tau, qd_real * w, mpackint ldw );
void Clatrd ( const char *uplo, mpackint n, mpackint nb, qd_complex * A, mpackint lda, qd_real * e, qd_complex * tau, qd_complex * w, mpackint ldw );
void Clacrm ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * B, mpackint ldb, qd_complex * c, mpackint ldc, qd_real * rwork );
void Rtrti2 ( const char *uplo, const char *diag, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Ctrti2 ( const char *uplo, const char *diag, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rgetf2 ( mpackint m, mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Cgetf2 ( mpackint m, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rlaswp ( mpackint n, qd_real * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Claswp ( mpackint n, qd_complex * A, mpackint lda, mpackint k1, mpackint k2, mpackint *ipiv, mpackint incx );
void Rlasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * w, mpackint ldw, mpackint *info );
void Clasyf ( const char *uplo, mpackint n, mpackint nb, mpackint kb, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * w, mpackint ldw, mpackint *info );
void Clahef ( const char *uplo, mpackint n, mpackint nb, mpackint kb, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * w, mpackint ldw, mpackint *info );
void Clacrt ( mpackint n, qd_complex * cx, mpackint incx, qd_complex * cy, mpackint incy, qd_complex c, qd_complex s );
void Claesy ( qd_complex a, qd_complex b, qd_complex c, qd_complex * rt1, qd_complex * rt2, qd_complex * evscal, qd_complex * cs1, qd_complex * sn1 );
void Crot ( mpackint n, qd_complex * cx, mpackint incx, qd_complex * cy, mpackint incy, qd_real c, qd_complex s );
void Cspmv ( const char *uplo, mpackint n, qd_complex alpha, qd_complex * AP, qd_complex * x, mpackint incx, qd_complex beta, qd_complex * y, mpackint incy );
void Cspr ( const char *uplo, mpackint n, qd_complex alpha, qd_complex * x, mpackint incx, qd_complex * AP );
void Csymv ( const char *uplo, mpackint n, qd_complex alpha, qd_complex * A, mpackint lda, qd_complex * x, mpackint incx, qd_complex beta, qd_complex * y, mpackint incy );
void Csyr ( const char *uplo, mpackint n, qd_complex alpha, qd_complex * x, mpackint incx, qd_complex * A, mpackint lda );
mpackint iCmax1 ( mpackint n, qd_complex * cx, mpackint incx );
qd_real RCsum1 ( mpackint n, qd_complex * cx, mpackint incx );
void Rlacn2 ( mpackint n, qd_real * v, qd_real * x, mpackint *isgn, qd_real * est, mpackint *kase, mpackint *isave );
void Clacn2 ( mpackint n, qd_complex * v, qd_complex * x, qd_real * est, mpackint *kase, mpackint *isave );
void Rlatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, qd_real * A, mpackint lda, qd_real * x, qd_real * scale, qd_real * cnorm, mpackint *info );
void Clatrs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, qd_complex * A, mpackint lda, qd_complex * x, qd_real * scale, qd_real * cnorm, mpackint *info );

/* not yet done ... auxiliary routines */
void Rgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_real * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtf2 ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_complex * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgebd2 ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * d, qd_real * e, qd_real * tauq, qd_real * taup, qd_real * work, mpackint *info );
void Cgebd2 ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * d, qd_real * e, qd_complex * tauq, qd_complex * taup, qd_complex * work, mpackint *info );
void Rgehd2 ( mpackint n, mpackint ilo, mpackint ihi, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cgehd2 ( mpackint n, mpackint ilo, mpackint ihi, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rgelq2 ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cgelq2 ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rgeql2 ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cgeql2 ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rgeqr2 ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cgeqr2 ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rgerq2 ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cgerq2 ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rgesc2 ( mpackint n, qd_real * A, mpackint lda, qd_real * rhs, mpackint *ipiv, mpackint *jpiv, qd_real * scale );
void Cgesc2 ( mpackint n, qd_complex * A, mpackint lda, qd_complex * rhs, mpackint *ipiv, mpackint *jpiv, qd_real * scale );
void Rgetc2 ( mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Cgetc2 ( mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, mpackint *jpiv, mpackint *info );
void Rgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, qd_real * dl, qd_real * d, qd_real * du, qd_real * du2, mpackint *ipiv, qd_real * B, mpackint ldb );
void Cgtts2 ( mpackint itrans, mpackint n, mpackint nrhs, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * du2, mpackint *ipiv, qd_complex * B, mpackint ldb );
void Rlabrd ( mpackint m, mpackint n, mpackint nb, qd_real * A, mpackint lda, qd_real * d, qd_real * e, qd_real * tauq, qd_real * taup, qd_real * x, mpackint ldx, qd_real * y, mpackint ldy );
void Clabrd ( mpackint m, mpackint n, mpackint nb, qd_complex * A, mpackint lda, qd_real * d, qd_real * e, qd_complex * tauq, qd_complex * taup, qd_complex * x, mpackint ldx, qd_complex * y, mpackint ldy );
void Rlacpy ( const char *uplo, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb );
void Clacpy ( const char *uplo, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb );
void Clarcm ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * c, mpackint ldc, qd_real * rwork );
void Rlaebz ( mpackint ijob, mpackint nitmax, mpackint n, mpackint mmax, mpackint minp, mpackint nbmin, qd_real abstol, qd_real reltol, qd_real pivmin, qd_real * d, qd_real * e, qd_real * e2, mpackint *nval, qd_real * AB, qd_real * c, mpackint *mout, mpackint *nab, qd_real * work, mpackint *iwork, mpackint *info );
void Rlaed0 ( mpackint icompq, mpackint qsiz, mpackint n, qd_real * d, qd_real * e, qd_real * q, mpackint ldq, qd_real * qstore, mpackint ldqs, qd_real * work, mpackint *iwork, mpackint *info );
void Claed0 ( mpackint qsiz, mpackint n, qd_real * d, qd_real * e, qd_complex * q, mpackint ldq, qd_complex * qstore, mpackint ldqs, qd_real * rwork, mpackint *iwork, mpackint *info );
void Rlaed1 ( mpackint n, qd_real * d, qd_real * q, mpackint ldq, mpackint *indxq, qd_real rho, mpackint cutpnt, qd_real * work, mpackint *iwork, mpackint *info );
void Rlaed2 ( mpackint *k, mpackint n, mpackint n1, qd_real * d, qd_real * q, mpackint ldq, mpackint *indxq, qd_real * rho, qd_real * z, qd_real * dlamda, qd_real * w, qd_real * q2, mpackint *indx, mpackint *indxc, mpackint *indxp, mpackint *coltyp, mpackint *info );
void Rlaed3 ( mpackint k, mpackint n, mpackint n1, qd_real * d, qd_real * q, mpackint ldq, qd_real * rho, qd_real * dlamda, qd_real * q2, mpackint *indx, mpackint *ctot, qd_real * w, qd_real * s, mpackint *info );
void Rlaed4 ( mpackint n, mpackint i, qd_real * d, qd_real * z, qd_real * delta, qd_real rho, qd_real * dlam, mpackint *info );
void Rlaed5 ( mpackint i, qd_real * d, qd_real * z, qd_real * delta, qd_real rho, qd_real * dlam );
void Rlaed6 ( mpackint kniter, mpackint orgati, qd_real rho, qd_real * d, qd_real * z, qd_real * finit, qd_real * tau, mpackint *info );
void Rlaed7 ( mpackint icompq, mpackint n, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, qd_real * d, qd_real * q, mpackint ldq, mpackint *indxq, qd_real rho, mpackint cutpnt, qd_real * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, qd_real * givnum, qd_real * work, mpackint *iwork, mpackint *info );
void Claed7 ( mpackint n, mpackint cutpnt, mpackint qsiz, mpackint tlvls, mpackint curlvl, mpackint curpbm, qd_real * d, qd_complex * q, mpackint ldq, qd_real rho, mpackint *indxq, qd_real * qstore, mpackint *qptr, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, qd_real * givnum, qd_complex * work, qd_real * rwork, mpackint *iwork, mpackint *info );
void Rlaed8 ( mpackint icompq, mpackint *k, mpackint n, mpackint qsiz, qd_real * d, qd_real * q, mpackint ldq, mpackint *indxq, qd_real * rho, mpackint cutpnt, qd_real * z, qd_real * dlamda, qd_real * q2, mpackint ldq2, qd_real * w, mpackint *perm, mpackint *givptr, mpackint *givcol, qd_real * givnum, mpackint *indxp, mpackint *indx, mpackint *info );
void Claed8 ( mpackint *k, mpackint n, mpackint qsiz, qd_complex * q, mpackint ldq, qd_real * d, qd_real * rho, mpackint cutpnt, qd_real * z, qd_real * dlamda, qd_complex * q2, mpackint ldq2, qd_real * w, mpackint *indxp, mpackint *indx, mpackint *indxq, mpackint *perm, mpackint *givptr, mpackint *givcol, qd_real * givnum, mpackint *info );
void Rlaed9 ( mpackint k, mpackint kstart, mpackint kstop, mpackint n, qd_real * d, qd_real * q, mpackint ldq, qd_real rho, qd_real * dlamda, qd_real * w, qd_real * s, mpackint lds, mpackint *info );
void Rlaeda ( mpackint n, mpackint tlvls, mpackint curlvl, mpackint curpbm, mpackint *prmptr, mpackint *perm, mpackint *givptr, mpackint *givcol, qd_real * givnum, qd_real * q, mpackint *qptr, qd_real * z, qd_real * ztemp, mpackint *info );
void Rlaein ( mpackint rightv, mpackint noinit, mpackint n, qd_real * h, mpackint ldh, qd_real wr, qd_real wi, qd_real * vr, qd_real * vi, qd_real * B, mpackint ldb, qd_real * work, qd_real eps3, qd_real smlnum, qd_real bignum, mpackint *info );
void Claein ( mpackint rightv, mpackint noinit, mpackint n, qd_complex * h, mpackint ldh, qd_complex w, qd_complex * v, qd_complex * B, mpackint ldb, qd_real * rwork, qd_real eps3, qd_real smlnum, mpackint *info );
void Rlaexc ( mpackint wantq, mpackint n, qd_real * t, mpackint ldt, qd_real * q, mpackint ldq, mpackint j1, mpackint n1, mpackint n2, qd_real * work, mpackint *info );
void Rlag2 ( qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real safmin, qd_real * scale1, qd_real * scale2, qd_real * wr1, qd_real * wr2, qd_real * wi );
void Rlags2 ( mpackint upper, qd_real a1, qd_real a2, qd_real a3, qd_real b1, qd_real b2, qd_real b3, qd_real * csu, qd_real * snu, qd_real * csv, qd_real * snv, qd_real * csq, qd_real * snq );
void Clags2 ( mpacklogical * upper, qd_real a1, qd_complex a2, qd_real a3, qd_real b1, qd_complex b2, qd_real b3, qd_real * csu, qd_complex * snu, qd_real * csv, qd_complex * snv, qd_real * csq, qd_complex * snq );
void Rlagtf ( mpackint n, qd_real * a, qd_real lambda, qd_real * b, qd_real * c, qd_real * tol, qd_real * d, mpackint *in, mpackint *info );
void Rlagtm ( const char *trans, mpackint n, mpackint nrhs, qd_real alpha, qd_real * dl, qd_real * d, qd_real * du, qd_real * x, mpackint ldx, qd_real * beta, qd_real * B, mpackint ldb );
void Clagtm ( const char *trans, mpackint n, mpackint nrhs, qd_real alpha, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * x, mpackint ldx, qd_real beta, qd_complex * B, mpackint ldb );
void Rlagts ( mpackint job, mpackint n, qd_real * a, qd_real * b, qd_real * c, qd_real * d, mpackint *in, qd_real * y, qd_real * tol, mpackint *info );
void Rlagv2 ( qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * csl, qd_real * snl, qd_real * csr, qd_real * snr );
void Rlahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, qd_real * h, mpackint ldh, qd_real * wr, qd_real * wi, mpackint iloz, mpackint ihiz, qd_real * z, mpackint ldz, mpackint *info );
void Clahqr ( mpackint wantt, mpackint wantz, mpackint n, mpackint ilo, mpackint ihi, qd_complex * h, mpackint ldh, qd_complex * w, mpackint iloz, mpackint ihiz, qd_complex * z, mpackint ldz, mpackint *info );
void Rlahr2 ( mpackint n, mpackint k, mpackint nb, qd_real * A, mpackint lda, qd_real * tau, qd_real * t, mpackint ldt, qd_real * y, mpackint ldy );
void Clahr2 ( mpackint n, mpackint k, mpackint nb, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * t, mpackint ldt, qd_complex * y, mpackint ldy );
void Rlahrd ( mpackint n, mpackint k, mpackint nb, qd_real * A, mpackint lda, qd_real * tau, qd_real * t, mpackint ldt, qd_real * y, mpackint ldy );
void Clahrd ( mpackint n, mpackint k, mpackint nb, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * t, mpackint ldt, qd_complex * y, mpackint ldy );
void Rlaic1 ( mpackint job, mpackint j, qd_real * x, qd_real sest, qd_real * w, qd_real gamma, qd_real * sestpr, qd_real * s, qd_real * c );
void Claic1 ( mpackint job, mpackint j, qd_complex * x, qd_real sest, qd_complex * w, qd_complex gamma, qd_real * sestpr, qd_complex * s, qd_complex * c );
void Rlaln2 ( mpackint ltrans, mpackint na, mpackint nw, qd_real smin, qd_real ca, qd_real * A, mpackint lda, qd_real d1, qd_real d2, qd_real * B, mpackint ldb, qd_real wr, qd_real wi, qd_real * x, mpackint ldx, qd_real * scale, qd_real * xnorm, mpackint *info );
void Rlals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, qd_real * B, mpackint ldb, qd_real * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, qd_real * givnum, mpackint ldgnum, qd_real * poles, qd_real * difl, qd_real * difr, qd_real * z, mpackint k, qd_real c, qd_real s, qd_real * work, mpackint *info );
void Clals0 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint nrhs, qd_complex * B, mpackint ldb, qd_complex * bx, mpackint ldbx, mpackint *perm, mpackint givptr, mpackint *givcol, mpackint ldgcol, qd_real * givnum, mpackint ldgnum, qd_real * poles, qd_real * difl, qd_real * difr, qd_real * z, mpackint k, qd_real c, qd_real s, qd_real * rwork, mpackint *info );
void Rlalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, qd_real * B, mpackint ldb, qd_real * bx, mpackint ldbx, qd_real * u, mpackint ldu, qd_real * vt, mpackint *k, qd_real * difl, qd_real * difr, qd_real * z, qd_real * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, qd_real * givnum, qd_real * c, qd_real * s, qd_real * work, mpackint *iwork, mpackint *info );
void Clalsa ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint nrhs, qd_complex * B, mpackint ldb, qd_complex * bx, mpackint ldbx, qd_real * u, mpackint ldu, qd_real * vt, mpackint *k, qd_real * difl, qd_real * difr, qd_real * z, qd_real * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, qd_real * givnum, qd_real * c, qd_real * s, qd_real * rwork, mpackint *iwork, mpackint *info );
void Rlalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, qd_real * d, qd_real * e, qd_real * B, mpackint ldb, qd_real rcond, mpackint *rank, qd_real * work, mpackint *iwork, mpackint *info );
void Clalsd ( const char *uplo, mpackint smlsiz, mpackint n, mpackint nrhs, qd_real * d, qd_real * e, qd_complex * B, mpackint ldb, qd_real rcond, mpackint *rank, qd_complex * work, qd_real * rwork, mpackint *iwork, mpackint *info );
void Rlamrg ( mpackint n1, mpackint n2, qd_real * a, mpackint dtrd1, mpackint dtrd2, mpackint *index );
qd_real Rlangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, qd_real * ab, mpackint ldab, qd_real * work );
qd_real Clangb ( const char *norm, mpackint n, mpackint kl, mpackint ku, qd_complex * AB, mpackint ldab, qd_real * work );
qd_real Rlange ( const char *norm, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * work );
qd_real Clange ( const char *norm, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * work );
qd_real Rlangt ( const char *norm, mpackint n, qd_real * dl, qd_real * d, qd_real * du );
qd_real Clangt ( const char *norm, mpackint n, qd_complex * dl, qd_complex * d, qd_complex * du );
qd_real Rlanhs ( const char *norm, mpackint n, qd_real * A, mpackint lda, qd_real * work );
qd_real Clanhs ( const char *norm, mpackint n, qd_complex * A, mpackint lda, qd_real * work );
qd_real Rlansb ( const char *norm, const char *uplo, mpackint n, mpackint k, qd_real * AB, mpackint ldab, qd_real * work );
qd_real Clansb ( const char *norm, const char *uplo, mpackint n, mpackint k, qd_complex * AB, mpackint ldab, qd_real * work );
qd_real Clanhb ( const char *norm, const char *uplo, mpackint n, mpackint k, qd_complex * AB, mpackint ldab, qd_real * work );
qd_real Rlansp ( const char *norm, const char *uplo, mpackint n, qd_real * ap, qd_real * work );
qd_real Clansp ( const char *norm, const char *uplo, mpackint n, qd_complex * ap, qd_real * work );
qd_real Clanhp ( const char *norm, const char *uplo, mpackint n, qd_complex * ap, qd_real * work );
qd_real Rlantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, qd_real * AB, mpackint ldab, qd_real * work );
qd_complex Clantb ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint k, qd_complex * AB, mpackint ldab, qd_real * work );
qd_real Rlantp ( const char *norm, const char *uplo, const char *diag, mpackint n, qd_real * ap, qd_real * work );
qd_complex Clantp ( const char *norm, const char *uplo, const char *diag, mpackint n, qd_complex * ap, qd_real * work );
qd_real Rlantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * work );
qd_real Clantr ( const char *norm, const char *uplo, const char *diag, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * work );
void Rlanv2 ( qd_real * a, qd_real * b, qd_real * c, qd_real * d, qd_real * rt1r, qd_real * rt1i, qd_real * rt2r, qd_real * rt2i, qd_real * cs, qd_real * sn );
void Rlapll ( mpackint n, qd_real * x, mpackint incx, qd_real * y, mpackint incy, qd_real * ssmin );
void Clapll ( mpackint n, qd_complex * x, mpackint incx, qd_complex * y, mpackint incy, qd_real * ssmin );
void Rlapmt ( mpackint *forwrd, mpackint m, mpackint n, qd_real * X, mpackint ldx, mpackint *k );
void Clapmt ( mpackint *forwrd, mpackint m, mpackint n, qd_complex * X, mpackint ldx, mpackint *k );
void Rlaqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_real * AB, mpackint ldab, qd_real * r, qd_real * c, qd_real rowcnd, qd_real colcnd, qd_real amax, char *equed );
void Claqgb ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_complex * AB, mpackint ldab, qd_real * r, qd_real * c, qd_real rowcnd, qd_real colcnd, qd_real amax, char *equed );
void Rlaqge ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * r, qd_real * c, qd_real rowcnd, qd_real colcnd, qd_real amax, char *equed );
void Claqge ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * r, qd_real * c, qd_real rowcnd, qd_real colcnd, qd_real amax, char *equed );
void Rlaqp2 ( mpackint m, mpackint n, mpackint offset, qd_real * A, mpackint lda, mpackint *jpvt, qd_real * tau, qd_real * vn1, qd_real * vn2, qd_real * work );
void Claqp2 ( mpackint m, mpackint n, mpackint offset, qd_complex * A, mpackint lda, mpackint *jpvt, qd_complex * tau, qd_real * vn1, qd_real * vn2, qd_complex * work );
void Rlaqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, qd_real * A, mpackint lda, mpackint *jpvt, qd_real * tau, qd_real * vn1, qd_real * vn2, qd_real * auxv, qd_real * f, mpackint ldf );
void Claqps ( mpackint m, mpackint n, mpackint offset, mpackint nb, mpackint *kb, qd_complex * A, mpackint lda, mpackint *jpvt, qd_complex * tau, qd_real * vn1, qd_real * vn2, qd_complex * auxv, qd_complex * f, mpackint ldf );
void Rlaqsb ( const char *uplo, mpackint n, mpackint kd, qd_real * ab, mpackint ldab, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Claqsb ( const char *uplo, mpackint n, mpackint kd, qd_complex * ab, mpackint ldab, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Claqhb ( const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Rlaqsp ( const char *uplo, mpackint n, qd_real * ap, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Claqsp ( const char *uplo, mpackint n, qd_complex * ap, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Claqhp ( const char *uplo, mpackint n, qd_complex * ap, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Rlaqsy ( const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Claqsy ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Claqhe ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * s, qd_real scond, qd_real amax, char *equed );
void Rlaqtr ( mpackint ltran, mpackint lreal, mpackint n, qd_real * t, mpackint ldt, qd_real * B, qd_real w, qd_real * scale, qd_real * x, qd_real * work, mpackint *info );
void Rlar1v ( mpackint n, mpackint b1, mpackint bn, qd_real lambda, qd_real * d, qd_real * l, qd_real * ld, qd_real * lld, qd_real pivmin, qd_real gaptol, qd_real * z, mpackint wantnc, mpackint *negcnt, qd_real * ztz, qd_real * mingma, mpackint *r, mpackint *isuppz, qd_real * nrminv, qd_real * resid, qd_real * rqcorr, qd_real * work );
void Clar1v ( mpackint n, mpackint b1, mpackint bn, qd_real lambda, qd_real * d, qd_real * l, qd_real * ld, qd_real * lld, qd_real pivmin, qd_real gaptol, qd_complex * z, mpackint wantnc, mpackint *negcnt, qd_real * ztz, qd_real * mingma, mpackint *r, mpackint *isuppz, qd_real * nrminv, qd_real * resid, qd_real * rqcorr, qd_real * work );
void Rlar2v ( mpackint n, qd_real * x, qd_real * y, qd_real * z, mpackint incx, qd_real * c, qd_real * s, mpackint incc );
void Clar2v ( mpackint n, qd_complex * x, qd_complex * y, qd_complex * z, mpackint incx, qd_real * c, qd_complex * s, mpackint incc );
void Rlarfx ( const char *side, mpackint m, mpackint n, qd_real * v, qd_real tau, qd_real * c, mpackint ldc, qd_real * work );
void Clarfx ( const char *side, mpackint m, mpackint n, qd_complex * v, qd_complex tau, qd_complex * c, mpackint ldc, qd_complex * work );
void Rlargv ( mpackint n, qd_real * x, mpackint incx, qd_real * y, mpackint incy, qd_real * c, mpackint incc );
void Clargv ( mpackint n, qd_complex * x, mpackint incx, qd_complex * y, mpackint incy, qd_real * c, mpackint incc );
void Rlarnv ( mpackint idist, mpackint *iseed, mpackint n, qd_real * x );
void Clarnv ( mpackint idist, mpackint *iseed, mpackint n, qd_complex * x );
mpackint Rlaneg ( mpackint n, qd_real * d, qd_real * lld, qd_real sigma, qd_real pivmin, mpackint r );
void Rlarra ( mpackint n, qd_real * d, qd_real * e, qd_real * e2, qd_real spltol, qd_real tnrm, mpackint *nsplit, mpackint *isplit, mpackint *info );
void Rlarrb ( mpackint n, qd_real * d, qd_real * lld, mpackint ifirst, mpackint ilast, qd_real rtol1, qd_real rtol2, mpackint offset, qd_real * w, qd_real * wgap, qd_real * werr, qd_real * work, mpackint *iwork, qd_real pivmin, qd_real spdiam, mpackint twist, mpackint *info );
void Rlarrc ( const char *jobt, mpackint n, qd_real vl, qd_real vu, qd_real * d, qd_real * e, qd_real pivmin, mpackint *eigcnt, mpackint *lcnt, mpackint *rcnt, mpackint *info );
void Rlarrd ( const char *range, const char *order, mpackint n, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real *gers, qd_real reltol, qd_real * d, qd_real * e, qd_real * e2, qd_real pivmin, mpackint nsplit, mpackint *isplit, mpackint *m, qd_real * w, qd_real * werr, qd_real * wl, qd_real * wu, mpackint *iblock, mpackint *indexw, qd_real * work, mpackint *iwork, mpackint *info );
void Rlarre ( const char *range, mpackint n, qd_real * vl, qd_real * vu, mpackint il, mpackint iu, qd_real * d, qd_real * e, qd_real * e2, qd_real rtol1, qd_real rtol2, qd_real spltol, mpackint * nsplit, mpackint *isplit, mpackint * m, qd_real * w, qd_real * werr, qd_real * wgap, mpackint *iblock, mpackint *indexw, qd_real * gers, qd_real * pivmin, qd_real * work, mpackint *iwork, mpackint *info );
void Rlarrf ( mpackint n, qd_real * d, qd_real * l, qd_real * ld, mpackint clstrt, mpackint clend, qd_real * w, qd_real * wgap, qd_real * werr, qd_real spdiam, qd_real clgapl, qd_real clgapr, qd_real pivmin, qd_real * sigma, qd_real * dplus, qd_real * lplus, qd_real * work, mpackint *info );
void Rlarrj ( mpackint n, qd_real * d, qd_real * e2, mpackint ifirst, mpackint ilast, qd_real rtol, mpackint offset, qd_real * w, qd_real * werr, qd_real * work, mpackint *iwork, qd_real pivmin, qd_real spdiam, mpackint *info );
void Rlarrk ( mpackint n, mpackint iw, qd_real gl, qd_real gu, qd_real * d, qd_real * e2, qd_real pivmin, qd_real reltol, qd_real * w, qd_real * werr, mpackint *info );
void Rlarrr ( mpackint n, qd_real * d, qd_real * e, mpackint *info );
void Rlartv ( mpackint n, qd_real * x, mpackint incx, qd_real * y, mpackint incy, qd_real * c, qd_real * s, mpackint incc );
void Clartv ( mpackint n, qd_complex * x, mpackint incx, qd_complex * y, mpackint incy, qd_real * c, qd_complex * s, mpackint incc );
void Rlarrv ( mpackint n, qd_real vl, qd_real vu, qd_real * d, qd_real * l, qd_real pivmin, mpackint * isplit, mpackint m, mpackint dol, mpackint dou, qd_real minrgp, qd_real rtol1, qd_real rtol2, qd_real * w, qd_real * werr, qd_real * wgap, mpackint * iblock, mpackint * indexw, qd_real * gers, qd_real * z, mpackint ldz, mpackint * isuppz, qd_real * work, mpackint * iwork, mpackint * info );
void Clarrv ( mpackint n, qd_real vl, qd_real vu, qd_real * d, qd_real * l, qd_real pivmin, mpackint *isplit, mpackint m, mpackint dol, mpackint dou, qd_real minrgp, qd_real rtol1, qd_real rtol2, qd_real * w, qd_real * werr, qd_real * wgap, mpackint *iblock, mpackint *indexw, qd_real * gers, qd_complex * z, mpackint ldz, mpackint *isuppz, qd_real * work, mpackint *iwork, mpackint *info );
void Rlaruv ( mpackint *iseed, mpackint n, qd_real * x );
void Rlarz ( const char *side, mpackint m, mpackint n, mpackint l, qd_real * v, mpackint incv, qd_real tau, qd_real * C, mpackint ldc, qd_real * work );
void Clarz ( const char *side, mpackint m, mpackint n, mpackint l, qd_complex * v, mpackint incv, qd_complex tau, qd_complex * c, mpackint ldc, qd_complex * work );
void Rlarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, qd_real * v, mpackint ldv, qd_real * t, mpackint ldt, qd_real * c, mpackint ldc, qd_real * work, mpackint ldwork );
void Clarzb ( const char *side, const char *trans, const char *direct, const char *storev, mpackint m, mpackint n, mpackint k, mpackint l, qd_complex * v, mpackint ldv, qd_complex * t, mpackint ldt, qd_complex * c, mpackint ldc, qd_complex * work, mpackint ldwork );
void Rlarzt ( const char *direct, const char *storev, mpackint n, mpackint k, qd_real * v, mpackint ldv, qd_real * tau, qd_real * t, mpackint ldt );
void Clarzt ( const char *direct, const char *storev, mpackint n, mpackint k, qd_complex * v, mpackint ldv, qd_complex * tau, qd_complex * t, mpackint ldt );
void Rlas2 ( qd_real f, qd_real g, qd_real h, qd_real * ssmin, qd_real * ssmax );
void Rlasd0 ( mpackint n, mpackint sqre, qd_real * d, qd_real * e, qd_real * u, mpackint ldu, qd_real * vt, mpackint ldvt, mpackint smlsiz, mpackint *iwork, qd_real * work, mpackint *info );
void Rlasd1 ( mpackint nl, mpackint nr, mpackint *sqre, qd_real * d, qd_real * alpha, qd_real * beta, qd_real * u, mpackint ldu, qd_real * vt, mpackint ldvt, mpackint *idxq, mpackint *iwork, qd_real * work, mpackint *info );
void Rlasd2 ( mpackint nl, mpackint nr, mpackint sqre, mpackint *k, qd_real * d, qd_real * z, qd_real alpha, qd_real beta, qd_real * u, mpackint ldu, qd_real * vt, mpackint ldvt, qd_real * dsigma, qd_real * u2, mpackint ldu2, qd_real * vt2, mpackint ldvt2, mpackint *idxp, mpackint *idx, mpackint *idxc, mpackint *idxq, mpackint *coltyp, mpackint *info );
void Rlasd3 ( mpackint nl, mpackint nr, mpackint sqre, mpackint k, qd_real * d, qd_real * q, mpackint ldq, qd_real * dsigma, qd_real * u, mpackint ldu, qd_real * u2, mpackint ldu2, qd_real * vt, mpackint ldvt, qd_real * vt2, mpackint ldvt2, mpackint *idxc, mpackint *ctot, qd_real * z, mpackint *info );
void Rlasd4 ( mpackint n, mpackint i, qd_real * d, qd_real * z, qd_real * delta, qd_real rho, qd_real * sigma, qd_real * work, mpackint *info );
void Rlasd5 ( mpackint i, qd_real * d, qd_real * z, qd_real * delta, qd_real rho, qd_real * dsigma, qd_real * work );
void Rlasd6 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, qd_real * d, qd_real * vf, qd_real * vl, qd_real * alpha, qd_real * beta, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, qd_real * givnum, mpackint ldgnum, qd_real * poles, qd_real * difl, qd_real * difr, qd_real * z, mpackint k, qd_real * c, qd_real * s, qd_real * work, mpackint *iwork, mpackint *info );
void Rlasd7 ( mpackint icompq, mpackint nl, mpackint nr, mpackint sqre, mpackint k, qd_real * d, qd_real * z, qd_real * zw, qd_real * vf, qd_real * vfw, qd_real * vl, qd_real * vlw, qd_real alpha, qd_real beta, qd_real * dsigma, mpackint *idx, mpackint *idxp, mpackint *idxq, mpackint *perm, mpackint *givptr, mpackint *givcol, mpackint ldgcol, qd_real * givnum, mpackint ldgnum, qd_real * c, qd_real * s, mpackint *info );
void Rlasd8 ( mpackint icompq, mpackint k, qd_real * d, qd_real * z, qd_real * vf, qd_real * vl, qd_real * difl, qd_real * difr, mpackint lddifr, qd_real * dsigma, qd_real * work, mpackint *info );
void Rlasda ( mpackint icompq, mpackint smlsiz, mpackint n, mpackint sqre, qd_real * d, qd_real * e, qd_real * u, mpackint ldu, qd_real * vt, mpackint *k, qd_real * difl, qd_real * difr, qd_real * z, qd_real * poles, mpackint *givptr, mpackint *givcol, mpackint ldgcol, mpackint *perm, qd_real * givnum, qd_real * c, qd_real * s, qd_real * work, mpackint *iwork, mpackint *info );
void Rlasdq ( const char *uplo, mpackint sqre, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, qd_real * d, qd_real * e, qd_real * vt, mpackint ldvt, qd_real * u, mpackint ldu, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Rlasdt ( mpackint n, mpackint lvl, mpackint nd, mpackint *inode, mpackint *ndiml, mpackint *ndimr, mpackint msub );
void Rlasq1 ( mpackint n, qd_real * d, qd_real * e, qd_real * work, mpackint *info );
void Rlasq2 ( mpackint n, qd_real * z, mpackint *info );
void Rlasq3 ( mpackint i0, mpackint n0, qd_real * z, mpackint pp, qd_real * dmin, qd_real * sigma, qd_real * desig, qd_real qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint ieee );
void Rlasq4 ( mpackint i0, mpackint n0, qd_real * z, mpackint pp, mpackint n0in, qd_real dmin, qd_real dmin1, qd_real dmin2, qd_real dn, qd_real dn1, qd_real dn2, qd_real * tau, mpackint *ttype );
void Rlasq5 ( mpackint i0, mpackint n0, qd_real * z, mpackint pp, qd_real tau, qd_real * dmin, qd_real * dmin1, qd_real * dmin2, qd_real * dn, qd_real * dnm1, qd_real * dnm2, mpackint ieee );
void Rlasq6 ( mpackint i0, mpackint n0, qd_real * z, mpackint pp, qd_real * dmin, qd_real * dmin1, qd_real * dmin2, qd_real * dn, qd_real * dnm1, qd_real * dnm2 );
void Rlasv2 ( qd_real f, qd_real g, qd_real h, qd_real * ssmin, qd_real * ssmax, qd_real * snr, qd_real * csr, qd_real * snl, qd_real * csl );
void Rlasy2 ( mpackint ltranl, mpackint ltranr, mpackint isgn, mpackint n1, mpackint n2, qd_real * tl, mpackint ldtl, qd_real * tr, mpackint ldtr, qd_real * B, mpackint ldb, qd_real * scale, qd_real * x, mpackint ldx, qd_real * xnorm, mpackint *info );
void Rlatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, qd_real * x, qd_real * scale, qd_real * cnorm, mpackint *info );
void Clatbs ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_complex * x, qd_real * scale, qd_real * cnorm, mpackint *info );
void Rlatdf ( mpackint ijob, mpackint n, qd_real * z, mpackint ldz, qd_real * rhs, qd_real * rdsum, qd_real * rdscal, mpackint *ipiv, mpackint *jpiv );
void Clatdf ( mpackint ijob, mpackint n, qd_complex * z, mpackint ldz, qd_complex * rhs, qd_real * rdsum, qd_real * rdscal, mpackint *ipiv, mpackint *jpiv );
void Rlatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, qd_real * ap, qd_real * x, qd_real * scale, qd_real * cnorm, mpackint *info );
void Clatps ( const char *uplo, const char *trans, const char *diag, const char *normin, mpackint n, qd_complex * ap, qd_complex * x, qd_real * scale, qd_real * cnorm, mpackint *info );
void Rlauu2 ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Clauu2 ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rlauum ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Clauum ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rlatrz ( mpackint m, mpackint n, mpackint l, qd_real * A, mpackint lda, qd_real * tau, qd_real * work );
void Clatrz ( mpackint m, mpackint n, mpackint l, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work );
void Rorgl2 ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cungl2 ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rorgr2 ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint *info );
void Cungr2 ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint *info );
void Rorm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Cunm2l ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint *info );
void Rorm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Cunm2r ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint *info );
void Rorml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Cunml2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint *info );
void Rormr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * C, mpackint ldc, qd_real * work, mpackint *info );
void Cunmr2 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint *info );
void Rormr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Cunmr3 ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint *info );
void Rpbtf2 ( const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, mpackint *info );
void Cpbtf2 ( const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, mpackint *info );
void Rptts2 ( mpackint n, mpackint nrhs, qd_real * d, qd_real * e, qd_real * b, mpackint ldb );
void Cptts2 ( mpackint iuplo, mpackint n, mpackint nrhs, qd_real * d, qd_complex * e, qd_complex * B, mpackint ldb );
void Rrscl ( mpackint n, qd_real sa, qd_real * sx, mpackint incx );
void CRrscl ( mpackint n, qd_real sa, qd_complex * sx, mpackint incx );
void Rsygs2 ( mpackint itype, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *info );
void Chegs2 ( mpackint itype, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint *info );
void Rsytf2 ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Csytf2 ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Chetf2 ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, mpackint *info );
void Rtgex2 ( mpackint wantq, mpackint wantz, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * q, mpackint ldq, qd_real * z, mpackint ldz, mpackint j1, mpackint n1, mpackint n2, qd_real * work, mpackint lwork, mpackint *info );
void Ctgex2 ( mpackint wantq, mpackint wantz, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * q, mpackint ldq, qd_complex * z, mpackint ldz, mpackint j1, mpackint *info );
void Rtgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * c, mpackint ldc, qd_real * d, mpackint ldd, qd_real * e, mpackint lde, qd_real * f, mpackint ldf, qd_real * scale, qd_real * rdsum, qd_real * rdscal, mpackint *iwork, mpackint *pq, mpackint *info );
void Ctgsy2 ( const char *trans, mpackint ijob, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * C, mpackint ldc, qd_complex * d, mpackint ldd, qd_complex * e, mpackint lde, qd_complex * f, mpackint ldf, qd_real * scale, qd_real * rdsum, qd_real * rdscal, mpackint *info );
void Rlazq3 ( mpackint i0, mpackint n0, qd_real * z, mpackint pp, qd_real * dmin, qd_real * sigma, qd_real * desig, qd_real qmax, mpackint *nfail, mpackint *iter, mpackint *ndiv, mpackint *ieee, mpackint *ttype, qd_real * dmin1, qd_real * dmin2, qd_real * dn, qd_real * dn1, qd_real * dn2, qd_real * tau );
void Rlazq4 ( mpackint i0, mpackint n0, qd_real * z, mpackint pp, mpackint n0in, qd_real dmin, qd_real dmin1, qd_real dmin2, qd_real dn, qd_real dn1, qd_real dn2, qd_real * tau, mpackint *ttype, qd_real * g );
void Rlaqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, qd_real * h, mpackint ldh, qd_real * wr, qd_real * wi, mpackint iloz, mpackint ihiz, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *info );
void Claqr0 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, qd_complex * h, mpackint ldh, qd_complex * w, mpackint *iloz, mpackint *ihiz, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, mpackint *info );
void Rlaqr1 ( mpackint n, qd_real * h, mpackint ldh, qd_real sr1, qd_real si1, qd_real sr2, qd_real si2, qd_real * v );
void Claqr1 ( mpackint n, qd_complex * h, mpackint ldh, qd_complex s1, qd_complex s2, qd_complex * v );
void Rlaqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, qd_real * h, mpackint ldh, mpackint iloz, mpackint ihiz, qd_real * z, mpackint ldz, mpackint *ns, mpackint *nd, qd_real * sr, qd_real * si, qd_real * v, mpackint ldv, mpackint nh, qd_real * t, mpackint ldt, mpackint nv, qd_real * wv, mpackint ldwv, qd_real * work, mpackint lwork );
void Claqr2 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, qd_complex * h, mpackint ldh, mpackint iloz, mpackint ihiz, qd_complex * z, mpackint ldz, mpackint *ns, mpackint *nd, qd_complex * sh, qd_complex * v, mpackint ldv, mpackint nh, qd_complex * t, mpackint ldt, mpackint nv, qd_complex * wv, mpackint ldwv, qd_complex * work, mpackint lwork );
void Rlaqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, qd_real * h, mpackint ldh, mpackint iloz, mpackint ihiz, qd_real * z, mpackint ldz, mpackint ns, mpackint nd, qd_real * sr, qd_real * si, qd_real * v, mpackint ldv, mpackint nh, qd_real * t, mpackint ldt, mpackint nv, qd_real * wv, mpackint ldwv, qd_real * work, mpackint lwork );
void Claqr3 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ktop, mpackint kbot, mpackint nw, qd_complex * h, mpackint ldh, mpackint iloz, mpackint ihiz, qd_complex * z, mpackint ldz, mpackint *ns, mpackint *nd, qd_complex * sh, qd_complex * v, mpackint ldv, mpackint nh, qd_complex * t, mpackint ldt, mpackint nv, qd_complex * wv, mpackint ldwv, qd_complex * work, mpackint lwork );
void Rlaqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, qd_real * h, mpackint ldh, qd_real * wr, qd_real * wi, mpackint iloz, mpackint ihiz, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *info );
void Claqr4 ( mpacklogical wantt, mpacklogical wantz, mpackint n, mpackint ilo, mpackint ihi, qd_complex * h, mpackint ldh, qd_complex * w, mpackint iloz, mpackint ihiz, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, mpackint *info );
void Rlaqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kac22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, qd_real * sr, qd_real * si, qd_real * h, mpackint ldh, mpackint iloz, mpackint ihiz, qd_real * z, mpackint ldz, qd_real * v, mpackint ldv, qd_real * u, mpackint ldu, mpackint nv, qd_real * wv, mpackint ldwv, mpackint nh, qd_real * wh, mpackint ldwh );
void Claqr5 ( mpacklogical wantt, mpacklogical wantz, mpackint kacc22, mpackint n, mpackint ktop, mpackint kbot, mpackint nshfts, qd_complex * s, qd_complex * h, mpackint ldh, mpackint iloz, mpackint ihiz, qd_complex * z, mpackint ldz, qd_complex * v, mpackint ldv, qd_complex * u, mpackint ldu, mpackint nv, qd_complex * wv, mpackint ldwv, mpackint nh, qd_complex * wh, mpackint ldwh );
void Rlatzm ( const char *side, mpackint m, mpackint n, qd_real * v, mpackint incv, qd_real * tau, qd_real *c1, qd_real * c2, mpackint ldc, qd_real * work );
void Clatzm ( const char *side, mpackint m, mpackint n, qd_complex * v, mpackint incv, qd_complex * tau, qd_complex * c1, qd_complex * c2, mpackint ldc, qd_complex * work );
void Clacp2 ( const char *uplo, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_complex * B, mpackint ldb );
mpackint Risnan ( qd_real din );

/* not yet done ... driver and computational routines */
void Rbdsdc ( const char *uplo, const char *compq, mpackint n, qd_real * d, qd_real * e, qd_real * u, mpackint ldu, qd_real * vt, mpackint ldvt, qd_real * q, mpackint * iq, qd_real * work, mpackint * iwork, mpackint * info );
void Rbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, qd_real * d, qd_real * e, qd_real * vt, mpackint ldvt, qd_real * u, mpackint ldu, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Cbdsqr ( const char *uplo, mpackint n, mpackint ncvt, mpackint nru, mpackint ncc, qd_real * d, qd_real * e, qd_complex * vt, mpackint ldvt, qd_complex * u, mpackint ldu, qd_complex * c, mpackint ldc, qd_real * rwork, mpackint * info );
void Rdisna ( const char *job, mpackint m, mpackint n, qd_real * d, qd_real * sep, mpackint *info );
void Rgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, qd_real * AB, mpackint ldab, qd_real * d, qd_real * e, qd_real * q, mpackint ldq, qd_real * pt, mpackint ldpt, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Cgbbrd ( const char *vect, mpackint m, mpackint n, mpackint ncc, mpackint kl, mpackint ku, qd_complex * AB, mpackint ldab, qd_real * d, qd_real * e, qd_complex * q, mpackint ldq, qd_complex * pt, mpackint ldpt, qd_complex * c, mpackint ldc, qd_complex * work, qd_real * rwork, mpackint * info );
void Rgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, qd_real * AB, mpackint ldab, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Cgbcon ( const char *norm, mpackint n, mpackint kl, mpackint ku, qd_complex * AB, mpackint ldab, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_real * AB, mpackint ldab, qd_real * r, qd_real * c, qd_real * rowcnd, qd_real * colcnd, qd_real * amax, mpackint *info );
void Cgbequ ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_complex * AB, mpackint ldab, qd_real * r, qd_real * c, qd_real * rowcnd, qd_real * colcnd, qd_real * amax, mpackint *info );
void Rgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_real * AB, mpackint ldab, qd_real * afb, mpackint ldafb, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cgbrfs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_complex * AB, mpackint ldab, qd_complex * afb, mpackint ldafb, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_real * AB, mpackint ldab, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Cgbsv ( mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_complex * ab, mpackint ldab, mpackint *ipiv, qd_complex * b, mpackint ldb, mpackint *info );
void Rgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_real * AB, mpackint ldab, qd_real * afb, mpackint ldafb, mpackint * ipiv, char *equed, qd_real * r, qd_real * c, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint * iwork, mpackint * info );
void Cgbsvx ( const char *fact, const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_complex * AB, mpackint ldab, qd_complex * afb, mpackint ldafb, mpackint * ipiv, char *equed, qd_real * r, qd_real * c, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint * info );
void Rgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_real * AB, mpackint ldab, mpackint *ipiv, mpackint *info );
void Cgbtrf ( mpackint m, mpackint n, mpackint kl, mpackint ku, qd_complex * ab, mpackint ldab, mpackint *ipiv, mpackint *info );
void Rgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_real * AB, mpackint ldab, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Cgbtrs ( const char *trans, mpackint n, mpackint kl, mpackint ku, mpackint nrhs, qd_complex * AB, mpackint ldab, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Rgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, qd_real * scale, mpackint m, qd_real * v, mpackint ldv, mpackint *info );
void Cgebak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, qd_real * scale, mpackint m, qd_complex * v, mpackint ldv, mpackint *info );
void Rgebal ( const char *job, mpackint n, qd_real * A, mpackint lda, mpackint *ilo, mpackint *ihi, qd_real * scale, mpackint *info );
void Cgebal ( const char *job, mpackint n, qd_complex * A, mpackint lda, mpackint *ilo, mpackint *ihi, qd_real * scale, mpackint *info );
void Rgebrd ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * d, qd_real * e, qd_real * tauq, qd_real * taup, qd_real * work, mpackint lwork, mpackint *info );
void Cgebrd ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * d, qd_real * e, qd_complex * tauq, qd_complex * taup, qd_complex * work, mpackint lwork, mpackint *info );
void Rgecon ( const char *norm, mpackint n, qd_real * A, mpackint lda, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Cgecon ( const char *norm, mpackint n, qd_complex * A, mpackint lda, qd_real anorm, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgeequ ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * r, qd_real * c, qd_real * rowcnd, qd_real * colcnd, qd_real * amax, mpackint *info );
void Cgeequ ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * r, qd_real * c, qd_real * rowcnd, qd_real * colcnd, qd_real * amax, mpackint *info );
void Rgees ( const char *jobvs, const char *sort, LFP select, mpackint n, qd_real * A, mpackint lda, mpackint *sdim, qd_real * wr, qd_real * wi, qd_real * vs, mpackint ldvs, qd_real * work, mpackint lwork, mpacklogical * bwork, mpackint *info );
void Cgees ( const char *jobvs, const char *sort, LFP select, mpackint n, qd_complex * A, mpackint lda, mpackint *sdim, qd_complex * w, qd_complex * vs, mpackint ldvs, qd_complex * work, mpackint lwork, qd_real * rwork, mpacklogical * bwork, mpackint *info );
void Rgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, qd_real * A, mpackint lda, mpackint * sdim, qd_real * wr, qd_real * wi, qd_real * vs, mpackint ldvs, qd_real * rconde, qd_real * rcondv, qd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cgeesx ( const char *jobvs, const char *sort, LFP select, const char *sense, mpackint n, qd_complex * A, mpackint lda, mpackint *sdim, qd_complex * w, qd_complex * vs, mpackint ldvs, qd_real * rconde, qd_real * rcondv, qd_complex * work, mpackint lwork, qd_real * rwork, mpacklogical * bwork, mpackint *info );
void Rgeev ( const char *jobvl, const char *jobvr, mpackint n, qd_real * A, mpackint lda, qd_real * wr, qd_real * wi, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, qd_real * work, mpackint lwork, mpackint *info );
void Cgeev ( const char *jobvl, const char *jobvr, mpackint n, qd_complex * A, mpackint lda, qd_complex * w, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Rgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, qd_real * A, mpackint lda, qd_real * wr, qd_real * wi, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, qd_real * scale, qd_real * abnrm, qd_real * rconde, qd_real * rcondv, qd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgeevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, qd_complex * A, mpackint lda, qd_complex * w, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, qd_real * scale, qd_real * abnrm, qd_real * rconde, qd_real * rcondv, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Cgehrd ( mpackint n, mpackint ilo, mpackint ihi, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rgehrd ( mpackint n, mpackint ilo, mpackint ihi, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Rgelqf ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cgelqf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * work, mpackint lwork, mpackint *info );
void Cgels ( const char *trans, mpackint m, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * work, mpackint lwork, mpackint *info );
void Rgelsx ( mpackint m, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *jpvt, qd_real rcond, mpackint *rank, qd_real * work, mpackint *info );
void Cgelsx ( mpackint m, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint *jpvt, qd_real rcond, mpackint *rank, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgelsd ( mpackint m, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * s, qd_real * rcond, mpackint *rank, qd_real * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Cgelsd ( mpackint m, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real * s, qd_real rcond, mpackint * rank, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * iwork, mpackint * info );
void Rgelss ( mpackint m, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * s, qd_real rcond, mpackint * rank, qd_real * work, mpackint lwork, mpackint * info );
void Cgelss ( mpackint m, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real * s, qd_real rcond, mpackint * rank, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Rgelsy ( mpackint m, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *jpvt, qd_real rcond, mpackint *rank, qd_real * work, mpackint lwork, mpackint *info );
void Cgelsy ( mpackint m, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint * jpvt, qd_real rcond, mpackint * rank, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Rgeqlf ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cgeqlf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rgeqpf ( mpackint m, mpackint n, qd_real * A, mpackint lda, mpackint *jpvt, qd_real * tau, qd_real * work, mpackint *info );
void Cgeqpf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, mpackint *jpvt, qd_complex * tau, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgeqp3 ( mpackint m, mpackint n, qd_real * A, mpackint lda, mpackint *jpvt, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cgeqp3 ( mpackint m, mpackint n, qd_complex * A, mpackint lda, mpackint *jpvt, qd_complex * tau, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *info );
void Rgeqrf ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cgeqrf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rgerfs ( const char *trans, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * af, mpackint ldaf, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cgerfs ( const char *trans, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgerqf ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cgerqf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rgesdd ( const char *jobz, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * s, qd_real * u, mpackint ldu, qd_real * vt, mpackint ldvt, qd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Cgesdd ( const char *jobz, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * s, qd_complex * u, mpackint ldu, qd_complex * vt, mpackint ldvt, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * iwork, mpackint * info );
void Rgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * s, qd_real * u, mpackint ldu, qd_real * vt, mpackint ldvt, qd_real * work, mpackint lwork, mpackint * info );
void Cgesvd ( const char *jobu, const char *jobvt, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_real * s, qd_complex * u, mpackint ldu, qd_complex * vt, mpackint ldvt, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Rgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * af, mpackint ldaf, mpackint * ipiv, char *equed, qd_real * r, qd_real * c, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint * iwork, mpackint * info );
void Cgesvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, mpackint * ipiv, char *equed, qd_real * r, qd_real * c, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint * info );
void Rggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, qd_real * lscale, qd_real * rscale, mpackint m, qd_real * v, mpackint ldv, mpackint *info );
void Cggbak ( const char *job, const char *side, mpackint n, mpackint ilo, mpackint ihi, qd_real * lscale, qd_real * rscale, mpackint m, qd_complex * v, mpackint ldv, mpackint *info );
void Rggbal ( const char *job, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *ilo, mpackint *ihi, qd_real * lscale, qd_real * rscale, qd_real * work, mpackint *info );
void Cggbal ( const char *job, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint *ilo, mpackint *ihi, qd_real * lscale, qd_real * rscale, qd_real * work, mpackint *info );
void Rgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint * sdim, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * vsl, mpackint ldvsl, qd_real * vsr, mpackint ldvsr, qd_real * work, mpackint lwork, mpacklogical * bwork, mpackint * info );
void Cgges ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint * sdim, qd_complex * alpha, qd_complex * beta, qd_complex * vsl, mpackint ldvsl, qd_complex * vsr, mpackint ldvsr, qd_complex * work, mpackint lwork, qd_real * rwork, mpacklogical * bwork, mpackint * info );
void Rgegs ( const char *jobvsl, const char *jobvsr, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * vsl, mpackint ldvsl, qd_real * vsr, mpackint ldvsr, qd_real * work, mpackint lwork, mpackint *info );
void Cgegs ( const char *jobvsl, const char *jobvsr, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * alpha, qd_complex * beta, qd_complex * vsl, mpackint ldvsl, qd_complex * vsr, mpackint ldvsr, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Rggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint * sdim, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * vsl, mpackint ldvsl, qd_real * vsr, mpackint ldvsr, qd_real * rconde, qd_real * rcondv, qd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Cggesx ( const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint * sdim, qd_complex * alpha, qd_complex * beta, qd_complex * vsl, mpackint ldvsl, qd_complex * vsr, mpackint ldvsr, qd_real * rconde, qd_real * rcondv, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * iwork, mpackint liwork, mpacklogical * bwork, mpackint * info );
void Rggev ( const char *jobvl, const char *jobvr, mpackint n, qd_real * A, mpackint lda, qd_real * b, mpackint ldb, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, qd_real * work, mpackint lwork, mpackint * info );
void Cggev ( const char *jobvl, const char *jobvr, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * alpha, qd_complex * beta, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Rgegv ( const char *jobvl, const char *jobvr, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, qd_real * work, mpackint lwork, mpackint * info );
void Cgegv ( const char *jobvl, const char *jobvr, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * alpha, qd_complex * beta, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * info );
void Rggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, qd_real * lscale, qd_real * rscale, qd_real * abnrm, qd_real * bbnrm, qd_real * rconde, qd_real * rcondv, qd_real * work, mpackint lwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Cggevx ( const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * alpha, qd_complex * beta, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, mpackint * ilo, mpackint * ihi, qd_real * lscale, qd_real * rscale, qd_real * abnrm, qd_real * bbnrm, qd_real * rconde, qd_real * rcondv, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint * iwork, mpacklogical * bwork, mpackint * info );
void Rggglm ( mpackint n, mpackint m, mpackint p, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * d, qd_real * x, qd_real * y, qd_real * work, mpackint lwork, mpackint *info );
void Cggglm ( mpackint n, mpackint m, mpackint p, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * d, qd_complex * x, qd_complex * y, qd_complex * work, mpackint lwork, mpackint *info );
void Rgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * q, mpackint ldq, qd_real * z, mpackint ldz, mpackint *info );
void Cgghrd ( const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * q, mpackint ldq, qd_complex * z, mpackint ldz, mpackint *info );
void Rgglse ( mpackint m, mpackint n, mpackint p, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * c, qd_real * d, qd_real * x, qd_real * work, mpackint lwork, mpackint *info );
void Cgglse ( mpackint m, mpackint n, mpackint p, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * c, qd_complex * d, qd_complex * x, qd_complex * work, mpackint lwork, mpackint *info );
void Rggqrf ( mpackint n, mpackint m, mpackint p, qd_real * A, mpackint lda, qd_real * taua, qd_real * B, mpackint ldb, qd_real * taub, qd_real * work, mpackint lwork, mpackint *info );
void Cggqrf ( mpackint n, mpackint m, mpackint p, qd_complex * A, mpackint lda, qd_complex * taua, qd_complex * B, mpackint ldb, qd_complex * taub, qd_complex * work, mpackint lwork, mpackint *info );
void Rggrqf ( mpackint m, mpackint p, mpackint n, qd_real * A, mpackint lda, qd_real * taua, qd_real * B, mpackint ldb, qd_real * taub, qd_real * work, mpackint lwork, mpackint *info );
void Cggrqf ( mpackint m, mpackint p, mpackint n, qd_complex * A, mpackint lda, qd_complex * taua, qd_complex * B, mpackint ldb, qd_complex * taub, qd_complex * work, mpackint lwork, mpackint *info );
void Rggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * alpha, qd_real * beta, qd_real * u, mpackint ldu, qd_real * v, mpackint ldv, qd_real * q, mpackint ldq, qd_real * work, mpackint *iwork, mpackint *info );
void Cggsvd ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint n, mpackint p, mpackint *k, mpackint *l, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real * alpha, qd_real * beta, qd_complex * u, mpackint ldu, qd_complex * v, mpackint ldv, qd_complex * q, mpackint ldq, qd_complex * work, qd_real * rwork, mpackint *iwork, mpackint *info );
void Rggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real tola, qd_real tolb, mpackint *k, mpackint *l, qd_real * u, mpackint ldu, qd_real * v, mpackint ldv, qd_real * q, mpackint ldq, mpackint *iwork, qd_real * tau, qd_real * work, mpackint *info );
void Cggsvp ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real tola, qd_real tolb, mpackint *k, mpackint *l, qd_complex * u, mpackint ldu, qd_complex * v, mpackint ldv, qd_complex * q, mpackint ldq, mpackint *iwork, qd_real * rwork, qd_complex * tau, qd_complex * work, mpackint *info );
void Rgtcon ( const char *norm, mpackint n, qd_real * dl, qd_real * d, qd_real * du, qd_real * du2, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Cgtcon ( const char *norm, mpackint n, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * du2, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_complex * work, mpackint *info );
void Rgtrfs ( const char *trans, mpackint n, mpackint nrhs, qd_real * dl, qd_real * d, qd_real * du, qd_real * dlf, qd_real * df, qd_real * duf, qd_real * du2, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cgtrfs ( const char *trans, mpackint n, mpackint nrhs, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * dlf, qd_complex * df, qd_complex * duf, qd_complex * du2, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgtsv ( mpackint n, mpackint nrhs, qd_real * dl, qd_real * d, qd_real * du, qd_real * B, mpackint ldb, mpackint *info );
void Cgtsv ( mpackint n, mpackint nrhs, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * B, mpackint ldb, mpackint *info );
void Rgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, qd_real * dl, qd_real * d, qd_real * du, qd_real * dlf, qd_real * df, qd_real * duf, qd_real * du2, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cgtsvx ( const char *fact, const char *trans, mpackint n, mpackint nrhs, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * dlf, qd_complex * df, qd_complex * duf, qd_complex * du2, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rgttrf ( mpackint n, qd_real * dl, qd_real * d, qd_real * du, qd_real * du2, mpackint *ipiv, mpackint *info );
void Cgttrf ( mpackint n, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * du2, mpackint *ipiv, mpackint *info );
void Rgttrs ( const char *trans, mpackint n, mpackint nrhs, qd_real * dl, qd_real * d, qd_real * du, qd_real * du2, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Cgttrs ( const char *trans, mpackint n, mpackint nrhs, qd_complex * dl, qd_complex * d, qd_complex * du, qd_complex * du2, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Rhgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, qd_real * h, mpackint ldh, qd_real * t, mpackint ldt, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * q, mpackint ldq, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *info );
void Chgeqz ( const char *job, const char *compq, const char *compz, mpackint n, mpackint ilo, mpackint ihi, qd_complex * h, mpackint ldh, qd_complex * t, mpackint ldt, qd_complex * alpha, qd_complex * beta, qd_complex * q, mpackint ldq, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *info );
void Rhsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical *select, mpackint n, qd_real * h, mpackint ldh, qd_real * wr, qd_real * wi, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, mpackint mm, mpackint m, qd_real * work, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Chsein ( const char *side, const char *eigsrc, const char *initv, mpacklogical * select, mpackint n, qd_complex * h, mpackint ldh, qd_complex * w, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, mpackint mm, mpackint *m, qd_complex * work, qd_real * rwork, mpackint *ifaill, mpackint *ifailr, mpackint *info );
void Rhseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, qd_real * h, mpackint ldh, qd_real * wr, qd_real * wi, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *info );
void Chseqr ( const char *job, const char *compz, mpackint n, mpackint ilo, mpackint ihi, qd_complex * h, mpackint ldh, qd_complex * w, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, mpackint *info );
void Ropgtr ( const char *uplo, mpackint n, qd_real * ap, qd_real * tau, qd_real * q, mpackint ldq, qd_real * work, mpackint *info );
void Cupgtr ( const char *uplo, mpackint n, qd_complex * ap, qd_complex * tau, qd_complex * q, mpackint ldq, qd_complex * work, mpackint *info );
void Ropmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, qd_real * ap, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint *info );
void Cupmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, qd_complex * ap, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint *info );
void Rorgbr ( const char *vect, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cungbr ( const char *vect, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rorghr ( mpackint n, mpackint ilo, mpackint ihi, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cunghr ( mpackint n, mpackint ilo, mpackint ihi, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rorglq ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cunglq ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rorgrq ( mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Cungrq ( mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rormbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmbr ( const char *vect, const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rormhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmhr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint ilo, mpackint ihi, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rormlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmlq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rormql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmql ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rormqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmqr ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rormrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmrq ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rormrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmrz ( const char *side, const char *trans, mpackint m, mpackint n, mpackint k, mpackint l, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rormtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * c, mpackint ldc, qd_real * work, mpackint lwork, mpackint *info );
void Cunmtr ( const char *side, const char *uplo, const char *trans, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * c, mpackint ldc, qd_complex * work, mpackint lwork, mpackint *info );
void Rpbcon ( const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Cpbcon ( const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_real anorm, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rpbequ ( const char *uplo, mpackint n, mpackint kd, qd_real * ab, mpackint ldab, qd_real * s, qd_real * scond, qd_real * amax, mpackint *info );
void Cpbequ ( const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_real * s, qd_real * scond, qd_real * amax, mpackint *info );
void Rpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_real * AB, mpackint ldab, qd_real * afb, mpackint ldafb, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cpbrfs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_complex * AB, mpackint ldab, qd_complex * afb, mpackint ldafb, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rpbstf ( const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, mpackint *info );
void Cpbstf ( const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, mpackint *info );
void Rpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_real * AB, mpackint ldab, qd_real * B, mpackint ldb, mpackint *info );
void Cpbsv ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_complex * ab, mpackint ldab, qd_complex * B, mpackint ldb, mpackint *info );
void Rpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_real * AB, mpackint ldab, qd_real * afb, mpackint ldafb, char *equed, qd_real * s, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint * iwork, mpackint * info );
void Cpbsvx ( const char *fact, const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_complex * AB, mpackint ldab, qd_complex * afb, mpackint ldafb, char *equed, qd_real * s, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint * info );
void Rpbtrf ( const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, mpackint *info );
void Cpbtrf ( const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, mpackint *info );
void Rpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_real * ab, mpackint ldab, qd_real * B, mpackint ldb, mpackint *info );
void Cpbtrs ( const char *uplo, mpackint n, mpackint kd, mpackint nrhs, qd_complex * AB, mpackint ldab, qd_complex * B, mpackint ldb, mpackint *info );
void Rpocon ( const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Cpocon ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real anorm, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rpoequ ( mpackint n, qd_real * A, mpackint lda, qd_real * s, qd_real * scond, qd_real * amax, mpackint *info );
void Cpoequ ( mpackint n, qd_complex * A, mpackint lda, qd_real * s, qd_real * scond, qd_real * amax, mpackint *info );
void Rporfs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * af, mpackint ldaf, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cporfs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rposv ( const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *info );
void Cposv ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint *info );
void Rposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * af, mpackint ldaf, char *equed, qd_real * s, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint * iwork, mpackint * info );
void Cposvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, char *equed, qd_real * s, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint * info );
void Rpotri ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *info );
void Cpotri ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *info );
void Rpotrs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *info );
void Cpotrs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint *info );
void Rppcon ( const char *uplo, mpackint n, qd_real * ap, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Cppcon ( const char *uplo, mpackint n, qd_complex * ap, qd_real * anorm, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rppequ ( const char *uplo, mpackint n, qd_real * ap, qd_real * s, qd_real * scond, qd_real * amax, mpackint *info );
void Cppequ ( const char *uplo, mpackint n, qd_complex * ap, qd_real * s, qd_real * scond, qd_real * amax, mpackint *info );
void Rpptrf ( const char *uplo, mpackint n, qd_real * ap, mpackint *info );
void Cpptrf ( const char *uplo, mpackint n, qd_complex * ap, mpackint *info );
void Rpptri ( const char *uplo, mpackint n, qd_real * ap, mpackint *info );
void Cpptri ( const char *uplo, mpackint n, qd_complex * ap, mpackint *info );
void Rpptrs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, qd_real * B, mpackint ldb, mpackint *info );
void Cpptrs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * B, mpackint ldb, mpackint *info );
void Rpprfs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, qd_real * afp, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cpprfs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * afp, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rppsv ( const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, qd_real * B, mpackint ldb, mpackint *info );
void Cppsv ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * B, mpackint ldb, mpackint *info );
void Rppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, qd_real * afp, char *equed, qd_real * s, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cppsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * afp, char *equed, qd_real * s, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint * info );
void Rptcon ( mpackint n, qd_real * d, qd_real * e, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *info );
void Cptcon ( mpackint n, qd_real * d, qd_complex * e, qd_real anorm, qd_real * rcond, qd_real * rwork, mpackint *info );
void Rpteqr ( const char *compz, mpackint n, qd_real * d, qd_real * e, qd_real * z, mpackint ldz, qd_real * work, mpackint * info );
void Cpteqr ( const char *compz, mpackint n, qd_real * d, qd_real * e, qd_complex * z, mpackint ldz, qd_real * work, mpackint *info );
void Rptrfs ( mpackint n, mpackint nrhs, qd_real * d, qd_real * e, qd_real * df, qd_real * ef, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *info );
void Cptrfs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * d, qd_complex * e, qd_real * df, qd_complex * ef, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rptsv ( mpackint n, mpackint nrhs, qd_real * d, qd_real * e, qd_real * B, mpackint ldb, mpackint *info );
void Cptsv ( mpackint n, mpackint nrhs, qd_real * d, qd_complex * e, qd_complex * B, mpackint ldb, mpackint *info );
void Rptsvx ( const char *fact, mpackint n, mpackint nrhs, qd_real * d, qd_real * e, qd_real * df, qd_real * ef, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *info );
void Cptsvx ( const char *fact, mpackint n, mpackint nrhs, qd_real * d, qd_complex * e, qd_real * df, qd_complex * ef, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rpttrf ( mpackint n, qd_real * d, qd_real * e, mpackint *info );
void Cpttrf ( mpackint n, qd_real * d, qd_complex * e, mpackint *info );
void Rpttrs ( mpackint n, mpackint nrhs, qd_real * d, qd_real * e, qd_real * B, mpackint ldb, mpackint *info );
void Cpttrs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * d, qd_complex * e, qd_complex * B, mpackint ldb, mpackint *info );
void Rsbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *info );
void Chbev ( const char *jobz, const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint *info );
void Rsbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbevd ( const char *jobz, const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, qd_real * q, mpackint ldq, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbevx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_complex * q, mpackint ldq, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint * iwork, mpackint * ifail, mpackint * info );
void Rsbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_real * AB, mpackint ldab, qd_real * bb, mpackint ldbb, qd_real * x, mpackint ldx, qd_real * work, mpackint *info );
void Chbgst ( const char *vect, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_complex * AB, mpackint ldab, qd_complex * bb, mpackint ldbb, qd_complex * x, mpackint ldx, qd_complex * work, qd_real * rwork, mpackint *info );
void Rsbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_real * AB, mpackint ldab, qd_real * bb, mpackint ldbb, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *info );
void Chbgv ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_complex * AB, mpackint ldab, qd_complex * bb, mpackint ldbb, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint *info );
void Rsbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_real * AB, mpackint ldab, qd_real * BB, mpackint ldbb, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chbgvd ( const char *jobz, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_complex * AB, mpackint ldab, qd_complex * BB, mpackint ldbb, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_real * AB, mpackint ldab, qd_real * BB, mpackint ldbb, qd_real * q, mpackint ldq, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chbgvx ( const char *jobz, const char *range, const char *uplo, mpackint n, mpackint ka, mpackint kb, qd_complex * ab, mpackint ldab, qd_complex * bb, mpackint ldbb, qd_complex * q, mpackint ldq, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, qd_real * d, qd_real * e, qd_real * q, mpackint ldq, qd_real * work, mpackint *info );
void Chbtrd ( const char *vect, const char *uplo, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_real * d, qd_real * e, qd_complex * q, mpackint ldq, qd_complex * work, mpackint *info );
void Rspcon ( const char *uplo, mpackint n, qd_real * ap, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Cspcon ( const char *uplo, mpackint n, qd_complex * ap, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_complex * work, mpackint *info );
void Chpcon ( const char *uplo, mpackint n, qd_complex * ap, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_complex * work, mpackint *info );
void Rspev ( const char *jobz, const char *uplo, mpackint n, qd_real * ap, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *info );
void Chpev ( const char *jobz, const char *uplo, mpackint n, qd_complex * ap, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint *info );
void Rspevd ( const char *jobz, const char *uplo, mpackint n, qd_real * ap, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpevd ( const char *jobz, const char *uplo, mpackint n, qd_complex * ap, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspevx ( const char *jobz, const char *range, const char *uplo, mpackint n, qd_real * ap, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpevx ( const char *jobz, const char *range, const char *uplo, mpackint n, qd_complex * ap, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rspgst ( mpackint itype, const char *uplo, mpackint n, qd_real * ap, qd_real * bp, mpackint *info );
void Chpgst ( mpackint *itype, const char *uplo, mpackint n, qd_complex * ap, qd_complex * bp, mpackint *info );
void Rspgv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, qd_real * ap, qd_real * bp, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *info );
void Chpgv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, qd_complex * ap, qd_complex * bp, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint *info );
void Rspgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, qd_real * ap, qd_real * bp, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chpgvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, qd_complex * ap, qd_complex * bp, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rspgvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, qd_real * ap, qd_real * bp, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint m, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chpgvx ( mpackint itype, const char *jobz, char *range, const char *uplo, mpackint n, qd_complex * ap, qd_complex * bp, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, qd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsprfs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, qd_real * afp, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Csprfs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * afp, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Chprfs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * afp, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rspsv ( const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Cspsv ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Chpsv ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Rspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, qd_real * afp, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Cspsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * afp, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Chpsvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * afp, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rsptrd ( const char *uplo, mpackint n, qd_real * ap, qd_real * d, qd_real * e, qd_real * tau, mpackint *info );
void Chptrd ( const char *uplo, mpackint n, qd_complex * ap, qd_real * d, qd_real * e, qd_complex * tau, mpackint *info );
void Rsptrf ( const char *uplo, mpackint n, qd_real * ap, mpackint *ipiv, mpackint *info );
void Csptrf ( const char *uplo, mpackint n, qd_complex * ap, mpackint *ipiv, mpackint *info );
void Chptrf ( const char *uplo, mpackint n, qd_complex * ap, mpackint *ipiv, mpackint *info );
void Rsptri ( const char *uplo, mpackint n, qd_real * ap, mpackint *ipiv, qd_real * work, mpackint *info );
void Csptri ( const char *uplo, mpackint n, qd_complex * ap, mpackint *ipiv, qd_complex * work, mpackint *info );
void Chptri ( const char *uplo, mpackint n, qd_complex * ap, mpackint *ipiv, qd_complex * work, mpackint *info );
void Rsptrs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * ap, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Csptrs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Chptrs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * ap, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Rstebz ( const char *range, const char *order, mpackint n, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, qd_real * d, qd_real * e, mpackint * m, mpackint * nsplit, qd_real * w, mpackint *iblock, mpackint *isplit, qd_real * work, mpackint *iwork, mpackint *info );
void Rstedc ( const char *compz, mpackint n, qd_real * d, qd_real * e, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cstedc ( const char *compz, mpackint n, qd_real * d, qd_real * e, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstegr ( const char *jobz, const char *range, mpackint n, qd_real * d, qd_real * e, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_real * z, mpackint ldz, mpackint * isuppz, qd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstegr ( const char *jobz, const char *range, mpackint n, qd_real *d, qd_real * e, qd_real * vl, qd_real * vu, mpackint *il, mpackint *iu, qd_real * abstol, mpackint m, qd_real * w, qd_complex * z, mpackint ldz, mpackint *isuppz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstein ( mpackint n, qd_real * d, qd_real * e, mpackint m, qd_real * w, mpackint *iblock, mpackint *isplit, qd_real * z, mpackint ldz, qd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cstein ( mpackint n, qd_real * d, qd_real * e, mpackint m, qd_real * w, mpackint *iblock, mpackint *isplit, qd_complex * z, mpackint ldz, qd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstev ( const char *jobz, mpackint n, qd_real * d, qd_real * e, qd_real * z, mpackint ldz, qd_real * work, mpackint *info );
void Rstevd ( const char *jobz, mpackint n, qd_real * d, qd_real * e, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rstevr ( const char *jobz, const char *range, mpackint n, qd_real * d, qd_real * e, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_real * z, mpackint ldz, mpackint * isuppz, qd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rstevx ( const char *jobz, const char *range, mpackint n, qd_real * d, qd_real * e, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rstemr ( const char *jobz, const char *range, mpackint n, qd_real * d, qd_real * e, qd_real vl, qd_real vu, mpackint il, mpackint iu, mpackint * m, qd_real * w, qd_real * z, mpackint ldz, mpackint nzc, mpackint * isuppz, mpacklogical * tryrac, qd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cstemr ( const char *jobz, const char *range, mpackint n, qd_real * d, qd_real * e, qd_real vl, qd_real vu, mpackint il, mpackint iu, mpackint * m, qd_real * w, qd_complex * z, mpackint ldz, mpackint nzc, mpackint *isuppz, mpacklogical * tryrac, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsycon ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Csycon ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_complex * work, mpackint *info );
void Checon ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, qd_real anorm, qd_real * rcond, qd_complex * work, mpackint *info );
void Rsyevd ( const char *jobz, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * w, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Cheevd ( const char *jobz, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real * w, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsyevr ( const char *jobz, const char *range, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_real * z, mpackint ldz, mpackint * isuppz, qd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Cheevr ( const char *jobz, const char *range, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_complex * z, mpackint ldz, mpackint * isuppz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rsyevx ( const char *jobz, const char *range, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Cheevx ( const char *jobz, const char *range, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsygst ( mpackint itype, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, mpackint *info );
void Chegst ( mpackint itype, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, mpackint *info );
void Rsygv ( mpackint itype, const char *jobz, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * w, qd_real * work, mpackint lwork, mpackint *info );
void Chegv ( mpackint *itype, const char *jobz, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real * w, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *info );
void Rsygvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * w, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Chegvd ( mpackint itype, const char *jobz, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real * w, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint lrwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Rsygvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint *m, qd_real * w, qd_real * z, mpackint ldz, qd_real * work, mpackint lwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Chegvx ( mpackint itype, const char *jobz, const char *range, const char *uplo, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real vl, qd_real vu, mpackint il, mpackint iu, qd_real abstol, mpackint * m, qd_real * w, qd_complex * z, mpackint ldz, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *iwork, mpackint *ifail, mpackint *info );
void Rsyrfs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * af, mpackint ldaf, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Csyrfs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Cherfs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rsysv ( const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * work, mpackint lwork, mpackint *info );
void Csysv ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * work, mpackint lwork, mpackint *info );
void Chesv ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * work, mpackint lwork, mpackint *info );
void Rsysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * af, mpackint ldaf, mpackint *ipiv, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_real * work, mpackint lwork, mpackint *iwork, mpackint *info );
void Csysvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *info );
void Chesvx ( const char *fact, const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * af, mpackint ldaf, mpackint *ipiv, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * rcond, qd_real * ferr, qd_real * berr, qd_complex * work, mpackint lwork, qd_real * rwork, mpackint *info );
void Rsytrf ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * work, mpackint lwork, mpackint *info );
void Csytrf ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * work, mpackint lwork, mpackint *info );
void Chetrf ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * work, mpackint lwork, mpackint *info );
void Rsytri ( const char *uplo, mpackint n, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * work, mpackint *info );
void Csytri ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * work, mpackint *info );
void Chetri ( const char *uplo, mpackint n, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * work, mpackint *info );
void Rsytrs ( const char *uplo, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, mpackint *ipiv, qd_real * B, mpackint ldb, mpackint *info );
void Csytrs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Chetrs ( const char *uplo, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, mpackint *ipiv, qd_complex * B, mpackint ldb, mpackint *info );
void Rtbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, qd_real * AB, mpackint ldab, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Ctbcon ( const char *norm, const char *uplo, const char *diag, mpackint n, mpackint kd, qd_complex * AB, mpackint ldab, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rtbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, qd_real * AB, mpackint ldab, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Ctbrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, qd_complex * AB, mpackint ldab, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint * info );
void Rtbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, qd_real * ab, mpackint ldab, qd_real * B, mpackint ldb, mpackint *info );
void Ctbtrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint kd, mpackint nrhs, qd_complex * ab, mpackint ldab, qd_complex * B, mpackint ldb, mpackint *info );
void Rtgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, qd_real * s, mpackint lds, qd_real *p, mpackint ldp, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, mpackint mm, mpackint *m, qd_real * work, mpackint * info );
void Ctgevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, qd_complex * s, mpackint lds, qd_complex * p, mpackint ldp, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, mpackint mm, mpackint * m, qd_complex * work, qd_real * rwork, mpackint * info );
void Rtgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * q, mpackint ldq, qd_real * z, mpackint ldz, mpackint * ifst, mpackint * ilst, qd_real * work, mpackint lwork, mpackint * info );
void Ctgexc ( mpacklogical wantq, mpacklogical wantz, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * q, mpackint ldq, qd_complex * z, mpackint ldz, mpackint ifst, mpackint *ilst, mpackint *info );
void Rtgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical *select, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * alphar, qd_real * alphai, qd_real * beta, qd_real * q, mpackint ldq, qd_real * z, mpackint ldz, mpackint * m, qd_real * pl, qd_real * pr, qd_real * dif, qd_real * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Ctgsen ( mpackint ijob, mpacklogical wantq, mpacklogical wantz, mpacklogical * select, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * alpha, qd_complex * beta, qd_complex * q, mpackint ldq, qd_complex * z, mpackint ldz, mpackint * m, qd_real * pl, qd_real * pr, qd_real * dif, qd_complex * work, mpackint lwork, mpackint * iwork, mpackint liwork, mpackint * info );
void Rtgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real tola, qd_real tolb, qd_real * alpha, qd_real * beta, qd_real * u, mpackint ldu, qd_real * v, mpackint ldv, qd_real * q, mpackint ldq, qd_real * work, mpackint ncycle, mpackint *info );
void Ctgsja ( const char *jobu, const char *jobv, const char *jobq, mpackint m, mpackint p, mpackint n, mpackint k, mpackint l, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_real tola, qd_real tolb, qd_real * alpha, qd_real * beta, qd_complex * u, mpackint ldu, qd_complex * v, mpackint ldv, qd_complex * q, mpackint ldq, qd_complex * work, mpackint * ncycle, mpackint *info );
void Rtgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, qd_real * s, qd_real * dif, mpackint mm, mpackint * m, qd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, qd_real * s, qd_real * dif, mpackint mm, mpackint * m, qd_complex * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * c, mpackint ldc, qd_real * d, mpackint ldd, qd_real * e, mpackint lde, qd_real * f, mpackint ldf, qd_real * scale, qd_real * dif, qd_real * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Ctgsyl ( const char *trans, mpackint ijob, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * c, mpackint ldc, qd_complex * d, mpackint ldd, qd_complex * e, mpackint lde, qd_complex * f, mpackint ldf, qd_real * scale, qd_real * dif, qd_complex * work, mpackint lwork, mpackint * iwork, mpackint * info );
void Rtpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, qd_real * ap, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Ctpcon ( const char *norm, const char *uplo, const char *diag, mpackint n, qd_complex * ap, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rtprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_real * ap, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Ctprfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rtptri ( const char *uplo, const char *diag, mpackint n, qd_real * ap, mpackint *info );
void Ctptri ( const char *uplo, const char *diag, mpackint n, qd_complex * ap, mpackint *info );
void Rtptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_real * ap, qd_real * B, mpackint ldb, mpackint *info );
void Ctptrs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_complex * ap, qd_complex * B, mpackint ldb, mpackint *info );
void Rtrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, qd_real * A, mpackint lda, qd_real * rcond, qd_real * work, mpackint *iwork, mpackint *info );
void Ctrcon ( const char *norm, const char *uplo, const char *diag, mpackint n, qd_complex * A, mpackint lda, qd_real * rcond, qd_complex * work, qd_real * rwork, mpackint *info );
void Rtrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, qd_real * t, mpackint ldt, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, mpackint mm, mpackint *m, qd_real * work, mpackint *info );
void Ctrevc ( const char *side, const char *howmny, mpacklogical * select, mpackint n, qd_complex * t, mpackint ldt, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, mpackint mm, mpackint *m, qd_complex * work, qd_real * rwork, mpackint *info );
void Rtrexc ( const char *compq, mpackint n, qd_real * t, mpackint ldt, qd_real * q, mpackint ldq, mpackint *ifst, mpackint *ilst, qd_real * work, mpackint *info );
void Ctrexc ( const char *compq, mpackint n, qd_complex * t, mpackint ldt, qd_complex * q, mpackint ldq, mpackint ifst, mpackint ilst, mpackint *info );
void Rtrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_real * work, mpackint *iwork, mpackint *info );
void Ctrrfs ( const char *uplo, const char *trans, const char *diag, mpackint n, mpackint nrhs, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * x, mpackint ldx, qd_real * ferr, qd_real * berr, qd_complex * work, qd_real * rwork, mpackint *info );
void Rtrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, qd_real * t, mpackint ldt, qd_real * q, mpackint ldq, qd_real * wr, qd_real * wi, mpackint m, qd_real * s, qd_real * sep, qd_real * work, mpackint lwork, mpackint *iwork, mpackint liwork, mpackint *info );
void Ctrsen ( const char *job, const char *compq, mpacklogical * select, mpackint n, qd_complex * t, mpackint ldt, qd_complex * q, mpackint ldq, qd_complex * w, mpackint m, qd_real * s, qd_real * sep, qd_complex * work, mpackint lwork, mpackint *info );
void Rtrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, qd_real * t, mpackint ldt, qd_real * vl, mpackint ldvl, qd_real * vr, mpackint ldvr, qd_real * s, qd_real * sep, mpackint mm, mpackint *m, qd_real * work, mpackint ldwork, mpackint *iwork, mpackint *info );
void Ctrsna ( const char *job, const char *howmny, mpacklogical * select, mpackint n, qd_complex * t, mpackint ldt, qd_complex * vl, mpackint ldvl, qd_complex * vr, mpackint ldvr, qd_real * s, qd_real * sep, mpackint mm, mpackint *m, qd_complex * work, mpackint ldwork, qd_real * rwork, mpackint *info );
void Rtrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * B, mpackint ldb, qd_real * c, mpackint ldc, qd_real * scale, mpackint *info );
void Ctrsyl ( const char *trana, const char *tranb, mpackint isgn, mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * B, mpackint ldb, qd_complex * c, mpackint ldc, qd_real * scale, mpackint *info );
void Rtzrzf ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, qd_real * work, mpackint lwork, mpackint *info );
void Ctzrzf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, qd_complex * work, mpackint lwork, mpackint *info );
void Rtzrqf ( mpackint m, mpackint n, qd_real * A, mpackint lda, qd_real * tau, mpackint *info );
void Ctzrqf ( mpackint m, mpackint n, qd_complex * A, mpackint lda, qd_complex * tau, mpackint *info );

#endif
